/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRuleDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterDescriptorImpl;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteRuleDescriptorImpl;

public class UrlRewriteRulesDescriptorImpl
implements UrlRewriteRulesDescriptor {
    private Map<String, UrlRewriteFunctionDescriptor> funcMap = new HashMap<String, UrlRewriteFunctionDescriptor>();
    private List<UrlRewriteFunctionDescriptor> funcList = new ArrayList<UrlRewriteFunctionDescriptor>();
    private List<UrlRewriteRuleDescriptor> ruleList = new ArrayList<UrlRewriteRuleDescriptor>();
    private Map<String, UrlRewriteRuleDescriptor> ruleMap = new HashMap<String, UrlRewriteRuleDescriptor>();
    private List<UrlRewriteFilterDescriptor> filterList = new ArrayList<UrlRewriteFilterDescriptor>();
    private Map<String, UrlRewriteFilterDescriptor> filterMap = new HashMap<String, UrlRewriteFilterDescriptor>();

    @Override
    public void addRules(UrlRewriteRulesDescriptor rules) {
        for (UrlRewriteRuleDescriptor rule : rules.getRules()) {
            this.addRule(rule);
        }
        for (UrlRewriteFilterDescriptor filter : rules.getFilters()) {
            this.addFilter(filter);
        }
    }

    @Override
    public UrlRewriteRuleDescriptor getRule(String name) {
        return this.ruleMap.get(name);
    }

    @Override
    public List<UrlRewriteRuleDescriptor> getRules() {
        return this.ruleList;
    }

    @Override
    public UrlRewriteRuleDescriptor addRule(String name) {
        UrlRewriteRuleDescriptor rule = this.newRule();
        rule.name(name);
        this.addRule(rule);
        return rule;
    }

    @Override
    public UrlRewriteRuleDescriptor newRule() {
        return new UrlRewriteRuleDescriptorImpl();
    }

    @Override
    public void addRule(UrlRewriteRuleDescriptor rule) {
        this.ruleList.add(rule);
        String name = rule.name();
        if (name != null && !name.isEmpty()) {
            this.ruleMap.put(rule.name(), rule);
        }
    }

    @Override
    public List<UrlRewriteFunctionDescriptor> getFunctions() {
        return this.funcList;
    }

    @Override
    public <T extends UrlRewriteFunctionDescriptor<?>> T getFunction(String name) {
        return (T)this.funcMap.get(name);
    }

    @Override
    public <T extends UrlRewriteFunctionDescriptor<?>> T addFunction(String name) {
        T descriptor = this.newFunction(name);
        this.addFunction((UrlRewriteFunctionDescriptor)descriptor);
        return descriptor;
    }

    protected <T extends UrlRewriteFunctionDescriptor<?>> T newFunction(String name) {
        return UrlRewriteFunctionDescriptorFactory.create(name);
    }

    protected void addFunction(UrlRewriteFunctionDescriptor descriptor) {
        this.funcList.add(descriptor);
        this.funcMap.put(descriptor.name(), descriptor);
    }

    @Override
    public List<UrlRewriteFilterDescriptor> getFilters() {
        return this.filterList;
    }

    @Override
    public UrlRewriteFilterDescriptor getFilter(String name) {
        return this.filterMap.get(name);
    }

    @Override
    public UrlRewriteFilterDescriptor newFilter() {
        return new UrlRewriteFilterDescriptorImpl();
    }

    @Override
    public UrlRewriteFilterDescriptor addFilter(String name) {
        UrlRewriteFilterDescriptor filter = this.newFilter();
        filter.name(name);
        this.addFilter(filter);
        return filter;
    }

    @Override
    public void addFilter(UrlRewriteFilterDescriptor descriptor) {
        this.filterList.add(descriptor);
        this.filterMap.put(descriptor.name(), descriptor);
    }
}

