/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiEndPoint;
import com.cloudera.api.swagger.model.ApiMapEntry;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This object contains enough information for a Workload cluster to connect to an SDX cluster. This object contains no secrets.")
public class ApiRemoteDataContext {
    @SerializedName(value="endPointId")
    private String endPointId = null;
    @SerializedName(value="endPoints")
    private List<ApiEndPoint> endPoints = null;
    @SerializedName(value="configs")
    private List<ApiMapEntry> configs = null;
    @SerializedName(value="clusterVersion")
    private String clusterVersion = null;

    public ApiRemoteDataContext endPointId(String endPointId) {
        this.endPointId = endPointId;
        return this;
    }

    @ApiModelProperty(value="A string to uniquely identify the SDX cluster.")
    public String getEndPointId() {
        return this.endPointId;
    }

    public void setEndPointId(String endPointId) {
        this.endPointId = endPointId;
    }

    public ApiRemoteDataContext endPoints(List<ApiEndPoint> endPoints) {
        this.endPoints = endPoints;
        return this;
    }

    public ApiRemoteDataContext addEndPointsItem(ApiEndPoint endPointsItem) {
        if (this.endPoints == null) {
            this.endPoints = new ArrayList<ApiEndPoint>();
        }
        this.endPoints.add(endPointsItem);
        return this;
    }

    @ApiModelProperty(value="List of endPoints exported by this SDX cluster.")
    public List<ApiEndPoint> getEndPoints() {
        return this.endPoints;
    }

    public void setEndPoints(List<ApiEndPoint> endPoints) {
        this.endPoints = endPoints;
    }

    public ApiRemoteDataContext configs(List<ApiMapEntry> configs) {
        this.configs = configs;
        return this;
    }

    public ApiRemoteDataContext addConfigsItem(ApiMapEntry configsItem) {
        if (this.configs == null) {
            this.configs = new ArrayList<ApiMapEntry>();
        }
        this.configs.add(configsItem);
        return this;
    }

    @ApiModelProperty(value="SDX cluster specifc options.")
    public List<ApiMapEntry> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<ApiMapEntry> configs) {
        this.configs = configs;
    }

    public ApiRemoteDataContext clusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
        return this;
    }

    @ApiModelProperty(value="Cluster version")
    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRemoteDataContext apiRemoteDataContext = (ApiRemoteDataContext)o;
        return Objects.equals(this.endPointId, apiRemoteDataContext.endPointId) && Objects.equals(this.endPoints, apiRemoteDataContext.endPoints) && Objects.equals(this.configs, apiRemoteDataContext.configs) && Objects.equals(this.clusterVersion, apiRemoteDataContext.clusterVersion);
    }

    public int hashCode() {
        return Objects.hash(this.endPointId, this.endPoints, this.configs, this.clusterVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRemoteDataContext {\n");
        sb.append("    endPointId: ").append(this.toIndentedString(this.endPointId)).append("\n");
        sb.append("    endPoints: ").append(this.toIndentedString(this.endPoints)).append("\n");
        sb.append("    configs: ").append(this.toIndentedString(this.configs)).append("\n");
        sb.append("    clusterVersion: ").append(this.toIndentedString(this.clusterVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

