/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;

public class Saml2MetadataFilter
implements Filter {
    private Config config;
    private String clientName;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        CommonHelper.assertNotNull((String)"clientName", (Object)this.clientName);
        SAML2Client client = (SAML2Client)((Object)this.config.getClients().findClient(this.clientName).get());
        if (client == null) {
            throw new TechnicalException("No SAML2Client: " + this.clientName);
        }
        client.init();
        servletResponse.getWriter().write(client.getServiceProviderMetadataResolver().getMetadata());
        servletResponse.getWriter().flush();
    }

    public void destroy() {
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }
}

