/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class CappedBufferHttpEntity
extends HttpEntityWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private int replayWriteIndex = -1;
    private int replayWriteLimit;
    private byte[] replayBuffer;
    private InputStream wrappedStream = null;

    public CappedBufferHttpEntity(HttpEntity entity, int bufferSize) throws IOException {
        super(entity);
        if (!entity.isRepeatable()) {
            this.replayBuffer = new byte[bufferSize];
            this.replayWriteLimit = bufferSize - 1;
        } else {
            this.replayBuffer = null;
        }
    }

    public CappedBufferHttpEntity(HttpEntity entity) throws IOException {
        this(entity, 4096);
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return this.wrappedEntity.isStreaming();
    }

    public boolean isChunked() {
        return this.wrappedEntity.isChunked();
    }

    public long getContentLength() {
        return this.wrappedEntity.getContentLength();
    }

    public InputStream getContent() throws IOException {
        if (this.replayBuffer == null) {
            return this.wrappedEntity.getContent();
        }
        if (this.wrappedStream == null) {
            this.wrappedStream = this.wrappedEntity.getContent();
        }
        return new ReplayStream();
    }

    public void writeTo(OutputStream stream) throws IOException {
        IOUtils.copy((InputStream)this.getContent(), (OutputStream)stream);
    }

    public void consumeContent() throws IOException {
        throw new UnsupportedOperationException();
    }

    private class ReplayStream
    extends InputStream {
        private int replayReadIndex = -1;

        private ReplayStream() {
        }

        @Override
        public int read() throws IOException {
            int b;
            if (this.replayReadIndex < CappedBufferHttpEntity.this.replayWriteIndex) {
                b = CappedBufferHttpEntity.this.replayBuffer[++this.replayReadIndex];
            } else {
                b = CappedBufferHttpEntity.this.wrappedStream.read();
                if (b > -1) {
                    if (CappedBufferHttpEntity.this.replayWriteIndex < CappedBufferHttpEntity.this.replayWriteLimit) {
                        ((CappedBufferHttpEntity)CappedBufferHttpEntity.this).replayBuffer[++((CappedBufferHttpEntity)CappedBufferHttpEntity.this).replayWriteIndex] = (byte)b;
                        ++this.replayReadIndex;
                    } else {
                        throw new IOException("Hit replay buffer max limit");
                    }
                }
            }
            return b;
        }

        @Override
        public int read(byte[] buffer, int offset, int limit) throws IOException {
            int count;
            if (this.replayReadIndex < CappedBufferHttpEntity.this.replayWriteIndex) {
                count = CappedBufferHttpEntity.this.replayWriteIndex - this.replayReadIndex;
                count = Math.min(limit, count);
                System.arraycopy(CappedBufferHttpEntity.this.replayBuffer, this.replayReadIndex + 1, buffer, offset, count);
                this.replayReadIndex += count;
            } else {
                count = CappedBufferHttpEntity.this.wrappedStream.read(buffer, offset, limit);
                if (count > -1) {
                    if (CappedBufferHttpEntity.this.replayWriteIndex + count < CappedBufferHttpEntity.this.replayWriteLimit) {
                        System.arraycopy(buffer, offset, CappedBufferHttpEntity.this.replayBuffer, CappedBufferHttpEntity.this.replayWriteIndex + 1, count);
                        this.replayReadIndex += count;
                        CappedBufferHttpEntity.this.replayWriteIndex = CappedBufferHttpEntity.this.replayWriteIndex + count;
                    } else {
                        throw new IOException("Hit replay buffer max limit");
                    }
                }
            }
            return count;
        }
    }
}

