/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.PhysicalRowId;

final class Location {
    private long blockId;
    private short offset;

    Location(long blockId, short offset) {
        this.blockId = blockId;
        this.offset = offset;
    }

    Location(long blockOffset) {
        this.offset = (short)(blockOffset & 0xFFFFL);
        this.blockId = blockOffset >> 16;
    }

    Location(PhysicalRowId physicalRowId) {
        this.blockId = physicalRowId.getBlock();
        this.offset = physicalRowId.getOffset();
    }

    long getBlock() {
        return this.blockId;
    }

    short getOffset() {
        return this.offset;
    }

    long toLong() {
        return (this.blockId << 16) + (long)this.offset;
    }

    public int hashCode() {
        return 663;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Location)) {
            return false;
        }
        Location ol = (Location)o;
        return ol.blockId == this.blockId && ol.offset == this.offset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Location ( ").append(this.blockId).append(" : ");
        sb.append(this.offset).append(" ) ");
        return sb.toString();
    }
}

