/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder.property.interpreter;

import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Param;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.builder.property.interpreter.AbstractInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;

public class ServiceParameterPropertyInterpreter
extends AbstractInterpreter {
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private Service service;

    public ServiceParameterPropertyInterpreter(Service service) {
        if (service == null) {
            throw new IllegalArgumentException(gatewayResources.providerIsRequiredError());
        }
        this.service = service;
    }

    @Override
    public void interpret(String token, String value) throws InterpretException {
        if (token == null || token.isEmpty()) {
            throw new InterpretException(gatewayResources.serviceParameterNameIsRequiredError());
        }
        if (value == null || value.isEmpty()) {
            throw new InterpretException(gatewayResources.serviceParameterValueIsRequiredError());
        }
        Param param = new Param();
        param.setName(token);
        param.setValue(value);
        this.service.addParam(param);
    }
}

