/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.ParentIdAndRdnComparator;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.server.xdbm.impl.avl.AvlTable;

public class AvlRdnIndex
extends AvlIndex<ParentIdAndRdn> {
    public AvlRdnIndex() {
    }

    public AvlRdnIndex(String attributeId) {
        super(attributeId, true);
    }

    @Override
    public void init(SchemaManager schemaManager, AttributeType attributeType) throws LdapException {
        this.attributeType = attributeType;
        MatchingRule mr = attributeType.getEquality();
        if (mr == null) {
            mr = attributeType.getOrdering();
        }
        if (mr == null) {
            mr = attributeType.getSubstring();
        }
        this.normalizer = mr.getNormalizer();
        if (this.normalizer == null) {
            throw new LdapOtherException(I18n.err((I18n)I18n.ERR_212, (Object[])new Object[]{attributeType}));
        }
        ParentIdAndRdnComparator comp = new ParentIdAndRdnComparator(mr.getOid());
        UuidComparator.INSTANCE.setSchemaManager(schemaManager);
        this.forward = new AvlTable(attributeType.getName(), comp, UuidComparator.INSTANCE, false);
        this.reverse = new AvlTable(attributeType.getName(), UuidComparator.INSTANCE, comp, false);
    }
}

