/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasRestProfile;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasRestAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(CasRestAuthenticator.class);
    protected CasConfiguration configuration;

    public CasRestAuthenticator(CasConfiguration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) {
        if (credentials == null || credentials.getPassword() == null || credentials.getUsername() == null) {
            throw new TechnicalException("Credentials are required");
        }
        String ticketGrantingTicketId = this.requestTicketGrantingTicket(credentials.getUsername(), credentials.getPassword(), context);
        if (CommonHelper.isNotBlank((String)ticketGrantingTicketId)) {
            credentials.setUserProfile((CommonProfile)new CasRestProfile(ticketGrantingTicketId, credentials.getUsername()));
        }
    }

    private String requestTicketGrantingTicket(String username, String password, WebContext context) {
        String string;
        int responseCode;
        String locationHeader;
        HttpURLConnection connection;
        block5: {
            connection = null;
            connection = HttpUtils.openPostConnection((URL)new URL(this.configuration.computeFinalRestUrl(context)));
            String payload = HttpUtils.encodeQueryParam((String)"username", (String)username) + "&" + HttpUtils.encodeQueryParam((String)"password", (String)password);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
            out.write(payload);
            out.close();
            locationHeader = connection.getHeaderField("location");
            responseCode = connection.getResponseCode();
            if (locationHeader == null || responseCode != 201) break block5;
            String string2 = locationHeader.substring(locationHeader.lastIndexOf("/") + 1);
            HttpUtils.closeConnection((HttpURLConnection)connection);
            return string2;
        }
        try {
            logger.debug("Ticket granting ticket request failed: " + locationHeader + " " + responseCode + HttpUtils.buildHttpErrorMessage((HttpURLConnection)connection));
            string = null;
        }
        catch (IOException e) {
            try {
                throw new TechnicalException((Throwable)e);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection((HttpURLConnection)connection);
        return string;
    }
}

