/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHostNameList;
import com.cloudera.api.swagger.model.ApiPerfInspectorPingArgs;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Arguments used for the Cloudera Manager level performance inspector. Network diagnostics will be run from every host in sourceHostList to every host in targetHostList.")
public class ApiHostsPerfInspectorArgs {
    @SerializedName(value="sourceHostList")
    private ApiHostNameList sourceHostList = null;
    @SerializedName(value="targetHostList")
    private ApiHostNameList targetHostList = null;
    @SerializedName(value="pingArgs")
    private ApiPerfInspectorPingArgs pingArgs = null;

    public ApiHostsPerfInspectorArgs sourceHostList(ApiHostNameList sourceHostList) {
        this.sourceHostList = sourceHostList;
        return this;
    }

    @ApiModelProperty(value="Required list of host names which'll act as source for running network diagnostics test.")
    public ApiHostNameList getSourceHostList() {
        return this.sourceHostList;
    }

    public void setSourceHostList(ApiHostNameList sourceHostList) {
        this.sourceHostList = sourceHostList;
    }

    public ApiHostsPerfInspectorArgs targetHostList(ApiHostNameList targetHostList) {
        this.targetHostList = targetHostList;
        return this;
    }

    @ApiModelProperty(value="Required list of host names which'll act as target for running network diagnostics test.")
    public ApiHostNameList getTargetHostList() {
        return this.targetHostList;
    }

    public void setTargetHostList(ApiHostNameList targetHostList) {
        this.targetHostList = targetHostList;
    }

    public ApiHostsPerfInspectorArgs pingArgs(ApiPerfInspectorPingArgs pingArgs) {
        this.pingArgs = pingArgs;
        return this;
    }

    @ApiModelProperty(value="Optional ping request arguments. If not specified, default arguments will be used for ping test.")
    public ApiPerfInspectorPingArgs getPingArgs() {
        return this.pingArgs;
    }

    public void setPingArgs(ApiPerfInspectorPingArgs pingArgs) {
        this.pingArgs = pingArgs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHostsPerfInspectorArgs apiHostsPerfInspectorArgs = (ApiHostsPerfInspectorArgs)o;
        return Objects.equals(this.sourceHostList, apiHostsPerfInspectorArgs.sourceHostList) && Objects.equals(this.targetHostList, apiHostsPerfInspectorArgs.targetHostList) && Objects.equals(this.pingArgs, apiHostsPerfInspectorArgs.pingArgs);
    }

    public int hashCode() {
        return Objects.hash(this.sourceHostList, this.targetHostList, this.pingArgs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHostsPerfInspectorArgs {\n");
        sb.append("    sourceHostList: ").append(this.toIndentedString(this.sourceHostList)).append("\n");
        sb.append("    targetHostList: ").append(this.toIndentedString(this.targetHostList)).append("\n");
        sb.append("    pingArgs: ").append(this.toIndentedString(this.pingArgs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

