/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.auth;

import java.lang.reflect.Constructor;
import java.net.URI;
import javax.security.auth.login.Configuration;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;

class ConfigurationFactory {
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private static final Class implClazz;

    ConfigurationFactory() {
    }

    static Configuration create(URI uri) {
        Configuration config = null;
        if (implClazz != null) {
            try {
                Constructor ctor = implClazz.getDeclaredConstructor(URI.class);
                config = (Configuration)ctor.newInstance(uri);
            }
            catch (Exception e) {
                log.failedToInstantiateJAASConfigurationFileImplementation(implClazz.getCanonicalName(), e);
            }
        } else {
            log.noJAASConfigurationFileImplementation();
        }
        return config;
    }

    static {
        String implName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.login.ConfigFile" : "com.sun.security.auth.login.ConfigFile";
        log.usingJAASConfigurationFileImplementation(implName);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(implName, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.failedToLoadJAASConfigurationFileImplementation(implName, e);
        }
        implClazz = clazz;
    }
}

