/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.spi.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.Pattern;
import org.jboss.shrinkwrap.descriptor.spi.node.Query;
import org.jboss.shrinkwrap.descriptor.spi.node.QueryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum RelativeGetQuery implements Query<List<Node>>
{
    INSTANCE;


    @Override
    public List<Node> execute(Node node, Pattern ... patterns) throws IllegalArgumentException {
        QueryUtil.validateNodeAndPatterns(node, patterns);
        List<Pattern> patternSequence = Arrays.asList(patterns);
        return this.findMatch(node, patternSequence, patternSequence);
    }

    private List<Node> findMatch(Node start, List<Pattern> patternSequence, List<Pattern> entirePatternSequence) {
        ArrayList<Node> matchedNodes = new ArrayList<Node>();
        Pattern pattern = patternSequence.get(0);
        if (pattern.matches(start)) {
            if (patternSequence.size() == 1) {
                matchedNodes.add(start);
            } else {
                for (Node child : start.getChildren()) {
                    List<Pattern> remainingPatterns = patternSequence.subList(1, patternSequence.size());
                    matchedNodes.addAll(this.findMatch(child, remainingPatterns, entirePatternSequence));
                }
            }
        }
        for (Node child : start.getChildren()) {
            matchedNodes.addAll(this.findMatch(child, entirePatternSequence, entirePatternSequence));
        }
        return matchedNodes;
    }
}

