/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.kylin.metadata.model;

import java.util.Map;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Range;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;

public interface ISegment extends Comparable<ISegment> {

    public KylinConfig getConfig();

    public String getId();

    public String getName();

    public boolean isOffsetCube();

    public SegmentRange getSegRange();

    public Map<String, DimensionRangeInfo> getDimensionRangeInfoMap();

    public SegmentRange.KafkaOffsetPartitionedSegmentRange getKSRange();

    public TimeRange getTSRange();

    public Range<Long> getRange();

    public int getLayoutSize();

    public int getEffectiveLayoutSize();

    public NDataModel getModel();

    public SegmentStatusEnum getStatus();

    public long getLastBuildTime();

    public void validate();

}
