/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrInputDocumentReader
extends Reader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrInputDocument doc;
    private final String[] fields;
    private final String fieldValueSep;
    private final int maxTotalChars;
    private final int maxCharsPerFieldValue;
    private int totalCharsConsumed;
    private int currentFieldIdx = 0;
    private int currentFieldValueIdx = 0;
    private int currentFieldValueOffset = 0;
    private boolean eod = false;
    private int eodReturnValue = -1;

    public SolrInputDocumentReader(SolrInputDocument doc, int maxTotalChars, int maxCharsPerFieldValue) {
        this(doc, SolrInputDocumentReader.getStringFields(doc), maxTotalChars, maxCharsPerFieldValue, " ");
    }

    public SolrInputDocumentReader(SolrInputDocument doc, String[] fields, int maxTotalChars, int maxCharsPerFieldValue, String fieldValueSep) {
        this.doc = doc;
        this.fields = fields;
        this.fieldValueSep = fieldValueSep;
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("fields cannot be empty");
        }
        this.maxTotalChars = maxTotalChars;
        this.maxCharsPerFieldValue = maxCharsPerFieldValue;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        StringBuilder sb = new StringBuilder(len);
        int numChars = this.fillBuffer(sb, len);
        if (numChars > -1) {
            sb.getChars(0, numChars, cbuf, off);
        }
        this.totalCharsConsumed += numChars;
        return numChars;
    }

    private int fillBuffer(StringBuilder sb, int targetLen) {
        if (this.eod) {
            return this.eodReturnValue;
        }
        if (this.totalCharsConsumed + targetLen > this.maxTotalChars) {
            targetLen = this.maxTotalChars - this.totalCharsConsumed;
        }
        while (sb.length() < targetLen && !this.eod) {
            this.nextDocChunk(sb, targetLen);
        }
        if (sb.length() == 0) {
            this.eod = true;
            return this.eodReturnValue;
        }
        return sb.length();
    }

    private int nextDocChunk(StringBuilder sb, int maxChunkLength) {
        if (this.currentFieldIdx > this.fields.length - 1) {
            return this.returnEod();
        }
        int startFieldValueIdx = this.currentFieldValueIdx;
        int startFieldValueOffset = this.currentFieldValueOffset;
        do {
            SolrInputField f;
            if ((f = this.doc.getField(this.fields[this.currentFieldIdx])) == null) {
                log.debug("Field with name {} did not exist on docuemnt.", (Object)this.fields[this.currentFieldIdx]);
                this.incField(sb);
                continue;
            }
            Iterator fvIt = f.iterator();
            this.currentFieldValueIdx = -1;
            while (fvIt.hasNext() && sb.length() < maxChunkLength) {
                ++this.currentFieldValueIdx;
                String fvStr = String.valueOf(fvIt.next());
                if (this.currentFieldValueIdx < startFieldValueIdx) continue;
                startFieldValueIdx = 0;
                if (sb.length() > 0) {
                    if (maxChunkLength - sb.length() < this.fieldValueSep.length()) {
                        sb.append(this.fieldValueSep.substring(0, maxChunkLength - sb.length()));
                    } else {
                        sb.append(this.fieldValueSep);
                    }
                }
                this.currentFieldValueOffset = startFieldValueOffset;
                startFieldValueOffset = 0;
                int charsNeeded = maxChunkLength - sb.length();
                int endOffset = fvStr.length();
                if (fvStr.length() - this.currentFieldValueOffset > charsNeeded) {
                    endOffset = this.currentFieldValueOffset + charsNeeded;
                }
                if (endOffset - this.currentFieldValueOffset > this.maxCharsPerFieldValue) {
                    endOffset = this.maxCharsPerFieldValue - this.currentFieldValueOffset;
                }
                sb.append(fvStr.substring(this.currentFieldValueOffset, endOffset));
                this.currentFieldValueOffset = endOffset == fvStr.length() ? 0 : endOffset;
            }
            if (sb.length() >= maxChunkLength) {
                return this.returnValue(sb);
            }
            this.incField(sb);
        } while (this.currentFieldIdx <= this.fields.length - 1 && sb.length() < maxChunkLength);
        return sb.length() == 0 ? this.eodReturnValue : sb.length();
    }

    private int returnEod() {
        this.eod = true;
        return this.eodReturnValue;
    }

    private int returnValue(StringBuilder sb) {
        if (sb.length() == 0) {
            return this.returnEod();
        }
        return sb.length();
    }

    private void incField(StringBuilder sb) {
        ++this.currentFieldIdx;
        this.currentFieldValueIdx = 0;
        this.currentFieldValueOffset = 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean ready() throws IOException {
        return !this.eod;
    }

    public void setEodReturnValue(int eodReturnValue) {
        this.eodReturnValue = eodReturnValue;
    }

    public static String asString(Reader reader) {
        try {
            return IOUtils.toString((Reader)reader);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed reading doc content from reader", (Throwable)e);
        }
    }

    protected static String[] getStringFields(SolrInputDocument doc) {
        Iterable iterable = () -> doc.iterator();
        List<String> strFields = StreamSupport.stream(iterable.spliterator(), false).filter(f -> f.getFirstValue() instanceof String).map(SolrInputField::getName).collect(Collectors.toList());
        return strFields.toArray(new String[0]);
    }
}

