/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import java.util.concurrent.TimeUnit;

public final class DeadlineClock {
    private final long startTime = System.nanoTime();
    private final long durationNanos;

    public DeadlineClock(TimeUnit unit, long duration) {
        this.durationNanos = unit.toNanos(duration);
    }

    public boolean isBeforeDeadline() {
        return !this.isAfterDeadline();
    }

    public boolean isAfterDeadline() {
        return System.nanoTime() - this.startTime >= this.durationNanos;
    }

    public long timeUntilDeadline(TimeUnit unit) {
        long elapsedNanos = System.nanoTime() - this.startTime;
        if (elapsedNanos >= this.durationNanos) {
            return 0L;
        }
        return unit.convert(this.durationNanos - elapsedNanos, TimeUnit.NANOSECONDS);
    }
}

