/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupManager;
import org.apache.solr.core.backup.BackupProperties;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public RestoreCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        try (RestoreContext restoreContext = new RestoreContext(message, this.ocmh);){
            if (state.hasCollection(restoreContext.restoreCollectionName)) {
                RestoreOnExistingCollection restoreOnExistingCollection = new RestoreOnExistingCollection(restoreContext);
                restoreOnExistingCollection.process(restoreContext, results);
            } else {
                RestoreOnANewCollection restoreOnANewCollection = new RestoreOnANewCollection(message, restoreContext.backupCollectionState);
                restoreOnANewCollection.validate(restoreContext.backupCollectionState, restoreContext.nodeList.size());
                restoreOnANewCollection.process(results, restoreContext);
            }
        }
    }

    private void requestReplicasToRestore(NamedList results, DocCollection restoreCollection, ClusterState clusterState, BackupProperties backupProperties, URI backupPath, String repo, ShardHandler shardHandler, String asyncId) {
        OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker = this.ocmh.asyncRequestTracker(asyncId);
        for (Slice slice : restoreCollection.getSlices()) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RESTORECORE.toString()});
            Optional<ShardBackupId> shardBackupId = backupProperties.getShardBackupIdFor(slice.getName());
            if (shardBackupId.isPresent()) {
                params.set("shardBackupId", new String[]{shardBackupId.get().getIdAsString()});
            } else {
                params.set("name", new String[]{"snapshot." + slice.getName()});
            }
            params.set("location", new String[]{backupPath.toASCIIString()});
            params.set("repository", new String[]{repo});
            shardRequestTracker.sliceCmd(clusterState, params, null, slice, shardHandler);
        }
        shardRequestTracker.processResponses((NamedList<Object>)new NamedList(), shardHandler, true, "Could not restore core");
    }

    private int getInt(ZkNodeProps message, String propertyName, Integer count, int defaultValue) {
        Integer value = message.getInt(propertyName, count);
        return value != null ? value : defaultValue;
    }

    private class RestoreOnExistingCollection {
        private RestoreOnExistingCollection(RestoreContext rc) {
            int numShardsOfBackup = rc.backupCollectionState.getSlices().size();
            int numShards = rc.zkStateReader.getClusterState().getCollection(rc.restoreCollectionName).getSlices().size();
            if (numShardsOfBackup != numShards) {
                String msg = String.format(Locale.ROOT, "Unable to restoring since number of shards in backup and specified collection does not match, numShardsOfBackup:%d numShardsOfCollection:%d", numShardsOfBackup, numShards);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(RestoreContext rc, NamedList results) throws Exception {
            ClusterState clusterState = rc.zkStateReader.getClusterState();
            DocCollection restoreCollection = clusterState.getCollection(rc.restoreCollectionName);
            this.enableReadOnly(clusterState, restoreCollection);
            try {
                RestoreCmd.this.requestReplicasToRestore(results, restoreCollection, clusterState, rc.backupProperties, rc.backupPath, rc.repo, rc.shardHandler, rc.asyncId);
            }
            finally {
                this.disableReadOnly(clusterState, restoreCollection);
            }
        }

        private void disableReadOnly(ClusterState clusterState, DocCollection restoreCollection) throws Exception {
            ZkNodeProps params = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toString(), "collection", restoreCollection.getName(), "readOnly", null});
            RestoreCmd.this.ocmh.modifyCollection(clusterState, params, new NamedList());
        }

        private void enableReadOnly(ClusterState clusterState, DocCollection restoreCollection) throws Exception {
            ZkNodeProps params = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toString(), "collection", restoreCollection.getName(), "readOnly", "true"});
            RestoreCmd.this.ocmh.modifyCollection(clusterState, params, new NamedList());
        }
    }

    private class RestoreOnANewCollection {
        private int numNrtReplicas;
        private int numTlogReplicas;
        private int numPullReplicas;
        private int totalReplicasPerShard;
        private int maxShardsPerNode;
        private ZkNodeProps message;

        private RestoreOnANewCollection(ZkNodeProps message, DocCollection backupCollectionState) {
            this.message = message;
            this.numNrtReplicas = message.get("replicationFactor") != null ? message.getInt("replicationFactor", Integer.valueOf(0)) : (message.get("nrtReplicas") != null ? message.getInt("nrtReplicas", Integer.valueOf(0)).intValue() : backupCollectionState.getReplicationFactor().intValue());
            this.numTlogReplicas = RestoreCmd.this.getInt(message, "tlogReplicas", backupCollectionState.getNumTlogReplicas(), 0);
            this.numPullReplicas = RestoreCmd.this.getInt(message, "pullReplicas", backupCollectionState.getNumPullReplicas(), 0);
            this.totalReplicasPerShard = this.numNrtReplicas + this.numTlogReplicas + this.numPullReplicas;
            assert (this.totalReplicasPerShard > 0);
            this.maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(backupCollectionState.getMaxShardsPerNode()));
        }

        public void process(NamedList results, RestoreContext rc) throws Exception {
            this.uploadConfig(rc.backupProperties.getConfigName(), rc.restoreConfigName, rc.zkStateReader, rc.backupManager, rc.requestIsTrusted);
            log.info("Starting restore into collection={} with backup_name={} at location={}", new Object[]{rc.restoreCollectionName, rc.backupName, rc.location});
            this.createCoreLessCollection(rc.restoreCollectionName, rc.restoreConfigName, rc.backupCollectionState, rc.zkStateReader.getClusterState(), rc.backupProperties);
            rc.backupManager.uploadCollectionProperties(rc.restoreCollectionName);
            DocCollection restoreCollection = rc.zkStateReader.getClusterState().getCollection(rc.restoreCollectionName);
            this.markAllShardsAsConstruction(restoreCollection);
            ClusterState clusterState = rc.zkStateReader.getClusterState();
            ArrayList<String> sliceNames = new ArrayList<String>();
            restoreCollection.getSlices().forEach(x -> sliceNames.add(x.getName()));
            List<ReplicaPosition> replicaPositions = this.getReplicaPositions(restoreCollection, rc.nodeList, clusterState, sliceNames);
            this.createSingleReplicaPerShard(results, restoreCollection, rc.asyncId, clusterState, replicaPositions);
            Object failures = results.get("failure");
            if (failures != null && ((SimpleOrderedMap)failures).size() > 0) {
                log.error("Restore failed to create initial replicas.");
                RestoreCmd.this.ocmh.cleanupCollection(rc.restoreCollectionName, new NamedList());
                return;
            }
            restoreCollection = rc.zkStateReader.getClusterState().getCollection(rc.restoreCollectionName);
            RestoreCmd.this.requestReplicasToRestore(results, restoreCollection, clusterState, rc.backupProperties, rc.backupPath, rc.repo, rc.shardHandler, rc.asyncId);
            this.requestReplicasToApplyBufferUpdates(restoreCollection, rc.asyncId, rc.shardHandler);
            this.markAllShardsAsActive(restoreCollection);
            this.addReplicasToShards(results, clusterState, restoreCollection, replicaPositions, rc.asyncId);
            this.restoringAlias(rc.backupProperties);
            log.info("Completed restoring collection={} backupName={}", (Object)restoreCollection, (Object)rc.backupName);
        }

        private void validate(DocCollection backupCollectionState, int availableNodeCount) {
            int numShards = backupCollectionState.getActiveSlices().size();
            int totalReplicasPerShard = this.numNrtReplicas + this.numTlogReplicas + this.numPullReplicas;
            assert (totalReplicasPerShard > 0);
            int maxShardsPerNode = this.message.getInt("maxShardsPerNode", Integer.valueOf(backupCollectionState.getMaxShardsPerNode()));
            if (maxShardsPerNode != -1 && numShards * totalReplicasPerShard > availableNodeCount * maxShardsPerNode) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Solr cloud with available number of nodes:%d is insufficient for restoring a collection with %d shards, total replicas per shard %d and maxShardsPerNode %d. Consider increasing maxShardsPerNode value OR number of available nodes.", availableNodeCount, numShards, totalReplicasPerShard, maxShardsPerNode));
            }
        }

        private void uploadConfig(String configName, String restoreConfigName, ZkStateReader zkStateReader, BackupManager backupMgr, boolean requestIsTrusted) throws IOException {
            if (zkStateReader.getConfigManager().configExists(restoreConfigName).booleanValue()) {
                log.info("Using existing config {}", (Object)restoreConfigName);
            } else {
                log.info("Uploading config {}", (Object)restoreConfigName);
                backupMgr.uploadConfigDir(configName, restoreConfigName, requestIsTrusted);
            }
        }

        private void createCoreLessCollection(String restoreCollectionName, String restoreConfigName, DocCollection backupCollectionState, ClusterState clusterState, BackupProperties backupProperties) throws Exception {
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            propMap.put("operation", CollectionParams.CollectionAction.CREATE.toString());
            propMap.put("fromApi", "true");
            if (backupProperties.getStateFormat() == null) {
                propMap.put("stateFormat", "2");
            }
            propMap.put("replicationFactor", this.numNrtReplicas);
            propMap.put("nrtReplicas", this.numNrtReplicas);
            propMap.put("tlogReplicas", this.numTlogReplicas);
            propMap.put("pullReplicas", this.numPullReplicas);
            propMap.put("maxShardsPerNode", this.maxShardsPerNode);
            for (String string : OverseerCollectionMessageHandler.COLLECTION_PROPS_AND_DEFAULTS.keySet()) {
                Object object = this.message.getProperties().getOrDefault(string, backupCollectionState.get(string));
                if (object == null || propMap.get(string) != null) continue;
                propMap.put(string, object);
            }
            propMap.put("name", restoreCollectionName);
            propMap.put("createNodeSet", "EMPTY");
            propMap.put("collection.configName", restoreConfigName);
            Map routerProps = (Map)backupCollectionState.getProperties().get("router");
            for (Map.Entry entry : routerProps.entrySet()) {
                propMap.put("router." + (String)entry.getKey(), entry.getValue());
            }
            Set set = backupCollectionState.getActiveSlicesMap().keySet();
            if (backupCollectionState.getRouter() instanceof ImplicitDocRouter) {
                propMap.put("shards", StrUtils.join(set, (char)','));
            } else {
                propMap.put("numShards", set.size());
                Collection collection = backupCollectionState.getActiveSlices();
                LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>(collection.size());
                for (Slice backupSlice : collection) {
                    newSlices.put(backupSlice.getName(), new Slice(backupSlice.getName(), Collections.emptyMap(), backupSlice.getProperties(), restoreCollectionName));
                }
                propMap.put("shards", newSlices);
            }
            ((RestoreCmd)RestoreCmd.this).ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(clusterState, new ZkNodeProps(propMap), new NamedList());
        }

        private void markAllShardsAsConstruction(DocCollection restoreCollection) throws KeeperException, InterruptedException {
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
            for (Slice shard : restoreCollection.getSlices()) {
                propMap.put(shard.getName(), Slice.State.CONSTRUCTION.toString());
            }
            propMap.put("collection", restoreCollection.getName());
            ((RestoreCmd)RestoreCmd.this).ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)new ZkNodeProps(propMap)));
        }

        private List<ReplicaPosition> getReplicaPositions(DocCollection restoreCollection, List<String> nodeList, ClusterState clusterState, List<String> sliceNames) throws IOException, InterruptedException {
            Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(restoreCollection.getName()).forShard(sliceNames).assignNrtReplicas(this.numNrtReplicas).assignTlogReplicas(this.numTlogReplicas).assignPullReplicas(this.numPullReplicas).onNodes(nodeList).build();
            Assign.AssignStrategyFactory assignStrategyFactory = new Assign.AssignStrategyFactory(((RestoreCmd)RestoreCmd.this).ocmh.cloudManager);
            Assign.AssignStrategy assignStrategy = assignStrategyFactory.create(clusterState, restoreCollection);
            return assignStrategy.assign(((RestoreCmd)RestoreCmd.this).ocmh.cloudManager, assignRequest);
        }

        private void createSingleReplicaPerShard(NamedList results, DocCollection restoreCollection, String asyncId, ClusterState clusterState, List<ReplicaPosition> replicaPositions) throws Exception {
            CountDownLatch countDownLatch = new CountDownLatch(restoreCollection.getSlices().size());
            for (Slice slice : restoreCollection.getSlices()) {
                String sliceName = slice.getName();
                log.info("Adding replica for shard={} collection={} ", (Object)sliceName, (Object)restoreCollection);
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                propMap.put("operation", CollectionParams.CollectionAction.CREATESHARD);
                propMap.put("collection", restoreCollection.getName());
                propMap.put("shard", sliceName);
                if (this.numNrtReplicas >= 1) {
                    propMap.put("type", Replica.Type.NRT.name());
                } else if (this.numTlogReplicas >= 1) {
                    propMap.put("type", Replica.Type.TLOG.name());
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected number of replicas, replicationFactor, " + Replica.Type.NRT + " or " + Replica.Type.TLOG + " must be greater than 0");
                }
                for (ReplicaPosition replicaPosition : replicaPositions) {
                    if (!Objects.equals(replicaPosition.shard, slice.getName())) continue;
                    String node = replicaPosition.node;
                    propMap.put("node", node);
                    replicaPositions.remove(replicaPosition);
                    break;
                }
                if (asyncId != null) {
                    propMap.put("async", asyncId);
                }
                RestoreCmd.this.ocmh.addPropertyParams(this.message, propMap);
                NamedList addReplicaResult = new NamedList();
                RestoreCmd.this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap), addReplicaResult, () -> {
                    Object addResultFailure = addReplicaResult.get("failure");
                    if (addResultFailure != null) {
                        SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
                        if (failure == null) {
                            failure = new SimpleOrderedMap();
                            results.add("failure", (Object)failure);
                        }
                        failure.addAll((NamedList)addResultFailure);
                    } else {
                        SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
                        if (success == null) {
                            success = new SimpleOrderedMap();
                            results.add("success", (Object)success);
                        }
                        success.addAll((NamedList)addReplicaResult.get("success"));
                    }
                    countDownLatch.countDown();
                });
            }
            boolean allIsDone = countDownLatch.await(1L, TimeUnit.HOURS);
            if (!allIsDone) {
                throw new TimeoutException("Initial replicas were not created within 1 hour. Timing out.");
            }
        }

        private void requestReplicasToApplyBufferUpdates(DocCollection restoreCollection, String asyncId, ShardHandler shardHandler) {
            OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker = RestoreCmd.this.ocmh.asyncRequestTracker(asyncId);
            for (Slice s : restoreCollection.getSlices()) {
                for (Replica r : s.getReplicas()) {
                    String nodeName = r.getNodeName();
                    String coreNodeName = r.getCoreName();
                    Replica.State stateRep = r.getState();
                    log.debug("Calling REQUESTAPPLYUPDATES on: nodeName={}, coreNodeName={}, state={}", new Object[]{nodeName, coreNodeName, stateRep});
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                    params.set("name", new String[]{coreNodeName});
                    shardRequestTracker.sendShardRequest(nodeName, params, shardHandler);
                }
                shardRequestTracker.processResponses((NamedList<Object>)new NamedList(), shardHandler, true, "REQUESTAPPLYUPDATES calls did not succeed");
            }
        }

        private void markAllShardsAsActive(DocCollection restoreCollection) throws KeeperException, InterruptedException {
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
            propMap.put("collection", restoreCollection.getName());
            for (Slice shard : restoreCollection.getSlices()) {
                propMap.put(shard.getName(), Slice.State.ACTIVE.toString());
            }
            ((RestoreCmd)RestoreCmd.this).ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)new ZkNodeProps(propMap)));
        }

        private void addReplicasToShards(NamedList results, ClusterState clusterState, DocCollection restoreCollection, List<ReplicaPosition> replicaPositions, String asyncId) throws Exception {
            int totalReplicasPerShard = this.numNrtReplicas + this.numTlogReplicas + this.numPullReplicas;
            if (totalReplicasPerShard > 1) {
                if (log.isInfoEnabled()) {
                    log.info("Adding replicas to restored collection={}", (Object)restoreCollection.getName());
                }
                for (Slice slice : restoreCollection.getSlices()) {
                    int createdNrtReplicas = 0;
                    int createdTlogReplicas = 0;
                    int createdPullReplicas = 0;
                    if (this.numNrtReplicas > 0) {
                        ++createdNrtReplicas;
                    } else if (this.numTlogReplicas > 0) {
                        ++createdTlogReplicas;
                    }
                    for (int i = 1; i < totalReplicasPerShard; ++i) {
                        Replica.Type typeToCreate;
                        if (createdNrtReplicas < this.numNrtReplicas) {
                            ++createdNrtReplicas;
                            typeToCreate = Replica.Type.NRT;
                        } else if (createdTlogReplicas < this.numTlogReplicas) {
                            ++createdTlogReplicas;
                            typeToCreate = Replica.Type.TLOG;
                        } else {
                            typeToCreate = Replica.Type.PULL;
                            assert (++createdPullReplicas <= this.numPullReplicas) : "Unexpected number of replicas";
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Adding replica for shard={} collection={} of type {} ", new Object[]{slice.getName(), restoreCollection, typeToCreate});
                        }
                        HashMap<String, Object> propMap = new HashMap<String, Object>();
                        propMap.put("collection", restoreCollection.getName());
                        propMap.put("shard", slice.getName());
                        propMap.put("type", typeToCreate.name());
                        for (ReplicaPosition replicaPosition : replicaPositions) {
                            if (!Objects.equals(replicaPosition.shard, slice.getName())) continue;
                            String node = replicaPosition.node;
                            propMap.put("node", node);
                            replicaPositions.remove(replicaPosition);
                            break;
                        }
                        if (asyncId != null) {
                            propMap.put("async", asyncId);
                        }
                        RestoreCmd.this.ocmh.addPropertyParams(this.message, propMap);
                        RestoreCmd.this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap), results, null);
                    }
                }
            }
        }

        private void restoringAlias(BackupProperties properties) {
            String backupCollection = properties.getCollection();
            String backupCollectionAlias = properties.getCollectionAlias();
            if (backupCollectionAlias != null && !backupCollectionAlias.equals(backupCollection)) {
                log.debug("Restoring alias {} -> {}", (Object)backupCollectionAlias, (Object)backupCollection);
                ((RestoreCmd)RestoreCmd.this).ocmh.zkStateReader.aliasesManager.applyModificationAndExportToZk(a -> a.cloneWithCollectionAlias(backupCollectionAlias, backupCollection));
            }
        }
    }

    private static class RestoreContext
    implements Closeable {
        final String restoreCollectionName;
        final String backupName;
        final String backupCollection;
        final String asyncId;
        final String repo;
        final String restoreConfigName;
        final int backupId;
        final URI location;
        final URI backupPath;
        final List<String> nodeList;
        final boolean requestIsTrusted;
        final CoreContainer container;
        final BackupRepository repository;
        final ZkStateReader zkStateReader;
        final BackupManager backupManager;
        final BackupProperties backupProperties;
        final DocCollection backupCollectionState;
        final ShardHandler shardHandler;

        private RestoreContext(ZkNodeProps message, OverseerCollectionMessageHandler ocmh) throws IOException {
            this.restoreCollectionName = message.getStr("collection");
            this.backupName = message.getStr("name");
            this.asyncId = message.getStr("async");
            this.repo = message.getStr("repository");
            this.backupId = message.getInt("backupId", Integer.valueOf(-1));
            this.requestIsTrusted = message.getBool("trusted", false);
            this.container = ocmh.overseer.getCoreContainer();
            this.repository = this.container.newBackupRepository(Optional.ofNullable(this.repo));
            this.location = this.repository.createDirectoryURI(message.getStr("location"));
            URI backupNameUri = this.repository.resolveDirectory(this.location, this.backupName);
            String[] entries = this.repository.listAll(backupNameUri);
            boolean incremental = !Arrays.stream(entries).anyMatch(entry -> entry.equals("backup.properties"));
            this.backupPath = incremental ? this.repository.resolveDirectory(backupNameUri, entries[0]) : backupNameUri;
            this.zkStateReader = ocmh.zkStateReader;
            this.backupManager = this.backupId == -1 ? BackupManager.forRestore(this.repository, this.zkStateReader, this.backupPath) : BackupManager.forRestore(this.repository, this.zkStateReader, this.backupPath, this.backupId);
            this.backupProperties = this.backupManager.readBackupProperties();
            this.backupCollection = this.backupProperties.getCollection();
            this.restoreConfigName = message.getStr("collection.configName", this.backupProperties.getConfigName());
            this.backupCollectionState = this.backupManager.readCollectionState(this.backupCollection);
            this.shardHandler = ocmh.shardHandlerFactory.getShardHandler();
            this.nodeList = Assign.getLiveOrLiveAndCreateNodeSetList(this.zkStateReader.getClusterState().getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM, this.container.getZkController().getSolrCloudManager().getDistribStateManager());
        }

        @Override
        public void close() throws IOException {
            if (this.repository != null) {
                this.repository.close();
            }
        }
    }
}

