/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SourceCodeManagementSystems {
    SUBVERSION(".svn", null),
    GIT(".git", ".gitignore"),
    BAZAAR(".bzr", ".bzrignore"),
    MERCURIAL(".hg", ".hgignore"),
    CVS("CVS", ".cvsignore");

    private String directory;
    private String ignoreFile;

    private SourceCodeManagementSystems(String directory, String ignoreFile) {
        this.directory = directory;
        this.ignoreFile = ignoreFile;
    }

    public List<String> getExclusions() {
        ArrayList<String> excludes = new ArrayList<String>(2);
        if (this.hasIgnoreFile()) {
            excludes.add("**/" + this.ignoreFile);
        }
        excludes.add("*/" + this.directory + "/*");
        return excludes;
    }

    public boolean hasIgnoreFile() {
        return this.ignoreFile != null && this.ignoreFile.length() != 0;
    }

    public static List<String> getPluginExclusions() {
        ArrayList<String> pluginExclusions = new ArrayList<String>();
        for (SourceCodeManagementSystems scm : SourceCodeManagementSystems.values()) {
            pluginExclusions.addAll(scm.getExclusions());
        }
        return pluginExclusions;
    }

    public String getIgnoreFile() {
        return this.ignoreFile;
    }
}

