<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
---
layout: page
title: Mailing Lists, IRC and Archives

    
---

# General

Communication at Mahout happens primarily online via mailing lists. We have
a user as well as a dev list for discussion. In addition there is a commit
list so we are able to monitor what happens on the wiki and in svn.

<a name="MailingLists,IRCandArchives-Mailinglists"></a>
# Mailing lists

<a name="MailingLists,IRCandArchives-MahoutUserList"></a>
## Mahout User List

This list is for users of Mahout to ask questions, share knowledge, and
discuss issues. Do send mail to this list with usage and configuration
questions and problems. Also, please send questions to this list to verify
your problem before filing issues in JIRA. 

* [Subscribe](mailto:user-subscribe@mahout.apache.org)
* [Unsubscribe](mailto:user-unsubscribe@mahout.apache.org)

<a name="MailingLists,IRCandArchives-MahoutDeveloperList"></a>
## Mahout Developer List

This is the list where participating developers of the Mahout project meet
and discuss issues concerning Mahout internals, code changes/additions,
etc. Do not send mail to this list with usage questions or configuration
questions and problems. 

Discussion list: 

* [Subscribe](mailto:dev-subscribe@mahout.apache.org)
 -- Do not send mail to this list with usage questions or configuration
questions and problems. 
* [Unsubscribe](mailto:dev-unsubscribe@mahout.apache.org)

Commit notifications: 

* [Subscribe](mailto:commits-subscribe@mahout.apache.org)
* [Unsubscribe](mailto:commits-unsubscribe@mahout.apache.org)

<a name="MailingLists,IRCandArchives-IRC"></a>
# IRC

Mahout's IRC channel is **#mahout**.  It is a logged channel.  Please keep in
mind that it is for discussion purposes only and that (pseudo)decisions
should be brought back to the dev@ mailing list or JIRA and other people
who are not on IRC should be given time to respond before any work is
committed.

<a name="MailingLists,IRCandArchives-Archives"></a>
# Archives

<a name="MailingLists,IRCandArchives-OfficialApacheArchive"></a>
## Official Apache Archive

* [http://mail-archives.apache.org/mod_mbox/mahout-dev/](http://mail-archives.apache.org/mod_mbox/mahout-dev/)
* [http://mail-archives.apache.org/mod_mbox/mahout-user/](http://mail-archives.apache.org/mod_mbox/mahout-user/)

<a name="MailingLists,IRCandArchives-ExternalArchives"></a>
## External Archives

* [MarkMail](http://mahout.markmail.org/)
* [Gmane](http://dir.gmane.org/gmane.comp.apache.mahout.user)

Please note the inclusion of a link to an archive does not imply an
endorsement of that company by any of the committers of Mahout the Lucene
PMC or the Apache Software Foundation. Each archive owner is solely
responsible for the contents and availability of their archive.
