/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorMapping;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesMaster;
import org.openxmlformats.schemas.presentationml.x2006.main.NotesMasterDocument;

public class XSLFNotesMaster
extends XSLFSheet {
    private CTNotesMaster _slide;
    private XSLFTheme _theme;

    XSLFNotesMaster() {
        this._slide = XSLFNotesMaster.prototype();
    }

    protected XSLFNotesMaster(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        NotesMasterDocument doc = NotesMasterDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._slide = doc.getNotesMaster();
        this.setCommonSlideData(this._slide.getCSld());
    }

    private static CTNotesMaster prototype() {
        InputStream is = XSLFNotesMaster.class.getResourceAsStream("notesMaster.xml");
        if (is == null) {
            throw new POIXMLException("Missing resource 'notesMaster.xml'");
        }
        try {
            NotesMasterDocument doc = NotesMasterDocument.Factory.parse((InputStream)is);
            CTNotesMaster slide = doc.getNotesMaster();
            return slide;
        }
        catch (Exception e) {
            throw new POIXMLException("Can't initialize NotesMaster", e);
        }
    }

    public CTNotesMaster getXmlObject() {
        return this._slide;
    }

    @Override
    protected String getRootElementName() {
        return "notesMaster";
    }

    @Override
    public XSLFSheet getMasterSheet() {
        return null;
    }

    @Override
    public XSLFTheme getTheme() {
        if (this._theme == null) {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSLFTheme)) continue;
                this._theme = (XSLFTheme)p;
                CTColorMapping cmap = this._slide.getClrMap();
                if (cmap == null) break;
                this._theme.initColorMap(cmap);
                break;
            }
        }
        return this._theme;
    }
}

