/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmItsfHeader;
import org.apache.tika.parser.chm.accessor.ChmItspHeader;
import org.apache.tika.parser.chm.accessor.ChmPmglHeader;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmDirectoryListingSet {
    private List<DirectoryListingEntry> dlel;
    private byte[] data;
    private int placeHolder = -1;
    private long dataOffset = -1L;
    private int controlDataIndex = -1;
    private int resetTableIndex = -1;
    private boolean isNotControlDataFound = true;
    private boolean isNotResetTableFound = true;
    private ChmPmglHeader PMGLheader;

    public ChmDirectoryListingSet(byte[] data, ChmItsfHeader chmItsHeader, ChmItspHeader chmItspHeader) throws TikaException {
        this.setDirectoryListingEntryList(new ArrayList<DirectoryListingEntry>());
        ChmCommons.assertByteArrayNotNull(data);
        this.setData(data);
        this.enumerateChmDirectoryListingList(chmItsHeader, chmItspHeader);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("list:=" + this.getDirectoryListingEntryList().toString() + System.getProperty("line.separator"));
        sb.append("number of list items:=" + this.getDirectoryListingEntryList().size());
        return sb.toString();
    }

    public int getControlDataIndex() {
        return this.controlDataIndex;
    }

    protected void setControlDataIndex(int controlDataIndex) {
        this.controlDataIndex = controlDataIndex;
    }

    public int getResetTableIndex() {
        return this.resetTableIndex;
    }

    protected void setResetTableIndex(int resetTableIndex) {
        this.resetTableIndex = resetTableIndex;
    }

    private void setPlaceHolder(int placeHolder) {
        this.placeHolder = placeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enumerateChmDirectoryListingList(ChmItsfHeader chmItsHeader, ChmItspHeader chmItspHeader) {
        try {
            int startPmgl = chmItspHeader.getIndex_head();
            int stopPmgl = chmItspHeader.getUnknown_0024();
            int dir_offset = (int)(chmItsHeader.getDirOffset() + (long)chmItspHeader.getHeader_len());
            this.setDataOffset(chmItsHeader.getDataOffset());
            byte[] dir_chunk = null;
            int i = startPmgl;
            while (i >= 0) {
                dir_chunk = new byte[(int)chmItspHeader.getBlock_len()];
                int start = i * (int)chmItspHeader.getBlock_len() + dir_offset;
                dir_chunk = ChmCommons.copyOfRange(this.getData(), start, start + (int)chmItspHeader.getBlock_len());
                this.PMGLheader = new ChmPmglHeader();
                this.PMGLheader.parse(dir_chunk, this.PMGLheader);
                this.enumerateOneSegment(dir_chunk);
                i = this.PMGLheader.getBlockNext();
                dir_chunk = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setData(null);
        }
    }

    private void checkControlData(DirectoryListingEntry dle) {
        if (this.isNotControlDataFound && dle.getName().contains("ControlData")) {
            this.setControlDataIndex(this.getDirectoryListingEntryList().size());
            this.isNotControlDataFound = false;
        }
    }

    private void checkResetTable(DirectoryListingEntry dle) {
        if (this.isNotResetTableFound && dle.getName().contains("ResetTable")) {
            this.setResetTableIndex(this.getDirectoryListingEntryList().size());
            this.isNotResetTableFound = false;
        }
    }

    public static final boolean startsWith(byte[] data, String prefix) {
        for (int i = 0; i < prefix.length(); ++i) {
            if (data[i] == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void enumerateOneSegment(byte[] dir_chunk) throws ChmParsingException {
        if (dir_chunk != null) {
            if (ChmDirectoryListingSet.startsWith(dir_chunk, "PMGI")) {
                int header_len = 8;
                return;
            }
            if (!ChmDirectoryListingSet.startsWith(dir_chunk, "PMGL")) {
                throw new ChmParsingException("Bad dir entry block.");
            }
            int header_len = 20;
            this.placeHolder = header_len;
            while (this.placeHolder > 0 && (long)this.placeHolder < (long)dir_chunk.length - this.PMGLheader.getFreeSpace()) {
                byte temp;
                int strlen = 0;
                while ((temp = dir_chunk[this.placeHolder++]) >= 128) {
                    strlen <<= 7;
                    strlen += temp & 0x7F;
                }
                if ((strlen = (strlen << 7) + temp & 0x7F) > dir_chunk.length) {
                    throw new ChmParsingException("Bad data of a string length.");
                }
                DirectoryListingEntry dle = new DirectoryListingEntry();
                dle.setNameLength(strlen);
                try {
                    dle.setName(new String(ChmCommons.copyOfRange(dir_chunk, this.placeHolder, this.placeHolder + dle.getNameLength()), "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    dle.setName(new String(dir_chunk, this.placeHolder, this.placeHolder + dle.getNameLength()));
                }
                this.checkControlData(dle);
                this.checkResetTable(dle);
                this.setPlaceHolder(this.placeHolder + dle.getNameLength());
                if (this.placeHolder < dir_chunk.length && dir_chunk[this.placeHolder] == 0) {
                    dle.setEntryType(ChmCommons.EntryType.UNCOMPRESSED);
                } else {
                    dle.setEntryType(ChmCommons.EntryType.COMPRESSED);
                }
                this.setPlaceHolder(this.placeHolder + 1);
                dle.setOffset(this.getEncint(dir_chunk));
                dle.setLength(this.getEncint(dir_chunk));
                this.getDirectoryListingEntryList().add(dle);
            }
        }
    }

    private int getEncint(byte[] data_chunk) {
        BigInteger bi = BigInteger.ZERO;
        byte[] nb = new byte[1];
        if (this.placeHolder < data_chunk.length) {
            byte ob;
            while ((ob = data_chunk[this.placeHolder]) < 0) {
                nb[0] = (byte)(ob & 0x7F);
                bi = bi.shiftLeft(7).add(new BigInteger(nb));
                this.setPlaceHolder(this.placeHolder + 1);
            }
            nb[0] = (byte)(ob & 0x7F);
            bi = bi.shiftLeft(7).add(new BigInteger(nb));
            this.setPlaceHolder(this.placeHolder + 1);
        }
        return bi.intValue();
    }

    public void setDirectoryListingEntryList(List<DirectoryListingEntry> dlel) {
        this.dlel = dlel;
    }

    public List<DirectoryListingEntry> getDirectoryListingEntryList() {
        return this.dlel;
    }

    private void setData(byte[] data) {
        this.data = data;
    }

    private byte[] getData() {
        return this.data;
    }

    private void setDataOffset(long dataOffset) {
        this.dataOffset = dataOffset;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }
}

