/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.tika.parser.pdf.PDF2XHTML;

public class PDFParserConfig
implements Serializable {
    private static final long serialVersionUID = 6492570218190936986L;
    private boolean enableAutoSpace = true;
    private boolean suppressDuplicateOverlappingText;
    private boolean extractAnnotationText = true;
    private boolean sortByPosition = false;
    private boolean useNonSequentialParser = false;
    private boolean extractAcroFormContent = true;
    private boolean extractInlineImages = false;
    private boolean extractUniqueInlineImagesOnly = true;
    private Float averageCharTolerance;
    private Float spacingTolerance;

    public PDFParserConfig() {
        this.init(this.getClass().getResourceAsStream("PDFParser.properties"));
    }

    public PDFParserConfig(InputStream is) {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is) {
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        this.setEnableAutoSpace(this.getProp(props.getProperty("enableAutoSpace"), this.getEnableAutoSpace()));
        this.setSuppressDuplicateOverlappingText(this.getProp(props.getProperty("suppressDuplicateOverlappingText"), this.getSuppressDuplicateOverlappingText()));
        this.setExtractAnnotationText(this.getProp(props.getProperty("extractAnnotationText"), this.getExtractAnnotationText()));
        this.setSortByPosition(this.getProp(props.getProperty("sortByPosition"), this.getSortByPosition()));
        this.setUseNonSequentialParser(this.getProp(props.getProperty("useNonSequentialParser"), this.getUseNonSequentialParser()));
        this.setExtractAcroFormContent(this.getProp(props.getProperty("extractAcroFormContent"), this.getExtractAcroFormContent()));
        this.setExtractInlineImages(this.getProp(props.getProperty("extractInlineImages"), this.getExtractInlineImages()));
        this.setExtractUniqueInlineImagesOnly(this.getProp(props.getProperty("extractUniqueInlineImagesOnly"), this.getExtractUniqueInlineImagesOnly()));
    }

    public void configure(PDF2XHTML pdf2XHTML) {
        pdf2XHTML.setForceParsing(true);
        pdf2XHTML.setSortByPosition(this.getSortByPosition());
        if (this.getEnableAutoSpace()) {
            pdf2XHTML.setWordSeparator(" ");
        } else {
            pdf2XHTML.setWordSeparator("");
        }
        if (this.getAverageCharTolerance() != null) {
            pdf2XHTML.setAverageCharTolerance(this.getAverageCharTolerance().floatValue());
        }
        if (this.getSpacingTolerance() != null) {
            pdf2XHTML.setSpacingTolerance(this.getSpacingTolerance().floatValue());
        }
        pdf2XHTML.setSuppressDuplicateOverlappingText(this.getSuppressDuplicateOverlappingText());
    }

    public void setExtractAcroFormContent(boolean extractAcroFormContent) {
        this.extractAcroFormContent = extractAcroFormContent;
    }

    public boolean getExtractAcroFormContent() {
        return this.extractAcroFormContent;
    }

    public void setExtractInlineImages(boolean extractInlineImages) {
        this.extractInlineImages = extractInlineImages;
    }

    public boolean getExtractInlineImages() {
        return this.extractInlineImages;
    }

    public void setExtractUniqueInlineImagesOnly(boolean extractUniqueInlineImagesOnly) {
        this.extractUniqueInlineImagesOnly = extractUniqueInlineImagesOnly;
    }

    public boolean getExtractUniqueInlineImagesOnly() {
        return this.extractUniqueInlineImagesOnly;
    }

    public boolean getEnableAutoSpace() {
        return this.enableAutoSpace;
    }

    public void setEnableAutoSpace(boolean enableAutoSpace) {
        this.enableAutoSpace = enableAutoSpace;
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingText) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingText;
    }

    public boolean getExtractAnnotationText() {
        return this.extractAnnotationText;
    }

    public void setExtractAnnotationText(boolean extractAnnotationText) {
        this.extractAnnotationText = extractAnnotationText;
    }

    public boolean getSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean sortByPosition) {
        this.sortByPosition = sortByPosition;
    }

    public boolean getUseNonSequentialParser() {
        return this.useNonSequentialParser;
    }

    public void setUseNonSequentialParser(boolean useNonSequentialParser) {
        this.useNonSequentialParser = useNonSequentialParser;
    }

    public Float getAverageCharTolerance() {
        return this.averageCharTolerance;
    }

    public void setAverageCharTolerance(Float averageCharTolerance) {
        this.averageCharTolerance = averageCharTolerance;
    }

    public Float getSpacingTolerance() {
        return this.spacingTolerance;
    }

    public void setSpacingTolerance(Float spacingTolerance) {
        this.spacingTolerance = spacingTolerance;
    }

    private boolean getProp(String p, boolean defaultMissing) {
        if (p == null) {
            return defaultMissing;
        }
        if (p.toLowerCase(Locale.ROOT).equals("true")) {
            return true;
        }
        if (p.toLowerCase(Locale.ROOT).equals("false")) {
            return false;
        }
        return defaultMissing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.averageCharTolerance == null ? 0 : this.averageCharTolerance.hashCode());
        result = 31 * result + (this.enableAutoSpace ? 1231 : 1237);
        result = 31 * result + (this.extractAcroFormContent ? 1231 : 1237);
        result = 31 * result + (this.extractAnnotationText ? 1231 : 1237);
        result = 31 * result + (this.extractInlineImages ? 1231 : 1237);
        result = 31 * result + (this.extractUniqueInlineImagesOnly ? 1231 : 1237);
        result = 31 * result + (this.sortByPosition ? 1231 : 1237);
        result = 31 * result + (this.spacingTolerance == null ? 0 : this.spacingTolerance.hashCode());
        result = 31 * result + (this.suppressDuplicateOverlappingText ? 1231 : 1237);
        result = 31 * result + (this.useNonSequentialParser ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PDFParserConfig other = (PDFParserConfig)obj;
        if (this.averageCharTolerance == null ? other.averageCharTolerance != null : !this.averageCharTolerance.equals(other.averageCharTolerance)) {
            return false;
        }
        if (this.enableAutoSpace != other.enableAutoSpace) {
            return false;
        }
        if (this.extractAcroFormContent != other.extractAcroFormContent) {
            return false;
        }
        if (this.extractAnnotationText != other.extractAnnotationText) {
            return false;
        }
        if (this.extractInlineImages != other.extractInlineImages) {
            return false;
        }
        if (this.extractUniqueInlineImagesOnly != other.extractUniqueInlineImagesOnly) {
            return false;
        }
        if (this.sortByPosition != other.sortByPosition) {
            return false;
        }
        if (this.spacingTolerance == null ? other.spacingTolerance != null : !this.spacingTolerance.equals(other.spacingTolerance)) {
            return false;
        }
        if (this.suppressDuplicateOverlappingText != other.suppressDuplicateOverlappingText) {
            return false;
        }
        return this.useNonSequentialParser == other.useNonSequentialParser;
    }

    public String toString() {
        return "PDFParserConfig [enableAutoSpace=" + this.enableAutoSpace + ", suppressDuplicateOverlappingText=" + this.suppressDuplicateOverlappingText + ", extractAnnotationText=" + this.extractAnnotationText + ", sortByPosition=" + this.sortByPosition + ", useNonSequentialParser=" + this.useNonSequentialParser + ", extractAcroFormContent=" + this.extractAcroFormContent + ", extractInlineImages=" + this.extractInlineImages + ", extractUniqueInlineImagesOnly=" + this.extractUniqueInlineImagesOnly + ", averageCharTolerance=" + this.averageCharTolerance + ", spacingTolerance=" + this.spacingTolerance + "]";
    }
}

