/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientFactory {
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;

    public static HttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings) {
        PoolingClientConnectionManager cm = HttpClientFactory.createClientConnectionManagerWithSSLSettings(maxConnections);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)cm);
        HttpParams params = client.getParams();
        params.setParameter("http.protocol.handle-redirects", (Object)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutMilliseconds);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutMilliseconds);
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            params.setParameter("http.route.default-proxy", (Object)proxyHost);
        }
        return client;
    }

    public static HttpClient createClient(int maxConnections, int timeoutMilliseconds) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, ProxySettings.NO_PROXY);
    }

    public static HttpClient createClient(int timeoutMilliseconds) {
        return HttpClientFactory.createClient(50, timeoutMilliseconds);
    }

    public static HttpClient createClient() {
        return HttpClientFactory.createClient(30000);
    }

    private static PoolingClientConnectionManager createClientConnectionManagerWithSSLSettings(int maxConnections) {
        try {
            AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
            SSLSocketFactory socketFactory = HttpClientFactory.createSslSocketFactory((X509HostnameVerifier)hostnameVerifier);
            SchemeRegistry schemeRegistry = HttpClientFactory.createSchemeRegistry(socketFactory);
            PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
            cm.setDefaultMaxPerRoute(maxConnections);
            cm.setMaxTotal(maxConnections);
            return cm;
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, PoolingClientConnectionManager.class);
        }
    }

    private static SchemeRegistry createSchemeRegistry(SSLSocketFactory socketFactory) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme(HTTP_PROTOCOL, 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme(HTTPS_PROTOCOL, 443, (SchemeSocketFactory)socketFactory));
        return schemeRegistry;
    }

    private static SSLSocketFactory createSslSocketFactory(X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, HttpClientFactory.trustEverything(), new SecureRandom());
        return new SSLSocketFactory(sslContext, hostnameVerifier);
    }

    private static TrustManager[] trustEverything() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

