/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReleaseTracker {
    public static Map<Object, String> OBJECTS = new ConcurrentHashMap<Object, String>();

    public static boolean track(Object object) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new ObjectTrackerException().printStackTrace(pw);
        OBJECTS.put(object, sw.toString());
        return true;
    }

    public static boolean release(Object object) {
        OBJECTS.remove(object);
        return true;
    }

    public static boolean clearObjectTrackerAndCheckEmpty() {
        Set<Map.Entry<Object, String>> entries = OBJECTS.entrySet();
        boolean empty = entries.isEmpty();
        if (entries.size() > 0) {
            System.err.println("ObjectTracker found objects that were not released!!!");
        }
        for (Map.Entry<Object, String> entry : entries) {
            System.err.println(entry.getValue());
        }
        OBJECTS.clear();
        return empty;
    }

    private static class ObjectTrackerException
    extends RuntimeException {
        private ObjectTrackerException() {
        }
    }
}

