/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class StandardEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final long length;
    private final DDMReader reader;
    private long remainingBytes;
    private ByteArrayInputStream currentBuffer;

    StandardEXTDTAReaderInputStream(DDMReader dDMReader, boolean bl) throws DRDAProtocolException {
        super(false, bl);
        this.reader = dDMReader;
        this.remainingBytes = bl ? dDMReader.getDdmLength() - 1L : dDMReader.getDdmLength();
        this.length = this.remainingBytes;
        this.currentBuffer = dDMReader.readLOBInitStream(this.remainingBytes + (long)(bl ? 1 : 0));
    }

    public final int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        return n == 1 ? byArray[0] : -1;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int n3 = this.currentBuffer.read(byArray, n, n2 = (int)Math.min(this.remainingBytes, (long)n2));
        if (n3 < 0) {
            this.nextBuffer();
            n3 = this.currentBuffer.read(byArray, n, n2);
        }
        if (this.readStatusByte && (long)n3 == this.remainingBytes) {
            if (this.currentBuffer.available() == 0) {
                this.nextBuffer();
            }
            this.checkStatus(this.currentBuffer.read());
            if (this.currentBuffer.read() != -1) {
                throw new IllegalStateException("Remaining bytes in buffer after status byte");
            }
        }
        this.remainingBytes -= (long)n3;
        return n3;
    }

    public final int available() {
        if (this.remainingBytes <= 0L) {
            return 0;
        }
        int n = this.currentBuffer.available();
        if (this.readStatusByte && (long)n > this.remainingBytes) {
            --n;
        }
        return n;
    }

    final long getLength() {
        return this.length;
    }

    private void nextBuffer() throws IOException {
        long l = this.readStatusByte ? this.remainingBytes + 1L : this.remainingBytes;
        this.currentBuffer = this.reader.readLOBContinuationStream(l);
    }

    protected void onClientSideStreamingError() {
        this.currentBuffer = null;
        this.remainingBytes = -1L;
    }
}

