/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.QueryTypeImpl;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.ExtendedHolder;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryServiceImpl
extends AbstractAtomPubService
implements DiscoveryService {
    public DiscoveryServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeACL, BigInteger maxItems, ExtensionsData extension) {
        ObjectListImpl result = new ObjectListImpl();
        String link = null;
        UrlBuilder url = null;
        if (changeLogToken instanceof ExtendedHolder && changeLogToken.getValue() == null && (link = (String)((ExtendedHolder)changeLogToken).getExtraValue("http://docs.oasis-open.org/ns/cmis/link/200908/changes")) != null) {
            url = new UrlBuilder(link);
        }
        if (link == null && (link = this.loadRepositoryLink(repositoryId, "http://docs.oasis-open.org/ns/cmis/link/200908/changes")) != null) {
            url = new UrlBuilder(link);
            url.addParameter("changeLogToken", changeLogToken == null ? null : (String)changeLogToken.getValue());
            url.addParameter("includeProperties", (Object)includeProperties);
            url.addParameter("filter", (Object)filter);
            url.addParameter("includePolicyIds", (Object)includePolicyIds);
            url.addParameter("includeACL", (Object)includeACL);
            url.addParameter("maxItems", (Object)maxItems);
        }
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or content changes not supported!");
        }
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        String lastChangeLogToken = null;
        String nextLink = null;
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                nextLink = ((AtomLink)element.getObject()).getHref();
                continue;
            }
            if (this.isInt("numItems", element)) {
                result.setNumItems((BigInteger)element.getObject());
                continue;
            }
            if (!this.isStr("changeLogToken", element)) continue;
            lastChangeLogToken = (String)element.getObject();
        }
        if (!feed.getEntries().isEmpty()) {
            result.setObjects(new ArrayList(feed.getEntries().size()));
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData hit = null;
                for (AtomElement element : entry.getElements()) {
                    if (!(element.getObject() instanceof ObjectData)) continue;
                    hit = (ObjectData)element.getObject();
                }
                if (hit == null) continue;
                result.getObjects().add(hit);
            }
        }
        if (changeLogToken != null) {
            changeLogToken.setValue(lastChangeLogToken);
            if (changeLogToken instanceof ExtendedHolder && nextLink != null) {
                ((ExtendedHolder)changeLogToken).setExtraValue("http://docs.oasis-open.org/ns/cmis/link/200908/changes", nextLink);
            }
        }
        return result;
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectListImpl result = new ObjectListImpl();
        String link = this.loadCollection(repositoryId, "query");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or query not supported!");
        }
        UrlBuilder url = new UrlBuilder(link);
        final QueryTypeImpl query = new QueryTypeImpl();
        query.setStatement(statement);
        query.setSearchAllVersions(searchAllVersions);
        query.setIncludeAllowableActions(includeAllowableActions);
        query.setIncludeRelationships(includeRelationships);
        query.setRenditionFilter(renditionFilter);
        query.setMaxItems(maxItems);
        query.setSkipCount(skipCount);
        final CmisVersion cmisVersion = this.getCmisVersion(repositoryId);
        Response resp = this.post(url, "application/cmisquery+xml", new Output(){

            public void write(OutputStream out) throws Exception {
                XMLStreamWriter writer = XMLUtils.createWriter((OutputStream)out);
                XMLUtils.startXmlDocument((XMLStreamWriter)writer);
                XMLConverter.writeQuery((XMLStreamWriter)writer, (CmisVersion)cmisVersion, (QueryTypeImpl)query);
                XMLUtils.endXmlDocument((XMLStreamWriter)writer);
            }
        });
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                continue;
            }
            if (!this.isInt("numItems", element)) continue;
            result.setNumItems((BigInteger)element.getObject());
        }
        if (!feed.getEntries().isEmpty()) {
            result.setObjects(new ArrayList(feed.getEntries().size()));
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData hit = null;
                for (AtomElement element : entry.getElements()) {
                    if (!(element.getObject() instanceof ObjectData)) continue;
                    hit = (ObjectData)element.getObject();
                }
                if (hit == null) continue;
                result.getObjects().add(hit);
            }
        }
        return result;
    }
}

