/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.jettyrunner;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;

public class ManifoldCFJettyShutdown {
    public static final String _rcsid = "@(#)$Id: ManifoldCFJettyShutdown.java 1672616 2015-04-10 11:47:49Z kwright $";
    protected final String jettyBaseURL;

    public ManifoldCFJettyShutdown(String jettyBaseURL) {
        this.jettyBaseURL = jettyBaseURL;
    }

    public void shutdownJetty() throws Exception {
        String shutdownToken = System.getProperty("org.apache.manifoldcf.jettyshutdowntoken");
        if (shutdownToken != null) {
            int socketTimeout = 900000;
            int connectionTimeout = 300000;
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager();
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(60000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
            PoolingHttpClientConnectionManager connectionManager = poolingConnectionManager;
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
            HttpPost method = new HttpPost(this.jettyBaseURL + "/shutdown?token=" + URLEncoder.encode(shutdownToken, "UTF-8"));
            method.setEntity((HttpEntity)new StringEntity("", ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
            try {
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)method);
                int resultCode = httpResponse.getStatusLine().getStatusCode();
                if (resultCode != 200) {
                    throw new Exception("Received result code " + resultCode + " from POST");
                }
            }
            catch (NoHttpResponseException noHttpResponseException) {}
        } else {
            throw new Exception("No jetty shutdown token specified");
        }
    }

    public static void main(String[] args) {
        if (args.length != 0 && args.length != 1) {
            System.err.println("Usage: ManifoldCFJettyShutdown [<jetty_base_url>]");
            System.exit(1);
        }
        String jettyURL = args.length > 0 ? args[0] : "http://localhost:8345";
        try {
            ManifoldCFJettyShutdown js = new ManifoldCFJettyShutdown(jettyURL);
            js.shutdownJetty();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

