/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableConfigurationNode;
import org.apache.manifoldcf.scriptengine.VariableDict;
import org.apache.manifoldcf.scriptengine.VariableInt;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.VariableString;

public class VariableConfiguration
extends VariableBase {
    protected Configuration configuration;

    public VariableConfiguration() {
        this.configuration = new Configuration();
    }

    public VariableConfiguration(Configuration c) {
        this.configuration = c;
    }

    public VariableConfiguration(String json) throws ScriptException {
        this.configuration = new Configuration();
        if (json != null && json.length() > 0) {
            try {
                this.configuration.fromJSON(json);
            }
            catch (ManifoldCFException e) {
                throw new ScriptException("Invalid json: '" + json + "': " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int i = 0;
        while (i < this.configuration.getChildCount()) {
            if (i > 0) {
                sb.append(", ");
            }
            ConfigurationNode child = this.configuration.findChild(i++);
            sb.append(new VariableConfigurationNode(child).getScriptValue());
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public boolean hasConfigurationValue() throws ScriptException {
        return true;
    }

    @Override
    public Configuration getConfigurationValue() throws ScriptException {
        return this.configuration;
    }

    @Override
    public VariableReference getAttribute(String attributeName) throws ScriptException {
        if (attributeName.equals("__size__")) {
            return new VariableInt(this.configuration.getChildCount());
        }
        if (attributeName.equals("__dict__")) {
            VariableDict dict = new VariableDict();
            int i = 0;
            while (i < this.configuration.getChildCount()) {
                ConfigurationNode child = this.configuration.findChild(i++);
                String type = child.getType();
                dict.getIndexed(new VariableString(type)).setReference(new VariableConfigurationNode(child));
            }
            return dict;
        }
        return super.getAttribute(attributeName);
    }

    @Override
    public VariableReference getIndexed(Variable index) throws ScriptException {
        if (index == null) {
            throw new ScriptException(this.composeMessage("Subscript cannot be null"));
        }
        int indexValue = index.getIntValue();
        if (indexValue >= 0 && indexValue < this.configuration.getChildCount()) {
            return new NodeReference(indexValue);
        }
        throw new ScriptException(this.composeMessage("Subscript is out of bounds: " + indexValue));
    }

    @Override
    public void insertAt(Variable v, Variable index) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Can't insert a null object into a configuration"));
        }
        if (index == null) {
            this.configuration.addChild(this.configuration.getChildCount(), v.getConfigurationNodeValue());
        } else {
            int indexValue = index.getIntValue();
            if (indexValue < 0 || indexValue > this.configuration.getChildCount()) {
                throw new ScriptException(this.composeMessage("Configuration insert out of bounds: " + indexValue));
            }
            this.configuration.addChild(indexValue, v.getConfigurationNodeValue());
        }
    }

    @Override
    public void removeAt(Variable index) throws ScriptException {
        if (index == null) {
            throw new ScriptException(this.composeMessage("Configuration remove index cannot be null"));
        }
        int indexValue = index.getIntValue();
        if (indexValue < 0 || indexValue >= this.configuration.getChildCount()) {
            throw new ScriptException(this.composeMessage("Configuration remove index out of bounds"));
        }
        this.configuration.removeChild(indexValue);
    }

    @Override
    public VariableReference plus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '+' can't add a null object"));
        }
        ConfigurationNode node = v.getConfigurationNodeValue();
        Configuration c = new Configuration();
        int i = 0;
        while (i < this.configuration.getChildCount()) {
            ConfigurationNode child = this.configuration.findChild(i++);
            c.addChild(c.getChildCount(), child);
        }
        c.addChild(c.getChildCount(), node);
        return new VariableConfiguration(c);
    }

    protected class NodeReference
    implements VariableReference {
        protected int index;

        public NodeReference(int index) {
            this.index = index;
        }

        @Override
        public void setReference(Variable v) throws ScriptException {
            if (this.index < 0 || this.index >= VariableConfiguration.this.configuration.getChildCount()) {
                throw new ScriptException(VariableConfiguration.this.composeMessage("Index out of range for Configuration children: " + this.index));
            }
            ConfigurationNode confNode = v.getConfigurationNodeValue();
            VariableConfiguration.this.configuration.removeChild(this.index);
            VariableConfiguration.this.configuration.addChild(this.index, confNode);
        }

        @Override
        public Variable resolve() throws ScriptException {
            if (this.index < 0 || this.index >= VariableConfiguration.this.configuration.getChildCount()) {
                throw new ScriptException(VariableConfiguration.this.composeMessage("Index out of range for Configuration children: " + this.index));
            }
            return new VariableConfigurationNode(VariableConfiguration.this.configuration.findChild(this.index));
        }

        @Override
        public boolean isNull() {
            return this.index < 0 || this.index >= VariableConfiguration.this.configuration.getChildCount();
        }
    }
}

