/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.TransactionalAgentsInitializationCommand;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class UnRegisterTransformation
extends TransactionalAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: UnRegisterTransformation.java 1601529 2014-06-09 23:19:08Z kwright $";
    private final String className;

    public UnRegisterTransformation(String className) {
        this.className = className;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        ITransformationConnectorManager mgr = TransformationConnectorManagerFactory.make(tc);
        ITransformationConnectionManager connManager = TransformationConnectionManagerFactory.make(tc);
        String[] connectionNames = connManager.findConnectionsForConnector(this.className);
        AgentManagerFactory.noteTransformationConnectorDeregistration(tc, connectionNames);
        mgr.unregisterConnector(this.className);
        Logging.root.info((Object)("Successfully unregistered transformation connector '" + this.className + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: UnRegisterTransformation <classname>");
            System.exit(1);
        }
        String className = args[0];
        try {
            UnRegisterTransformation unRegisterTransformation = new UnRegisterTransformation(className);
            unRegisterTransformation.execute();
            System.err.println("Successfully unregistered transformation connector '" + className + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

