/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.confluence;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.confluence.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.confluence.client.ConfluenceClient;
import org.apache.manifoldcf.crawler.connectors.confluence.model.ConfluenceUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceAuthorityConnector
extends BaseAuthorityConnector {
    private static final String PARAMETER_PREFIX = "confluence_";
    private static final String CONF_SERVER_TAB_PROPERTY = "ConfluenceAuthorityConnector.Server";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_conf.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_conf_server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_conf.html";
    private Logger logger = LoggerFactory.getLogger(ConfluenceAuthorityConnector.class);
    protected String protocol = null;
    protected String host = null;
    protected String port = null;
    protected String path = null;
    protected String username = null;
    protected String password = null;
    protected ConfluenceClient confluenceClient = null;

    public void setConfluenceClient(ConfluenceClient client) {
        this.confluenceClient = client;
    }

    public void disconnect() throws ManifoldCFException {
        if (this.confluenceClient != null) {
            this.confluenceClient = null;
        }
        this.protocol = null;
        this.host = null;
        this.port = null;
        this.path = null;
        this.username = null;
        this.password = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.protocol = this.params.getParameter("protocol");
        this.host = this.params.getParameter("host");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.username = this.params.getParameter("username");
        this.password = this.params.getObfuscatedParameter("password");
        try {
            this.initConfluenceClient();
        }
        catch (ManifoldCFException e) {
            this.logger.debug("Not possible to initialize Confluence client. Reason: {}", (Object)e.getMessage());
        }
    }

    public String check() throws ManifoldCFException {
        try {
            Boolean result;
            if (!this.isConnected()) {
                this.initConfluenceClient();
            }
            if ((result = Boolean.valueOf(this.confluenceClient.checkAuth())).booleanValue()) {
                return super.check();
            }
            throw new ManifoldCFException("Confluence instance could not be reached");
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
        catch (Exception e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void initConfluenceClient() throws ManifoldCFException {
        if (this.confluenceClient == null) {
            int portInt;
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence protocol = '" + this.protocol + "'"));
            }
            if (StringUtils.isEmpty((String)this.host)) {
                throw new ManifoldCFException("Parameter host required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence host = '" + this.host + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence port = '" + this.port + "'"));
            }
            if (StringUtils.isEmpty((String)this.path)) {
                throw new ManifoldCFException("Parameter path required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence path = '" + this.path + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence username = '" + this.username + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence password '" + this.password != null ? "set" : "not set'"));
            }
            if (this.port != null && this.port.length() > 0) {
                try {
                    portInt = Integer.parseInt(this.port);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                portInt = this.protocol.toLowerCase(Locale.ROOT).equals("http") ? 80 : 443;
            }
            this.confluenceClient = new ConfluenceClient(this.protocol, this.host, portInt, this.path, this.username, this.password);
        }
    }

    public boolean isConnected() {
        return this.confluenceClient != null;
    }

    private void fillInServerConfigurationMap(Map<String, String> serverMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String confluenceProtocol = parameters.getParameter("protocol");
        String confluenceHost = parameters.getParameter("host");
        String confluencePort = parameters.getParameter("port");
        String confluencePath = parameters.getParameter("path");
        String confluenceUsername = parameters.getParameter("username");
        String confluencePassword = parameters.getObfuscatedParameter("password");
        if (confluenceProtocol == null) {
            confluenceProtocol = "http";
        }
        if (confluenceHost == null) {
            confluenceHost = "";
        }
        if (confluencePort == null) {
            confluencePort = "8090";
        }
        if (confluencePath == null) {
            confluencePath = "/confluence";
        }
        if (confluenceUsername == null) {
            confluenceUsername = "";
        }
        confluencePassword = confluencePassword == null ? "" : mapper.mapPasswordToKey(confluencePassword);
        serverMap.put("confluence_protocol", confluenceProtocol);
        serverMap.put("confluence_host", confluenceHost);
        serverMap.put("confluence_port", confluencePort);
        serverMap.put("confluence_path", confluencePath);
        serverMap.put("confluence_username", confluenceUsername);
        serverMap.put("confluence_password", confluencePassword);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap, true);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CONF_SERVER_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap, true);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String confluencePassword;
        String confluenceUsername;
        String confluencePath;
        String confluencePort;
        String confluenceHost;
        String confluenceProtocol = variableContext.getParameter("confluence_protocol");
        if (confluenceProtocol != null) {
            parameters.setParameter("protocol", confluenceProtocol);
        }
        if ((confluenceHost = variableContext.getParameter("confluence_host")) != null) {
            parameters.setParameter("host", confluenceHost);
        }
        if ((confluencePort = variableContext.getParameter("confluence_port")) != null) {
            parameters.setParameter("port", confluencePort);
        }
        if ((confluencePath = variableContext.getParameter("confluence_path")) != null) {
            parameters.setParameter("path", confluencePath);
        }
        if ((confluenceUsername = variableContext.getParameter("confluence_username")) != null) {
            parameters.setParameter("username", confluenceUsername);
        }
        if ((confluencePassword = variableContext.getParameter("confluence_password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(confluencePassword));
        }
        return null;
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        try {
            ConfluenceUser confluenceUser = this.confluenceClient.getUserAuthorities(userName);
            if (confluenceUser.getUsername() == null || confluenceUser.getUsername().isEmpty() || confluenceUser.getAuthorities().isEmpty()) {
                return RESPONSE_USERNOTFOUND;
            }
            return new AuthorizationResponse(confluenceUser.getAuthorities().toArray(new String[confluenceUser.getAuthorities().size()]), 0);
        }
        catch (Exception e) {
            return RESPONSE_UNREACHABLE;
        }
    }
}

