/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Array;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.types.Type;

public class ArrayType
extends Type {
    public static final int defaultArrayCardinality = 1024;
    public static final int defaultLargeArrayCardinality = Integer.MAX_VALUE;
    final Type dataType;
    final int maxCardinality;

    public ArrayType(Type type, int n) {
        super(50, 50, 0L, 0);
        if (type == null) {
            type = Type.SQL_ALL_TYPES;
        }
        this.dataType = type;
        this.maxCardinality = n;
    }

    @Override
    public int displaySize() {
        return 7 + (this.dataType.displaySize() + 1) * this.maxCardinality;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2003;
    }

    @Override
    public Class getJDBCClass() {
        return Array.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Array";
    }

    @Override
    public int getJDBCScale() {
        return 0;
    }

    @Override
    public int getJDBCPrecision() {
        return 0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 0;
    }

    @Override
    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dataType.getNameString()).append(' ');
        stringBuffer.append("ARRAY");
        if (this.maxCardinality != 1024) {
            stringBuffer.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public String getFullNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dataType.getFullNameString()).append(' ');
        stringBuffer.append("ARRAY");
        if (this.maxCardinality != 1024) {
            stringBuffer.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDefinition() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dataType.getDefinition()).append(' ');
        stringBuffer.append("ARRAY");
        if (this.maxCardinality != 1024) {
            stringBuffer.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Object[] objectArray = (Object[])object2;
        Object[] objectArray2 = (Object[])object;
        int n = objectArray2.length;
        if (objectArray.length < n) {
            n = objectArray.length;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.dataType.compare(session, objectArray2[i], objectArray[i]);
            if (n2 == 0) continue;
            return n2;
        }
        if (objectArray2.length > objectArray.length) {
            return 1;
        }
        if (objectArray2.length < objectArray.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.dataType.convertToTypeLimits(sessionInterface, objectArray[i]);
        }
        return objectArray2;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type == null) {
            return object;
        }
        if (!type.isArrayType()) {
            throw Error.error(5562);
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Type type2 = type.collectionBaseType();
        if (this.dataType.equals(type2)) {
            return object;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.dataType.convertToType(sessionInterface, objectArray[i], type2);
        }
        return objectArray2;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        Object[] objectArray;
        boolean bl = false;
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
            bl = true;
        } else if (object instanceof JDBCArray) {
            objectArray = ((JDBCArray)object).getArrayInternal();
        } else if (object instanceof JDBCArrayBasic) {
            objectArray = (Object[])((JDBCArrayBasic)object).getArray();
            bl = true;
        } else if (object instanceof Array) {
            try {
                objectArray = (Object[])((Array)object).getArray();
                bl = true;
            }
            catch (Exception exception) {
                throw Error.error(5561);
            }
        } else {
            throw Error.error(5561);
        }
        if (bl) {
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.dataType.convertJavaToSQL(sessionInterface, objectArray[i]);
                objectArray2[i] = this.dataType.convertToTypeLimits(sessionInterface, objectArray[i]);
            }
            return objectArray2;
        }
        return objectArray;
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return new JDBCArray(objectArray, this.collectionBaseType(), (Type)this, sessionInterface);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        return object;
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return this.convertToSQLString(object);
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        Object[] objectArray = (Object[])object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ARRAY");
        stringBuffer.append('[');
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.dataType.convertToSQLString(objectArray[i]));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type == null) {
            return true;
        }
        if (!type.isArrayType()) {
            return false;
        }
        Type type2 = type.collectionBaseType();
        return this.dataType.canConvertFrom(type2);
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (!type.isArrayType()) {
            return -1;
        }
        if (this.maxCardinality >= ((ArrayType)type).maxCardinality) {
            return this.dataType.canMoveFrom((ArrayType)type);
        }
        if (this.dataType.canMoveFrom((ArrayType)type) == -1) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean canBeAssignedFrom(Type type) {
        if (type == null) {
            return true;
        }
        Type type2 = type.collectionBaseType();
        return type2 != null && this.dataType.canBeAssignedFrom(type2);
    }

    @Override
    public Type collectionBaseType() {
        return this.dataType;
    }

    @Override
    public int arrayLimitCardinality() {
        return this.maxCardinality;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this == type) {
            return this;
        }
        if (!type.isArrayType()) {
            throw Error.error(5562);
        }
        Type type2 = type.collectionBaseType();
        if (this.dataType.equals(type2)) {
            return ((ArrayType)type).maxCardinality > this.maxCardinality ? type : this;
        }
        Type type3 = this.dataType.getAggregateType(type2);
        int n = ((ArrayType)type).maxCardinality > this.maxCardinality ? ((ArrayType)type).maxCardinality : this.maxCardinality;
        return new ArrayType(type3, n);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n) {
        ArrayType arrayType = (ArrayType)this.getAggregateType(type);
        if (type == null) {
            return arrayType;
        }
        if (n != 36) {
            return arrayType;
        }
        if (arrayType.maxCardinality == Integer.MAX_VALUE) {
            return arrayType;
        }
        long l = (long)((ArrayType)type).maxCardinality + (long)this.maxCardinality;
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new ArrayType(this.dataType, (int)l);
    }

    @Override
    public int cardinality(Session session, Object object) {
        if (object == null) {
            return 0;
        }
        return ((Object[])object).length;
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        int n = ((Object[])object).length + ((Object[])object2).length;
        Object[] objectArray = new Object[n];
        System.arraycopy(object, 0, objectArray, 0, ((Object[])object).length);
        System.arraycopy(object2, 0, objectArray, ((Object[])object).length, ((Object[])object2).length);
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Type) {
            if (((Type)object).typeCode != 50) {
                return false;
            }
            return this.maxCardinality == ((ArrayType)object).maxCardinality && this.dataType.equals(((ArrayType)object).dataType);
        }
        return false;
    }

    @Override
    public int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n = 0;
        Object[] objectArray = (Object[])object;
        for (int i = 0; i < objectArray.length && i < 4; ++i) {
            n += this.dataType.hashCode(objectArray[i]);
        }
        return n;
    }

    public void sort(Session session, Object object, SortAndSlice sortAndSlice) {
        Object[] objectArray = (Object[])object;
        Type.TypedComparator typedComparator = session.getComparator();
        typedComparator.setType(this.dataType, sortAndSlice);
        ArraySort.sort(objectArray, 0, objectArray.length, typedComparator);
    }

    public int deDuplicate(Session session, Object object, SortAndSlice sortAndSlice) {
        Object[] objectArray = (Object[])object;
        Type.TypedComparator typedComparator = session.getComparator();
        typedComparator.setType(this.dataType, sortAndSlice);
        return ArraySort.deDuplicate(objectArray, 0, objectArray.length, typedComparator);
    }
}

