/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.alfrescowebscript;

import com.github.maoo.indexer.client.AlfrescoClient;
import com.github.maoo.indexer.client.AlfrescoDownException;
import com.github.maoo.indexer.client.AlfrescoResponse;
import com.github.maoo.indexer.client.WebScriptsAlfrescoClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.alfrescowebscript.ConfigurationHandler;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class AlfrescoConnector
extends BaseRepositoryConnector {
    private static final String ACTIVITY_FETCH = "fetch document";
    private static final String[] activitiesList = new String[]{"fetch document"};
    private AlfrescoClient alfrescoClient;
    private String binName;
    private static final String CONTENT_URL_PROPERTY = "contentUrlPath";
    private static final String AUTHORITIES_PROPERTY = "readableAuthorities";
    private static final String MIMETYPE_PROPERTY = "mimetype";
    private static final String SIZE_PROPERTY = "size";
    private static final String MODIFIED_DATE_PROPERTY = "cm:modified";
    private static final String CREATED_DATE_PROPERTY = "cm:created";
    private static final String FIELD_UUID = "uuid";
    private static final String FIELD_NODEREF = "nodeRef";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_NAME = "name";
    protected static final long interruptionRetryTime = 300000L;

    public int getConnectorModel() {
        return 3;
    }

    public void setClient(AlfrescoClient client) {
        this.alfrescoClient = client;
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.binName};
    }

    public void connect(ConfigParams config) {
        super.connect(config);
        String protocol = AlfrescoConnector.getConfig(config, "protocol", "http");
        String hostname = AlfrescoConnector.getConfig(config, "hostname", "localhost");
        String port = AlfrescoConnector.getConfig(config, "port", "8080");
        String endpoint = AlfrescoConnector.getConfig(config, "endpoint", "/alfresco/service");
        String storeProtocol = AlfrescoConnector.getConfig(config, "storeprotocol", "workspace");
        String storeId = AlfrescoConnector.getConfig(config, "storeid", "SpacesStore");
        String username = AlfrescoConnector.getConfig(config, "username", null);
        String password = AlfrescoConnector.getObfuscatedConfig(config, "password", null);
        this.alfrescoClient = new WebScriptsAlfrescoClient(protocol, hostname + ":" + port, endpoint, storeProtocol, storeId, username, password);
        this.binName = hostname;
    }

    private static String getConfig(ConfigParams config, String parameter, String defaultValue) {
        String protocol = config.getParameter(parameter);
        if (protocol == null) {
            return defaultValue;
        }
        return protocol;
    }

    private static String getObfuscatedConfig(ConfigParams config, String parameter, String defaultValue) {
        String protocol = config.getObfuscatedParameter(parameter);
        if (protocol == null) {
            return defaultValue;
        }
        return protocol;
    }

    public String check() throws ManifoldCFException {
        try {
            this.alfrescoClient.fetchUserAuthorities("admin");
            return super.check();
        }
        catch (AlfrescoDownException e) {
            if (Logging.connectors != null) {
                Logging.connectors.warn((Object)e.getMessage(), (Throwable)e);
            }
            return "Alfresco connection check failed: " + e.getMessage();
        }
        catch (Exception e) {
            if (Logging.connectors != null) {
                Logging.connectors.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new ManifoldCFException("Alfresco connection check failed", (Throwable)e);
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.alfrescoClient = null;
        this.binName = null;
        super.disconnect();
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public int getMaxDocumentRequest() {
        return 20;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        try {
            long aclChangesetsProcessed;
            long transactionIdsProcessed;
            StringTokenizer tokenizer;
            long lastTransactionId = 0L;
            long lastAclChangesetId = 0L;
            if (lastSeedVersion != null && !lastSeedVersion.isEmpty() && (tokenizer = new StringTokenizer(lastSeedVersion, "|")).countTokens() == 2) {
                lastTransactionId = new Long(tokenizer.nextToken());
                lastAclChangesetId = new Long(tokenizer.nextToken());
            }
            if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)new MessageFormat("Starting from transaction id: {0} and acl changeset id: {1}", Locale.ROOT).format(new Object[]{lastTransactionId, lastAclChangesetId}));
            }
            do {
                AlfrescoResponse response = this.alfrescoClient.fetchNodes(lastTransactionId, lastAclChangesetId, ConfigurationHandler.getFilters(spec));
                int count = 0;
                for (Map doc : response.getDocuments()) {
                    String uuid = doc.get(FIELD_UUID).toString();
                    activities.addSeedDocument(uuid);
                    ++count;
                }
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("Fetched and added {0} seed documents", Locale.ROOT).format(new Object[]{new Integer(count)}));
                }
                transactionIdsProcessed = response.getLastTransactionId() - lastTransactionId;
                aclChangesetsProcessed = response.getLastAclChangesetId() - lastAclChangesetId;
                lastTransactionId = response.getLastTransactionId();
                lastAclChangesetId = response.getLastAclChangesetId();
                if (Logging.connectors == null || !Logging.connectors.isDebugEnabled()) continue;
                Logging.connectors.debug((Object)new MessageFormat("transaction_id={0}, acl_changeset_id={1}", Locale.ROOT).format(new Object[]{lastTransactionId, lastAclChangesetId}));
            } while (transactionIdsProcessed > 0L || aclChangesetsProcessed > 0L);
            if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)new MessageFormat("Recording {0} as last transaction id and {1} as last changeset id", Locale.ROOT).format(new Object[]{lastTransactionId, lastAclChangesetId}));
            }
            return lastTransactionId + "|" + lastAclChangesetId;
        }
        catch (AlfrescoDownException e) {
            AlfrescoConnector.handleAlfrescoDownException(e, "seeding");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        boolean enableDocumentProcessing = ConfigurationHandler.getEnableDocumentProcessing(spec);
        String[] stringArray = documentIdentifiers;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block56: {
                long startTime;
                Long fileLengthLong;
                String errorDesc;
                String errorCode;
                String doc;
                block64: {
                    block62: {
                        block61: {
                            block60: {
                                block59: {
                                    block58: {
                                        block57: {
                                            if (n2 >= n) {
                                                return;
                                            }
                                            doc = stringArray[n2];
                                            errorCode = null;
                                            errorDesc = null;
                                            fileLengthLong = null;
                                            startTime = System.currentTimeMillis();
                                            try {
                                                long length;
                                                InputStream stream;
                                                RepositoryDocument rd;
                                                String contentUrlPath;
                                                String documentVersion;
                                                String nodeRef;
                                                String uuid;
                                                block66: {
                                                    byte[] empty;
                                                    block65: {
                                                        String nextVersion = statuses.getIndexedVersionString(doc);
                                                        AlfrescoResponse response = this.alfrescoClient.fetchNode(doc);
                                                        if (response.getDocumentList().isEmpty()) {
                                                            if (Logging.connectors != null) {
                                                                Logging.connectors.warn((Object)new MessageFormat("Invalid Seeded Document from Alfresco with ID {0}", Locale.ROOT).format(new Object[]{doc}));
                                                            }
                                                            activities.deleteDocument(doc);
                                                            break block56;
                                                        }
                                                        Map map = (Map)response.getDocumentList().get(0);
                                                        if (((Boolean)map.get("deleted")).booleanValue()) {
                                                            activities.deleteDocument(doc);
                                                            break block56;
                                                        }
                                                        uuid = doc;
                                                        nodeRef = map.containsKey(FIELD_NODEREF) ? map.get(FIELD_NODEREF).toString() : "";
                                                        String type = map.containsKey(FIELD_TYPE) ? map.get(FIELD_TYPE).toString() : "";
                                                        String name = map.containsKey(FIELD_NAME) ? map.get(FIELD_NAME).toString() : "";
                                                        Map properties = this.alfrescoClient.fetchMetadata(uuid);
                                                        Long lSize = null;
                                                        Object mdObject = properties.get(SIZE_PROPERTY);
                                                        if (mdObject != null) {
                                                            String size = mdObject.toString();
                                                            lSize = new Long(size);
                                                        }
                                                        Date modifiedDate = null;
                                                        mdObject = properties.get(MODIFIED_DATE_PROPERTY);
                                                        if (mdObject != null) {
                                                            modifiedDate = DateParser.parseISO8601Date((String)mdObject.toString());
                                                        }
                                                        Date createdDate = null;
                                                        mdObject = properties.get(CREATED_DATE_PROPERTY);
                                                        if (mdObject != null) {
                                                            createdDate = DateParser.parseISO8601Date((String)mdObject.toString());
                                                        }
                                                        if (modifiedDate == null) {
                                                            activities.deleteDocument(doc);
                                                            break block56;
                                                        }
                                                        StringBuilder sb = new StringBuilder();
                                                        sb.append(enableDocumentProcessing ? "+" : "-");
                                                        sb.append(new Long(modifiedDate.getTime()).toString());
                                                        List permissions = (List)properties.remove(AUTHORITIES_PROPERTY);
                                                        if (permissions != null) {
                                                            for (String permission : permissions) {
                                                                sb.append(permission);
                                                            }
                                                        }
                                                        if (!activities.checkDocumentNeedsReindexing(doc, documentVersion = sb.toString())) break block56;
                                                        String mimeType = null;
                                                        Object mimetypeObject = properties.get(MIMETYPE_PROPERTY);
                                                        if (mimetypeObject != null) {
                                                            mimeType = mimetypeObject.toString();
                                                        }
                                                        if (lSize != null && !activities.checkLengthIndexable(lSize.longValue())) {
                                                            activities.noDocument(doc, documentVersion);
                                                            errorCode = "EXCLUDEDLENGTH";
                                                            errorDesc = "Excluding document because of length (" + lSize + ")";
                                                            if (errorCode == null) break block56;
                                                            break block57;
                                                        }
                                                        if (!activities.checkMimeTypeIndexable(mimeType)) {
                                                            activities.noDocument(doc, documentVersion);
                                                            errorCode = "EXCLUDEDMIMETYPE";
                                                            errorDesc = "Excluding document because of mime type (" + mimeType + ")";
                                                            if (errorCode == null) break block56;
                                                            break block58;
                                                        }
                                                        if (!activities.checkDateIndexable(modifiedDate)) {
                                                            activities.noDocument(doc, documentVersion);
                                                            errorCode = "EXCLUDEDDATE";
                                                            errorDesc = "Excluding document because of date (" + modifiedDate + ")";
                                                            if (errorCode == null) break block56;
                                                            break block59;
                                                        }
                                                        contentUrlPath = (String)properties.get(CONTENT_URL_PROPERTY);
                                                        if (contentUrlPath == null || contentUrlPath.isEmpty()) {
                                                            activities.noDocument(doc, documentVersion);
                                                            errorCode = "NOURL";
                                                            errorDesc = "Excluding document because no URL found";
                                                            if (errorCode == null) break block56;
                                                            break block60;
                                                        }
                                                        if (!activities.checkURLIndexable(contentUrlPath)) {
                                                            activities.noDocument(doc, documentVersion);
                                                            errorCode = "EXCLUDEDURL";
                                                            errorDesc = "Excluding document because of URL ('" + contentUrlPath + "')";
                                                            if (errorCode == null) break block56;
                                                            break block61;
                                                        }
                                                        rd = new RepositoryDocument();
                                                        rd.addField(FIELD_NODEREF, nodeRef);
                                                        rd.addField(FIELD_TYPE, type);
                                                        rd.setFileName(name);
                                                        if (modifiedDate != null) {
                                                            rd.setModifiedDate(modifiedDate);
                                                        }
                                                        if (createdDate != null) {
                                                            rd.setCreatedDate(createdDate);
                                                        }
                                                        for (String property : properties.keySet()) {
                                                            Object propertyValue = properties.get(property);
                                                            rd.addField(property, propertyValue.toString());
                                                        }
                                                        if (mimeType != null && !mimeType.isEmpty()) {
                                                            rd.setMimeType(mimeType);
                                                        }
                                                        if (permissions != null) {
                                                            rd.setSecurityACL("document", permissions.toArray(new String[permissions.size()]));
                                                        }
                                                        empty = new byte[]{};
                                                        if (!enableDocumentProcessing) break block65;
                                                        if (lSize != null) {
                                                            stream = this.alfrescoClient.fetchContent(contentUrlPath);
                                                            if (stream == null) {
                                                                activities.noDocument(doc, documentVersion);
                                                                errorCode = "NOSTREAM";
                                                                errorDesc = "Excluding document because no content stream found";
                                                                if (errorCode == null) break block56;
                                                                break block62;
                                                            }
                                                            length = lSize;
                                                            break block66;
                                                        } else {
                                                            stream = new ByteArrayInputStream(empty);
                                                            length = 0L;
                                                        }
                                                        break block66;
                                                    }
                                                    stream = new ByteArrayInputStream(empty);
                                                    length = 0L;
                                                }
                                                try {
                                                    rd.setBinary(stream, length);
                                                    if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                                                        Logging.connectors.debug((Object)new MessageFormat("Ingesting with id: {0}, URI {1} and rd {2}", Locale.ROOT).format(new Object[]{uuid, nodeRef, rd.getFileName()}));
                                                    }
                                                    activities.ingestDocumentWithException(doc, documentVersion, contentUrlPath, rd);
                                                    errorCode = "OK";
                                                    fileLengthLong = new Long(length);
                                                }
                                                catch (IOException e) {
                                                    AlfrescoConnector.handleIOException(e, "reading stream");
                                                }
                                                finally {
                                                    try {
                                                        stream.close();
                                                    }
                                                    catch (IOException e) {
                                                        AlfrescoConnector.handleIOException(e, "closing stream");
                                                    }
                                                }
                                                if (errorCode == null) break block56;
                                                break block64;
                                            }
                                            catch (AlfrescoDownException e) {
                                                AlfrescoConnector.handleAlfrescoDownException(e, "processing");
                                                break block56;
                                            }
                                            catch (ManifoldCFException e) {
                                                if (e.getErrorCode() == 2) {
                                                    errorCode = null;
                                                }
                                                throw e;
                                            }
                                        }
                                        activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                                        break block56;
                                    }
                                    activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                                    break block56;
                                }
                                activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                                break block56;
                            }
                            activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                            break block56;
                        }
                        activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                        break block56;
                    }
                    activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                    break block56;
                }
                activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                break block56;
                finally {
                    if (errorCode != null) {
                        activities.recordActivity(new Long(startTime), ACTIVITY_FETCH, fileLengthLong, doc, errorCode, errorDesc, null);
                    }
                }
            }
            ++n2;
        }
    }

    protected static void handleAlfrescoDownException(AlfrescoDownException e, String context) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        String message = "Server appears down during " + context + ": " + e.getMessage();
        Logging.connectors.warn((Object)message, (Throwable)e);
        throw new ServiceInterruption(message, (Throwable)e, currentTime + 300000L, -1L, 3, true);
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof InterruptedIOException && !(e instanceof SocketTimeoutException)) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        long currentTime = System.currentTimeMillis();
        if (e instanceof ConnectException) {
            String message = "Server could not be contacted during " + context + ": " + e.getMessage();
            Logging.connectors.warn((Object)message, (Throwable)e);
            throw new ServiceInterruption(message, (Throwable)e, currentTime + 300000L, -1L, 3, true);
        }
        if (e instanceof SocketTimeoutException) {
            String message2 = "Socket timeout exception during " + context + ": " + e.getMessage();
            Logging.connectors.warn((Object)message2, (Throwable)e);
            throw new ServiceInterruption(message2, (Throwable)e, currentTime + 300000L, currentTime + 1200000L, -1, false);
        }
        if (e.getClass().getName().equals("java.net.SocketException")) {
            if (e.getMessage().toLowerCase(Locale.ROOT).indexOf("broken pipe") != -1 || e.getMessage().toLowerCase(Locale.ROOT).indexOf("connection reset") != -1 || e.getMessage().toLowerCase(Locale.ROOT).indexOf("target server failed to respond") != -1) {
                String message = "Server dropped connection during " + context + ": " + e.getMessage();
                Logging.connectors.warn((Object)message, (Throwable)e);
                throw new ServiceInterruption(message, (Throwable)e, currentTime + 300000L, -1L, 3, false);
            }
            String message2 = "Socket exception during " + context + ": " + e.getMessage();
            Logging.connectors.warn((Object)message2, (Throwable)e);
            throw new ServiceInterruption(message2, (Throwable)e, currentTime + 300000L, currentTime + 1200000L, -1, false);
        }
        String message3 = "IO exception during " + context + ": " + e.getMessage();
        Logging.connectors.warn((Object)message3, (Throwable)e);
        throw new ServiceInterruption(message3, (Throwable)e, currentTime + 300000L, currentTime + 0x6DDD00L, -1, true);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        ConfigurationHandler.outputConfigurationHeader(threadContext, out, locale, parameters, tabsArray);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        ConfigurationHandler.outputConfigurationBody(threadContext, out, locale, parameters, tabName);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        return ConfigurationHandler.processConfigurationPost(threadContext, variableContext, locale, parameters);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        ConfigurationHandler.viewConfiguration(threadContext, out, locale, parameters);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        ConfigurationHandler.outputSpecificationHeader(out, locale, os, connectionSequenceNumber, tabsArray);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        ConfigurationHandler.outputSpecificationBody(out, locale, os, connectionSequenceNumber, actualSequenceNumber, tabName);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        return ConfigurationHandler.processSpecificationPost(variableContext, locale, os, connectionSequenceNumber);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        ConfigurationHandler.viewSpecification(out, locale, os, connectionSequenceNumber);
    }
}

