/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.crawl.CatalogCrawler;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFile;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateType;

@ThreadSafe
public class CollectionManagerCatalog
extends CollectionManagerAbstract
implements CatalogCrawler.Listener {
    private final String catalogUrl;
    private long lastScanned;
    private boolean debug = false;
    private List<MFile> mfiles;

    public CollectionManagerCatalog(String collectionName, String collectionSpec, String olderThan, Formatter errlog) {
        super(collectionName, null);
        int pos;
        if (collectionSpec.startsWith("catalog:")) {
            collectionSpec = collectionSpec.substring("catalog:".length());
        }
        if ((pos = collectionSpec.indexOf(63)) > 0) {
            this.dateExtractor = new DateExtractorFromName(collectionSpec.substring(pos + 1), true);
            collectionSpec = collectionSpec.substring(0, pos);
        }
        this.catalogUrl = collectionSpec;
        this.root = System.getProperty("user.dir");
    }

    @Override
    public String getRoot() {
        return null;
    }

    @Override
    public long getLastScanned() {
        return this.lastScanned;
    }

    @Override
    public long getLastChanged() {
        return 0L;
    }

    @Override
    public boolean isScanNeeded() {
        return this.mfiles == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scan(boolean sendEvent) throws IOException {
        StringBuilder buff;
        this.mfiles = new ArrayList<MFile>(100);
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        InvCatalogImpl cat = catFactory.readXML(this.catalogUrl);
        boolean isValid = cat.check(buff = new StringBuilder(), false);
        if (!isValid) {
            this.logger.warn("Catalog invalid= " + this.catalogUrl + " validation output= " + buff);
            return false;
        }
        CatalogCrawler crawler = new CatalogCrawler(1, false, (CatalogCrawler.Listener)this);
        long start = System.currentTimeMillis();
        try {
            crawler.crawl(cat, null, null, null);
        }
        finally {
            long took = System.currentTimeMillis() - start;
            if (this.debug) {
                System.out.format("***Done " + this.catalogUrl + " took = " + took + " msecs%n", new Object[0]);
            }
        }
        this.lastScanned = System.currentTimeMillis();
        return true;
    }

    @Override
    public Iterable<MFile> getFilesSorted() {
        return this.mfiles == null ? new ArrayList() : this.mfiles;
    }

    @Override
    public void getDataset(InvDataset ds, Object context) {
        if (ds.hasAccess()) {
            ThreddsDataFactory tdataFactory = new ThreddsDataFactory();
            InvAccess access = tdataFactory.chooseDatasetAccess(ds.getAccess());
            if (access == null) {
                throw new IllegalStateException();
            }
            MFileRemote mfile = new MFileRemote(access);
            if (mfile.getPath().endsWith(".xml")) {
                return;
            }
            this.mfiles.add(mfile);
            if (this.debug) {
                System.out.format("add %s %n", mfile.getPath());
            }
        }
    }

    @Override
    public boolean getCatalogRef(InvCatalogRef dd, Object context) {
        return true;
    }

    private static class MFileRemote
    implements MFile {
        private Object info;
        private final InvAccess access;
        private Date lastModified;

        MFileRemote(InvAccess access) {
            this.access = access;
            for (DateType dateType : access.getDataset().getDates()) {
                if (!dateType.getType().equals("modified")) continue;
                this.lastModified = dateType.getDate();
            }
        }

        @Override
        public long getLastModified() {
            return this.lastModified == null ? -1L : this.lastModified.getTime();
        }

        @Override
        public long getLength() {
            return (long)this.access.getDataSize();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public String getPath() {
            return this.access.getWrappedUrlName();
        }

        @Override
        public String getName() {
            return this.access.getDataset().getName();
        }

        @Override
        public int compareTo(MFile o) {
            return this.getPath().compareTo(o.getPath());
        }

        @Override
        public Object getAuxInfo() {
            return this.info;
        }

        @Override
        public void setAuxInfo(Object info) {
            this.info = info;
        }
    }
}

