/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.fuzzyml.CharacterReceiver;
import org.apache.manifoldcf.connectorcommon.fuzzyml.Parser;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLFuzzyHierarchicalParseState;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLParsingContext;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLStringParsingContext;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.webcrawler.CookieManager;
import org.apache.manifoldcf.crawler.connectors.webcrawler.CredentialsDescription;
import org.apache.manifoldcf.crawler.connectors.webcrawler.DNSManager;
import org.apache.manifoldcf.crawler.connectors.webcrawler.DataCache;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindContentHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindHTMLFormHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindHTMLHrefHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindPreferredRedirectionHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindRedirectionHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormData;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormParseState;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IDiscoveredLinkHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IRedirectionHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IThrottledConnection;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IXMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginCookies;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;
import org.apache.manifoldcf.crawler.connectors.webcrawler.Messages;
import org.apache.manifoldcf.crawler.connectors.webcrawler.PageCredentials;
import org.apache.manifoldcf.crawler.connectors.webcrawler.RobotsManager;
import org.apache.manifoldcf.crawler.connectors.webcrawler.SequenceCredentials;
import org.apache.manifoldcf.crawler.connectors.webcrawler.ThrottleDescription;
import org.apache.manifoldcf.crawler.connectors.webcrawler.ThrottledFetcher;
import org.apache.manifoldcf.crawler.connectors.webcrawler.TrustsDescription;
import org.apache.manifoldcf.crawler.connectors.webcrawler.WebURL;
import org.apache.manifoldcf.crawler.interfaces.IAbortActivity;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IFingerprintActivity;
import org.apache.manifoldcf.crawler.interfaces.IHistoryActivity;
import org.apache.manifoldcf.crawler.interfaces.INamingActivity;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class WebcrawlerConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: WebcrawlerConnector.java 995042 2010-09-08 13:10:06Z kwright $";
    protected static final int RESULTSTATUS_FALSE = 0;
    protected static final int RESULTSTATUS_TRUE = 1;
    protected static final int RESULTSTATUS_NOTYETDETERMINED = 2;
    protected static final String[] interestingMimeTypeArray = new String[]{"application/rtf", "application/xls", "text/html", "text/rtf", "application/x-excel", "application/x-msexcel", "application/x-mspowerpoint", "application/x-msword-doc", "application/x-msword", "application/x-word", "text/xml", "application/xml", "no-type", "text/plain", "application/x-rtf", "application/x-pdf", "text/richtext", "Text", "Text/html"};
    protected static final Set<String> interestingMimeTypeMap = new HashSet<String>();
    protected static final Set<String> understoodProtocols;
    protected static final int ROBOTS_NONE = 0;
    protected static final int ROBOTS_DATA = 1;
    protected static final int ROBOTS_ALL = 2;
    protected static final int META_ROBOTS_NONE = 0;
    protected static final int META_ROBOTS_ALL = 1;
    public static final String REL_LINK = "link";
    public static final String REL_REDIRECT = "redirect";
    public static final String ACTIVITY_FETCH = "fetch";
    public static final String ACTIVITY_PROCESS = "process";
    public static final String ACTIVITY_ROBOTSPARSE = "robots parse";
    public static final String ACTIVITY_LOGON_START = "begin logon";
    public static final String ACTIVITY_LOGON_END = "end logon";
    protected static final String FETCH_ROBOTS = "ROBOTS";
    protected static final String FETCH_STANDARD = "URL";
    protected static final String FETCH_LOGIN = "LOGIN";
    protected static final Set<String> reservedHeaders;
    protected static final List<String> potentiallyExcludedHeaders;
    protected int robotsUsage = 2;
    protected int metaRobotsTagsUsage = 1;
    protected String userAgent = null;
    protected String from = null;
    protected int connectionTimeoutMilliseconds = 60000;
    protected int socketTimeoutMilliseconds = 300000;
    protected String throttleGroupName = null;
    protected ThrottleDescription throttleDescription = null;
    protected CredentialsDescription credentialsDescription = null;
    protected TrustsDescription trustsDescription = null;
    protected RobotsManager robotsManager = null;
    protected DNSManager dnsManager = null;
    protected CookieManager cookieManager = null;
    protected boolean isInitialized = false;
    protected static DataCache cache;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected String proxyAuthDomain = null;
    protected String proxyAuthUsername = null;
    protected String proxyAuthPassword = null;
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static final int SESSIONSTATE_NORMAL = 0;
    protected static final int SESSIONSTATE_LOGIN = 1;
    protected static final int RESULT_NO_DOCUMENT = 0;
    protected static final int RESULT_NO_VERSION = 1;
    protected static final int RESULT_VERSION_NEEDED = 2;
    protected static final int RESULT_RETRY_DOCUMENT = 3;

    public int getConnectorModel() {
        return 0;
    }

    public void install(IThreadContext threadContext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        RobotsManager rm = new RobotsManager(threadContext, mainDatabase);
        DNSManager dns = new DNSManager(threadContext, mainDatabase);
        CookieManager cm = new CookieManager(threadContext, mainDatabase);
        mainDatabase.beginTransaction();
        try {
            rm.install();
            dns.install();
            cm.install();
        }
        catch (ManifoldCFException e) {
            mainDatabase.signalRollback();
            throw e;
        }
        catch (Error e) {
            mainDatabase.signalRollback();
            throw e;
        }
        finally {
            mainDatabase.endTransaction();
        }
    }

    public void deinstall(IThreadContext threadContext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        RobotsManager rm = new RobotsManager(threadContext, mainDatabase);
        DNSManager dns = new DNSManager(threadContext, mainDatabase);
        CookieManager cm = new CookieManager(threadContext, mainDatabase);
        mainDatabase.beginTransaction();
        try {
            cm.deinstall();
            rm.deinstall();
            dns.deinstall();
        }
        catch (ManifoldCFException e) {
            mainDatabase.signalRollback();
            throw e;
        }
        catch (Error e) {
            mainDatabase.signalRollback();
            throw e;
        }
        finally {
            mainDatabase.endTransaction();
        }
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH, ACTIVITY_PROCESS, ACTIVITY_ROBOTSPARSE, ACTIVITY_LOGON_START, ACTIVITY_LOGON_END};
    }

    public String[] getRelationshipTypes() {
        return new String[]{REL_LINK, REL_REDIRECT};
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.robotsManager = null;
        this.dnsManager = null;
        this.cookieManager = null;
    }

    protected void getSession() throws ManifoldCFException {
        if (this.robotsManager == null || this.dnsManager == null || this.cookieManager == null) {
            IDBInterface databaseHandle = DBInterfaceFactory.make((IThreadContext)this.currentContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            this.robotsManager = new RobotsManager(this.currentContext, databaseHandle);
            this.dnsManager = new DNSManager(this.currentContext, databaseHandle);
            this.cookieManager = new CookieManager(this.currentContext, databaseHandle);
        }
        if (!this.isInitialized) {
            String throttleGroupName = "";
            String emailAddress = this.params.getParameter("Email address");
            if (emailAddress == null) {
                throw new ManifoldCFException("Missing email address");
            }
            this.userAgent = "Mozilla/5.0 (ApacheManifoldCFWebCrawler; " + emailAddress + ")";
            this.from = emailAddress;
            String robotsTxt = this.params.getParameter("Robots usage");
            this.robotsUsage = 2;
            if (robotsTxt == null || robotsTxt.length() == 0 || robotsTxt.equals("all")) {
                this.robotsUsage = 2;
            } else if (robotsTxt.equals("none")) {
                this.robotsUsage = 0;
            } else if (robotsTxt.equals("data")) {
                this.robotsUsage = 1;
            }
            String metaRobots = this.params.getParameter("Meta robots tags usage");
            if (metaRobots == null || metaRobots.length() == 0 || metaRobots.equals("all")) {
                this.metaRobotsTagsUsage = 1;
            } else if (metaRobots.equals("none")) {
                this.metaRobotsTagsUsage = 0;
            }
            this.throttleDescription = new ThrottleDescription(this.params);
            this.credentialsDescription = new CredentialsDescription(this.params);
            this.trustsDescription = new TrustsDescription(this.params);
            this.proxyHost = this.params.getParameter("Proxy host");
            String proxyPortString = this.params.getParameter("Proxy port");
            this.proxyAuthDomain = this.params.getParameter("Proxy authentication domain");
            this.proxyAuthUsername = this.params.getParameter("Proxy authentication user name");
            this.proxyAuthPassword = this.params.getObfuscatedParameter("Proxy authentication password");
            this.proxyPort = -1;
            if (proxyPortString != null && proxyPortString.length() > 0) {
                try {
                    this.proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            this.isInitialized = true;
        }
    }

    public void poll() throws ManifoldCFException {
        ThrottledFetcher.flushIdleConnections(this.currentContext);
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        return super.check();
    }

    public void disconnect() throws ManifoldCFException {
        this.throttleGroupName = null;
        this.throttleDescription = null;
        this.credentialsDescription = null;
        this.trustsDescription = null;
        this.userAgent = null;
        this.from = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.proxyAuthDomain = null;
        this.proxyAuthUsername = null;
        this.proxyAuthPassword = null;
        this.isInitialized = false;
        super.disconnect();
    }

    public String[] getBinNames(String documentIdentifier) {
        try {
            URI uri = new URI(documentIdentifier);
            return new String[]{uri.getHost()};
        }
        catch (URISyntaxException e) {
            return new String[]{""};
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        DocumentURLFilter filter = new DocumentURLFilter(spec);
        String seeds = "";
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("seeds")) continue;
            seeds = sn.getValue();
        }
        List<String> list = WebcrawlerConnector.stringToArray(seeds);
        int index = 0;
        while (index < list.size()) {
            String urlCandidate;
            String documentIdentifier;
            if ((documentIdentifier = this.makeDocumentIdentifier(null, urlCandidate = list.get(index++), filter, (IHistoryActivity)activities)) == null) {
                Logging.connectors.warn((Object)("WEB: Illegal seed URL '" + urlCandidate + "'"));
                continue;
            }
            activities.addSeedDocument(documentIdentifier, this.calculateDocumentEvents((INamingActivity)activities, documentIdentifier));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        acls = WebcrawlerConnector.getAcls(spec);
        Arrays.sort(acls);
        excludedHeaders = WebcrawlerConnector.findExcludedHeaders(spec);
        filter = new DocumentURLFilter(spec);
        filterVersion = filter.getVersionString();
        block14: for (String documentIdentifier : documentIdentifiers) {
            if (!filter.isDocumentAndHostLegal(documentIdentifier, (IHistoryActivity)activities)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Removing url '" + documentIdentifier + "' because it's not in the set of allowed ones"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            try {
                sessionCredential = this.getSequenceCredential(documentIdentifier);
                if (Logging.connectors.isDebugEnabled() && sessionCredential != null) {
                    Logging.connectors.debug((Object)("Web: For document identifier '" + documentIdentifier + "' found session credential key '" + sessionCredential.getSequenceKey() + "'"));
                }
                fetchStatus = new FetchStatus();
                if (sessionCredential != null) {
                    sequenceKey = sessionCredential.getSequenceKey();
                    globalSequenceEvent = this.makeSessionLoginEventName((INamingActivity)activities, sequenceKey);
                } else {
                    globalSequenceEvent = null;
                }
                try {
                    this.loginAndFetch(fetchStatus, activities, documentIdentifier, sessionCredential, globalSequenceEvent);
                    switch (fetchStatus.resultSignal) {
                        case 0: {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Removing url '" + documentIdentifier + "'" + (fetchStatus.contextMessage != null ? " because " + fetchStatus.contextMessage : "")), fetchStatus.contextException);
                            }
                            activities.deleteDocument(documentIdentifier);
                            ** break;
lbl31:
                            // 1 sources

                            continue block14;
                        }
                        case 1: {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Ignoring url '" + documentIdentifier + "'" + (fetchStatus.contextMessage != null ? " because " + fetchStatus.contextMessage : "")), fetchStatus.contextException);
                            }
                            activities.noDocument(documentIdentifier, "");
                            ** break;
lbl37:
                            // 1 sources

                            continue block14;
                        }
                        case 2: {
                            sb = new StringBuilder();
                            WebcrawlerConnector.packList((StringBuilder)sb, (String[])acls, (char)'+');
                            if (acls.length > 0) {
                                sb.append('+');
                                WebcrawlerConnector.pack((StringBuilder)sb, (String)"DEAD_AUTHORITY", (char)'+');
                            } else {
                                sb.append('-');
                            }
                            metaHash = new HashMap<String, Set<String>>();
                            fixedListStrings = new String[2];
                            headerCount = 0;
                            for (String headerName : fetchStatus.headerData.keySet()) {
                                lowerHeaderName = headerName.toLowerCase(Locale.ROOT);
                                if (WebcrawlerConnector.reservedHeaders.contains(lowerHeaderName) || excludedHeaders.contains(lowerHeaderName)) continue;
                                headerCount += fetchStatus.headerData.get(headerName).size();
                            }
                            fullMetadata = new String[headerCount];
                            headerCount = 0;
                            for (String headerName : fetchStatus.headerData.keySet()) {
                                lowerHeaderName = headerName.toLowerCase(Locale.ROOT);
                                if (WebcrawlerConnector.reservedHeaders.contains(lowerHeaderName) || excludedHeaders.contains(lowerHeaderName)) continue;
                                valueSet = (HashSet<String>)metaHash.get(headerName);
                                if (valueSet == null) {
                                    valueSet = new HashSet<String>();
                                    metaHash.put(headerName, valueSet);
                                }
                                headerValues = fetchStatus.headerData.get(headerName);
                                for (String headerValue : headerValues) {
                                    valueSet.add(headerValue);
                                    fixedListStrings[0] = "header-" + headerName;
                                    fixedListStrings[1] = headerValue;
                                    newsb = new StringBuilder();
                                    WebcrawlerConnector.packFixedList((StringBuilder)newsb, (String[])fixedListStrings, (char)'=');
                                    fullMetadata[headerCount++] = newsb.toString();
                                }
                            }
                            Arrays.sort(fullMetadata);
                            WebcrawlerConnector.packList((StringBuilder)sb, (String[])fullMetadata, (char)'+');
                            sb.append(fetchStatus.checkSum);
                            sb.append("+");
                            sb.append(filterVersion);
                            versionString = sb.toString();
                            indexDocument = this.extractLinks(documentIdentifier, activities, filter);
                            if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue block14;
                            this.processDocument(activities, documentIdentifier, versionString, indexDocument, metaHash, (String[])acls, filter);
                            ** break;
lbl90:
                            // 1 sources

                            continue block14;
                        }
                        case 3: {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Retrying url '" + documentIdentifier + "' later" + (fetchStatus.contextMessage != null ? " because " + fetchStatus.contextMessage : "")), fetchStatus.contextException);
                            }
                            activities.retryDocumentProcessing(documentIdentifier);
                            ** break;
lbl96:
                            // 1 sources

                            continue block14;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value for result signal: " + Integer.toString(fetchStatus.resultSignal));
                        }
                    }
                }
                finally {
                    if (fetchStatus.sessionState == 1 && globalSequenceEvent != null) {
                        activities.completeEventSequence(globalSequenceEvent);
                    }
                }
            }
            finally {
                WebcrawlerConnector.cache.deleteData(documentIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loginAndFetch(FetchStatus fetchStatus, IProcessActivity activities, String documentIdentifier, SequenceCredentials sessionCredential, String globalSequenceEvent) throws ManifoldCFException, ServiceInterruption {
        String activityResultCode;
        block62: {
            String currentURI;
            block64: {
                long currentTime = System.currentTimeMillis();
                int connectionLimit = 200;
                currentURI = documentIdentifier;
                activityResultCode = null;
                FormData formData = null;
                while (true) {
                    boolean isLoginPage;
                    String contentLink;
                    String preferredRedirection;
                    String preferredLink;
                    block68: {
                        boolean seenContentError;
                        boolean seenRedirectionError;
                        boolean seenLinkError;
                        boolean seenFormError;
                        boolean seenAnything;
                        Iterator iterMatches;
                        block69: {
                            int ipAddressStatus;
                            block66: {
                                int robotsStatus;
                                block67: {
                                    block63: {
                                        URL url;
                                        try {
                                            url = new URL(currentURI);
                                        }
                                        catch (MalformedURLException e) {
                                            fetchStatus.contextMessage = "was not a valid URL: " + e.getMessage();
                                            fetchStatus.contextException = e;
                                            activityResultCode = "-12";
                                            fetchStatus.resultSignal = 0;
                                            break block62;
                                        }
                                        String hostName = url.getHost();
                                        StringBuilder ipAddressBuffer = new StringBuilder();
                                        ipAddressStatus = this.lookupIPAddress(currentURI, activities, hostName, currentTime, ipAddressBuffer);
                                        if (ipAddressStatus != 1) break block66;
                                        String ipAddress = ipAddressBuffer.toString();
                                        String protocol = url.getProtocol();
                                        int port = url.getPort();
                                        if (port == -1) {
                                            port = url.getDefaultPort();
                                        }
                                        String[] binNames = this.getBinNames(currentURI);
                                        PageCredentials credential = this.getPageCredential(currentURI);
                                        IKeystoreManager trustStore = protocol.equalsIgnoreCase("https") ? this.getTrustStore(currentURI) : KeystoreManagerFactory.make((String)"");
                                        robotsStatus = 1;
                                        if (documentIdentifier.equals(currentURI) && this.robotsUsage >= 1 && (robotsStatus = this.checkFetchAllowed(documentIdentifier, protocol, ipAddress, port, credential, trustStore, hostName, binNames, currentTime, url.getFile(), activities, connectionLimit, this.proxyHost, this.proxyPort, this.proxyAuthDomain, this.proxyAuthUsername, this.proxyAuthPassword)) != 1) break block67;
                                        LoginCookies lc = null;
                                        if (sessionCredential != null) {
                                            lc = this.cookieManager.readCookies(sessionCredential.getSequenceKey());
                                        }
                                        try (IThrottledConnection connection = ThrottledFetcher.getConnection(this.currentContext, this.throttleGroupName, protocol, ipAddress, port, credential, trustStore, this.throttleDescription, binNames, connectionLimit, this.proxyHost, this.proxyPort, this.proxyAuthDomain, this.proxyAuthUsername, this.proxyAuthPassword, this.socketTimeoutMilliseconds, this.connectionTimeoutMilliseconds, (IAbortActivity)activities);){
                                            connection.beginFetch(fetchStatus.sessionState == 1 ? FETCH_LOGIN : FETCH_STANDARD);
                                            try {
                                                String contentType;
                                                connection.executeFetch(url.getFile(), this.userAgent, this.from, false, hostName, formData, lc);
                                                int response = connection.getResponseCode();
                                                if (response == 200 || response == 302 || response == 301) {
                                                    if (fetchStatus.sessionState == 1) {
                                                        LoginCookies lastFetchCookies = connection.getLastFetchCookies();
                                                        this.cookieManager.updateCookies(sessionCredential.getSequenceKey(), lastFetchCookies);
                                                    }
                                                    if (this.isContentInteresting((IFingerprintActivity)activities, currentURI, response, contentType = WebcrawlerConnector.extractContentType(connection.getResponseHeader("Content-Type")))) {
                                                        fetchStatus.checkSum = cache.addData(activities, currentURI, connection);
                                                        fetchStatus.headerData = connection.getResponseHeaders();
                                                        fetchStatus.resultSignal = 2;
                                                        activityResultCode = null;
                                                        break block63;
                                                    } else {
                                                        fetchStatus.contextMessage = "it had the wrong content type ('" + contentType + "')";
                                                        fetchStatus.resultSignal = 0;
                                                        activityResultCode = "EXCLUDEDMIMETYPE";
                                                    }
                                                    break block63;
                                                }
                                                contentType = WebcrawlerConnector.extractContentType(connection.getResponseHeader("Content-Type"));
                                                String encoding = WebcrawlerConnector.extractEncoding(contentType);
                                                if (encoding == null) {
                                                    encoding = StandardCharsets.UTF_8.name();
                                                }
                                                String decodedResponse = "undecodable";
                                                try {
                                                    decodedResponse = "'" + connection.getLimitedResponseBody(1024, encoding) + "'";
                                                }
                                                catch (ManifoldCFException e) {
                                                    if (e.getErrorCode() == 2) {
                                                        throw e;
                                                    }
                                                    connection.noteInterrupted(e);
                                                }
                                                catch (ServiceInterruption e) {
                                                    connection.noteInterrupted(e);
                                                }
                                                fetchStatus.contextMessage = "it failed to fetch (status=" + Integer.toString(response) + ", message=" + decodedResponse + ")";
                                                fetchStatus.resultSignal = 1;
                                                activityResultCode = null;
                                            }
                                            catch (ManifoldCFException e) {
                                                connection.noteInterrupted(e);
                                                throw e;
                                            }
                                            catch (ServiceInterruption e) {
                                                connection.noteInterrupted(e);
                                                throw e;
                                            }
                                            finally {
                                                connection.doneFetch(activities);
                                            }
                                        }
                                    }
                                    preferredLink = null;
                                    preferredRedirection = null;
                                    formData = null;
                                    contentLink = null;
                                    if (fetchStatus.resultSignal != 2) break block64;
                                    isLoginPage = false;
                                    if (sessionCredential == null) break block68;
                                    iterMatches = sessionCredential.findLoginParameters(currentURI);
                                    seenAnything = false;
                                    seenFormError = false;
                                    seenLinkError = false;
                                    seenRedirectionError = false;
                                    seenContentError = false;
                                    break block69;
                                }
                                if (robotsStatus == 0) {
                                    activityResultCode = "-11";
                                    fetchStatus.contextMessage = "robots.txt says so";
                                    fetchStatus.resultSignal = 0;
                                    break block64;
                                } else {
                                    activityResultCode = null;
                                    fetchStatus.resultSignal = 3;
                                    fetchStatus.contextMessage = "robots prerequisite already in progress";
                                }
                                break block64;
                            }
                            if (ipAddressStatus == 0) {
                                activityResultCode = "-10";
                                fetchStatus.contextMessage = "ip address not found";
                                fetchStatus.resultSignal = 0;
                                break block64;
                            } else {
                                activityResultCode = null;
                                fetchStatus.contextMessage = "dns prerequisite already in progress";
                                fetchStatus.resultSignal = 3;
                            }
                            break block64;
                        }
                        while (iterMatches.hasNext()) {
                            seenAnything = true;
                            LoginParameters lp = (LoginParameters)iterMatches.next();
                            FormData newFormData = this.findHTMLForm(currentURI, lp);
                            if (newFormData != null) {
                                if (formData != null) {
                                    seenFormError = true;
                                    formData = null;
                                    continue;
                                }
                                if (seenFormError) continue;
                                formData = newFormData;
                                preferredLink = null;
                                preferredRedirection = null;
                                continue;
                            }
                            String newPreferredLink = this.findHTMLLinkURI(currentURI, lp);
                            if (newPreferredLink != null) {
                                if (preferredLink != null) {
                                    seenLinkError = true;
                                    preferredLink = null;
                                    continue;
                                }
                                if (seenLinkError || seenFormError || formData != null) continue;
                                preferredLink = newPreferredLink;
                                preferredRedirection = null;
                                continue;
                            }
                            String newPreferredRedirection = this.findPreferredRedirectionURI(currentURI, lp);
                            if (newPreferredRedirection != null) {
                                if (preferredRedirection != null) {
                                    seenRedirectionError = true;
                                    preferredRedirection = null;
                                    continue;
                                }
                                if (seenRedirectionError || seenLinkError || seenFormError || formData != null || preferredLink != null) continue;
                                preferredRedirection = newPreferredRedirection;
                                continue;
                            }
                            String newContentLink = this.findSpecifiedContent(currentURI, lp);
                            if (newContentLink == null) continue;
                            if (contentLink != null) {
                                seenContentError = true;
                                contentLink = null;
                                continue;
                            }
                            if (seenContentError || seenRedirectionError || seenLinkError || seenFormError || formData != null || preferredLink != null || preferredRedirection != null) continue;
                            contentLink = newContentLink;
                        }
                        if (formData != null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' matches form, so determined to be login page for sequence '" + sessionCredential.getSequenceKey() + "'"));
                            }
                            isLoginPage = true;
                        } else if (preferredLink != null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' matches preferred link, so determined to be login page for sequence '" + sessionCredential.getSequenceKey() + "'"));
                            }
                            isLoginPage = true;
                        } else if (preferredRedirection != null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' matches preferred redirection, so determined to be login page for sequence '" + sessionCredential.getSequenceKey() + "'"));
                            }
                            isLoginPage = true;
                        } else if (contentLink != null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' matches content, so determined to be login page for sequence '" + sessionCredential.getSequenceKey() + "'"));
                            }
                            isLoginPage = true;
                        } else if (seenAnything && Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("WEB: Document '" + currentURI + "' did not match expected form, link, redirection, or content for sequence '" + sessionCredential.getSequenceKey() + "'"));
                        }
                    }
                    if (fetchStatus.sessionState == 0 && isLoginPage) {
                        if (activities.beginEventSequence(globalSequenceEvent)) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: For document '" + documentIdentifier + "', beginning login sequence '" + sessionCredential.getSequenceKey() + "'"));
                            }
                            activities.recordActivity(null, ACTIVITY_LOGON_START, null, sessionCredential.getSequenceKey(), "OK", null, null);
                            fetchStatus.sessionState = 1;
                        } else {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("WEB: For document '" + documentIdentifier + "', login sequence '" + sessionCredential.getSequenceKey() + "' was already in progress."));
                            }
                            cache.deleteData(currentURI);
                            fetchStatus.contextMessage = "login sequence already in progress";
                            fetchStatus.resultSignal = 3;
                            activityResultCode = null;
                        }
                    } else if (fetchStatus.sessionState == 1 && !isLoginPage) {
                        activities.completeEventSequence(globalSequenceEvent);
                        activities.recordActivity(null, ACTIVITY_LOGON_END, null, sessionCredential.getSequenceKey(), "OK", null, null);
                        fetchStatus.sessionState = 0;
                        if (!currentURI.equals(documentIdentifier)) {
                            cache.deleteData(currentURI);
                            currentURI = documentIdentifier;
                            continue;
                        }
                    }
                    if (fetchStatus.resultSignal != 2 || fetchStatus.sessionState != 1) break;
                    String targetURI = formData != null ? formData.getActionURI() : (preferredLink != null ? preferredLink : (preferredRedirection != null ? preferredRedirection : contentLink));
                    cache.deleteData(currentURI);
                    if (targetURI == null || targetURI.length() == 0) {
                        activities.completeEventSequence(globalSequenceEvent);
                        activities.recordActivity(null, ACTIVITY_LOGON_END, null, sessionCredential.getSequenceKey(), "NEXTLINKNOTFOUND", "Could not find a usable link to the next page: " + fetchStatus.contextMessage, null);
                        fetchStatus.sessionState = 0;
                        currentURI = documentIdentifier;
                        continue;
                    }
                    currentURI = targetURI;
                }
                if (fetchStatus.resultSignal != 2 && fetchStatus.sessionState == 1) {
                    activities.completeEventSequence(globalSequenceEvent);
                    activities.recordActivity(null, ACTIVITY_LOGON_END, null, sessionCredential.getSequenceKey(), "LINKTARGETUNSUITABLE", "Page was unsuitable for a login sequence because: " + fetchStatus.contextMessage, null);
                    fetchStatus.sessionState = 0;
                }
            }
            if (!currentURI.equals(documentIdentifier)) {
                activityResultCode = null;
                if (fetchStatus.contextMessage != null) {
                    fetchStatus.contextMessage = "for login sequence url '" + currentURI + "': " + fetchStatus.contextMessage;
                }
                if (fetchStatus.resultSignal != 2) {
                    fetchStatus.resultSignal = 3;
                }
            }
        }
        if (activityResultCode != null) {
            activities.recordActivity(null, ACTIVITY_FETCH, null, documentIdentifier, activityResultCode, fetchStatus.contextMessage, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processDocument(IProcessActivity activities, String documentIdentifier, String versionString, boolean indexDocument, Map<String, Set<String>> metaHash, String[] acls, DocumentURLFilter filter) throws ManifoldCFException, ServiceInterruption {
        String errorCode = null;
        String errorDesc = null;
        Long fileLengthLong = null;
        long startTime = System.currentTimeMillis();
        try {
            String mimeType;
            if (!indexDocument) {
                errorCode = "CONTENTNOTINDEXABLE";
                errorDesc = "Content not indexable";
                activities.noDocument(documentIdentifier, versionString);
                return;
            }
            int responseCode = cache.getResponseCode(documentIdentifier);
            if (responseCode != 200) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Web: For document '" + documentIdentifier + "', not indexing because response code not indexable: " + responseCode));
                }
                errorCode = "RESPONSECODENOTINDEXABLE";
                errorDesc = "HTTP response code not indexable (" + responseCode + ")";
                activities.noDocument(documentIdentifier, versionString);
                return;
            }
            long dataLength = cache.getDataLength(documentIdentifier);
            if (!activities.checkLengthIndexable(dataLength)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Web: For document '" + documentIdentifier + "', not indexing because pipeline thinks length " + dataLength + " is not acceptable"));
                }
                errorCode = "EXCLUDEDLENGTH";
                errorDesc = "Rejected due to length (" + dataLength + ")";
                activities.noDocument(documentIdentifier, versionString);
                return;
            }
            if (!activities.checkURLIndexable(documentIdentifier)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Web: For document '" + documentIdentifier + "', not indexing because output connector does not want URL"));
                }
                errorCode = "EXCLUDEDURL";
                errorDesc = "Rejected due to URL ('" + documentIdentifier + "')";
                activities.noDocument(documentIdentifier, versionString);
                return;
            }
            String ingestURL = filter.isDocumentIndexable(documentIdentifier, activities);
            if (ingestURL == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Web: For document '" + documentIdentifier + "', not indexing because document does not match web job constraints"));
                }
                errorCode = "JOBRESTRICTION";
                errorDesc = "Rejected because job excludes this URL ('" + documentIdentifier + "')";
                activities.noDocument(documentIdentifier, versionString);
                return;
            }
            String contentType = cache.getContentType(documentIdentifier);
            if (contentType != null) {
                String[] contentTypes = contentType.split(",");
                contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
            }
            if (contentType != null) {
                int pos = contentType.indexOf(";");
                if (pos != -1) {
                    contentType = contentType.substring(0, pos);
                }
                contentType = contentType.trim();
            }
            if (!activities.checkMimeTypeIndexable(contentType)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Web: For document '" + documentIdentifier + "', not indexing because output connector does not want mime type '" + contentType + "'"));
                }
                errorCode = "EXCLUDEDMIMETYPE";
                errorDesc = "Rejected because of mime type (" + contentType + ")";
                activities.noDocument(documentIdentifier, versionString);
                return;
            }
            if (!filter.isDocumentContentIndexable(documentIdentifier)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Web: For document '" + documentIdentifier + "', not indexing because document content matched document content exclusion rule"));
                }
                errorCode = "EXCLUDEDCONTENT";
                errorDesc = "Rejected due to content exclusion rule";
                activities.noDocument(documentIdentifier, versionString);
                return;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Decided to ingest '" + documentIdentifier + "'"));
            }
            RepositoryDocument rd = new RepositoryDocument();
            String fileName = "";
            try {
                fileName = this.documentIdentifiertoFileName(documentIdentifier);
            }
            catch (URISyntaxException e1) {
                fileName = "";
            }
            if (fileName.length() > 0) {
                rd.setFileName(fileName);
            }
            if ((mimeType = cache.getContentType(documentIdentifier)) != null) {
                rd.setMimeType(mimeType);
            }
            String[] denyAcls = acls == null ? null : (acls.length > 0 ? new String[]{defaultAuthorityDenyToken} : new String[]{});
            if (acls != null && denyAcls != null) {
                rd.setSecurity("document", acls, denyAcls);
            }
            for (String key : metaHash.keySet()) {
                Set<String> metaList = metaHash.get(key);
                String[] values = new String[metaList.size()];
                int k = 0;
                for (String value : metaList) {
                    values[k++] = value;
                }
                rd.addField(key, values);
            }
            InputStream is = cache.getData(documentIdentifier);
            if (is != null) {
                try {
                    rd.setBinary(is, dataLength);
                    try {
                        activities.ingestDocumentWithException(documentIdentifier, versionString, ingestURL, rd);
                        errorCode = "OK";
                        fileLengthLong = new Long(dataLength);
                    }
                    catch (IOException e) {
                        errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                        errorDesc = e.getMessage();
                        WebcrawlerConnector.handleIOException(e, "reading data");
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                        errorDesc = e.getMessage();
                        WebcrawlerConnector.handleIOException(e, "closing stream");
                    }
                }
            } else {
                Logging.connectors.error((Object)("WEB: Expected a cached document for '" + documentIdentifier + "', but none present!"));
            }
            if (errorCode == null) return;
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() != 2) throw e;
            errorCode = null;
            throw e;
        }
        finally {
            if (errorCode != null) {
                activities.recordActivity(new Long(startTime), ACTIVITY_PROCESS, fileLengthLong, documentIdentifier, errorCode, errorDesc, null);
            }
        }
        activities.recordActivity(new Long(startTime), ACTIVITY_PROCESS, fileLengthLong, documentIdentifier, errorCode, errorDesc, null);
        return;
    }

    protected static String extractContentType(String contentType) {
        if (contentType != null) {
            String[] contentTypes = contentType.split(",");
            contentType = contentTypes.length > 0 ? contentTypes[contentTypes.length - 1].trim() : null;
        }
        return contentType;
    }

    protected static String extractEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semiIndex = contentType.indexOf(";");
        if (semiIndex == -1) {
            return null;
        }
        String suffix = contentType.substring(semiIndex + 1);
        if ((suffix = suffix.trim()).startsWith("charset=")) {
            String trialSuffix = suffix.substring("charset=".length());
            int semi = trialSuffix.indexOf(";");
            if (semi == -1) {
                return trialSuffix;
            }
            return trialSuffix.substring(0, semi).trim();
        }
        return null;
    }

    protected static String extractMimeType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semiIndex = contentType.indexOf(";");
        if (semiIndex != -1) {
            contentType = contentType.substring(0, semiIndex);
        }
        contentType = contentType.trim();
        return contentType;
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketException) {
            throw new ManifoldCFException("Socket timeout error " + context + ": " + e.getMessage(), (Throwable)e);
        }
        if (e instanceof ConnectTimeoutException) {
            throw new ManifoldCFException("Socket connect timeout error " + context + ": " + e.getMessage(), (Throwable)e);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException("IO error " + context + ": " + e.getMessage(), (Throwable)e);
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Email"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Robots"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Bandwidth"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.AccessCredentials"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Certificates"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Proxy"));
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration.js.vm", velocityContext);
    }

    private void fillInEmailTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String email = parameters.getParameter("Email address");
        if (email == null) {
            email = "";
        }
        velocityContext.put("EMAIL", email);
    }

    private void fillInRobotsTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String metaRobotsTagsUsage;
        String robotsUsage = parameters.getParameter("Robots usage");
        if (robotsUsage == null) {
            robotsUsage = "all";
        }
        if ((metaRobotsTagsUsage = parameters.getParameter("Meta robots tags usage")) == null) {
            metaRobotsTagsUsage = "all";
        }
        velocityContext.put("ROBOTSUSAGE", robotsUsage);
        velocityContext.put("METAROBOTSTAGSUSAGE", metaRobotsTagsUsage);
    }

    private void fillInBandwidthTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        int i = 0;
        int binCounter = 0;
        ArrayList throttlesMapList = new ArrayList();
        while (i < parameters.getChildCount()) {
            ConfigNode cn;
            if (!(cn = parameters.getChild(i++)).getType().equals("bindesc")) continue;
            HashMap<String, String> throttleMap = new HashMap<String, String>();
            String regexp = cn.getAttributeValue("binregexp");
            String isCaseInsensitive = cn.getAttributeValue("caseinsensitive");
            String maxConnections = null;
            String maxKBPerSecond = null;
            String maxFetchesPerMinute = null;
            int j = 0;
            while (j < cn.getChildCount()) {
                ConfigNode childNode;
                if ((childNode = cn.getChild(j++)).getType().equals("maxconnections")) {
                    maxConnections = childNode.getAttributeValue("value");
                    continue;
                }
                if (childNode.getType().equals("maxkbpersecond")) {
                    maxKBPerSecond = childNode.getAttributeValue("value");
                    continue;
                }
                if (!childNode.getType().equals("maxfetchesperminute")) continue;
                maxFetchesPerMinute = childNode.getAttributeValue("value");
            }
            if (maxConnections == null) {
                maxConnections = "";
            }
            if (maxKBPerSecond == null) {
                maxKBPerSecond = "";
            }
            if (maxFetchesPerMinute == null) {
                maxFetchesPerMinute = "";
            }
            if (regexp == null) {
                regexp = "";
            }
            if (isCaseInsensitive == null || isCaseInsensitive.length() == 0) {
                isCaseInsensitive = "false";
            }
            throttleMap.put("regexp", regexp);
            throttleMap.put("isCaseInsensitive", isCaseInsensitive);
            throttleMap.put("maxConnections", maxConnections);
            throttleMap.put("maxKBPerSecond", maxKBPerSecond);
            throttleMap.put("maxFetchesPerMinute", maxFetchesPerMinute);
            throttlesMapList.add(throttleMap);
            ++binCounter;
        }
        if (parameters.getChildCount() == 0) {
            velocityContext.put("BRANDNEW", true);
        }
        velocityContext.put("THROTTLESMAPLIST", throttlesMapList);
    }

    private void fillInProxyTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String proxyAuthPassword;
        String proxyAuthUsername;
        String proxyAuthDomain;
        String proxyPort;
        String proxyHost = parameters.getParameter("Proxy host");
        if (proxyHost == null) {
            proxyHost = "";
        }
        if ((proxyPort = parameters.getParameter("Proxy port")) == null) {
            proxyPort = "";
        }
        if ((proxyAuthDomain = parameters.getParameter("Proxy authentication domain")) == null) {
            proxyAuthDomain = "";
        }
        if ((proxyAuthUsername = parameters.getParameter("Proxy authentication user name")) == null) {
            proxyAuthUsername = "";
        }
        proxyAuthPassword = (proxyAuthPassword = parameters.getObfuscatedParameter("Proxy authentication password")) == null ? "" : out.mapPasswordToKey(proxyAuthPassword);
        velocityContext.put("PROXYHOST", proxyHost);
        velocityContext.put("PROXYPORT", proxyPort);
        velocityContext.put("PROXYAUTHDOMAIN", proxyAuthDomain);
        velocityContext.put("PROXYAUTHUSERNAME", proxyAuthUsername);
        velocityContext.put("PROXYAUTHPASSWORD", proxyAuthPassword);
    }

    private void fillInCertificatesTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        int i = 0;
        ArrayList trustMapList = new ArrayList();
        while (i < parameters.getChildCount()) {
            String trustStore;
            IKeystoreManager localTruststore;
            String[] truststoreContents;
            ConfigNode cn;
            if (!(cn = parameters.getChild(i++)).getType().equals("trust")) continue;
            HashMap<String, String> trustMap = new HashMap<String, String>();
            String regexp = cn.getAttributeValue("urlregexp");
            String trustEverything = cn.getAttributeValue("trusteverything");
            if (trustEverything == null) {
                trustEverything = "false";
            }
            trustMap.put("trustEverything", trustEverything);
            trustMap.put("regexp", regexp);
            if (trustEverything == "false" && (truststoreContents = (localTruststore = (trustStore = cn.getAttributeValue("truststore")) == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)trustStore)).getContents()).length == 1) {
                String alias = truststoreContents[0];
                String description = localTruststore.getDescription(alias);
                String shortenedDescription = description;
                if (shortenedDescription.length() > 100) {
                    shortenedDescription = shortenedDescription.substring(0, 100) + "...";
                }
                trustMap.put("trustStore", trustStore);
                trustMap.put("shortenedDescription", shortenedDescription);
            }
            trustMapList.add(trustMap);
        }
        velocityContext.put("TRUSTMAPLIST", trustMapList);
    }

    private void fillInAccessTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String type;
        int i = 0;
        ArrayList pageAccessMapList = new ArrayList();
        while (i < parameters.getChildCount()) {
            String domain;
            ConfigNode cn;
            if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential")) continue;
            HashMap<String, String> pageAccessMap = new HashMap<String, String>();
            type = cn.getAttributeValue("type");
            if (type.equals("session")) continue;
            String regexp = cn.getAttributeValue("urlregexp");
            if (regexp == null) {
                regexp = "";
            }
            if ((domain = cn.getAttributeValue("domain")) == null) {
                domain = "";
            }
            String userName = cn.getAttributeValue("username");
            String password = out.mapPasswordToKey(ManifoldCF.deobfuscate((String)cn.getAttributeValue("password")));
            pageAccessMap.put("regexp", regexp);
            pageAccessMap.put("domain", domain);
            pageAccessMap.put("userName", userName);
            pageAccessMap.put("password", password);
            pageAccessMap.put("type", type);
            pageAccessMapList.add(pageAccessMap);
        }
        velocityContext.put("PAGEACCESSMAPLIST", pageAccessMapList);
        i = 0;
        ArrayList sessionAccessMapList = new ArrayList();
        while (i < parameters.getChildCount()) {
            ConfigNode cn;
            if (!(cn = parameters.getChild(i++)).getType().equals("accesscredential") || !(type = cn.getAttributeValue("type")).equals("session")) continue;
            HashMap<String, Object> sessionAccessMap = new HashMap<String, Object>();
            String regexp = cn.getAttributeValue("urlregexp");
            if (regexp == null) {
                regexp = "";
            }
            sessionAccessMap.put("regexp", regexp);
            int q = 0;
            ArrayList authPageMapList = new ArrayList();
            while (q < cn.getChildCount()) {
                String overrideTargetURL;
                ConfigNode authPageNode;
                if (!(authPageNode = cn.getChild(q++)).getType().equals("authpage")) continue;
                HashMap<String, Object> authPageMap = new HashMap<String, Object>();
                String pageRegexp = authPageNode.getAttributeValue("urlregexp");
                String pageType = authPageNode.getAttributeValue("type");
                String matchRegexp = authPageNode.getAttributeValue("match");
                if (matchRegexp == null) {
                    matchRegexp = "";
                }
                if ((overrideTargetURL = authPageNode.getAttributeValue("overridetargeturl")) == null) {
                    overrideTargetURL = "";
                }
                authPageMap.put("pageRegexp", pageRegexp);
                authPageMap.put("pageType", pageType);
                authPageMap.put("matchRegexp", matchRegexp);
                authPageMap.put("overrideTargetURL", overrideTargetURL);
                if (pageType.equals("form")) {
                    int z = 0;
                    ArrayList authPageParamMapList = new ArrayList();
                    while (z < authPageNode.getChildCount()) {
                        String password;
                        String value;
                        ConfigNode paramNode;
                        if (!(paramNode = authPageNode.getChild(z++)).getType().equals("authparameter")) continue;
                        HashMap<String, String> authPageParamMap = new HashMap<String, String>();
                        String param = paramNode.getAttributeValue("name");
                        if (param == null) {
                            param = "";
                        }
                        if ((value = paramNode.getAttributeValue("value")) == null) {
                            value = "";
                        }
                        password = (password = paramNode.getAttributeValue("password")) == null ? "" : out.mapPasswordToKey(ManifoldCF.deobfuscate((String)password));
                        authPageParamMap.put("param", param);
                        authPageParamMap.put("value", value);
                        authPageParamMap.put("password", password);
                        authPageParamMapList.add(authPageParamMap);
                    }
                    authPageMap.put("authPageParamMapList", authPageParamMapList);
                }
                authPageMapList.add(authPageMap);
            }
            sessionAccessMap.put("authPageMapList", authPageMapList);
            sessionAccessMapList.add(sessionAccessMap);
        }
        velocityContext.put("SESSIONACCESSMAPLIST", sessionAccessMapList);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TABNAME", tabName);
        this.fillInEmailTab(velocityContext, out, parameters);
        this.fillInRobotsTab(velocityContext, out, parameters);
        this.fillInBandwidthTab(velocityContext, out, parameters);
        this.fillInAccessTab(velocityContext, out, parameters);
        this.fillInCertificatesTab(velocityContext, out, parameters);
        this.fillInProxyTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Email.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Robots.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Bandwidth.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Access.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Certificates.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Proxy.html.vm", velocityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        ConfigNode node;
        ConfigNode node2;
        String regexp;
        String addop;
        ConfigNode node3;
        String regexp2;
        String op;
        String prefix;
        int count;
        int i;
        String x;
        String proxyAuthPassword;
        String proxyAuthUsername;
        String proxyAuthDomain;
        String proxyPort;
        String proxyHost;
        String obeyMetaRobotsTags;
        String robotsUsage;
        String email = variableContext.getParameter("email");
        if (email != null) {
            parameters.setParameter("Email address", email);
        }
        if ((robotsUsage = variableContext.getParameter("robotsusage")) != null) {
            parameters.setParameter("Robots usage", robotsUsage);
        }
        if ((obeyMetaRobotsTags = variableContext.getParameter("metarobotstagsusage")) != null) {
            parameters.setParameter("Meta robots tags usage", obeyMetaRobotsTags);
        }
        if ((proxyHost = variableContext.getParameter("proxyhost")) != null) {
            parameters.setParameter("Proxy host", proxyHost);
        }
        if ((proxyPort = variableContext.getParameter("proxyport")) != null) {
            parameters.setParameter("Proxy port", proxyPort);
        }
        if ((proxyAuthDomain = variableContext.getParameter("proxyauthdomain")) != null) {
            parameters.setParameter("Proxy authentication domain", proxyAuthDomain);
        }
        if ((proxyAuthUsername = variableContext.getParameter("proxyauthusername")) != null) {
            parameters.setParameter("Proxy authentication user name", proxyAuthUsername);
        }
        if ((proxyAuthPassword = variableContext.getParameter("proxyauthpassword")) != null) {
            parameters.setObfuscatedParameter("Proxy authentication password", variableContext.mapKeyToPassword(proxyAuthPassword));
        }
        if ((x = variableContext.getParameter("bandwidth_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node4 = parameters.getChild(i);
                if (node4.getType().equals("bindesc")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                ConfigNode child;
                prefix = "bandwidth_" + Integer.toString(i);
                op = variableContext.getParameter("op_" + prefix);
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter("regexp_" + prefix);
                String isCaseInsensitive = variableContext.getParameter("insensitive_" + prefix);
                String maxConnections = variableContext.getParameter("connections_" + prefix);
                String rate = variableContext.getParameter("rate_" + prefix);
                String fetches = variableContext.getParameter("fetches_" + prefix);
                node3 = new ConfigNode("bindesc");
                node3.setAttribute("binregexp", regexp2);
                if (isCaseInsensitive != null && isCaseInsensitive.length() > 0) {
                    node3.setAttribute("caseinsensitive", isCaseInsensitive);
                }
                if (maxConnections != null && maxConnections.length() > 0) {
                    child = new ConfigNode("maxconnections");
                    child.setAttribute("value", maxConnections);
                    node3.addChild(node3.getChildCount(), (ConfigurationNode)child);
                }
                if (rate != null && rate.length() > 0) {
                    child = new ConfigNode("maxkbpersecond");
                    child.setAttribute("value", rate);
                    node3.addChild(node3.getChildCount(), (ConfigurationNode)child);
                }
                if (fetches != null && fetches.length() > 0) {
                    child = new ConfigNode("maxfetchesperminute");
                    child.setAttribute("value", fetches);
                    node3.addChild(node3.getChildCount(), (ConfigurationNode)child);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node3);
            }
            addop = variableContext.getParameter("bandwidth_op");
            if (addop != null && addop.equals("Add")) {
                ConfigNode child;
                regexp = variableContext.getParameter("regexp_bandwidth");
                String isCaseInsensitive = variableContext.getParameter("insensitive_bandwidth");
                String maxConnections = variableContext.getParameter("connections_bandwidth");
                String rate = variableContext.getParameter("rate_bandwidth");
                String fetches = variableContext.getParameter("fetches_bandwidth");
                node2 = new ConfigNode("bindesc");
                node2.setAttribute("binregexp", regexp);
                if (isCaseInsensitive != null && isCaseInsensitive.length() > 0) {
                    node2.setAttribute("caseinsensitive", isCaseInsensitive);
                }
                if (maxConnections != null && maxConnections.length() > 0) {
                    child = new ConfigNode("maxconnections");
                    child.setAttribute("value", maxConnections);
                    node2.addChild(node2.getChildCount(), (ConfigurationNode)child);
                }
                if (rate != null && rate.length() > 0) {
                    child = new ConfigNode("maxkbpersecond");
                    child.setAttribute("value", rate);
                    node2.addChild(node2.getChildCount(), (ConfigurationNode)child);
                }
                if (fetches != null && fetches.length() > 0) {
                    child = new ConfigNode("maxfetchesperminute");
                    child.setAttribute("value", fetches);
                    node2.addChild(node2.getChildCount(), (ConfigurationNode)child);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((x = variableContext.getParameter("acredential_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node5 = parameters.getChild(i);
                if (node5.getType().equals("accesscredential") && !node5.getAttributeValue("type").equals("session")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                prefix = "acredential_" + Integer.toString(i);
                op = variableContext.getParameter("op_" + prefix);
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter("regexp_" + prefix);
                String type = variableContext.getParameter("type_" + prefix);
                String domain = variableContext.getParameter("domain_" + prefix);
                if (domain == null) {
                    domain = "";
                }
                String userName = variableContext.getParameter("username_" + prefix);
                String password = variableContext.getParameter("password_" + prefix);
                node3 = new ConfigNode("accesscredential");
                node3.setAttribute("urlregexp", regexp2);
                node3.setAttribute("type", type);
                node3.setAttribute("domain", domain);
                node3.setAttribute("username", userName);
                node3.setAttribute("password", ManifoldCF.obfuscate((String)variableContext.mapKeyToPassword(password)));
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node3);
            }
            addop = variableContext.getParameter("acredential_op");
            if (addop != null && addop.equals("Add")) {
                regexp = variableContext.getParameter("regexp_acredential");
                String type = variableContext.getParameter("type_acredential");
                String domain = variableContext.getParameter("domain_acredential");
                String userName = variableContext.getParameter("username_acredential");
                String password = variableContext.getParameter("password_acredential");
                node2 = new ConfigNode("accesscredential");
                node2.setAttribute("urlregexp", regexp);
                node2.setAttribute("type", type);
                node2.setAttribute("domain", domain);
                node2.setAttribute("username", userName);
                node2.setAttribute("password", ManifoldCF.obfuscate((String)password));
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((x = variableContext.getParameter("scredential_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node6 = parameters.getChild(i);
                if (node6.getType().equals("accesscredential") && node6.getAttributeValue("type").equals("session")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                prefix = "scredential_" + Integer.toString(i);
                op = variableContext.getParameter(prefix + "_op");
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter(prefix + "_regexp");
                node = new ConfigNode("accesscredential");
                node.setAttribute("urlregexp", regexp2);
                node.setAttribute("type", "session");
                int loginPageCount = Integer.parseInt(variableContext.getParameter(prefix + "_loginpagecount"));
                for (int q = 0; q < loginPageCount; ++q) {
                    String authpagePrefix = prefix + "_" + Integer.toString(q);
                    String authpageOp = variableContext.getParameter(authpagePrefix + "_op");
                    if (authpageOp != null && authpageOp.equals("Delete")) continue;
                    String pageRegexp = variableContext.getParameter(authpagePrefix + "_regexp");
                    String pageType = variableContext.getParameter(authpagePrefix + "_type");
                    String matchRegexp = variableContext.getParameter(authpagePrefix + "_matchregexp");
                    if (matchRegexp == null) {
                        matchRegexp = "";
                    }
                    String overrideTargetURL = variableContext.getParameter(authpagePrefix + "_overridetargeturl");
                    ConfigNode authPageNode = new ConfigNode("authpage");
                    authPageNode.setAttribute("urlregexp", pageRegexp);
                    authPageNode.setAttribute("type", pageType);
                    authPageNode.setAttribute("match", matchRegexp);
                    if (overrideTargetURL != null && overrideTargetURL.length() > 0) {
                        authPageNode.setAttribute("overridetargeturl", overrideTargetURL);
                    }
                    if (pageType.equals("form")) {
                        int paramCount = Integer.parseInt(variableContext.getParameter(authpagePrefix + "_loginparamcount"));
                        for (int z = 0; z < paramCount; ++z) {
                            String paramPrefix = authpagePrefix + "_" + Integer.toString(z);
                            String paramOp = variableContext.getParameter(paramPrefix + "_op");
                            if (paramOp != null && paramOp.equals("Delete")) continue;
                            String name = variableContext.getParameter(paramPrefix + "_param");
                            String value = variableContext.getParameter(paramPrefix + "_value");
                            String password = variableContext.getParameter(paramPrefix + "_password");
                            ConfigNode paramNode = new ConfigNode("authparameter");
                            paramNode.setAttribute("name", name);
                            if (value != null && value.length() > 0) {
                                paramNode.setAttribute("value", value);
                            }
                            if (password != null && password.length() > 0) {
                                paramNode.setAttribute("password", ManifoldCF.obfuscate((String)variableContext.mapKeyToPassword(password)));
                            }
                            authPageNode.addChild(authPageNode.getChildCount(), (ConfigurationNode)paramNode);
                        }
                        String paramAddOp = variableContext.getParameter(authpagePrefix + "_loginparamop");
                        if (paramAddOp != null && paramAddOp.equals("Add")) {
                            String name = variableContext.getParameter(authpagePrefix + "_loginparamname");
                            String value = variableContext.getParameter(authpagePrefix + "_loginparamvalue");
                            String password = variableContext.getParameter(authpagePrefix + "_loginparampassword");
                            ConfigNode paramNode = new ConfigNode("authparameter");
                            paramNode.setAttribute("name", name);
                            if (value != null && value.length() > 0) {
                                paramNode.setAttribute("value", value);
                            }
                            if (password != null && password.length() > 0) {
                                paramNode.setAttribute("password", ManifoldCF.obfuscate((String)password));
                            }
                            authPageNode.addChild(authPageNode.getChildCount(), (ConfigurationNode)paramNode);
                        }
                    }
                    node.addChild(node.getChildCount(), (ConfigurationNode)authPageNode);
                }
                String authpageAddop = variableContext.getParameter(prefix + "_loginpageop");
                if (authpageAddop != null && authpageAddop.equals("Add")) {
                    String pageRegexp = variableContext.getParameter(prefix + "_loginpageregexp");
                    String pageType = variableContext.getParameter(prefix + "_loginpagetype");
                    String matchRegexp = variableContext.getParameter(prefix + "_loginpagematchregexp");
                    if (matchRegexp == null) {
                        matchRegexp = "";
                    }
                    String overrideTargetURL = variableContext.getParameter(prefix + "_loginpageoverridetargeturl");
                    ConfigNode authPageNode = new ConfigNode("authpage");
                    authPageNode.setAttribute("urlregexp", pageRegexp);
                    authPageNode.setAttribute("type", pageType);
                    authPageNode.setAttribute("match", matchRegexp);
                    if (overrideTargetURL != null && overrideTargetURL.length() > 0) {
                        authPageNode.setAttribute("overridetargeturl", overrideTargetURL);
                    }
                    node.addChild(node.getChildCount(), (ConfigurationNode)authPageNode);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
            addop = variableContext.getParameter("scredential_op");
            if (addop != null && addop.equals("Add")) {
                regexp = variableContext.getParameter("scredential_regexp");
                ConfigNode node7 = new ConfigNode("accesscredential");
                node7.setAttribute("urlregexp", regexp);
                node7.setAttribute("type", "session");
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node7);
            }
        }
        if ((x = variableContext.getParameter("trust_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node8 = parameters.getChild(i);
                if (node8.getType().equals("trust")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count2 = Integer.parseInt(x);
            for (i = 0; i < count2; ++i) {
                prefix = "trust_" + Integer.toString(i);
                op = variableContext.getParameter("op_" + prefix);
                if (op != null && op.equals("Delete")) continue;
                regexp2 = variableContext.getParameter("regexp_" + prefix);
                String trustall = variableContext.getParameter("trustall_" + prefix);
                String truststore = variableContext.getParameter("truststore_" + prefix);
                ConfigNode node9 = new ConfigNode("trust");
                node9.setAttribute("urlregexp", regexp2);
                if (trustall != null && trustall.equals("true")) {
                    node9.setAttribute("trusteverything", "true");
                } else {
                    node9.setAttribute("truststore", truststore);
                }
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node9);
            }
            addop = variableContext.getParameter("trust_op");
            if (addop != null && addop.equals("Add")) {
                regexp = variableContext.getParameter("regexp_trust");
                String trustall = variableContext.getParameter("all_trust");
                if (trustall != null && trustall.equals("true")) {
                    node = new ConfigNode("trust");
                    node.setAttribute("urlregexp", regexp);
                    node.setAttribute("trusteverything", "true");
                    parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
                } else {
                    byte[] certificateValue = variableContext.getBinaryBytes("certificate_trust");
                    IKeystoreManager mgr = KeystoreManagerFactory.make((String)"");
                    ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                    String certError = null;
                    try {
                        mgr.importCertificate("Certificate", (InputStream)is);
                    }
                    catch (Throwable e) {
                        certError = e.getMessage();
                    }
                    finally {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException pageRegexp) {}
                    }
                    if (certError != null) {
                        return "Illegal certificate: " + certError;
                    }
                    node3 = new ConfigNode("trust");
                    node3.setAttribute("urlregexp", regexp);
                    node3.setAttribute("truststore", mgr.getString());
                    parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node3);
                }
            }
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        this.fillInEmailTab(velocityContext, out, parameters);
        this.fillInRobotsTab(velocityContext, out, parameters);
        this.fillInBandwidthTab(velocityContext, out, parameters);
        this.fillInAccessTab(velocityContext, out, parameters);
        this.fillInCertificatesTab(velocityContext, out, parameters);
        this.fillInProxyTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration.html.vm", velocityContext);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Seeds"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Canonicalization"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.URLMappings"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Inclusions"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Exclusions"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Security"));
        tabsArray.add(Messages.getString(locale, "WebcrawlerConnector.Metadata"));
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("SEQNUM", connectionSequenceNumber);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification.js.vm", velocityContext);
    }

    private void fillInSeedsTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        String seeds = "";
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("seeds") || (seeds = sn.getValue()) != null) continue;
            seeds = "";
        }
        velocityContext.put("SEEDS", seeds);
    }

    private void fillInCanonicalizationTab(Map<String, Object> velocityContext, IHTTPOutput out, Locale locale, Specification ds) {
        int q = 0;
        ArrayList canonicalizationMapList = new ArrayList();
        while (q < ds.getChildCount()) {
            String allowLowercasingOutput;
            String allowBVSessionRemovalOutput;
            String allowPHPSessionRemovalOutput;
            String allowASPSessionRemovalOutput;
            String allowJavaSessionRemovalOutput;
            String allowReorderOutput;
            String allowReorder;
            SpecificationNode specNode;
            if (!(specNode = ds.getChild(q++)).getType().equals("urlspec")) continue;
            HashMap<String, String> canonicalizationMap = new HashMap<String, String>();
            String regexpString = specNode.getAttributeValue("regexp");
            String description = specNode.getAttributeValue("description");
            if (description == null) {
                description = "";
            }
            if ((allowReorder = specNode.getAttributeValue("reorder")) == null || allowReorder.length() == 0) {
                allowReorder = "no";
                allowReorderOutput = Messages.getBodyString(locale, "WebcrawlerConnector.no");
            } else {
                allowReorderOutput = allowReorder.equals("no") ? Messages.getBodyString(locale, "WebcrawlerConnector.no") : Messages.getBodyString(locale, "WebcrawlerConnector.yes");
            }
            String allowJavaSessionRemoval = specNode.getAttributeValue("javasessionremoval");
            if (allowJavaSessionRemoval == null || allowJavaSessionRemoval.length() == 0) {
                allowJavaSessionRemoval = "no";
                allowJavaSessionRemovalOutput = Messages.getBodyString(locale, "WebcrawlerConnector.no");
            } else {
                allowJavaSessionRemovalOutput = allowJavaSessionRemoval.equals("no") ? Messages.getBodyString(locale, "WebcrawlerConnector.no") : Messages.getBodyString(locale, "WebcrawlerConnector.yes");
            }
            String allowASPSessionRemoval = specNode.getAttributeValue("aspsessionremoval");
            if (allowASPSessionRemoval == null || allowASPSessionRemoval.length() == 0) {
                allowASPSessionRemoval = "no";
                allowASPSessionRemovalOutput = Messages.getBodyString(locale, "WebcrawlerConnector.no");
            } else {
                allowASPSessionRemovalOutput = allowASPSessionRemoval.equals("no") ? Messages.getBodyString(locale, "WebcrawlerConnector.no") : Messages.getBodyString(locale, "WebcrawlerConnector.yes");
            }
            String allowPHPSessionRemoval = specNode.getAttributeValue("phpsessionremoval");
            if (allowPHPSessionRemoval == null || allowPHPSessionRemoval.length() == 0) {
                allowPHPSessionRemoval = "no";
                allowPHPSessionRemovalOutput = Messages.getBodyString(locale, "WebcrawlerConnector.no");
            } else {
                allowPHPSessionRemovalOutput = allowPHPSessionRemoval.equals("no") ? Messages.getBodyString(locale, "WebcrawlerConnector.no") : Messages.getBodyString(locale, "WebcrawlerConnector.yes");
            }
            String allowBVSessionRemoval = specNode.getAttributeValue("bvsessionremoval");
            if (allowBVSessionRemoval == null || allowBVSessionRemoval.length() == 0) {
                allowBVSessionRemoval = "no";
                allowBVSessionRemovalOutput = Messages.getBodyString(locale, "WebcrawlerConnector.no");
            } else {
                allowBVSessionRemovalOutput = allowBVSessionRemoval.equals("no") ? Messages.getBodyString(locale, "WebcrawlerConnector.no") : Messages.getBodyString(locale, "WebcrawlerConnector.yes");
            }
            String allowLowercasing = specNode.getAttributeValue("lowercase");
            if (allowLowercasing == null || allowLowercasing.length() == 0) {
                allowLowercasing = "no";
                allowLowercasingOutput = Messages.getBodyString(locale, "WebcrawlerConnector.no");
            } else {
                allowLowercasingOutput = allowLowercasing.equals("no") ? Messages.getBodyString(locale, "WebcrawlerConnector.no") : Messages.getBodyString(locale, "WebcrawlerConnector.yes");
            }
            canonicalizationMap.put("regexpString", regexpString);
            canonicalizationMap.put("description", description);
            canonicalizationMap.put("allowReorder", allowReorder);
            canonicalizationMap.put("allowReorderOutput", allowReorderOutput);
            canonicalizationMap.put("allowJavaSessionRemoval", allowJavaSessionRemoval);
            canonicalizationMap.put("allowJavaSessionRemovalOutput", allowJavaSessionRemovalOutput);
            canonicalizationMap.put("allowASPSessionRemoval", allowASPSessionRemoval);
            canonicalizationMap.put("allowASPSessionRemovalOutput", allowASPSessionRemovalOutput);
            canonicalizationMap.put("allowPHPSessionRemoval", allowPHPSessionRemoval);
            canonicalizationMap.put("allowPHPSessionRemovalOutput", allowPHPSessionRemovalOutput);
            canonicalizationMap.put("allowBVSessionRemoval", allowBVSessionRemoval);
            canonicalizationMap.put("allowBVSessionRemovalOutput", allowBVSessionRemovalOutput);
            canonicalizationMap.put("allowLowercasing", allowLowercasing);
            canonicalizationMap.put("allowLowercasingOutput", allowLowercasingOutput);
            canonicalizationMapList.add(canonicalizationMap);
        }
        velocityContext.put("CANONICALIZATIONMAPLIST", canonicalizationMapList);
    }

    private void fillInMappingsTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        ArrayList<String> regexpList = new ArrayList<String>();
        ArrayList<String> matchStrings = new ArrayList<String>();
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("map")) continue;
            String match = sn.getAttributeValue("match");
            String map = sn.getAttributeValue("map");
            if (match == null) continue;
            regexpList.add(match);
            if (map == null) {
                map = "";
            }
            matchStrings.add(map);
        }
        velocityContext.put("REGEXPLIST", regexpList);
        velocityContext.put("MATCHSTRINGS", matchStrings);
    }

    private void fillInInclusionsTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        String inclusions = ".*\n";
        String inclusionsIndex = ".*\n";
        boolean includeMatching = true;
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("includes")) {
                inclusions = sn.getValue();
                if (inclusions != null) continue;
                inclusions = "";
                continue;
            }
            if (sn.getType().equals("includesindex")) {
                inclusionsIndex = sn.getValue();
                if (inclusionsIndex != null) continue;
                inclusionsIndex = "";
                continue;
            }
            if (!sn.getType().equals("limittoseeds")) continue;
            String value = sn.getAttributeValue("value");
            if (value == null || value.equals("false")) {
                includeMatching = false;
                continue;
            }
            includeMatching = true;
        }
        velocityContext.put("INCLUSIONS", inclusions);
        velocityContext.put("INCLUSIONSINDEX", inclusionsIndex);
        velocityContext.put("INCLUDEMATCHING", includeMatching);
    }

    private void fillInExclusionsTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        String exclusions = "";
        String exclusionsIndex = "";
        String exclusionsContentIndex = "";
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("excludes")) {
                exclusions = sn.getValue();
                if (exclusions != null) continue;
                exclusions = "";
                continue;
            }
            if (sn.getType().equals("excludesindex")) {
                exclusionsIndex = sn.getValue();
                if (exclusionsIndex != null) continue;
                exclusionsIndex = "";
                continue;
            }
            if (!sn.getType().equals("excludescontentindex") || (exclusionsContentIndex = sn.getValue()) != null) continue;
            exclusionsContentIndex = "";
        }
        velocityContext.put("EXCLUSIONS", exclusions);
        velocityContext.put("EXCLUSIONSINDEX", exclusionsIndex);
        velocityContext.put("EXCLUSIONSCONTENTINDEX", exclusionsContentIndex);
    }

    private void fillInSecurityTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        int i = 0;
        HashSet<String> tokens = new HashSet<String>();
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            tokens.add(token);
        }
        velocityContext.put("TOKENS", tokens);
    }

    private void fillInMetadataTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        HashSet<String> excludedHeaders = new HashSet<String>();
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("excludeheader")) continue;
            String value = sn.getAttributeValue("value");
            excludedHeaders.add(value);
        }
        velocityContext.put("POTENTIALLYEXCLUDEDHEADERS", potentiallyExcludedHeaders);
        velocityContext.put("EXCLUDEDHEADERS", excludedHeaders);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TABNAME", tabName);
        velocityContext.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        velocityContext.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        this.fillInSeedsTab(velocityContext, out, ds);
        this.fillInCanonicalizationTab(velocityContext, out, locale, ds);
        this.fillInMappingsTab(velocityContext, out, ds);
        this.fillInInclusionsTab(velocityContext, out, ds);
        this.fillInExclusionsTab(velocityContext, out, ds);
        this.fillInSecurityTab(velocityContext, out, ds);
        this.fillInMetadataTab(velocityContext, out, ds);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Seeds.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Canonicalization.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Mappings.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Inclusions.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Exclusions.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Security.html.vm", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editSpecification_Metadata.html.vm", velocityContext);
    }

    /*
     * WARNING - void declaration
     */
    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xc;
        SpecificationNode sn;
        String urlRegexpCount;
        String exclusionsContentIndex;
        String exclusionsIndex;
        String exclusions;
        String matchingHostsPresent;
        String string;
        String inclusions;
        String seeds;
        SpecificationNode cn;
        String rssop;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String value = variableContext.getParameter(seqPrefix + "rssmapcount");
        if (value != null) {
            int mapsize = Integer.parseInt(value);
            int j = 0;
            while (j < ds.getChildCount()) {
                SpecificationNode sn3 = ds.getChild(j);
                if (sn3.getType().equals("map")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            for (j = 0; j < mapsize; ++j) {
                void var11_19;
                String prefix = seqPrefix + "rssregexp_" + Integer.toString(j) + "_";
                String match = variableContext.getParameter(prefix + "match");
                String string2 = variableContext.getParameter(prefix + "map");
                if (string2 == null) {
                    String string3 = "";
                }
                SpecificationNode node = new SpecificationNode("map");
                node.setAttribute("match", match);
                node.setAttribute("map", (String)var11_19);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((rssop = variableContext.getParameter(seqPrefix + "rssop")) != null && rssop.equals("Add")) {
            String match = variableContext.getParameter(seqPrefix + "rssmatch");
            String map = variableContext.getParameter(seqPrefix + "rssmap");
            SpecificationNode node = new SpecificationNode("map");
            node.setAttribute("match", match);
            node.setAttribute("map", map);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        } else if (rssop != null && rssop.equals("Delete")) {
            int index = Integer.parseInt(variableContext.getParameter(seqPrefix + "rssindex"));
            for (int j = 0; j < ds.getChildCount(); ++j) {
                SpecificationNode sn2 = ds.getChild(j);
                if (!sn2.getType().equals("map")) continue;
                if (index == 0) {
                    ds.removeChild(j);
                    break;
                }
                --index;
            }
        }
        String excludedHeadersPresent = variableContext.getParameter(seqPrefix + "excludedheaders_present");
        if (excludedHeadersPresent != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i);
                if (sn2.getType().equals("excludeheader")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            String[] excludedHeaders = variableContext.getParameterValues(seqPrefix + "excludedheaders");
            if (excludedHeaders != null) {
                for (String excludedHeader : excludedHeaders) {
                    cn = new SpecificationNode("excludeheader");
                    cn.setAttribute("value", excludedHeader);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)cn);
                }
            }
        }
        if ((seeds = variableContext.getParameter(seqPrefix + "seeds")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode specificationNode = ds.getChild(i);
                if (specificationNode.getType().equals("seeds")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode specificationNode = new SpecificationNode("seeds");
            specificationNode.setValue(seeds);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)specificationNode);
        }
        if ((inclusions = variableContext.getParameter(seqPrefix + "inclusions")) != null) {
            void var11_29;
            boolean bl = false;
            while (var11_29 < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild((int)var11_29);
                if (sn5.getType().equals("includes")) {
                    ds.removeChild((int)var11_29);
                    continue;
                }
                ++var11_29;
            }
            SpecificationNode cn3 = new SpecificationNode("includes");
            cn3.setValue(inclusions);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn3);
        }
        if ((string = variableContext.getParameter(seqPrefix + "inclusionsindex")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(i);
                if (sn6.getType().equals("includesindex")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode cn4 = new SpecificationNode("includesindex");
            cn4.setValue(string);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn4);
        }
        if ((matchingHostsPresent = variableContext.getParameter(seqPrefix + "matchinghosts_present")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn7 = ds.getChild(i);
                if (sn7.getType().equals("limittoseeds")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            String matchingHosts = variableContext.getParameter(seqPrefix + "matchinghosts");
            cn = new SpecificationNode("limittoseeds");
            cn.setAttribute("value", matchingHosts == null || matchingHosts.equals("false") ? "false" : "true");
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn);
        }
        if ((exclusions = variableContext.getParameter(seqPrefix + "exclusions")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn8 = ds.getChild(i);
                if (sn8.getType().equals("excludes")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            cn = new SpecificationNode("excludes");
            cn.setValue(exclusions);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn);
        }
        if ((exclusionsIndex = variableContext.getParameter(seqPrefix + "exclusionsindex")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn9 = ds.getChild(i);
                if (sn9.getType().equals("excludesindex")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode cn5 = new SpecificationNode("excludesindex");
            cn5.setValue(exclusionsIndex);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn5);
        }
        if ((exclusionsContentIndex = variableContext.getParameter(seqPrefix + "exclusionscontentindex")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn10 = ds.getChild(i);
                if (sn10.getType().equals("excludescontentindex")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode cn6 = new SpecificationNode("excludescontentindex");
            cn6.setValue(exclusionsContentIndex);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)cn6);
        }
        if ((urlRegexpCount = variableContext.getParameter(seqPrefix + "urlregexpcount")) != null && urlRegexpCount.length() > 0) {
            SpecificationNode newSn;
            String lowercasing;
            String bvSession;
            String phpSession;
            String aspSession;
            String javaSession;
            String reorder;
            String regexpDescription;
            String regexp;
            int regexpCount = Integer.parseInt(urlRegexpCount);
            int j = 0;
            while (j < ds.getChildCount()) {
                sn = ds.getChild(j);
                if (sn.getType().equals("urlspec")) {
                    ds.removeChild(j);
                    continue;
                }
                ++j;
            }
            String operation = variableContext.getParameter(seqPrefix + "urlregexpop");
            if (operation == null) {
                operation = "Continue";
            }
            int opIndex = -1;
            if (operation.equals("Delete")) {
                opIndex = Integer.parseInt(variableContext.getParameter(seqPrefix + "urlregexpnumber"));
            }
            for (j = 0; j < regexpCount; ++j) {
                if (operation.equals("Delete") && j == opIndex) continue;
                regexp = variableContext.getParameter(seqPrefix + "urlregexp_" + Integer.toString(j));
                regexpDescription = variableContext.getParameter(seqPrefix + "urlregexpdesc_" + Integer.toString(j));
                reorder = variableContext.getParameter(seqPrefix + "urlregexpreorder_" + Integer.toString(j));
                javaSession = variableContext.getParameter(seqPrefix + "urlregexpjava_" + Integer.toString(j));
                aspSession = variableContext.getParameter(seqPrefix + "urlregexpasp_" + Integer.toString(j));
                phpSession = variableContext.getParameter(seqPrefix + "urlregexpphp_" + Integer.toString(j));
                bvSession = variableContext.getParameter(seqPrefix + "urlregexpbv_" + Integer.toString(j));
                lowercasing = variableContext.getParameter(seqPrefix + "urlregexplowercasing_" + Integer.toString(j));
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                if (lowercasing != null && lowercasing.length() > 0) {
                    newSn.setAttribute("lowercase", lowercasing);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
            if (operation.equals("Add")) {
                regexp = variableContext.getParameter(seqPrefix + "urlregexp");
                regexpDescription = variableContext.getParameter(seqPrefix + "urlregexpdesc");
                reorder = variableContext.getParameter(seqPrefix + "urlregexpreorder");
                javaSession = variableContext.getParameter(seqPrefix + "urlregexpjava");
                aspSession = variableContext.getParameter(seqPrefix + "urlregexpasp");
                phpSession = variableContext.getParameter(seqPrefix + "urlregexpphp");
                bvSession = variableContext.getParameter(seqPrefix + "urlregexpbv");
                lowercasing = variableContext.getParameter(seqPrefix + "urlregexplowercasing");
                newSn = new SpecificationNode("urlspec");
                newSn.setAttribute("regexp", regexp);
                if (regexpDescription != null && regexpDescription.length() > 0) {
                    newSn.setAttribute("description", regexpDescription);
                }
                if (reorder != null && reorder.length() > 0) {
                    newSn.setAttribute("reorder", reorder);
                }
                if (javaSession != null && javaSession.length() > 0) {
                    newSn.setAttribute("javasessionremoval", javaSession);
                }
                if (aspSession != null && aspSession.length() > 0) {
                    newSn.setAttribute("aspsessionremoval", aspSession);
                }
                if (phpSession != null && phpSession.length() > 0) {
                    newSn.setAttribute("phpsessionremoval", phpSession);
                }
                if (bvSession != null && bvSession.length() > 0) {
                    newSn.setAttribute("bvsessionremoval", bvSession);
                }
                if (lowercasing != null && lowercasing.length() > 0) {
                    newSn.setAttribute("lowercase", lowercasing);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newSn);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        this.fillInSeedsTab(velocityContext, out, ds);
        this.fillInCanonicalizationTab(velocityContext, out, locale, ds);
        this.fillInMappingsTab(velocityContext, out, ds);
        this.fillInInclusionsTab(velocityContext, out, ds);
        this.fillInExclusionsTab(velocityContext, out, ds);
        this.fillInSecurityTab(velocityContext, out, ds);
        this.fillInMetadataTab(velocityContext, out, ds);
        Messages.outputResourceWithVelocity(out, locale, "viewSpecification.html.vm", velocityContext);
    }

    protected String makeSessionLoginEventName(INamingActivity activities, String sequenceKey) {
        return activities.createGlobalString("webcrawler:session:" + sequenceKey);
    }

    protected String makeDNSEventName(INamingActivity activities, String hostNameKey) {
        return activities.createGlobalString("webcrawler:dns:" + hostNameKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int lookupIPAddress(String documentIdentifier, IProcessActivity activities, String hostName, long currentTime, StringBuilder ipAddressBuffer) throws ManifoldCFException, ServiceInterruption {
        String eventName = this.makeDNSEventName((INamingActivity)activities, hostName);
        DNSManager.DNSInfo info = this.dnsManager.lookup(hostName, currentTime);
        if (info != null) {
            String ipAddress = info.getIPAddress();
            if (ipAddress == null) {
                return 0;
            }
            ipAddressBuffer.append(ipAddress);
            return 1;
        }
        if (activities.beginEventSequence(eventName)) {
            try {
                InetAddress ip = null;
                try {
                    ip = InetAddress.getByName(hostName);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                String fqdn = null;
                String ipAddress = null;
                if (ip != null) {
                    fqdn = ip.getCanonicalHostName();
                    ipAddress = ip.getHostAddress();
                }
                this.dnsManager.writeDNSData(hostName, fqdn, ipAddress, currentTime + 21600000L);
                if (ipAddress == null) {
                    int n = 0;
                    return n;
                }
                ipAddressBuffer.append(ipAddress);
                int n = 1;
                return n;
            }
            finally {
                activities.completeEventSequence(eventName);
            }
        }
        return 2;
    }

    protected static String makeRobotsKey(String protocol, String hostName, int port) {
        String rval = hostName + ":" + port;
        if (!protocol.equalsIgnoreCase("http")) {
            rval = protocol.toLowerCase(Locale.ROOT) + ":" + rval;
        }
        return rval;
    }

    protected String makeRobotsEventName(INamingActivity versionActivities, String robotsKey) {
        return versionActivities.createGlobalString("webcrawler:robots:" + robotsKey);
    }

    /*
     * Exception decompiling
     */
    protected int checkFetchAllowed(String documentIdentifier, String protocol, String hostIPAddress, int port, PageCredentials credential, IKeystoreManager trustStore, String hostName, String[] binNames, long currentTime, String pathString, IProcessActivity versionActivities, int connectionLimit, String proxyHost, int proxyPort, String proxyAuthDomain, String proxyAuthUsername, String proxyAuthPassword) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String makeDocumentIdentifier(String parentIdentifier, String rawURL, DocumentURLFilter filter, IHistoryActivity activities) throws ManifoldCFException {
        try {
            WebURL url;
            if (parentIdentifier != null) {
                WebURL parentURL = new WebURL(parentIdentifier);
                url = parentURL.resolve(rawURL);
            } else {
                url = new WebURL(rawURL);
            }
            String protocol = url.getScheme();
            String host = url.getHost();
            if (protocol == null || host == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it has no protocol or host"));
                }
                return null;
            }
            if (!understoodProtocols.contains(protocol)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it has an unsupported protocol '" + protocol + "'"));
                }
                return null;
            }
            if (!filter.isHostLegal(host)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because its host is not found in the seeds ('" + host + "')"));
                }
                return null;
            }
            String id = this.doCanonicalization(filter, url);
            if (id == null) {
                return null;
            }
            int i = 0;
            while (i < id.length()) {
                char x;
                if ((x = id.charAt(i++)) >= ' ' && x <= '\u007f') continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it has illegal characters in it"));
                }
                return null;
            }
            if (!filter.isDocumentLegal(id, activities)) {
                return null;
            }
            return id;
        }
        catch (URISyntaxException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: Can't use url '" + rawURL + "' because it is badly formed: " + e.getMessage()));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected String doCanonicalization(DocumentURLFilter filter, WebURL url) throws ManifoldCFException, URISyntaxException {
        String pathString = url.getPath();
        String queryString = url.getRawQuery();
        WebURL rawURI = new WebURL(url.getScheme(), url.getHost(), url.getPort(), pathString, queryString);
        String completeRawURL = rawURI.toASCIIString();
        CanonicalizationPolicy p = completeRawURL != null ? filter.getCanonicalizationPolicies().findMatch(completeRawURL) : null;
        if (queryString != null) {
            if (p == null || p.canReorder()) {
                HashMap<String, ArrayList<String>> argumentMap = new HashMap<String, ArrayList<String>>();
                int index = 0;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if (p != null && p.canRemoveBvSession() && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        ArrayList<String> list = (ArrayList<String>)argumentMap.get(key);
                        if (list == null) {
                            list = new ArrayList<String>();
                            argumentMap.put(key, list);
                        }
                        list.add(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                Object[] sortArray = new String[argumentMap.size()];
                int i = 0;
                Iterator iter = argumentMap.keySet().iterator();
                while (iter.hasNext()) {
                    sortArray[i++] = (String)iter.next();
                }
                Arrays.sort(sortArray);
                StringBuilder newString = new StringBuilder();
                boolean isFirst = true;
                i = 0;
                while (i < sortArray.length) {
                    Object key = sortArray[i++];
                    ArrayList list = (ArrayList)argumentMap.get(key);
                    int j = 0;
                    while (j < list.size()) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append((String)list.get(j++));
                    }
                }
                queryString = newString.toString();
            } else {
                StringBuilder newString = new StringBuilder();
                int index = 0;
                boolean isFirst = true;
                while (index < queryString.length()) {
                    String argument;
                    int valueIndex;
                    int newIndex = queryString.indexOf("&", index);
                    if (newIndex == -1) {
                        newIndex = queryString.length();
                    }
                    String key = (valueIndex = (argument = queryString.substring(index, newIndex)).indexOf("=")) == -1 ? argument : argument.substring(0, valueIndex);
                    boolean includeArgument = true;
                    if ((p == null || p.canRemovePhpSession()) && key.equals("PHPSESSID")) {
                        includeArgument = false;
                    }
                    if (p != null && p.canRemoveBvSession() && key.indexOf("BVSession@@@@") != -1) {
                        includeArgument = false;
                    }
                    if (includeArgument) {
                        if (!isFirst) {
                            newString.append("&");
                        } else {
                            isFirst = false;
                        }
                        newString.append(argument);
                    }
                    if (newIndex < queryString.length()) {
                        index = newIndex + 1;
                        continue;
                    }
                    index = newIndex;
                }
                queryString = newString.toString();
            }
        }
        if (pathString != null) {
            int index = pathString.indexOf(";jsessionid=");
            if ((p == null || p.canRemoveJavaSession()) && index != -1) {
                pathString = pathString.substring(0, index);
            }
            if ((p == null || p.canRemoveAspSession()) && pathString.startsWith("/s(") && (index = pathString.indexOf(")")) != -1) {
                pathString = pathString.substring(index + 1);
            }
        }
        if (p != null && p.canLowercase()) {
            pathString = WebcrawlerConnector.filterMultipleSlashes(pathString);
        }
        url = new WebURL(url.getScheme(), url.getHost(), url.getPort(), pathString, queryString);
        String rval = url.toASCIIString();
        if (p != null && p.canLowercase()) {
            rval = rval.toLowerCase(Locale.ROOT);
        }
        return rval;
    }

    private static String filterMultipleSlashes(String pathString) {
        int index;
        while ((index = pathString.indexOf("//")) != -1) {
            pathString = pathString.substring(0, index) + pathString.substring(index + 1);
        }
        return pathString;
    }

    protected boolean isContentInteresting(IFingerprintActivity activities, String documentIdentifier, int response, String contentType) throws ServiceInterruption, ManifoldCFException {
        if (response != 200) {
            return true;
        }
        if (contentType == null) {
            return false;
        }
        String strippedContentType = contentType;
        int pos = strippedContentType.indexOf(";");
        if (pos != -1) {
            strippedContentType = strippedContentType.substring(0, pos);
        }
        if (interestingMimeTypeMap.contains(strippedContentType = strippedContentType.trim())) {
            return true;
        }
        boolean rval = activities.checkMimeTypeIndexable(contentType);
        if (!rval && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("Web: For document '" + documentIdentifier + "', not fetching because output connector does not want mimetype '" + contentType + "'"));
        }
        return rval;
    }

    protected String documentIdentifiertoFileName(String documentIdentifier) throws URISyntaxException {
        StringBuffer path = new StringBuffer();
        URI uri = null;
        uri = new URI(documentIdentifier);
        if (uri.getRawPath() != null) {
            if (uri.getRawPath().equals("")) {
                path.append("");
            } else if (uri.getRawPath().equals("/")) {
                path.append("index.html");
            } else if (uri.getRawPath().length() != 0) {
                if (uri.getRawPath().endsWith("/")) {
                    path.append("index.html");
                } else {
                    String[] names = uri.getRawPath().split("/");
                    path.append(names[names.length - 1]);
                }
            }
        }
        if (path.length() > 0 && uri.getRawQuery() != null) {
            path.append("?");
            path.append(uri.getRawQuery());
        }
        return path.toString();
    }

    protected String findRedirectionURI(String currentURI) throws ManifoldCFException {
        FindRedirectionHandler handler = new FindRedirectionHandler(currentURI);
        this.handleRedirects(currentURI, handler);
        return handler.getTargetURI();
    }

    protected FormData findHTMLForm(String currentURI, LoginParameters lp) throws ManifoldCFException {
        if (lp == null || lp.getFormNamePattern() == null) {
            return null;
        }
        FindHTMLFormHandler handler = new FindHTMLFormHandler(currentURI, lp.getFormNamePattern());
        this.handleHTML(currentURI, handler);
        handler.applyFormOverrides(lp);
        return handler.getFormData();
    }

    protected String findPreferredRedirectionURI(String currentURI, LoginParameters lp) throws ManifoldCFException {
        if (lp == null || lp.getPreferredRedirectionPattern() == null) {
            return null;
        }
        FindPreferredRedirectionHandler handler = new FindPreferredRedirectionHandler(currentURI, lp.getPreferredRedirectionPattern());
        this.handleRedirects(currentURI, handler);
        handler.applyOverrides(lp);
        return handler.getTargetURI();
    }

    protected String findSpecifiedContent(String currentURI, LoginParameters lp) throws ManifoldCFException {
        if (lp == null || lp.getContentPattern() == null) {
            return null;
        }
        FindContentHandler handler = new FindContentHandler(currentURI, lp.getContentPattern());
        this.handleHTML(currentURI, handler);
        handler.applyOverrides(lp);
        return handler.getTargetURI();
    }

    protected String findHTMLLinkURI(String currentURI, LoginParameters lp) throws ManifoldCFException {
        if (lp == null || lp.getPreferredLinkPattern() == null) {
            return null;
        }
        FindHTMLHrefHandler handler = new FindHTMLHrefHandler(currentURI, lp.getPreferredLinkPattern());
        this.handleHTML(currentURI, handler);
        handler.applyOverrides(lp);
        return handler.getTargetURI();
    }

    protected boolean extractLinks(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter) throws ManifoldCFException, ServiceInterruption {
        ProcessActivityRedirectionHandler redirectHandler = new ProcessActivityRedirectionHandler(documentIdentifier, activities, filter);
        this.handleRedirects(documentIdentifier, redirectHandler);
        if (Logging.connectors.isDebugEnabled() && !redirectHandler.shouldIndex()) {
            Logging.connectors.debug((Object)("Web: Not indexing document '" + documentIdentifier + "' because of redirection"));
        }
        ProcessActivityHTMLHandler htmlHandler = new ProcessActivityHTMLHandler(documentIdentifier, activities, filter, this.metaRobotsTagsUsage);
        this.handleHTML(documentIdentifier, htmlHandler);
        if (Logging.connectors.isDebugEnabled() && !htmlHandler.shouldIndex()) {
            Logging.connectors.debug((Object)("Web: Not indexing document '" + documentIdentifier + "' because of HTML robots or content tags prohibiting indexing"));
        }
        ProcessActivityXMLHandler xmlHandler = new ProcessActivityXMLHandler(documentIdentifier, activities, filter);
        this.handleXML(documentIdentifier, xmlHandler);
        if (Logging.connectors.isDebugEnabled() && !xmlHandler.shouldIndex()) {
            Logging.connectors.debug((Object)("Web: Not indexing document '" + documentIdentifier + "' because of XML robots or content tags prohibiting indexing"));
        }
        return htmlHandler.shouldIndex() && redirectHandler.shouldIndex() && xmlHandler.shouldIndex();
    }

    protected void handleRedirects(String documentURI, IRedirectionHandler handler) throws ManifoldCFException {
        int responseCode = cache.getResponseCode(documentURI);
        if (responseCode == 302 || responseCode == 301) {
            String referralURI = cache.getReferralURI(documentURI);
            if (referralURI == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: The document '" + documentURI + "' is a redirection, but there was no URI header!"));
                }
                return;
            }
            int index = referralURI.indexOf(" ");
            if (index != -1) {
                referralURI = referralURI.substring(0, index);
            }
            handler.noteDiscoveredLink(referralURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleXML(String documentURI, IXMLHandler handler) throws ManifoldCFException, ServiceInterruption {
        try {
            boolean isXML;
            int responseCode = cache.getResponseCode(documentURI);
            if (responseCode != 200) {
                return;
            }
            String contentType = WebcrawlerConnector.extractContentType(cache.getContentType(documentURI));
            String mimeType = WebcrawlerConnector.extractMimeType(contentType);
            boolean bl = isXML = mimeType.equals("text/xml") || mimeType.equals("application/rss+xml") || mimeType.equals("application/xml") || mimeType.equals("application/atom+xml") || mimeType.equals("application/xhtml+xml") || mimeType.equals("text/XML") || mimeType.equals("application/rdf+xml") || mimeType.equals("text/application") || mimeType.equals("XML");
            if (!isXML) {
                return;
            }
            String encoding = WebcrawlerConnector.extractEncoding(contentType);
            InputStream is = cache.getData(documentURI);
            if (is == null) {
                Logging.connectors.error((Object)("WEB: Document '" + documentURI + "' should be in cache but isn't"));
                return;
            }
            try {
                Parser p = new Parser();
                XMLFuzzyHierarchicalParseState x = new XMLFuzzyHierarchicalParseState();
                OuterContextClass c = new OuterContextClass(x, documentURI, handler);
                x.setContext((XMLParsingContext)c);
                try {
                    p.parseWithCharsetDetection(encoding, is, (CharacterReceiver)x);
                    c.checkIfValidFeed();
                }
                finally {
                    x.cleanup();
                }
            }
            finally {
                is.close();
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket connect timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHTML(String documentURI, IHTMLHandler handler) throws ManifoldCFException {
        int responseCode = cache.getResponseCode(documentURI);
        if (responseCode != 200) {
            return;
        }
        try {
            InputStream is;
            if (!this.isDocumentText(documentURI)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Document '" + documentURI + "' is not text; can't extract links"));
                }
                return;
            }
            String contentType = WebcrawlerConnector.extractContentType(cache.getContentType(documentURI));
            String encoding = WebcrawlerConnector.extractEncoding(contentType);
            if (encoding == null) {
                encoding = StandardCharsets.UTF_8.name();
            }
            if ((is = cache.getData(documentURI)) == null) {
                Logging.connectors.error((Object)("WEB: Document '" + documentURI + "' should be in cache but isn't"));
                return;
            }
            try {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Document '" + documentURI + "' is text, with encoding '" + encoding + "'; link extraction starting"));
                }
                Parser p = new Parser();
                p.parseWithoutCharsetDetection(encoding, is, (CharacterReceiver)new FormParseState(handler));
            }
            catch (UnsupportedEncodingException e) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Document '" + documentURI + "' had an unrecognized encoding '" + encoding + "'"));
                }
                return;
            }
            finally {
                is.close();
            }
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket connect timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDocumentText(String documentURI) throws ManifoldCFException {
        try {
            int amt;
            byte[] byteBuffer = new byte[4096];
            InputStream is = cache.getData(documentURI);
            if (is == null) {
                return false;
            }
            try {
                int incr;
                for (amt = 0; amt < byteBuffer.length; amt += incr) {
                    incr = is.read(byteBuffer, amt, byteBuffer.length - amt);
                    if (incr != -1) continue;
                    break;
                }
            }
            finally {
                is.close();
            }
            if (amt == 0) {
                return false;
            }
            return WebcrawlerConnector.isText(byteBuffer, amt);
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception accessing cached document: " + e.getMessage(), (Throwable)e);
        }
        catch (ConnectTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception accessing cached document: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception accessing cached document: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static boolean isText(byte[] beginChunk, int chunkLength) {
        if (chunkLength == 0) {
            return true;
        }
        int i = 0;
        int count = 0;
        while (i < chunkLength) {
            byte x;
            if ((x = beginChunk[i++]) == 0) {
                return false;
            }
            if (!WebcrawlerConnector.isStrange(x)) continue;
            ++count;
        }
        return (double)count / (double)chunkLength < 0.3;
    }

    protected static boolean isStrange(byte x) {
        return x >= 0 && x < 32 && !WebcrawlerConnector.isWhiteSpace(x);
    }

    protected static boolean isWhiteSpace(byte x) {
        return x == 9 || x == 10 || x == 13 || x == 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> stringToArray(String input) {
        ArrayList<String> list = new ArrayList<String>();
        try (StringReader str = new StringReader(input);
             BufferedReader is = new BufferedReader(str);){
            String nextString;
            while ((nextString = is.readLine()) != null) {
                if ((nextString = nextString.trim()).length() == 0 || nextString.startsWith("#")) continue;
                list.add(nextString);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    protected static void compileList(List<Pattern> output, List<String> input) throws ManifoldCFException {
        int i = 0;
        while (i < input.size()) {
            String inputString = input.get(i++);
            try {
                output.add(Pattern.compile(inputString));
            }
            catch (PatternSyntaxException e) {
                throw new ManifoldCFException("Mapping regular expression '" + inputString + "' is illegal: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected PageCredentials getPageCredential(String documentIdentifier) {
        return this.credentialsDescription.getPageCredential(documentIdentifier);
    }

    protected SequenceCredentials getSequenceCredential(String documentIdentifier) {
        return this.credentialsDescription.getSequenceCredential(documentIdentifier);
    }

    protected IKeystoreManager getTrustStore(String documentIdentifier) throws ManifoldCFException {
        return this.trustsDescription.getTrustStore(documentIdentifier);
    }

    protected static String[] getAcls(Specification spec) {
        HashSet<String> map = new HashSet<String>();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            map.add(token);
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static Set<String> findExcludedHeaders(Specification spec) throws ManifoldCFException {
        HashSet<String> rval = new HashSet<String>();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode n;
            if (!(n = spec.getChild(i++)).getType().equals("excludeheader")) continue;
            String value = n.getAttributeValue("value");
            rval.add(value);
        }
        return rval;
    }

    protected String[] calculateDocumentEvents(INamingActivity activities, String documentIdentifier) {
        try {
            URL url = new URL(documentIdentifier);
            String hostName = url.getHost();
            String protocol = url.getProtocol();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            String robotsKey = WebcrawlerConnector.makeRobotsKey(protocol, hostName, port);
            String robotsEventName = this.makeRobotsEventName(activities, robotsKey);
            String dnsEventName = this.makeDNSEventName(activities, hostName);
            SequenceCredentials sequenceCredential = this.getSequenceCredential(documentIdentifier);
            if (sequenceCredential != null) {
                String sessionKey = sequenceCredential.getSequenceKey();
                String sessionEventName = this.makeSessionLoginEventName(activities, sessionKey);
                return new String[]{robotsEventName, hostName, sessionEventName};
            }
            return new String[]{robotsEventName, hostName};
        }
        catch (MalformedURLException e) {
            Logging.connectors.warn((Object)("WEB: Could not form event names for identifier '" + documentIdentifier + "' because it was malformed: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    static {
        int i = 0;
        while (i < interestingMimeTypeArray.length) {
            String type = interestingMimeTypeArray[i++];
            interestingMimeTypeMap.add(type);
        }
        understoodProtocols = new HashSet<String>();
        understoodProtocols.add("http");
        understoodProtocols.add("https");
        reservedHeaders = new HashSet<String>();
        reservedHeaders.add("age");
        reservedHeaders.add("www-authenticate");
        reservedHeaders.add("proxy-authenticate");
        reservedHeaders.add("date");
        reservedHeaders.add("set-cookie");
        reservedHeaders.add("via");
        potentiallyExcludedHeaders = new ArrayList<String>();
        potentiallyExcludedHeaders.add("last-modified");
        cache = new DataCache();
    }

    protected static class FetchStatus {
        public int sessionState = 0;
        public int resultSignal = 0;
        public String contextMessage = null;
        public Throwable contextException = null;
        public String checkSum = null;
        public Map<String, List<String>> headerData = null;

        protected FetchStatus() {
        }
    }

    protected class DocumentURLFilter {
        protected String versionString;
        protected final MappingRules mappings = new MappingRules();
        protected final List<Pattern> includePatterns = new ArrayList<Pattern>();
        protected final List<Pattern> excludePatterns = new ArrayList<Pattern>();
        protected final List<Pattern> includeIndexPatterns = new ArrayList<Pattern>();
        protected final List<Pattern> excludeIndexPatterns = new ArrayList<Pattern>();
        protected Set<String> seedHosts = null;
        protected final List<Pattern> excludeContentIndexPatterns = new ArrayList<Pattern>();
        protected final CanonicalizationPolicies canonicalizationPolicies = new CanonicalizationPolicies();

        public DocumentURLFilter(Specification spec) throws ManifoldCFException {
            String includes = ".*";
            String excludes = "";
            String includesIndex = ".*";
            String excludesIndex = "";
            String excludesContentIndex = "";
            String seeds = "";
            ArrayList<String> packList = new ArrayList<String>();
            String[] packStuff = new String[2];
            boolean limitToSeeds = false;
            int i = 0;
            while (i < spec.getChildCount()) {
                SpecificationNode sn;
                if ((sn = spec.getChild(i++)).getType().equals("map")) {
                    Pattern p;
                    String match = sn.getAttributeValue("match");
                    String map = sn.getAttributeValue("map");
                    if (match == null || match.length() <= 0) continue;
                    packStuff[0] = match;
                    packStuff[1] = map;
                    StringBuilder sb = new StringBuilder();
                    WebcrawlerConnector.packList((StringBuilder)sb, (String[])packStuff, (char)'=');
                    packList.add(sb.toString());
                    try {
                        p = Pattern.compile(match);
                    }
                    catch (PatternSyntaxException e) {
                        throw new ManifoldCFException("Regular expression '" + match + "' is illegal: " + e.getMessage(), (Throwable)e);
                    }
                    if (map == null) {
                        map = "";
                    }
                    this.mappings.add(new MappingRule(p, map));
                    continue;
                }
                if (sn.getType().equals("seeds")) {
                    seeds = sn.getValue();
                    if (seeds != null) continue;
                    seeds = "";
                    continue;
                }
                if (sn.getType().equals("includes")) {
                    includes = sn.getValue();
                    if (includes != null) continue;
                    includes = "";
                    continue;
                }
                if (sn.getType().equals("excludes")) {
                    excludes = sn.getValue();
                    if (excludes != null) continue;
                    excludes = "";
                    continue;
                }
                if (sn.getType().equals("includesindex")) {
                    includesIndex = sn.getValue();
                    if (includesIndex != null) continue;
                    includesIndex = "";
                    continue;
                }
                if (sn.getType().equals("excludesindex")) {
                    excludesIndex = sn.getValue();
                    if (excludesIndex != null) continue;
                    excludesIndex = "";
                    continue;
                }
                if (sn.getType().equals("limittoseeds")) {
                    String value = sn.getAttributeValue("value");
                    if (value == null || value.equals("false")) {
                        limitToSeeds = false;
                        continue;
                    }
                    limitToSeeds = true;
                    continue;
                }
                if (sn.getType().equals("urlspec")) {
                    String reorder;
                    String urlRegexp = sn.getAttributeValue("regexp");
                    if (urlRegexp == null) {
                        urlRegexp = "";
                    }
                    boolean reorderValue = (reorder = sn.getAttributeValue("reorder")) == null ? false : reorder.equals("yes");
                    String javaSession = sn.getAttributeValue("javasessionremoval");
                    boolean javaSessionValue = javaSession == null ? false : javaSession.equals("yes");
                    String aspSession = sn.getAttributeValue("aspsessionremoval");
                    boolean aspSessionValue = aspSession == null ? false : aspSession.equals("yes");
                    String phpSession = sn.getAttributeValue("phpsessionremoval");
                    boolean phpSessionValue = phpSession == null ? false : phpSession.equals("yes");
                    String bvSession = sn.getAttributeValue("bvsessionremoval");
                    boolean bvSessionValue = bvSession == null ? false : bvSession.equals("yes");
                    String lowercasing = sn.getAttributeValue("lowercase");
                    boolean lowercasingValue = lowercasing == null ? false : lowercasing.equals("yes");
                    try {
                        this.canonicalizationPolicies.addRule(new CanonicalizationPolicy(Pattern.compile(urlRegexp), reorderValue, javaSessionValue, aspSessionValue, phpSessionValue, bvSessionValue, lowercasingValue));
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        throw new ManifoldCFException("Canonicalization regular expression '" + urlRegexp + "' is illegal: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (!sn.getType().equals("excludescontentindex") || (excludesContentIndex = sn.getValue()) != null) continue;
                excludesContentIndex = "";
            }
            StringBuilder versionBuffer = new StringBuilder();
            WebcrawlerConnector.pack((StringBuilder)versionBuffer, (String)includesIndex, (char)'+');
            WebcrawlerConnector.pack((StringBuilder)versionBuffer, (String)excludesIndex, (char)'+');
            WebcrawlerConnector.pack((StringBuilder)versionBuffer, (String)excludesContentIndex, (char)'+');
            WebcrawlerConnector.packList((StringBuilder)versionBuffer, (List)packList, (char)'+');
            this.versionString = versionBuffer.toString();
            List<String> list = WebcrawlerConnector.stringToArray(includes);
            WebcrawlerConnector.compileList(this.includePatterns, list);
            list = WebcrawlerConnector.stringToArray(excludes);
            WebcrawlerConnector.compileList(this.excludePatterns, list);
            list = WebcrawlerConnector.stringToArray(includesIndex);
            WebcrawlerConnector.compileList(this.includeIndexPatterns, list);
            list = WebcrawlerConnector.stringToArray(excludesIndex);
            WebcrawlerConnector.compileList(this.excludeIndexPatterns, list);
            list = WebcrawlerConnector.stringToArray(excludesContentIndex);
            WebcrawlerConnector.compileList(this.excludeContentIndexPatterns, list);
            if (limitToSeeds) {
                this.seedHosts = new HashSet<String>();
                list = WebcrawlerConnector.stringToArray(seeds);
                int index = 0;
                while (index < list.size()) {
                    String urlCandidate = list.get(index++);
                    try {
                        URI url = new URI(urlCandidate);
                        String host = url.getHost();
                        if (host == null) continue;
                        this.seedHosts.add(host);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }

        public String getVersionString() {
            return this.versionString;
        }

        public boolean isDocumentAndHostLegal(String url, IHistoryActivity activities) throws ManifoldCFException {
            if (!this.isDocumentLegal(url, activities)) {
                return false;
            }
            if (this.seedHosts == null) {
                return true;
            }
            try {
                URI uri = new URI(url);
                String host = uri.getHost();
                if (host == null) {
                    return false;
                }
                return this.isHostLegal(host);
            }
            catch (URISyntaxException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public boolean isHostLegal(String host) {
            if (this.seedHosts == null) {
                return true;
            }
            return this.seedHosts.contains(host);
        }

        public boolean isDocumentLegal(String url, IHistoryActivity activities) throws ManifoldCFException {
            Pattern p;
            Matcher m;
            int i;
            for (i = 0; i < this.includePatterns.size() && !(m = (p = this.includePatterns.get(i)).matcher(url)).find(); ++i) {
            }
            if (i == this.includePatterns.size()) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + url + "' is illegal because no include patterns match it"));
                }
                activities.recordActivity(Long.valueOf(System.currentTimeMillis()), WebcrawlerConnector.ACTIVITY_FETCH, null, url, "EXCLUDED", "URL has been excluded as it does not match any include filter", null);
                return false;
            }
            for (i = 0; i < this.excludePatterns.size(); ++i) {
                p = this.excludePatterns.get(i);
                m = p.matcher(url);
                if (!m.find()) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + url + "' is illegal because exclude pattern '" + p.toString() + "' matched it"));
                }
                activities.recordActivity(Long.valueOf(System.currentTimeMillis()), WebcrawlerConnector.ACTIVITY_FETCH, null, url, "EXCLUDED", "URL has been excluded as the exclude pattern " + p.toString() + " matched it", null);
                return false;
            }
            return true;
        }

        public String isDocumentIndexable(String url, IProcessActivity activities) throws ManifoldCFException {
            Pattern p;
            Matcher m;
            int i;
            for (i = 0; i < this.includeIndexPatterns.size() && !(m = (p = this.includeIndexPatterns.get(i)).matcher(url)).find(); ++i) {
            }
            if (i == this.includeIndexPatterns.size()) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + url + "' is not indexable because no include patterns match it"));
                }
                activities.recordActivity(Long.valueOf(System.currentTimeMillis()), WebcrawlerConnector.ACTIVITY_FETCH, null, url, "EXCLUDED", "URL has been excluded as it does not match any include filter", null);
                return null;
            }
            for (i = 0; i < this.excludeIndexPatterns.size(); ++i) {
                p = this.excludeIndexPatterns.get(i);
                m = p.matcher(url);
                if (!m.find()) continue;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + url + "' is not indexable because exclude pattern '" + p.toString() + "' matched it"));
                }
                activities.recordActivity(Long.valueOf(System.currentTimeMillis()), WebcrawlerConnector.ACTIVITY_FETCH, null, url, "EXCLUDED", "URL has been excluded as the exclude pattern " + p.toString() + " matched it", null);
                return null;
            }
            String rval = this.mappings.map(url);
            if (rval == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + url + "' is not indexable because it did not match a mapping rule"));
                }
                activities.recordActivity(Long.valueOf(System.currentTimeMillis()), WebcrawlerConnector.ACTIVITY_FETCH, null, url, "EXCLUDED", "URL has been excluded because it did not match a mapping rule", null);
            }
            return rval;
        }

        public CanonicalizationPolicies getCanonicalizationPolicies() {
            return this.canonicalizationPolicies;
        }

        public boolean isDocumentContentIndexable(String documentIdentifier) throws ManifoldCFException {
            String content = this.findSpecifiedContent(documentIdentifier, this.excludeContentIndexPatterns);
            if (content != null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Url '" + documentIdentifier + "' is not indexable because content exclusion pattern was matched"));
                }
                return false;
            }
            return true;
        }

        protected String findSpecifiedContent(String currentURI, List<Pattern> patterns) throws ManifoldCFException {
            if (this.excludeContentIndexPatterns.isEmpty()) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)"WEB: no content exclusion rule supplied... returning");
                }
                return null;
            }
            FindContentHandler handler = new FindContentHandler(currentURI, patterns);
            WebcrawlerConnector.this.handleHTML(currentURI, handler);
            return handler.getTargetURI();
        }
    }

    protected static class MappingRules {
        protected final List<MappingRule> mappings = new ArrayList<MappingRule>();

        public void add(MappingRule rule) {
            this.mappings.add(rule);
        }

        public boolean isMatch(String url) {
            if (this.mappings.size() == 0) {
                return true;
            }
            for (MappingRule p : this.mappings) {
                if (!p.checkMatch(url)) continue;
                return true;
            }
            return false;
        }

        public String map(String url) throws ManifoldCFException {
            if (this.mappings.size() == 0) {
                return url;
            }
            for (MappingRule p : this.mappings) {
                String rval = p.map(url);
                if (rval == null) continue;
                return rval;
            }
            return null;
        }
    }

    protected static class MappingRule {
        protected final Pattern matchPattern;
        protected final String evalExpression;

        public MappingRule(Pattern matchPattern, String evalExpression) {
            this.matchPattern = matchPattern;
            this.evalExpression = evalExpression;
        }

        public boolean checkMatch(String url) {
            Matcher matcher = this.matchPattern.matcher(url);
            return matcher.matches();
        }

        public String map(String url) throws ManifoldCFException {
            EvaluatorToken t;
            Matcher matcher = this.matchPattern.matcher(url);
            if (!matcher.matches()) {
                return null;
            }
            if (this.evalExpression == null || this.evalExpression.length() == 0) {
                return url;
            }
            StringBuilder sb = new StringBuilder();
            EvaluatorTokenStream et = new EvaluatorTokenStream(this.evalExpression);
            block11: while ((t = et.peek()) != null) {
                switch (t.getType()) {
                    case 2: {
                        et.advance();
                        continue block11;
                    }
                    case 0: {
                        et.advance();
                        String groupValue = matcher.group(t.getGroupNumber());
                        switch (t.getGroupStyle()) {
                            case 0: {
                                sb.append(groupValue);
                                continue block11;
                            }
                            case 1: {
                                sb.append(groupValue.toLowerCase(Locale.ROOT));
                                continue block11;
                            }
                            case 2: {
                                sb.append(groupValue.toUpperCase(Locale.ROOT));
                                continue block11;
                            }
                            case 3: {
                                if (groupValue.length() <= 0) continue block11;
                                sb.append(groupValue.substring(0, 1).toUpperCase(Locale.ROOT));
                                sb.append(groupValue.substring(1).toLowerCase(Locale.ROOT));
                                continue block11;
                            }
                        }
                        throw new ManifoldCFException("Illegal group style");
                    }
                    case 1: {
                        et.advance();
                        sb.append(t.getTextValue());
                        continue block11;
                    }
                }
                throw new ManifoldCFException("Illegal token type");
            }
            return sb.toString();
        }
    }

    protected static class CanonicalizationPolicies {
        protected final List<CanonicalizationPolicy> rules = new ArrayList<CanonicalizationPolicy>();

        public void addRule(CanonicalizationPolicy rule) {
            this.rules.add(rule);
        }

        public CanonicalizationPolicy findMatch(String url) {
            int i = 0;
            while (i < this.rules.size()) {
                CanonicalizationPolicy rule;
                if (!(rule = this.rules.get(i++)).checkMatch(url)) continue;
                return rule;
            }
            return null;
        }
    }

    protected static class CanonicalizationPolicy {
        protected final Pattern matchPattern;
        protected final boolean reorder;
        protected final boolean removeJavaSession;
        protected final boolean removeAspSession;
        protected final boolean removePhpSession;
        protected final boolean removeBVSession;
        protected final boolean lowercasing;

        public CanonicalizationPolicy(Pattern matchPattern, boolean reorder, boolean removeJavaSession, boolean removeAspSession, boolean removePhpSession, boolean removeBVSession, boolean lowercasing) {
            this.matchPattern = matchPattern;
            this.reorder = reorder;
            this.removeJavaSession = removeJavaSession;
            this.removeAspSession = removeAspSession;
            this.removePhpSession = removePhpSession;
            this.removeBVSession = removeBVSession;
            this.lowercasing = lowercasing;
        }

        public boolean checkMatch(String url) {
            Matcher matcher = this.matchPattern.matcher(url);
            return matcher.find();
        }

        public boolean canReorder() {
            return this.reorder;
        }

        public boolean canRemoveJavaSession() {
            return this.removeJavaSession;
        }

        public boolean canRemoveAspSession() {
            return this.removeAspSession;
        }

        public boolean canRemovePhpSession() {
            return this.removePhpSession;
        }

        public boolean canRemoveBvSession() {
            return this.removeBVSession;
        }

        public boolean canLowercase() {
            return this.lowercasing;
        }
    }

    protected static class EvaluatorTokenStream {
        protected String text;
        protected int pos;
        protected EvaluatorToken token = null;

        public EvaluatorTokenStream(String text) {
            this.text = text;
            this.pos = 0;
        }

        public EvaluatorToken peek() throws ManifoldCFException {
            if (this.token == null) {
                this.token = this.nextToken();
            }
            return this.token;
        }

        public void advance() {
            this.token = null;
        }

        protected EvaluatorToken nextToken() throws ManifoldCFException {
            char x;
            while (true) {
                if (this.pos == this.text.length()) {
                    return null;
                }
                x = this.text.charAt(this.pos);
                if (x > ' ') break;
                ++this.pos;
            }
            if (x == '\"') {
                ++this.pos;
                StringBuilder sb = new StringBuilder();
                while (this.pos != this.text.length()) {
                    x = this.text.charAt(this.pos);
                    ++this.pos;
                    if (x == '\"') break;
                    if (x == '\\') {
                        if (this.pos == this.text.length()) break;
                        x = this.text.charAt(this.pos++);
                    }
                    sb.append(x);
                }
                return new EvaluatorToken(sb.toString());
            }
            if (x == ',') {
                ++this.pos;
                return new EvaluatorToken();
            }
            StringBuilder sb = new StringBuilder();
            while (this.pos != this.text.length() && (x = this.text.charAt(this.pos)) >= '0' && x <= '9') {
                sb.append(x);
                ++this.pos;
            }
            String numberValue = sb.toString();
            int groupNumber = 0;
            if (numberValue.length() > 0) {
                groupNumber = new Integer(numberValue);
            }
            int modifierPos = this.pos;
            while (!(this.pos == this.text.length() || (x = this.text.charAt(this.pos)) == ',' || x >= '0' && x <= '9' || x <= ' ' && x >= '\u0000')) {
                ++this.pos;
            }
            int style = 0;
            if (modifierPos != this.pos) {
                String modifier = this.text.substring(modifierPos, this.pos);
                if (modifier.startsWith("u")) {
                    style = 2;
                } else if (modifier.startsWith("l")) {
                    style = 1;
                } else if (modifier.startsWith("m")) {
                    style = 3;
                } else {
                    throw new ManifoldCFException("Unknown style: " + modifier);
                }
            }
            return new EvaluatorToken(groupNumber, style);
        }
    }

    protected static class EvaluatorToken {
        public static final int TYPE_GROUP = 0;
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_COMMA = 2;
        public static final int GROUPSTYLE_NONE = 0;
        public static final int GROUPSTYLE_LOWER = 1;
        public static final int GROUPSTYLE_UPPER = 2;
        public static final int GROUPSTYLE_MIXED = 3;
        protected int type;
        protected int groupNumber = -1;
        protected int groupStyle = 0;
        protected String textValue = null;

        public EvaluatorToken() {
            this.type = 2;
        }

        public EvaluatorToken(int groupNumber, int groupStyle) {
            this.type = 0;
            this.groupNumber = groupNumber;
            this.groupStyle = groupStyle;
        }

        public EvaluatorToken(String text) {
            this.type = 1;
            this.textValue = text;
        }

        public int getType() {
            return this.type;
        }

        public int getGroupNumber() {
            return this.groupNumber;
        }

        public int getGroupStyle() {
            return this.groupStyle;
        }

        public String getTextValue() {
            return this.textValue;
        }
    }

    protected static class NameValue {
        protected final String name;
        protected final String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    protected class UrlsetItemContextClass
    extends XMLParsingContext {
        protected String linkField;

        public UrlsetItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts) {
            super(theStream, namespace, localName, qName, atts);
            this.linkField = null;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("loc")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("loc")) {
                this.linkField = ((XMLStringParsingContext)theContext).getValue();
            } else {
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
        }

        public void process(IXMLHandler handler) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    handler.noteDiscoveredLink(rawURL);
                }
            }
        }
    }

    protected class UrlsetContextClass
    extends XMLParsingContext {
        protected String documentURI;
        protected IXMLHandler handler;
        protected String ttlValue;

        public UrlsetContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("url") || localName.equals("sitemap")) {
                return new UrlsetItemContextClass(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("url") || theTag.equals("sitemap")) {
                UrlsetItemContextClass itemContext = (UrlsetItemContextClass)theContext;
                itemContext.process(this.handler);
            } else {
                super.endTag();
            }
        }

        protected void process() throws ManifoldCFException {
            this.handler.noteDiscoveredTtlValue(this.ttlValue);
        }
    }

    protected class FeedItemContextClass
    extends XMLParsingContext {
        protected List<String> linkField;

        public FeedItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts) {
            super(theStream, namespace, localName, qName, atts);
            this.linkField = new ArrayList<String>();
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals(WebcrawlerConnector.REL_LINK)) {
                String ref = atts.get("href");
                if (ref != null && ref.length() > 0) {
                    this.linkField.add(ref);
                }
                return super.beginTag(namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        public void process(IXMLHandler handler) throws ManifoldCFException {
            if (this.linkField.size() > 0) {
                for (String linkValue : this.linkField) {
                    String[] links = linkValue.split(", ");
                    int l = 0;
                    while (l < links.length) {
                        String rawURL = links[l++].trim();
                        handler.noteDiscoveredLink(rawURL);
                    }
                }
            }
        }
    }

    protected class FeedContextClass
    extends XMLParsingContext {
        protected String documentURI;
        protected IXMLHandler handler;
        protected String ttlValue;

        public FeedContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("ttl")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("entry")) {
                return new FeedItemContextClass(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("entry")) {
                FeedItemContextClass itemContext = (FeedItemContextClass)theContext;
                itemContext.process(this.handler);
            } else {
                super.endTag();
            }
        }

        protected void process() throws ManifoldCFException {
            this.handler.noteDiscoveredTtlValue(this.ttlValue);
        }
    }

    protected class RDFItemContextClass
    extends XMLParsingContext {
        protected String linkField;

        public RDFItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts) {
            super(theStream, namespace, localName, qName, atts);
            this.linkField = null;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals(WebcrawlerConnector.REL_LINK)) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals(WebcrawlerConnector.REL_LINK)) {
                this.linkField = ((XMLStringParsingContext)theContext).getValue();
            } else {
                super.endTag();
            }
        }

        public void process(IXMLHandler handler) throws ManifoldCFException {
            if (this.linkField != null && this.linkField.length() > 0) {
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    handler.noteDiscoveredLink(rawURL);
                }
            }
        }
    }

    protected class RDFContextClass
    extends XMLParsingContext {
        protected String documentURI;
        protected IXMLHandler handler;
        protected String ttlValue;

        public RDFContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("ttl")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("item")) {
                return new RDFItemContextClass(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RDFItemContextClass itemContext = (RDFItemContextClass)theContext;
                itemContext.process(this.handler);
            } else {
                super.endTag();
            }
        }

        protected void process() throws ManifoldCFException {
            this.handler.noteDiscoveredTtlValue(this.ttlValue);
        }
    }

    protected class RSSItemContextClass
    extends XMLParsingContext {
        protected String guidField;
        protected String linkField;

        public RSSItemContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts) {
            super(theStream, namespace, localName, qName, atts);
            this.guidField = null;
            this.linkField = null;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals(WebcrawlerConnector.REL_LINK)) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("guid")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals(WebcrawlerConnector.REL_LINK)) {
                this.linkField = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("guid")) {
                this.guidField = ((XMLStringParsingContext)theContext).getValue();
            } else {
                super.endTag();
            }
        }

        public void process(IXMLHandler handler) throws ManifoldCFException {
            if (this.linkField == null || this.linkField.length() == 0) {
                this.linkField = this.guidField;
            }
            if (this.linkField != null && this.linkField.length() > 0) {
                String[] links = this.linkField.split(", ");
                int l = 0;
                while (l < links.length) {
                    String rawURL = links[l++].trim();
                    handler.noteDiscoveredLink(rawURL);
                }
            }
        }
    }

    protected class RSSChannelContextClass
    extends XMLParsingContext {
        protected String documentURI;
        protected IXMLHandler handler;
        protected String ttlValue;

        public RSSChannelContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespace, localName, qName, atts);
            this.ttlValue = null;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("ttl")) {
                return new XMLStringParsingContext(this.theStream, namespace, localName, qName, atts);
            }
            if (localName.equals("item")) {
                return new RSSItemContextClass(this.theStream, namespace, localName, qName, atts);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext theContext = this.theStream.getContext();
            String theTag = theContext.getLocalname();
            if (theTag.equals("ttl")) {
                this.ttlValue = ((XMLStringParsingContext)theContext).getValue();
            } else if (theTag.equals("item")) {
                RSSItemContextClass itemContext = (RSSItemContextClass)theContext;
                itemContext.process(this.handler);
            } else {
                super.endTag();
            }
        }

        protected void process() throws ManifoldCFException {
            this.handler.noteDiscoveredTtlValue(this.ttlValue);
        }
    }

    protected class RSSContextClass
    extends XMLParsingContext {
        protected String documentURI;
        protected IXMLHandler handler;

        public RSSContextClass(XMLFuzzyHierarchicalParseState theStream, String namespace, String localName, String qName, Map<String, String> atts, String documentURI, IXMLHandler handler) {
            super(theStream, namespace, localName, qName, atts);
            this.documentURI = documentURI;
            this.handler = handler;
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("channel")) {
                return new RSSChannelContextClass(this.theStream, namespace, localName, qName, atts, this.documentURI, this.handler);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext context = this.theStream.getContext();
            String tagName = context.getLocalname();
            if (tagName.equals("channel")) {
                ((RSSChannelContextClass)context).process();
            } else {
                super.endTag();
            }
        }
    }

    protected class OuterContextClass
    extends XMLParsingContext {
        protected int outerTagCount;
        protected String documentURI;
        protected IXMLHandler handler;

        public OuterContextClass(XMLFuzzyHierarchicalParseState theStream, String documentURI, IXMLHandler handler) {
            super(theStream);
            this.outerTagCount = 0;
            this.documentURI = documentURI;
            this.handler = handler;
        }

        public void checkIfValidFeed() {
            if (this.outerTagCount == 0 && Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: XML document '" + this.documentURI + "' does not have rss, feed, or rdf:RDF tag - not valid feed"));
            }
        }

        protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
            if (localName.equals("rss")) {
                ++this.outerTagCount;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: Parsed bottom-level XML for RSS document '" + this.documentURI + "'"));
                }
                return new RSSContextClass(this.theStream, namespace, localName, qName, atts, this.documentURI, this.handler);
            }
            if (localName.toLowerCase(Locale.ROOT).equals("rdf")) {
                ++this.outerTagCount;
                return new RDFContextClass(this.theStream, namespace, localName, qName, atts, this.documentURI, this.handler);
            }
            if (localName.equals("feed")) {
                ++this.outerTagCount;
                return new FeedContextClass(this.theStream, namespace, localName, qName, atts, this.documentURI, this.handler);
            }
            if (localName.equals("urlset") || localName.equals("sitemapindex")) {
                ++this.outerTagCount;
                return new UrlsetContextClass(this.theStream, namespace, localName, qName, atts, this.documentURI, this.handler);
            }
            return super.beginTag(namespace, localName, qName, atts);
        }

        protected void endTag() throws ManifoldCFException {
            XMLParsingContext context = this.theStream.getContext();
            String tagName = context.getLocalname();
            if (tagName.toLowerCase(Locale.ROOT).equals("rdf")) {
                ((RDFContextClass)context).process();
            } else if (tagName.equals("feed")) {
                ((FeedContextClass)context).process();
            } else if (tagName.equals("urlset") || tagName.equals("sitemapindex")) {
                ((UrlsetContextClass)context).process();
            } else {
                super.endTag();
            }
        }
    }

    protected class ProcessActivityXMLHandler
    extends ProcessActivityLinkHandler
    implements IXMLHandler {
        public ProcessActivityXMLHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter) {
            super(documentIdentifier, activities, filter, "xml", WebcrawlerConnector.REL_LINK);
        }

        public boolean shouldIndex() {
            return true;
        }

        @Override
        public void noteDiscoveredTtlValue(String rawTtlValue) throws ManifoldCFException {
            long currentTime = System.currentTimeMillis();
            Long rescanTime = null;
            if (rawTtlValue != null) {
                try {
                    int minutes = Integer.parseInt(rawTtlValue);
                    long nextTime = currentTime + (long)minutes * 60000L;
                    rescanTime = new Long(nextTime);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "', found a ttl value of " + rawTtlValue + "; setting refetch time accordingly"));
                    }
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "' found illegal ttl value '" + rawTtlValue + "': " + e.getMessage()), (Throwable)e);
                }
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "' setting rescan time to " + (rescanTime == null ? "null" : rescanTime.toString())));
            }
            this.activities.setDocumentScheduleBounds(this.documentIdentifier, rescanTime, rescanTime, null, null);
        }
    }

    protected class ProcessActivityHTMLHandler
    extends ProcessActivityLinkHandler
    implements IHTMLHandler {
        boolean allowIndex;
        boolean allowFollow;
        boolean obeyMetaRobotsTags;

        public ProcessActivityHTMLHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter, int metaRobotTagsUsage) {
            super(documentIdentifier, activities, filter, "html", WebcrawlerConnector.REL_LINK);
            this.allowIndex = true;
            this.allowFollow = true;
            this.obeyMetaRobotsTags = true;
            this.obeyMetaRobotsTags = metaRobotTagsUsage == 1;
        }

        public boolean shouldIndex() {
            return this.allowIndex;
        }

        @Override
        public void noteTextCharacter(char textCharacter) throws ManifoldCFException {
        }

        @Override
        public void noteMetaTag(Map metaAttributes) throws ManifoldCFException {
            String contentValue;
            String name = (String)metaAttributes.get("name");
            if (this.obeyMetaRobotsTags && name != null && name.toLowerCase(Locale.ROOT).equals("robots") && (contentValue = (String)metaAttributes.get("content")) != null) {
                contentValue = contentValue.toLowerCase(Locale.ROOT);
                try {
                    String[] contentValues = contentValue.split(",");
                    int i = 0;
                    while (i < contentValues.length) {
                        String cv;
                        if ((cv = contentValues[i++].trim()).equals("index")) {
                            this.allowIndex = true;
                            continue;
                        }
                        if (cv.equals("noindex")) {
                            this.allowIndex = false;
                            continue;
                        }
                        if (cv.equals("none")) {
                            this.allowFollow = false;
                            this.allowIndex = false;
                            continue;
                        }
                        if (cv.equals("follow")) {
                            this.allowFollow = true;
                            continue;
                        }
                        if (!cv.equals("nofollow")) continue;
                        this.allowFollow = false;
                    }
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void noteFormStart(Map formAttributes) throws ManifoldCFException {
        }

        @Override
        public void noteFormInput(Map inputAttributes) throws ManifoldCFException {
        }

        @Override
        public void noteFormEnd() throws ManifoldCFException {
        }

        @Override
        public void noteBASEHREF(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredBase(rawURL);
            }
        }

        @Override
        public void noteAHREF(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }

        @Override
        public void noteLINKHREF(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }

        @Override
        public void noteIMGSRC(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }

        @Override
        public void noteFRAMESRC(String rawURL) throws ManifoldCFException {
            if (this.allowFollow) {
                this.noteDiscoveredLink(rawURL);
            }
        }

        @Override
        public void finishUp() throws ManifoldCFException {
        }
    }

    protected class ProcessActivityRedirectionHandler
    extends ProcessActivityLinkHandler
    implements IRedirectionHandler {
        public ProcessActivityRedirectionHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter) {
            super(documentIdentifier, activities, filter, "redirection", WebcrawlerConnector.REL_REDIRECT);
        }

        public boolean shouldIndex() {
            return true;
        }
    }

    protected class ProcessActivityLinkHandler
    implements IDiscoveredLinkHandler {
        protected String documentIdentifier;
        protected String baseDocumentIdentifier;
        protected IProcessActivity activities;
        protected DocumentURLFilter filter;
        protected String contextDescription;
        protected String linkType;

        public ProcessActivityLinkHandler(String documentIdentifier, IProcessActivity activities, DocumentURLFilter filter, String contextDescription, String linkType) {
            this.documentIdentifier = documentIdentifier;
            this.baseDocumentIdentifier = documentIdentifier;
            this.activities = activities;
            this.filter = filter;
            this.contextDescription = contextDescription;
            this.linkType = linkType;
        }

        @Override
        public void noteDiscoveredBase(String rawURL) throws ManifoldCFException {
            String newIdentifier = WebcrawlerConnector.this.makeDocumentIdentifier(this.baseDocumentIdentifier, rawURL, this.filter, (IHistoryActivity)this.activities);
            if (newIdentifier != null) {
                this.baseDocumentIdentifier = newIdentifier;
            }
        }

        @Override
        public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
            String newIdentifier = WebcrawlerConnector.this.makeDocumentIdentifier(this.baseDocumentIdentifier, rawURL, this.filter, (IHistoryActivity)this.activities);
            if (newIdentifier != null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "', found link to '" + newIdentifier + "'"));
                }
                this.activities.addDocumentReference(newIdentifier, this.documentIdentifier, this.linkType, null, null, null, WebcrawlerConnector.this.calculateDocumentEvents((INamingActivity)this.activities, newIdentifier));
            } else if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("WEB: In " + this.contextDescription + " document '" + this.documentIdentifier + "', found an unincluded URL '" + rawURL + "'"));
            }
        }
    }
}

