/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.tools;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeHex(byte[] data) {
        return Hex.encodeHex(data, 0);
    }

    public static String encodeHex(ByteBuffer data) {
        ByteBuffer byteBuffer = data.duplicate();
        StringBuilder sb = new StringBuilder();
        while (byteBuffer.remaining() > 0) {
            byte b = byteBuffer.get();
            sb.append(DIGITS[(0xF0 & b) >>> 4]);
            sb.append(DIGITS[0xF & b]);
        }
        return sb.toString();
    }

    public static String encodeHex(byte[] data, int group) {
        int l = data.length;
        char[] out = new char[(l << 1) + (group > 0 ? l / group : 0)];
        int i = 0;
        int j = 0;
        while (i < l) {
            if (group > 0 && i % group == 0 && j > 0) {
                out[j++] = 45;
            }
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return new String(out);
    }

    public static byte[] decodeHex(String hexString) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        int i = 0;
        while (i < hexString.length()) {
            int b = Integer.parseInt(hexString.substring(i, i + 2), 16);
            bas.write(b);
            i += 2;
        }
        return bas.toByteArray();
    }
}

