/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.interfaces;

import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.PerformanceStatistics;

public class QueueTracker {
    public static final String _rcsid = "@(#)$Id: QueueTracker.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final double binReductionFactor = 1.0;
    protected final PerformanceStatistics performanceStatistics = new PerformanceStatistics();
    protected final Map<String, BinCount> queuedBinCounts = new HashMap<String, BinCount>();
    protected final Map<String, BinCount> activeBinCounts = new HashMap<String, BinCount>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(String[] binNames) {
        int i = 0;
        while (i < binNames.length) {
            String binName = binNames[i++];
            Map<String, BinCount> map = this.queuedBinCounts;
            synchronized (map) {
                BinCount value = this.queuedBinCounts.get(binName);
                if (value == null) {
                    value = new BinCount();
                    this.queuedBinCounts.put(binName, value);
                }
                value.increment();
            }
        }
    }

    public void noteConnectionPerformance(int docCount, String connectionName, long elapsedTime) {
        this.performanceStatistics.noteDocumentsCompleted(connectionName, docCount, elapsedTime);
    }

    public PerformanceStatistics getCurrentStatistics() {
        return this.performanceStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginProcessing(String[] binNames) {
        int i = 0;
        while (i < binNames.length) {
            BinCount value;
            String binName = binNames[i++];
            Map<String, BinCount> map = this.queuedBinCounts;
            synchronized (map) {
                value = this.queuedBinCounts.get(binName);
                if (value != null && value.decrement()) {
                    this.queuedBinCounts.remove(binName);
                }
            }
            map = this.activeBinCounts;
            synchronized (map) {
                value = this.activeBinCounts.get(binName);
                if (value == null) {
                    value = new BinCount();
                    this.activeBinCounts.put(binName, value);
                }
                value.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProcessing(String[] binNames) {
        int i = 0;
        while (i < binNames.length) {
            String binName = binNames[i++];
            Map<String, BinCount> map = this.activeBinCounts;
            synchronized (map) {
                BinCount value = this.activeBinCounts.get(binName);
                if (value != null && value.decrement()) {
                    this.activeBinCounts.remove(binName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double calculateAssignmentRating(String[] binNames, IRepositoryConnection connection) {
        double ratingLog = 0.0;
        int i = 0;
        while (i < binNames.length) {
            String binName = binNames[i++];
            int count = 0;
            Map<String, BinCount> map = this.activeBinCounts;
            synchronized (map) {
                BinCount value = this.activeBinCounts.get(binName);
                if (value != null) {
                    count = value.getValue();
                }
            }
            ratingLog -= Math.log(1.0 + (double)count);
        }
        return ratingLog / (double)i;
    }

    protected static class BinCount {
        protected int count = 0;

        public BinCount duplicate() {
            BinCount rval = new BinCount();
            rval.count = this.count;
            return rval;
        }

        public void increment() {
            ++this.count;
        }

        public boolean decrement() {
            --this.count;
            return this.count == 0;
        }

        public void setValue(int count) {
            this.count = count;
        }

        public int getValue() {
            return this.count;
        }
    }
}

