/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.JoinClause;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.BucketDescription;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.DepthStatistics;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.DocumentSetAndFlags;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IPriorityCalculator;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.JobDeleteRecord;
import org.apache.manifoldcf.crawler.interfaces.JobNotifyRecord;
import org.apache.manifoldcf.crawler.interfaces.JobSeedingRecord;
import org.apache.manifoldcf.crawler.interfaces.JobStartRecord;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.PerformanceStatistics;
import org.apache.manifoldcf.crawler.interfaces.RegExpCriteria;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.interfaces.SortOrder;
import org.apache.manifoldcf.crawler.interfaces.StatusFilterCriteria;
import org.apache.manifoldcf.crawler.jobs.Carrydown;
import org.apache.manifoldcf.crawler.jobs.EventManager;
import org.apache.manifoldcf.crawler.jobs.HopCount;
import org.apache.manifoldcf.crawler.jobs.JobQueue;
import org.apache.manifoldcf.crawler.jobs.Jobs;
import org.apache.manifoldcf.crawler.jobs.PrereqEventManager;
import org.apache.manifoldcf.crawler.jobs.TrackerClass;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JobManager
implements IJobManager {
    public static final String _rcsid = "@(#)$Id: JobManager.java 998576 2010-09-19 01:11:02Z kwright $";
    protected static final String stufferLock = "_STUFFER_";
    protected static final String reprioritizationLock = "_REPRIORITIZER_";
    protected static final String deleteStufferLock = "_DELETESTUFFER_";
    protected static final String expireStufferLock = "_EXPIRESTUFFER_";
    protected static final String cleanStufferLock = "_CLEANSTUFFER_";
    protected static final String jobStopLock = "_JOBSTOP_";
    protected static final String jobResumeLock = "_JOBRESUME_";
    protected static final String hopLock = "_HOPLOCK_";
    protected final IDBInterface database;
    protected final IOutputConnectionManager outputMgr;
    protected final IRepositoryConnectionManager connectionMgr;
    protected final INotificationConnectionManager notificationMgr;
    protected final ITransformationConnectionManager transformationMgr;
    protected final IOutputConnectorManager outputConnectorMgr;
    protected final IConnectorManager connectorMgr;
    protected final ITransformationConnectorManager transformationConnectorMgr;
    protected final IRepositoryConnectorPool repositoryConnectorPool;
    protected final ILockManager lockManager;
    protected final IThreadContext threadContext;
    protected final JobQueue jobQueue;
    protected final Jobs jobs;
    protected final HopCount hopCount;
    protected final Carrydown carryDown;
    protected final EventManager eventManager;
    protected static Random random = new Random();
    private static int EXTRA_FACTOR = 2;

    public JobManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        this.database = database;
        this.threadContext = threadContext;
        this.jobs = new Jobs(threadContext, database);
        this.jobQueue = new JobQueue(threadContext, database);
        this.hopCount = new HopCount(threadContext, database);
        this.carryDown = new Carrydown(database);
        this.eventManager = new EventManager(database);
        this.outputMgr = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
        this.connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
        this.notificationMgr = NotificationConnectionManagerFactory.make(threadContext);
        this.transformationMgr = TransformationConnectionManagerFactory.make((IThreadContext)threadContext);
        this.outputConnectorMgr = OutputConnectorManagerFactory.make((IThreadContext)threadContext);
        this.connectorMgr = ConnectorManagerFactory.make(threadContext);
        this.transformationConnectorMgr = TransformationConnectorManagerFactory.make((IThreadContext)threadContext);
        this.repositoryConnectorPool = RepositoryConnectorPoolFactory.make(threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
    }

    @Override
    public void install() throws ManifoldCFException {
        this.jobs.install(this.transformationMgr.getTableName(), this.transformationMgr.getConnectionNameColumn(), this.outputMgr.getTableName(), this.outputMgr.getConnectionNameColumn(), this.connectionMgr.getTableName(), this.connectionMgr.getConnectionNameColumn(), this.notificationMgr.getTableName(), this.notificationMgr.getConnectionNameColumn());
        this.jobQueue.install(this.jobs.getTableName(), "id");
        this.hopCount.install(this.jobs.getTableName(), "id");
        this.carryDown.install(this.jobs.getTableName(), "id");
        this.eventManager.install();
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.eventManager.deinstall();
        this.carryDown.deinstall();
        this.hopCount.deinstall();
        this.jobQueue.deinstall();
        this.jobs.deinstall();
    }

    @Override
    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)8);
        IJobDescription[] list = this.getAllJobs();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        for (IJobDescription job : list) {
            int j;
            ManifoldCF.writeString((OutputStream)os, (String)job.getConnectionName());
            ManifoldCF.writeString((OutputStream)os, (String)job.getDescription());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getType());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getStartMethod());
            ManifoldCF.writeLong((OutputStream)os, (Long)job.getInterval());
            ManifoldCF.writeLong((OutputStream)os, (Long)job.getMaxInterval());
            ManifoldCF.writeLong((OutputStream)os, (Long)job.getExpiration());
            ManifoldCF.writeLong((OutputStream)os, (Long)job.getReseedInterval());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getPriority());
            ManifoldCF.writeDword((OutputStream)os, (int)job.getHopcountMode());
            ManifoldCF.writeString((OutputStream)os, (String)job.getSpecification().toXML());
            int recCount = job.getScheduleRecordCount();
            ManifoldCF.writeDword((OutputStream)os, (int)recCount);
            for (int j2 = 0; j2 < recCount; ++j2) {
                ScheduleRecord sr = job.getScheduleRecord(j2);
                JobManager.writeEnumeratedValues(os, sr.getDayOfWeek());
                JobManager.writeEnumeratedValues(os, sr.getMonthOfYear());
                JobManager.writeEnumeratedValues(os, sr.getDayOfMonth());
                JobManager.writeEnumeratedValues(os, sr.getYear());
                JobManager.writeEnumeratedValues(os, sr.getHourOfDay());
                JobManager.writeEnumeratedValues(os, sr.getMinutesOfHour());
                ManifoldCF.writeString((OutputStream)os, (String)sr.getTimezone());
                ManifoldCF.writeLong((OutputStream)os, (Long)sr.getDuration());
                ManifoldCF.writeByte((OutputStream)os, (int)(sr.getRequestMinimum() ? 1 : 0));
            }
            Map filters = job.getHopCountFilters();
            ManifoldCF.writeDword((OutputStream)os, (int)filters.size());
            for (String linkType : filters.keySet()) {
                Long hopcount = (Long)filters.get(linkType);
                ManifoldCF.writeString((OutputStream)os, (String)linkType);
                ManifoldCF.writeLong((OutputStream)os, (Long)hopcount);
            }
            ManifoldCF.writeDword((OutputStream)os, (int)job.countPipelineStages());
            for (j = 0; j < job.countPipelineStages(); ++j) {
                ManifoldCF.writeSdword((OutputStream)os, (int)job.getPipelineStagePrerequisite(j));
                ManifoldCF.writeByte((OutputStream)os, (int)(job.getPipelineStageIsOutputConnection(j) ? 1 : 0));
                ManifoldCF.writeString((OutputStream)os, (String)job.getPipelineStageConnectionName(j));
                ManifoldCF.writeString((OutputStream)os, (String)job.getPipelineStageDescription(j));
                ManifoldCF.writeString((OutputStream)os, (String)job.getPipelineStageSpecification(j).toXML());
            }
            ManifoldCF.writeDword((OutputStream)os, (int)job.countNotifications());
            for (j = 0; j < job.countNotifications(); ++j) {
                ManifoldCF.writeString((OutputStream)os, (String)job.getNotificationConnectionName(j));
                ManifoldCF.writeString((OutputStream)os, (String)job.getNotificationDescription(j));
                ManifoldCF.writeString((OutputStream)os, (String)job.getNotificationSpecification(j).toXML());
            }
        }
    }

    protected static void writeEnumeratedValues(OutputStream os, EnumeratedValues ev) throws IOException {
        if (ev == null) {
            ManifoldCF.writeSdword((OutputStream)os, (int)-1);
            return;
        }
        int size = ev.size();
        ManifoldCF.writeSdword((OutputStream)os, (int)size);
        Iterator iter = ev.getValues();
        while (iter.hasNext()) {
            ManifoldCF.writeDword((OutputStream)os, (int)((Integer)iter.next()));
        }
    }

    @Override
    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 5 && version != 6 && version != 8) {
            throw new IOException("Unknown job configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IJobDescription job = this.createJob();
            job.setConnectionName(ManifoldCF.readString((InputStream)is));
            job.setDescription(ManifoldCF.readString((InputStream)is));
            job.setType(ManifoldCF.readDword((InputStream)is));
            job.setStartMethod(ManifoldCF.readDword((InputStream)is));
            job.setInterval(ManifoldCF.readLong((InputStream)is));
            if (version >= 6) {
                job.setMaxInterval(ManifoldCF.readLong((InputStream)is));
            }
            job.setExpiration(ManifoldCF.readLong((InputStream)is));
            job.setReseedInterval(ManifoldCF.readLong((InputStream)is));
            job.setPriority(ManifoldCF.readDword((InputStream)is));
            job.setHopcountMode(ManifoldCF.readDword((InputStream)is));
            job.getSpecification().fromXML(ManifoldCF.readString((InputStream)is));
            int recCount = ManifoldCF.readDword((InputStream)is);
            for (int j = 0; j < recCount; ++j) {
                EnumeratedValues dayOfWeek = this.readEnumeratedValues(is);
                EnumeratedValues monthOfYear = this.readEnumeratedValues(is);
                EnumeratedValues dayOfMonth = this.readEnumeratedValues(is);
                EnumeratedValues year = this.readEnumeratedValues(is);
                EnumeratedValues hourOfDay = this.readEnumeratedValues(is);
                EnumeratedValues minutesOfHour = this.readEnumeratedValues(is);
                String timezone = ManifoldCF.readString((InputStream)is);
                Long duration = ManifoldCF.readLong((InputStream)is);
                boolean requestMinimum = ManifoldCF.readByte((InputStream)is) != 0;
                ScheduleRecord sr = new ScheduleRecord(dayOfWeek, monthOfYear, dayOfMonth, year, hourOfDay, minutesOfHour, timezone, duration, requestMinimum);
                job.addScheduleRecord(sr);
            }
            int hopFilterCount = ManifoldCF.readDword((InputStream)is);
            for (int j = 0; j < hopFilterCount; ++j) {
                String linkType = ManifoldCF.readString((InputStream)is);
                Long hopcount = ManifoldCF.readLong((InputStream)is);
                job.addHopCountFilter(linkType, hopcount);
            }
            int pipelineCount = ManifoldCF.readDword((InputStream)is);
            for (int j = 0; j < pipelineCount; ++j) {
                int prerequisite = ManifoldCF.readSdword((InputStream)is);
                int isOutput = ManifoldCF.readByte((InputStream)is);
                String connectionName = ManifoldCF.readString((InputStream)is);
                String description = ManifoldCF.readString((InputStream)is);
                String specification = ManifoldCF.readString((InputStream)is);
                job.addPipelineStage(prerequisite, isOutput == 1, connectionName, description).fromXML(specification);
            }
            if (version >= 8) {
                int notificationCount = ManifoldCF.readDword((InputStream)is);
                for (int j = 0; j < notificationCount; ++j) {
                    String connectionName = ManifoldCF.readString((InputStream)is);
                    String description = ManifoldCF.readString((InputStream)is);
                    String specification = ManifoldCF.readString((InputStream)is);
                    job.addNotification(connectionName, description).fromXML(specification);
                }
            }
            this.save(job);
        }
    }

    protected EnumeratedValues readEnumeratedValues(InputStream is) throws IOException {
        int size = ManifoldCF.readSdword((InputStream)is);
        if (size == -1) {
            return null;
        }
        int[] values = new int[size];
        int i = 0;
        while (i < size) {
            values[i++] = ManifoldCF.readDword((InputStream)is);
        }
        return new EnumeratedValues(values);
    }

    @Override
    public void noteConnectorDeregistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteConnectionDeregistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteConnectionDeregistration(list);
        }
    }

    protected void noteConnectionDeregistration(List<String> list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("connectionname", list);
        String query = this.database.buildConjunctionClause(newList, clauseDescriptionArray);
        IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + query + " FOR UPDATE", newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteConnectorDeregistration(jobID, statusValue);
        }
    }

    @Override
    public void noteConnectorRegistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteConnectionRegistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteConnectionRegistration(list);
        }
    }

    protected void noteConnectionRegistration(List<String> list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("connectionname", list);
        String query = this.database.buildConjunctionClause(newList, clauseDescriptionArray);
        IResultSet set = this.database.performQuery("SELECT " + "id" + "," + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + query + " FOR UPDATE", newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteConnectorRegistration(jobID, statusValue);
        }
    }

    @Override
    public void noteNotificationConnectorDeregistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteNotificationConnectionDeregistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteNotificationConnectionDeregistration(list);
        }
    }

    protected void noteNotificationConnectionDeregistration(List<String> list) throws ManifoldCFException {
        Long[] jobIDs = this.jobs.findJobsMatchingNotifications(list);
        if (jobIDs.length == 0) {
            return;
        }
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        ArrayList<Long> newList = new ArrayList<Long>();
        int i = 0;
        while (i < jobIDs.length) {
            if (currentCount == maxCount) {
                this.noteNotificationJobDeregistration(newList);
                newList.clear();
                currentCount = 0;
            }
            newList.add(jobIDs[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteNotificationJobDeregistration(newList);
        }
    }

    protected void noteNotificationJobDeregistration(List<Long> jobIDs) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("id", jobIDs);
        query.append("SELECT ").append("id").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(newList, clauseDescriptionArray)).append(" FOR UPDATE");
        IResultSet set = this.database.performQuery(query.toString(), newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteNotificationConnectorDeregistration(jobID, statusValue);
        }
    }

    @Override
    public void noteNotificationConnectorRegistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteNotificationConnectionRegistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteNotificationConnectionRegistration(list);
        }
    }

    protected void noteNotificationConnectionRegistration(List<String> list) throws ManifoldCFException {
        Long[] jobIDs = this.jobs.findJobsMatchingNotifications(list);
        if (jobIDs.length == 0) {
            return;
        }
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        ArrayList<Long> newList = new ArrayList<Long>();
        int i = 0;
        while (i < jobIDs.length) {
            if (currentCount == maxCount) {
                this.noteNotificationJobRegistration(newList);
                newList.clear();
                currentCount = 0;
            }
            newList.add(jobIDs[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteNotificationJobRegistration(newList);
        }
    }

    protected void noteNotificationJobRegistration(List<Long> jobIDs) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("id", jobIDs);
        query.append("SELECT ").append("id").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(newList, clauseDescriptionArray)).append(" FOR UPDATE");
        IResultSet set = this.database.performQuery(query.toString(), newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteNotificationConnectorDeregistration(jobID, statusValue);
        }
    }

    @Override
    public void noteOutputConnectorDeregistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteOutputConnectionDeregistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteOutputConnectionDeregistration(list);
        }
    }

    protected void noteOutputConnectionDeregistration(List<String> list) throws ManifoldCFException {
        Long[] jobIDs = this.jobs.findJobsMatchingOutputs(list);
        if (jobIDs.length == 0) {
            return;
        }
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        ArrayList<Long> newList = new ArrayList<Long>();
        int i = 0;
        while (i < jobIDs.length) {
            if (currentCount == maxCount) {
                this.noteOutputJobDeregistration(newList);
                newList.clear();
                currentCount = 0;
            }
            newList.add(jobIDs[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteOutputJobDeregistration(newList);
        }
    }

    protected void noteOutputJobDeregistration(List<Long> jobIDs) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("id", jobIDs);
        query.append("SELECT ").append("id").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(newList, clauseDescriptionArray)).append(" FOR UPDATE");
        IResultSet set = this.database.performQuery(query.toString(), newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteOutputConnectorDeregistration(jobID, statusValue);
        }
    }

    @Override
    public void noteOutputConnectorRegistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteOutputConnectionRegistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteOutputConnectionRegistration(list);
        }
    }

    protected void noteOutputConnectionRegistration(List<String> list) throws ManifoldCFException {
        Long[] jobIDs = this.jobs.findJobsMatchingOutputs(list);
        if (jobIDs.length == 0) {
            return;
        }
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        ArrayList<Long> newList = new ArrayList<Long>();
        int i = 0;
        while (i < jobIDs.length) {
            if (currentCount == maxCount) {
                this.noteOutputJobRegistration(newList);
                newList.clear();
                currentCount = 0;
            }
            newList.add(jobIDs[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteOutputJobRegistration(newList);
        }
    }

    protected void noteOutputJobRegistration(List<Long> jobIDs) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("id", jobIDs);
        query.append("SELECT ").append("id").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(newList, clauseDescriptionArray)).append(" FOR UPDATE");
        IResultSet set = this.database.performQuery(query.toString(), newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteOutputConnectorRegistration(jobID, statusValue);
        }
    }

    @Override
    public void noteTransformationConnectorDeregistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteTransformationConnectionDeregistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteTransformationConnectionDeregistration(list);
        }
    }

    protected void noteTransformationConnectionDeregistration(List<String> list) throws ManifoldCFException {
        Long[] jobIDs = this.jobs.findJobsMatchingTransformations(list);
        if (jobIDs.length == 0) {
            return;
        }
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        ArrayList<Long> newList = new ArrayList<Long>();
        int i = 0;
        while (i < jobIDs.length) {
            if (currentCount == maxCount) {
                this.noteTransformationJobDeregistration(newList);
                newList.clear();
                currentCount = 0;
            }
            newList.add(jobIDs[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteTransformationJobDeregistration(newList);
        }
    }

    protected void noteTransformationJobDeregistration(List<Long> jobIDs) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("id", jobIDs);
        query.append("SELECT ").append("id").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(newList, clauseDescriptionArray)).append(" FOR UPDATE");
        IResultSet set = this.database.performQuery(query.toString(), newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteTransformationConnectorDeregistration(jobID, statusValue);
        }
    }

    @Override
    public void noteTransformationConnectorRegistration(String[] connectionNames) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        int i = 0;
        while (i < connectionNames.length) {
            if (currentCount == maxCount) {
                this.noteTransformationConnectionRegistration(list);
                list.clear();
                currentCount = 0;
            }
            list.add(connectionNames[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteTransformationConnectionRegistration(list);
        }
    }

    protected void noteTransformationConnectionRegistration(List<String> list) throws ManifoldCFException {
        Long[] jobIDs = this.jobs.findJobsMatchingTransformations(list);
        if (jobIDs.length == 0) {
            return;
        }
        int maxCount = this.database.findConjunctionClauseMax(new ClauseDescription[0]);
        int currentCount = 0;
        ArrayList<Long> newList = new ArrayList<Long>();
        int i = 0;
        while (i < jobIDs.length) {
            if (currentCount == maxCount) {
                this.noteTransformationJobRegistration(newList);
                newList.clear();
                currentCount = 0;
            }
            newList.add(jobIDs[i++]);
            ++currentCount;
        }
        if (currentCount > 0) {
            this.noteTransformationJobRegistration(newList);
        }
    }

    protected void noteTransformationJobRegistration(List<Long> jobIDs) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("id", jobIDs);
        query.append("SELECT ").append("id").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(newList, clauseDescriptionArray)).append(" FOR UPDATE");
        IResultSet set = this.database.performQuery(query.toString(), newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long jobID = (Long)row.getValue("id");
            int statusValue = Jobs.stringToStatus((String)row.getValue("status"));
            this.jobs.noteTransformationConnectorRegistration(jobID, statusValue);
        }
    }

    @Override
    public void noteConnectionChange(String connectionName) throws ManifoldCFException {
        this.jobs.noteConnectionChange(connectionName);
    }

    @Override
    public void noteNotificationConnectionChange(String connectionName) throws ManifoldCFException {
        this.jobs.noteConnectionChange(connectionName);
    }

    @Override
    public void noteOutputConnectionChange(String connectionName) throws ManifoldCFException {
        this.jobs.noteOutputConnectionChange(connectionName);
    }

    @Override
    public void noteTransformationConnectionChange(String connectionName) throws ManifoldCFException {
        this.jobs.noteTransformationConnectionChange(connectionName);
    }

    @Override
    public void assessMarkedJobs() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.assessMarkedJobs();
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction assessing jobs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (RuntimeException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public IJobDescription[] getAllJobs() throws ManifoldCFException {
        return this.jobs.getAll();
    }

    @Override
    public IJobDescription createJob() throws ManifoldCFException {
        return this.jobs.create();
    }

    protected String getHopLockName(Long jobID) {
        return hopLock + jobID;
    }

    @Override
    public void deleteJob(Long id) throws ManifoldCFException {
        this.database.beginTransaction();
        try {
            int status;
            block14: {
                block13: {
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    clauseDescriptionArray[0] = new UnitaryClause("id", (Object)id);
                    String query = this.database.buildConjunctionClause(list, clauseDescriptionArray);
                    IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobs.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
                    if (set.getRowCount() == 0) {
                        throw new ManifoldCFException("Attempting to delete a job that doesn't exist: " + id);
                    }
                    IResultRow row = set.getRow(0);
                    status = Jobs.stringToStatus(row.getValue("status").toString());
                    if (status == 1) break block13;
                    if (status == 2) break block13;
                    if (status == 40) break block13;
                    if (status != 41) break block14;
                }
                throw new ManifoldCFException("Job " + id + " is active; you must shut it down before deleting it");
            }
            if (status != 0) {
                throw new ManifoldCFException("Job " + id + " is busy; you must wait and/or shut it down before deleting it");
            }
            this.jobs.writePermanentStatus(id, 25, true);
            Logging.jobs.info((Object)("Job " + id + " marked for deletion"));
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
    }

    @Override
    public IJobDescription load(Long id) throws ManifoldCFException {
        return this.jobs.load(id, false);
    }

    @Override
    public IJobDescription load(Long id, boolean readOnly) throws ManifoldCFException {
        return this.jobs.load(id, readOnly);
    }

    @Override
    public void save(IJobDescription jobDescription) throws ManifoldCFException {
        ManifoldCF.noteConfigurationChange();
        this.jobs.save(jobDescription);
    }

    @Override
    public boolean checkIfReference(String connectionName) throws ManifoldCFException {
        return this.jobs.checkIfReference(connectionName);
    }

    @Override
    public boolean checkIfNotificationReference(String connectionName) throws ManifoldCFException {
        return this.jobs.checkIfNotificationReference(connectionName);
    }

    @Override
    public boolean checkIfOutputReference(String connectionName) throws ManifoldCFException {
        return this.jobs.checkIfOutputReference(connectionName);
    }

    @Override
    public boolean checkIfTransformationReference(String connectionName) throws ManifoldCFException {
        return this.jobs.checkIfTransformationReference(connectionName);
    }

    @Override
    public IJobDescription[] findJobsForConnection(String connectionName) throws ManifoldCFException {
        return this.jobs.findJobsForConnection(connectionName);
    }

    @Override
    public void clearJobSeedingState(Long jobID) throws ManifoldCFException {
        this.jobs.clearSeedingState(jobID);
    }

    @Override
    public void cleanupProcessData(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)("Cleaning up process data for process '" + processID + "'"));
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.eventManager.restart(processID);
                this.jobQueue.restart(processID);
                this.jobs.restart(processID);
                this.hopCount.restart(processID);
                this.carryDown.restart(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                Logging.jobs.info((Object)"Cleanup complete");
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting for restart: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (RuntimeException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void cleanupProcessData() throws ManifoldCFException {
        Logging.jobs.info((Object)"Cleaning up all process data");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.eventManager.restart();
                this.jobQueue.restart();
                this.jobs.restart();
                this.hopCount.restart();
                this.carryDown.restart();
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                Logging.jobs.info((Object)"Cleanup complete");
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting for restart: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void prepareForClusterStart() throws ManifoldCFException {
        Logging.jobs.info((Object)"Starting cluster");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.eventManager.restartCluster();
                this.jobQueue.restartCluster();
                this.jobs.restartCluster();
                this.hopCount.restartCluster();
                this.carryDown.restartCluster();
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                Logging.jobs.info((Object)"Cluster start complete");
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction starting cluster: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetDocumentWorkerStatus(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)"Resetting document active status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobQueue.resetDocumentWorkerStatus(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting document active status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)"Reset complete");
    }

    @Override
    public void resetSeedingWorkerStatus(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)"Resetting seeding status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.resetSeedingWorkerStatus(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting seeding worker status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)"Reset complete");
    }

    @Override
    public void resetDocDeleteWorkerStatus(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)"Resetting doc deleting status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobQueue.resetDocDeleteWorkerStatus(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting doc deleting worker status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)"Reset complete");
    }

    @Override
    public void resetDocCleanupWorkerStatus(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)"Resetting doc cleaning status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobQueue.resetDocCleanupWorkerStatus(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting doc cleaning status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)"Reset complete");
    }

    @Override
    public void resetDeleteStartupWorkerStatus(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)"Resetting job delete starting up status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.resetDeleteStartupWorkerStatus(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting job delete starting up status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)"Reset complete");
    }

    @Override
    public void resetNotificationWorkerStatus(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)"Resetting notification worker status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.resetNotificationWorkerStatus(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting notification worker status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)"Reset complete");
    }

    @Override
    public void resetStartupWorkerStatus(String processID) throws ManifoldCFException {
        Logging.jobs.info((Object)"Resetting job starting up status");
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.resetStartupWorkerStatus(processID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting job starting up status: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)"Reset complete");
    }

    @Override
    public void deleteIngestedDocumentIdentifiers(DocumentDescription[] identifiers) throws ManifoldCFException {
        this.jobQueue.deleteIngestedDocumentIdentifiers(identifiers);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DocumentSetAndFlags getNextCleanableDocuments(String processID, int maxCount, long currentTime) throws ManifoldCFException {
        if (!this.jobs.cleaningJobsPresent()) {
            return new DocumentSetAndFlags(new DocumentDescription[0], new boolean[0]);
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Waiting to find documents to put on the cleaning queue");
        }
        while (true) {
            DocumentSetAndFlags documentSetAndFlags;
            long sleepAmt = 0L;
            this.lockManager.enterWriteLock(cleanStufferLock);
            this.database.beginTransaction();
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("After " + new Long(System.currentTimeMillis() - startTime).toString() + " ms, beginning query to look for documents to put on cleaning queue"));
                }
                ArrayList<Long> list = new ArrayList<Long>();
                StringBuilder sb = new StringBuilder("SELECT ");
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("t0." + "status", (Object)JobQueue.statusToString(6));
                sb.append("id").append(",").append("jobid").append(",").append("dochash").append(",").append("docid").append(",").append("failtime").append(",").append("failcount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ").append("(t0.").append("checktime").append(" IS NULL OR t0.").append("checktime").append("<=?) AND ");
                list.add(new Long(currentTime));
                ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
                clauseDescriptionArray2[0] = new UnitaryClause("t1." + "status", (Object)Jobs.statusToString(15));
                clauseDescriptionArray2[1] = new JoinClause("t1." + "id", "t0." + "jobid");
                sb.append("EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(") AND ");
                ClauseDescription[] clauseDescriptionArray3 = new ClauseDescription[3];
                clauseDescriptionArray3[0] = new JoinClause("t2." + "dochash", "t0." + "dochash");
                Object[] objectArray = new String[6];
                objectArray[0] = JobQueue.statusToString(1);
                objectArray[1] = JobQueue.statusToString(5);
                objectArray[2] = JobQueue.statusToString(8);
                objectArray[3] = JobQueue.statusToString(9);
                objectArray[4] = JobQueue.statusToString(7);
                objectArray[5] = JobQueue.statusToString(10);
                clauseDescriptionArray3[1] = new MultiClause("t2." + "status", objectArray);
                clauseDescriptionArray3[2] = new JoinClause("t2." + "jobid", "t0." + "jobid", "!=");
                sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.getTableName()).append(" t2 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray3)).append(") ");
                sb.append(this.database.constructOffsetLimitClause(0, maxCount));
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null, maxCount, null);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done getting docs to cleaning queue after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                HashMap<String, ArrayList<DocumentDescription>> connectionNameMap = new HashMap<String, ArrayList<DocumentDescription>>();
                HashMap<String, DocumentDescription> documentIDMap = new HashMap<String, DocumentDescription>();
                for (int i = 0; i < set.getRowCount(); ++i) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("jobid");
                    String documentIDHash = (String)row.getValue("dochash");
                    String documentID = (String)row.getValue("docid");
                    Long failTimeValue = (Long)row.getValue("failtime");
                    Long failCountValue = (Long)row.getValue("failcount");
                    long failTime = failTimeValue == null ? -1L : failTimeValue;
                    int failCount = failCountValue == null ? 0 : (int)failCountValue.longValue();
                    IJobDescription jobDesc = this.load(jobID);
                    String connectionName = jobDesc.getConnectionName();
                    DocumentDescription dd = new DocumentDescription((Long)row.getValue("id"), jobID, documentIDHash, documentID, failTime, failCount);
                    String compositeDocumentID = JobManager.makeCompositeID(documentIDHash, connectionName);
                    documentIDMap.put(compositeDocumentID, dd);
                    ArrayList<DocumentDescription> x = (ArrayList<DocumentDescription>)connectionNameMap.get(connectionName);
                    if (x == null) {
                        x = new ArrayList<DocumentDescription>();
                        connectionNameMap.put(connectionName, x);
                    }
                    x.add(dd);
                }
                HashMap<String, String> allowedDocIds = new HashMap<String, String>();
                for (String connectionName : connectionNameMap.keySet()) {
                    List x = (List)connectionNameMap.get(connectionName);
                    DocumentDescription[] descriptions = new DocumentDescription[x.size()];
                    for (int j = 0; j < descriptions.length; ++j) {
                        descriptions[j] = (DocumentDescription)x.get(j);
                    }
                    String[] docIDHashes = this.getUnindexableDocumentIdentifiers(descriptions, connectionName);
                    for (String docIDHash : docIDHashes) {
                        String key = JobManager.makeCompositeID(docIDHash, connectionName);
                        allowedDocIds.put(key, docIDHash);
                    }
                }
                Object[] compositeIDArray = new String[documentIDMap.size()];
                int j = 0;
                Iterator iter = documentIDMap.keySet().iterator();
                while (iter.hasNext()) {
                    compositeIDArray[j++] = (String)iter.next();
                }
                Arrays.sort(compositeIDArray);
                DocumentDescription[] rval = new DocumentDescription[documentIDMap.size()];
                boolean[] rvalBoolean = new boolean[documentIDMap.size()];
                for (int i = 0; i < compositeIDArray.length; ++i) {
                    Object compositeDocID = compositeIDArray[i];
                    DocumentDescription dd = (DocumentDescription)documentIDMap.get(compositeDocID);
                    rvalBoolean[i] = allowedDocIds.get(compositeDocID) != null;
                    rval[i] = dd;
                    this.jobQueue.setCleaningStatus(dd.getID(), processID);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done pruning unindexable docs after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                documentSetAndFlags = new DocumentSetAndFlags(rval, rvalBoolean);
            }
            catch (Error e) {
                try {
                    this.database.signalRollback();
                    TrackerClass.noteRollback();
                    throw e;
                    catch (ManifoldCFException e2) {
                        this.database.signalRollback();
                        TrackerClass.noteRollback();
                        if (e2.getErrorCode() != 6) throw e2;
                        if (Logging.perf.isDebugEnabled()) {
                            Logging.perf.debug((Object)("Aborted transaction finding deleteable docs: " + e2.getMessage()));
                        }
                        sleepAmt = this.getRandomAmount();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.database.endTransaction();
                    continue;
                }
            }
            this.database.endTransaction();
            this.lockManager.leaveWriteLock(cleanStufferLock);
            this.sleepFor(sleepAmt);
            return documentSetAndFlags;
            break;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    protected static String makeCompositeID(String docIDHash, String connectionName) {
        return docIDHash + ":" + connectionName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DocumentDescription[] getNextDeletableDocuments(String processID, int maxCount, long currentTime) throws ManifoldCFException {
        if (!this.jobs.deletingJobsPresent()) {
            return new DocumentDescription[0];
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Waiting to find documents to put on the delete queue");
        }
        while (true) {
            DocumentDescription[] documentDescriptionArray;
            long sleepAmt = 0L;
            this.lockManager.enterWriteLock(deleteStufferLock);
            this.database.beginTransaction();
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("After " + new Long(System.currentTimeMillis() - startTime).toString() + " ms, beginning query to look for documents to put on delete queue"));
                }
                ArrayList<Long> list = new ArrayList<Long>();
                StringBuilder sb = new StringBuilder("SELECT ");
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("t0." + "status", (Object)JobQueue.statusToString(11));
                sb.append("id").append(",").append("jobid").append(",").append("dochash").append(",").append("docid").append(",").append("failtime").append(",").append("failcount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ").append("t0.").append("checktime").append("<=? AND ");
                list.add(new Long(currentTime));
                ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
                clauseDescriptionArray2[0] = new UnitaryClause("t1." + "status", (Object)Jobs.statusToString(35));
                clauseDescriptionArray2[1] = new JoinClause("t1." + "id", "t0." + "jobid");
                sb.append("EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(") AND ");
                ClauseDescription[] clauseDescriptionArray3 = new ClauseDescription[3];
                clauseDescriptionArray3[0] = new JoinClause("t2." + "dochash", "t0." + "dochash");
                Object[] objectArray = new String[6];
                objectArray[0] = JobQueue.statusToString(1);
                objectArray[1] = JobQueue.statusToString(5);
                objectArray[2] = JobQueue.statusToString(8);
                objectArray[3] = JobQueue.statusToString(9);
                objectArray[4] = JobQueue.statusToString(7);
                objectArray[5] = JobQueue.statusToString(10);
                clauseDescriptionArray3[1] = new MultiClause("t2." + "status", objectArray);
                clauseDescriptionArray3[2] = new JoinClause("t2." + "jobid", "t0." + "jobid", "!=");
                sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.getTableName()).append(" t2 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray3)).append(") ");
                sb.append(this.database.constructOffsetLimitClause(0, maxCount));
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null, maxCount, null);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done getting docs to delete queue after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                HashMap<String, ArrayList<DocumentDescription>> connectionNameMap = new HashMap<String, ArrayList<DocumentDescription>>();
                HashMap<String, DocumentDescription> documentIDMap = new HashMap<String, DocumentDescription>();
                for (int i = 0; i < set.getRowCount(); ++i) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("jobid");
                    String documentIDHash = (String)row.getValue("dochash");
                    String documentID = (String)row.getValue("docid");
                    Long failTimeValue = (Long)row.getValue("failtime");
                    Long failCountValue = (Long)row.getValue("failcount");
                    long failTime = failTimeValue == null ? -1L : failTimeValue;
                    int failCount = failCountValue == null ? 0 : (int)failCountValue.longValue();
                    IJobDescription jobDesc = this.load(jobID);
                    String connectionName = jobDesc.getConnectionName();
                    DocumentDescription dd = new DocumentDescription((Long)row.getValue("id"), jobID, documentIDHash, documentID, failTime, failCount);
                    String compositeDocumentID = JobManager.makeCompositeID(documentIDHash, connectionName);
                    documentIDMap.put(compositeDocumentID, dd);
                    ArrayList<DocumentDescription> x = (ArrayList<DocumentDescription>)connectionNameMap.get(connectionName);
                    if (x == null) {
                        x = new ArrayList<DocumentDescription>();
                        connectionNameMap.put(connectionName, x);
                    }
                    x.add(dd);
                }
                HashMap<String, String> allowedDocIds = new HashMap<String, String>();
                for (String connectionName : connectionNameMap.keySet()) {
                    List x = (List)connectionNameMap.get(connectionName);
                    DocumentDescription[] descriptions = new DocumentDescription[x.size()];
                    for (int j = 0; j < descriptions.length; ++j) {
                        descriptions[j] = (DocumentDescription)x.get(j);
                    }
                    String[] docIDHashes = this.getUnindexableDocumentIdentifiers(descriptions, connectionName);
                    for (int j = 0; j < docIDHashes.length; ++j) {
                        String docIDHash = docIDHashes[j];
                        String key = JobManager.makeCompositeID(docIDHash, connectionName);
                        allowedDocIds.put(key, docIDHash);
                    }
                }
                Object[] compositeIDArray = new String[documentIDMap.size()];
                int j = 0;
                Iterator iter = documentIDMap.keySet().iterator();
                while (iter.hasNext()) {
                    compositeIDArray[j++] = (String)iter.next();
                }
                Arrays.sort(compositeIDArray);
                DocumentDescription[] rval = new DocumentDescription[allowedDocIds.size()];
                j = 0;
                for (int i = 0; i < compositeIDArray.length; ++i) {
                    Object compositeDocumentID = compositeIDArray[i];
                    DocumentDescription dd = (DocumentDescription)documentIDMap.get(compositeDocumentID);
                    if (allowedDocIds.get(compositeDocumentID) == null) {
                        this.jobQueue.deleteRecord(dd.getID());
                        continue;
                    }
                    rval[j++] = dd;
                    this.jobQueue.setDeletingStatus(dd.getID(), processID);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Done pruning unindexable docs after " + new Long(System.currentTimeMillis() - startTime).toString() + " ms."));
                }
                documentDescriptionArray = rval;
            }
            catch (Error e) {
                try {
                    this.database.signalRollback();
                    TrackerClass.noteRollback();
                    throw e;
                    catch (ManifoldCFException e2) {
                        this.database.signalRollback();
                        TrackerClass.noteRollback();
                        if (e2.getErrorCode() != 6) throw e2;
                        if (Logging.perf.isDebugEnabled()) {
                            Logging.perf.debug((Object)("Aborted transaction finding deleteable docs: " + e2.getMessage()));
                        }
                        sleepAmt = this.getRandomAmount();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.database.endTransaction();
                    continue;
                }
            }
            this.database.endTransaction();
            this.lockManager.leaveWriteLock(deleteStufferLock);
            this.sleepFor(sleepAmt);
            return documentDescriptionArray;
            break;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    protected String[] getUnindexableDocumentIdentifiers(DocumentDescription[] documentIdentifiers, String connectionName) throws ManifoldCFException {
        MutableInteger mi;
        String docIDHash;
        HashMap<String, MutableInteger> countMap = new HashMap<String, MutableInteger>();
        HashSet<String> map = new HashSet<String>();
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            String hash = documentIdentifiers[i].getDocumentIdentifierHash();
            map.add(hash);
            countMap.put(hash, new MutableInteger(0));
        }
        if (map.size() == 0) {
            return new String[0];
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> docList = new ArrayList<String>();
        Iterator<Object> iter = map.iterator();
        while (iter.hasNext()) {
            docList.add((String)iter.next());
        }
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("t0." + "dochash", docList);
        sb.append("SELECT t0.").append("dochash").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ").append("t0.").append("status").append(" IN (?,?,?,?,?) AND ");
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(11));
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[1];
        clauseDescriptionArray2[0] = new JoinClause("t1." + "id", "t0." + "jobid");
        sb.append("EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(" AND ").append("t1.").append("connectionname").append("=?)");
        list.add(connectionName);
        IResultSet results = this.database.performQuery(sb.toString(), list, null, null);
        for (int i = 0; i < results.getRowCount(); ++i) {
            IResultRow row = results.getRow(i);
            docIDHash = (String)row.getValue("dochash");
            mi = (MutableInteger)countMap.get(docIDHash);
            if (mi == null) continue;
            mi.increment();
        }
        int count = 0;
        for (String docIDHash2 : countMap.keySet()) {
            MutableInteger mi2 = (MutableInteger)countMap.get(docIDHash2);
            if (mi2.intValue() != 1) continue;
            ++count;
        }
        String[] rval = new String[count];
        iter = countMap.keySet().iterator();
        count = 0;
        while (iter.hasNext()) {
            docIDHash = (String)iter.next();
            mi = (MutableInteger)countMap.get(docIDHash);
            if (mi.intValue() != 1) continue;
            rval[count++] = docIDHash;
        }
        return rval;
    }

    @Override
    public void clearAllDocumentPriorities() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobQueue.clearAllDocPriorities();
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction clearing doc priorities for reprioritization: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DocumentDescription[] getNextNotYetProcessedReprioritizationDocuments(String processID, int n) throws ManifoldCFException {
        while (true) {
            Object[] objectArray;
            long sleepAmt = 0L;
            this.lockManager.enterWriteLock(reprioritizationLock);
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("needpriority", (Object)JobQueue.needPriorityToString(2));
                sb.append("id").append(",").append("dochash").append(",").append("docid").append(",").append("jobid").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" ").append(this.database.constructOffsetLimitClause(0, n));
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                DocumentDescription[] rval = new DocumentDescription[set.getRowCount()];
                Object[] docIDHashes = new String[set.getRowCount()];
                HashMap<Object, DocumentDescription> storageMap = new HashMap<Object, DocumentDescription>();
                for (int i = 0; i < set.getRowCount(); ++i) {
                    IResultRow row = set.getRow(i);
                    String docHash = (String)row.getValue("dochash");
                    Long jobID = (Long)row.getValue("jobid");
                    rval[i] = new DocumentDescription((Long)row.getValue("id"), jobID, docHash, (String)row.getValue("docid"));
                    docIDHashes[i] = docHash + ":" + jobID;
                    storageMap.put(docIDHashes[i], rval[i]);
                }
                Arrays.sort(docIDHashes);
                for (Object docIDHash : docIDHashes) {
                    DocumentDescription dd = (DocumentDescription)storageMap.get(docIDHash);
                    this.jobQueue.markNeedPriorityInProgress(dd.getID(), processID);
                }
                this.database.performCommit();
                objectArray = rval;
            }
            catch (ManifoldCFException e) {
                try {
                    this.database.signalRollback();
                    if (e.getErrorCode() != 6) throw e;
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finding documents for reprioritization: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                    catch (Error e2) {
                        this.database.signalRollback();
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.database.endTransaction();
                    continue;
                }
            }
            this.database.endTransaction();
            this.lockManager.leaveWriteLock(reprioritizationLock);
            this.sleepFor(sleepAmt);
            return objectArray;
            break;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    @Override
    public void writeDocumentPriorities(DocumentDescription[] documentDescriptions, IPriorityCalculator[] priorities) throws ManifoldCFException {
        while (true) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            Object[] docIDHashes = new String[documentDescriptions.length];
            for (int i = 0; i < documentDescriptions.length; ++i) {
                String documentIDHash = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
                docIDHashes[i] = documentIDHash;
                indexMap.put(documentIDHash, new Integer(i));
            }
            Arrays.sort(docIDHashes);
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (int i = 0; i < docIDHashes.length; ++i) {
                    Object docIDHash = docIDHashes[i];
                    Integer x = (Integer)indexMap.remove(docIDHash);
                    if (x == null) {
                        throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
                    }
                    int index = x;
                    DocumentDescription dd = documentDescriptions[index];
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    clauseDescriptionArray[0] = new UnitaryClause("id", (Object)dd.getID());
                    String query = this.database.buildConjunctionClause(list, clauseDescriptionArray);
                    IResultSet set = this.database.performQuery("SELECT " + "needpriority" + " FROM " + this.jobQueue.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
                    if (set.getRowCount() <= 0) continue;
                    IResultRow row = set.getRow(0);
                    int needPriority = JobQueue.stringToNeedPriority((String)row.getValue("needpriority"));
                    if (needPriority != 1) continue;
                    IPriorityCalculator priority = priorities[index];
                    this.jobQueue.writeDocPriority(dd.getID(), priority);
                }
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction writing doc priorities: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DocumentSetAndFlags getExpiredDocuments(String processID, int n, long currentTime) throws ManifoldCFException {
        if (!this.jobs.activeJobsPresent()) {
            return new DocumentSetAndFlags(new DocumentDescription[0], new boolean[0]);
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Beginning query to look for documents to expire");
        }
        ArrayList list = new ArrayList();
        StringBuilder sb = new StringBuilder("SELECT ");
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[3];
        Object[] objectArray = new Object[2];
        objectArray[0] = JobQueue.statusToString(0);
        objectArray[1] = JobQueue.statusToString(4);
        clauseDescriptionArray[0] = new MultiClause("t0." + "status", objectArray);
        clauseDescriptionArray[1] = new UnitaryClause("t0." + "checkaction", (Object)JobQueue.actionToString(1));
        clauseDescriptionArray[2] = new UnitaryClause("t0." + "checktime", "<=", (Object)new Long(currentTime));
        sb.append("t0.").append("id").append(",").append("t0.").append("jobid").append(",").append("t0.").append("dochash").append(",").append("t0.").append("docid").append(",").append("t0.").append("status").append(",").append("t0.").append("failtime").append(",").append("t0.").append("failcount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = Jobs.statusToString(1);
        objectArray2[1] = Jobs.statusToString(2);
        clauseDescriptionArray2[0] = new MultiClause("t1." + "status", objectArray2);
        clauseDescriptionArray2[1] = new JoinClause("t1." + "id", "t0." + "jobid");
        sb.append("EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(") AND ");
        ClauseDescription[] clauseDescriptionArray3 = new ClauseDescription[3];
        clauseDescriptionArray3[0] = new JoinClause("t2." + "dochash", "t0." + "dochash");
        Object[] objectArray3 = new String[6];
        objectArray3[0] = JobQueue.statusToString(1);
        objectArray3[1] = JobQueue.statusToString(5);
        objectArray3[2] = JobQueue.statusToString(8);
        objectArray3[3] = JobQueue.statusToString(9);
        objectArray3[4] = JobQueue.statusToString(7);
        objectArray3[5] = JobQueue.statusToString(10);
        clauseDescriptionArray3[1] = new MultiClause("t2." + "status", objectArray3);
        clauseDescriptionArray3[2] = new JoinClause("t2." + "jobid", "t0." + "jobid", "!=");
        sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.getTableName()).append(" t2 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray3)).append(") ");
        sb.append(this.database.constructOffsetLimitClause(0, n));
        String query = sb.toString();
        ArrayList answers = new ArrayList();
        int repeatCount = 0;
        while (true) {
            DocumentSetAndFlags documentSetAndFlags;
            long sleepAmt = 0L;
            this.lockManager.enterWriteLock(expireStufferLock);
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)(" Attempt " + Integer.toString(++repeatCount) + " to expire documents, after " + new Long(System.currentTimeMillis() - startTime) + " ms"));
            }
            this.database.beginTransaction();
            try {
                IResultSet set = this.database.performQuery(query, list, null, null, n, null);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)(" Expiring " + Integer.toString(set.getRowCount()) + " documents"));
                }
                HashMap<String, ArrayList<DocumentDescription>> connectionNameMap = new HashMap<String, ArrayList<DocumentDescription>>();
                HashMap<String, DocumentDescription> documentIDMap = new HashMap<String, DocumentDescription>();
                HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
                for (int i = 0; i < set.getRowCount(); ++i) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("jobid");
                    String documentIDHash = (String)row.getValue("dochash");
                    String documentID = (String)row.getValue("docid");
                    int status = JobQueue.stringToStatus(row.getValue("status").toString());
                    Long failTimeValue = (Long)row.getValue("failtime");
                    Long failCountValue = (Long)row.getValue("failcount");
                    long failTime = failTimeValue == null ? -1L : failTimeValue;
                    int failCount = failCountValue == null ? 0 : (int)failCountValue.longValue();
                    IJobDescription jobDesc = this.load(jobID);
                    String connectionName = jobDesc.getConnectionName();
                    DocumentDescription dd = new DocumentDescription((Long)row.getValue("id"), jobID, documentIDHash, documentID, failTime, failCount);
                    String compositeDocumentID = JobManager.makeCompositeID(documentIDHash, connectionName);
                    documentIDMap.put(compositeDocumentID, dd);
                    statusMap.put(compositeDocumentID, new Integer(status));
                    ArrayList<DocumentDescription> x = (ArrayList<DocumentDescription>)connectionNameMap.get(connectionName);
                    if (x == null) {
                        x = new ArrayList<DocumentDescription>();
                        connectionNameMap.put(connectionName, x);
                    }
                    x.add(dd);
                }
                HashMap<String, String> allowedDocIds = new HashMap<String, String>();
                for (String connectionName : connectionNameMap.keySet()) {
                    List x = (List)connectionNameMap.get(connectionName);
                    DocumentDescription[] descriptions = new DocumentDescription[x.size()];
                    for (int j = 0; j < descriptions.length; ++j) {
                        descriptions[j] = (DocumentDescription)x.get(j);
                    }
                    String[] docIDHashes = this.getUnindexableDocumentIdentifiers(descriptions, connectionName);
                    for (int j = 0; j < docIDHashes.length; ++j) {
                        String docIDHash = docIDHashes[j];
                        String key = JobManager.makeCompositeID(docIDHash, connectionName);
                        allowedDocIds.put(key, docIDHash);
                    }
                }
                Object[] compositeIDArray = new String[documentIDMap.size()];
                int j = 0;
                Iterator iter = documentIDMap.keySet().iterator();
                while (iter.hasNext()) {
                    compositeIDArray[j++] = (String)iter.next();
                }
                Arrays.sort(compositeIDArray);
                DocumentDescription[] rval = new DocumentDescription[documentIDMap.size()];
                boolean[] rvalBoolean = new boolean[documentIDMap.size()];
                for (int i = 0; i < compositeIDArray.length; ++i) {
                    Object compositeDocID = compositeIDArray[i];
                    DocumentDescription dd = (DocumentDescription)documentIDMap.get(compositeDocID);
                    rvalBoolean[i] = allowedDocIds.get(compositeDocID) != null;
                    rval[i] = dd;
                    this.jobQueue.updateActiveRecord(dd.getID(), (Integer)statusMap.get(compositeDocID), processID);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                documentSetAndFlags = new DocumentSetAndFlags(rval, rvalBoolean);
            }
            catch (ManifoldCFException e) {
                try {
                    this.database.signalRollback();
                    TrackerClass.noteRollback();
                    if (e.getErrorCode() != 6) throw e;
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finding docs to expire: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                    catch (Error e2) {
                        this.database.signalRollback();
                        TrackerClass.noteRollback();
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.database.endTransaction();
                    continue;
                }
            }
            this.database.endTransaction();
            this.lockManager.leaveWriteLock(expireStufferLock);
            this.sleepFor(sleepAmt);
            return documentSetAndFlags;
            break;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    @Override
    public DocumentDescription[] getNextDocuments(String processID, int n, long currentTime, long interval, BlockingDocuments blockingDocuments, PerformanceStatistics statistics, DepthStatistics scanRecord) throws ManifoldCFException {
        IResultSet set;
        if (!this.jobs.activeJobsPresent()) {
            return new DocumentDescription[0];
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)"Waiting to find documents to queue");
        }
        ThrottleLimit vList = new ThrottleLimit(n);
        IResultSet jobconnections = this.jobs.getActiveJobConnections();
        HashSet<String> connectionSet = new HashSet<String>();
        int i = 0;
        while (i < jobconnections.getRowCount()) {
            IResultRow row = jobconnections.getRow(i++);
            Long jobid = (Long)row.getValue("jobid");
            String connectionName = (String)row.getValue("connectionname");
            vList.addJob(jobid, connectionName);
            connectionSet.add(connectionName);
        }
        String[] activeConnectionNames = new String[connectionSet.size()];
        i = 0;
        for (String connectionName : connectionSet) {
            activeConnectionNames[i++] = connectionName;
        }
        IRepositoryConnection[] connections = this.connectionMgr.loadMultiple(activeConnectionNames);
        HashMap<String, Double> rawFetchCounts = new HashMap<String, Double>();
        double rawFetchCountTotal = 0.0;
        for (IRepositoryConnection connection : connections) {
            String connectionName = connection.getName();
            int maxConnections = connection.getMaxConnections();
            double avgFetchRate = statistics.calculateConnectionFetchRate(connectionName);
            double weightedRawFetchCount = avgFetchRate * (double)maxConnections;
            rawFetchCounts.put(connectionName, new Double(weightedRawFetchCount));
            rawFetchCountTotal += weightedRawFetchCount;
        }
        double fetchCountAdjustmentFactor = (double)n / rawFetchCountTotal;
        for (IRepositoryConnection connection : connections) {
            Object throttles;
            String connectionName = connection.getName();
            for (String throttle : throttles = connection.getThrottles()) {
                float throttleValue = connection.getThrottleValue(throttle);
                double fetchesPerTimeInterval = (double)throttleValue * (double)interval;
                int fetches = (int)fetchesPerTimeInterval;
                fetchesPerTimeInterval -= (double)fetches;
                if (random.nextDouble() <= fetchesPerTimeInterval) {
                    ++fetches;
                }
                vList.addLimit(connectionName, throttle, fetches);
            }
            Double weightedRawFetchCount = (Double)rawFetchCounts.get(connectionName);
            double adjustedFetchCount = weightedRawFetchCount * fetchCountAdjustmentFactor;
            int fetchCount = (int)adjustedFetchCount + 5;
            vList.setConnectionLimit(connectionName, fetchCount);
        }
        if (Logging.perf.isDebugEnabled()) {
            Logging.perf.debug((Object)("After " + new Long(System.currentTimeMillis() - startTime).toString() + " ms, beginning query to look for documents to queue"));
        }
        ArrayList<DocumentDescription> answers = new ArrayList<DocumentDescription>();
        Long currentTimeValue = new Long(currentTime);
        boolean isDone = false;
        for (int currentPriority = 1; !isDone && currentPriority <= 10; ++currentPriority) {
            if (!this.jobs.hasPriorityJobs(currentPriority)) continue;
            Long currentPriorityValue = new Long(currentPriority);
            this.fetchAndProcessDocuments(answers, currentTimeValue, currentPriorityValue, vList, connections, processID);
            isDone = !vList.checkContinue();
        }
        vList.tallyBlockingDocuments(blockingDocuments);
        DocumentDescription[] rval = new DocumentDescription[answers.size()];
        i = 0;
        for (DocumentDescription answer : answers) {
            rval[i++] = answer;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList list = new ArrayList();
        sb.append("docpriority").append(",").append("jobid").append(",").append("dochash").append(",").append("docid").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 ").append(this.jobQueue.getGetNextDocumentsIndexHint()).append(" WHERE ");
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[4];
        clauseDescriptionArray[0] = new UnitaryClause("t0." + "docpriority", "<", (Object)JobQueue.nullDocPriority);
        Object[] objectArray = new Object[2];
        objectArray[0] = JobQueue.statusToString(0);
        objectArray[1] = JobQueue.statusToString(4);
        clauseDescriptionArray[1] = new MultiClause("status", objectArray);
        clauseDescriptionArray[2] = new UnitaryClause("checkaction", "=", (Object)JobQueue.actionToString(0));
        clauseDescriptionArray[3] = new UnitaryClause("checktime", "<=", (Object)currentTimeValue);
        sb.append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = Jobs.statusToString(1);
        objectArray2[1] = Jobs.statusToString(2);
        clauseDescriptionArray2[0] = new MultiClause("t1." + "status", objectArray2);
        clauseDescriptionArray2[1] = new JoinClause("t1." + "id", "t0." + "jobid");
        sb.append("EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(") ");
        String[] stringArray = new String[4];
        stringArray[0] = "docpriority";
        stringArray[1] = "status";
        stringArray[2] = "checkaction";
        stringArray[3] = "checktime";
        sb.append(" ").append(this.database.constructIndexOrderByClause(stringArray, true)).append(" ").append(this.database.constructOffsetLimitClause(0, 1, true));
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                set = this.database.performQuery(sb.toString(), list, null, null, 1, null);
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction adding document bins: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                continue;
            }
            break;
        }
        if (set.getRowCount() > 0) {
            IResultRow row = set.getRow(0);
            Double docPriority = (Double)row.getValue("docpriority");
            if (docPriority != null) {
                if (docPriority < 1.0E9) {
                    scanRecord.addBins(docPriority);
                }
            }
        }
        return rval;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchAndProcessDocuments(List<DocumentDescription> answers, Long currentTimeValue, Long currentPriorityValue, ThrottleLimit vList, IRepositoryConnection[] connections, String processID) throws ManifoldCFException {
        int k;
        ArrayList list = new ArrayList();
        StringBuilder sb = new StringBuilder("SELECT t0.");
        sb.append("id").append(",t0.");
        if (Logging.scheduling.isDebugEnabled()) {
            sb.append("docpriority").append(",t0.");
        }
        sb.append("jobid").append(",t0.").append("dochash").append(",t0.").append("docid").append(",t0.").append("status").append(",t0.").append("failtime").append(",t0.").append("failcount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0 ").append(this.jobQueue.getGetNextDocumentsIndexHint()).append(" WHERE ");
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[4];
        clauseDescriptionArray[0] = new UnitaryClause("t0." + "docpriority", "<", (Object)JobQueue.nullDocPriority);
        Object[] objectArray = new Object[2];
        objectArray[0] = JobQueue.statusToString(0);
        objectArray[1] = JobQueue.statusToString(4);
        clauseDescriptionArray[1] = new MultiClause("t0." + "status", objectArray);
        clauseDescriptionArray[2] = new UnitaryClause("t0." + "checkaction", "=", (Object)JobQueue.actionToString(0));
        clauseDescriptionArray[3] = new UnitaryClause("t0." + "checktime", "<=", (Object)currentTimeValue);
        sb.append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[3];
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = Jobs.statusToString(1);
        objectArray2[1] = Jobs.statusToString(2);
        clauseDescriptionArray2[0] = new MultiClause("t1." + "status", objectArray2);
        clauseDescriptionArray2[1] = new JoinClause("t1." + "id", "t0." + "jobid");
        clauseDescriptionArray2[2] = new UnitaryClause("t1." + "priority", (Object)currentPriorityValue);
        sb.append("EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(") AND ");
        ClauseDescription[] clauseDescriptionArray3 = new ClauseDescription[3];
        clauseDescriptionArray3[0] = new JoinClause("t2." + "dochash", "t0." + "dochash");
        Object[] objectArray3 = new String[6];
        objectArray3[0] = JobQueue.statusToString(1);
        objectArray3[1] = JobQueue.statusToString(5);
        objectArray3[2] = JobQueue.statusToString(8);
        objectArray3[3] = JobQueue.statusToString(9);
        objectArray3[4] = JobQueue.statusToString(7);
        objectArray3[5] = JobQueue.statusToString(10);
        clauseDescriptionArray3[1] = new MultiClause("t2." + "status", objectArray3);
        clauseDescriptionArray3[2] = new JoinClause("t2." + "jobid", "t0." + "jobid", "!=");
        sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.getTableName()).append(" t2 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray3)).append(") AND ");
        PrereqEventManager cfr_ignored_0 = this.jobQueue.prereqEventManager;
        PrereqEventManager cfr_ignored_1 = this.jobQueue.prereqEventManager;
        sb.append("NOT EXISTS(SELECT 'x' FROM ").append(this.jobQueue.prereqEventManager.getTableName()).append(" t3,").append(this.eventManager.getTableName()).append(" t4 WHERE t0.").append("id").append("=t3.").append("owner").append(" AND t3.").append("eventname").append("=t4.").append("name").append(")");
        String[] stringArray = new String[4];
        stringArray[0] = "t0." + "docpriority";
        stringArray[1] = "t0." + "status";
        stringArray[2] = "t0." + "checkaction";
        stringArray[3] = "t0." + "checktime";
        sb.append(" ").append(this.database.constructIndexOrderByClause(stringArray, true)).append(" ");
        String query = sb.toString();
        String[] orderingKeys = new String[connections.length];
        for (k = 0; k < connections.length; ++k) {
            IRepositoryConnection connection = connections[k];
            orderingKeys[k] = connection.getName();
        }
        while (true) {
            long sleepAmt = 0L;
            this.lockManager.enterWriteLock(stufferLock);
            IRepositoryConnector[] connectors = this.repositoryConnectorPool.grabMultiple(orderingKeys, connections);
            for (k = 0; k < connections.length; ++k) {
                vList.addConnectionName(connections[k].getName(), connectors[k]);
            }
            int limitValue = vList.getRemainingDocuments();
            String finalQuery = query + this.database.constructOffsetLimitClause(0, limitValue, true);
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)("Queuing documents from time " + currentTimeValue.toString() + " job priority " + currentPriorityValue.toString() + " (up to " + Integer.toString(vList.getRemainingDocuments()) + " documents)"));
            }
            this.database.beginTransaction();
            try {
                int status;
                IResultSet set = this.database.performQuery(finalQuery, list, null, null, -1, (ILimitChecker)vList);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)(" Queuing " + Integer.toString(set.getRowCount()) + " documents"));
                }
                Object[] docIDHashes = new String[set.getRowCount()];
                HashMap<Object, DocumentDescription> storageMap = new HashMap<Object, DocumentDescription>();
                HashMap<Object, Integer> statusMap = new HashMap<Object, Integer>();
                for (int i = 0; i < set.getRowCount(); ++i) {
                    IResultRow row = set.getRow(i);
                    Long id = (Long)row.getValue("id");
                    Long jobID = (Long)row.getValue("jobid");
                    String docIDHash = (String)row.getValue("dochash");
                    String docID = (String)row.getValue("docid");
                    status = JobQueue.stringToStatus(row.getValue("status").toString());
                    Long failTimeValue = (Long)row.getValue("failtime");
                    Long failCountValue = (Long)row.getValue("failcount");
                    long failTime = failTimeValue == null ? -1L : failTimeValue;
                    int failCount = failCountValue == null ? -1 : (int)failCountValue.longValue();
                    DocumentDescription dd = new DocumentDescription(id, jobID, docIDHash, docID, failTime, failCount);
                    docIDHashes[i] = docIDHash + ":" + jobID;
                    storageMap.put(docIDHashes[i], dd);
                    statusMap.put(docIDHashes[i], new Integer(status));
                    if (!Logging.scheduling.isDebugEnabled()) continue;
                    Double docPriority = (Double)row.getValue("docpriority");
                    Logging.scheduling.debug((Object)("Stuffing document '" + docID + "' that has priority " + docPriority.toString() + " onto active list"));
                }
                Arrays.sort(docIDHashes);
                for (Object docIDHash : docIDHashes) {
                    DocumentDescription dd = (DocumentDescription)storageMap.get(docIDHash);
                    Long id = dd.getID();
                    status = (Integer)statusMap.get(docIDHash);
                    this.jobQueue.updateActiveRecord(id, status, processID);
                    answers.add(dd);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                try {
                    this.database.signalRollback();
                    if (e.getErrorCode() != 6) throw e;
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finding docs to queue: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                    catch (Error e2) {
                        this.database.signalRollback();
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.database.endTransaction();
                    continue;
                }
            }
            this.database.endTransaction();
            this.repositoryConnectorPool.releaseMultiple(connections, connectors);
            this.lockManager.leaveWriteLock(stufferLock);
            this.sleepFor(sleepAmt);
            return;
            break;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    @Override
    public boolean checkJobActive(Long jobID) throws ManifoldCFException {
        return this.jobs.checkJobActive(jobID);
    }

    @Override
    public boolean checkJobBusy(Long jobID) throws ManifoldCFException {
        return this.jobQueue.checkJobBusy(jobID);
    }

    @Override
    public void markDocumentCompletedMultiple(DocumentDescription[] documentDescriptions) throws ManifoldCFException {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        Object[] docIDHashes = new String[documentDescriptions.length];
        for (int i = 0; i < documentDescriptions.length; ++i) {
            String documentIDHash = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            docIDHashes[i] = documentIDHash;
            indexMap.put(documentIDHash, new Integer(i));
        }
        Arrays.sort(docIDHashes);
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (Object docIDHash : docIDHashes) {
                    DocumentDescription dd = documentDescriptions[(Integer)indexMap.get(docIDHash)];
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    clauseDescriptionArray[0] = new UnitaryClause("id", (Object)dd.getID());
                    String query = this.database.buildConjunctionClause(list, clauseDescriptionArray);
                    TrackerClass.notePreread(dd.getID());
                    IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobQueue.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
                    TrackerClass.noteRead(dd.getID());
                    if (set.getRowCount() <= 0) continue;
                    IResultRow row = set.getRow(0);
                    int status = JobQueue.stringToStatus((String)row.getValue("status"));
                    this.jobQueue.updateCompletedRecord(dd.getID(), status);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction marking completed " + Integer.toString(docIDHashes.length) + " docs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            catch (RuntimeException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void markDocumentCompleted(DocumentDescription documentDescription) throws ManifoldCFException {
        this.markDocumentCompletedMultiple(new DocumentDescription[]{documentDescription});
    }

    @Override
    public DocumentDescription[] markDocumentDeletedMultiple(Long jobID, String[] legalLinkTypes, DocumentDescription[] documentDescriptions, int hopcountMethod) throws ManifoldCFException {
        return this.doDeleteMultiple(jobID, legalLinkTypes, documentDescriptions, hopcountMethod);
    }

    @Override
    public DocumentDescription[] markDocumentDeleted(Long jobID, String[] legalLinkTypes, DocumentDescription documentDescription, int hopcountMethod) throws ManifoldCFException {
        return this.markDocumentDeletedMultiple(jobID, legalLinkTypes, new DocumentDescription[]{documentDescription}, hopcountMethod);
    }

    @Override
    public DocumentDescription[] markDocumentHopcountRemovalMultiple(Long jobID, String[] legalLinkTypes, DocumentDescription[] documentDescriptions, int hopcountMethod) throws ManifoldCFException {
        int i;
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        Object[] docIDHashes = new String[documentDescriptions.length];
        for (i = 0; i < documentDescriptions.length; ++i) {
            String documentIDHash = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            docIDHashes[i] = documentIDHash;
            indexMap.put(documentIDHash, new Integer(i));
        }
        Arrays.sort(docIDHashes);
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                ArrayList<String> deleteList = new ArrayList<String>();
                for (i = 0; i < docIDHashes.length; ++i) {
                    Object docIDHash = docIDHashes[i];
                    DocumentDescription dd = documentDescriptions[(Integer)indexMap.get(docIDHash)];
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    clauseDescriptionArray[0] = new UnitaryClause("id", (Object)dd.getID());
                    String query = this.database.buildConjunctionClause(list, clauseDescriptionArray);
                    TrackerClass.notePreread(dd.getID());
                    IResultSet set = this.database.performQuery("SELECT " + "status" + " FROM " + this.jobQueue.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
                    TrackerClass.noteRead(dd.getID());
                    if (set.getRowCount() <= 0) continue;
                    IResultRow row = set.getRow(0);
                    int status = JobQueue.stringToStatus((String)row.getValue("status"));
                    boolean didDelete = this.jobQueue.updateOrHopcountRemoveRecord(dd.getID(), status);
                    if (!didDelete) continue;
                    deleteList.add(dd.getDocumentIdentifierHash());
                }
                String[] docIDSimpleHashes = new String[deleteList.size()];
                for (int j = 0; j < docIDSimpleHashes.length; ++j) {
                    docIDSimpleHashes[j] = (String)deleteList.get(j);
                }
                DocumentDescription[] rval = this.calculateAffectedDeleteCarrydownChildren(jobID, docIDSimpleHashes);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                DocumentDescription[] documentDescriptionArray = rval;
                return documentDescriptionArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction marking completed " + Integer.toString(docIDHashes.length) + " docs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public DocumentDescription[] markDocumentHopcountRemoval(Long jobID, String[] legalLinkTypes, DocumentDescription documentDescription, int hopcountMethod) throws ManifoldCFException {
        return this.markDocumentHopcountRemovalMultiple(jobID, legalLinkTypes, new DocumentDescription[]{documentDescription}, hopcountMethod);
    }

    @Override
    public DocumentDescription[] markDocumentExpiredMultiple(Long jobID, String[] legalLinkTypes, DocumentDescription[] documentDescriptions, int hopcountMethod) throws ManifoldCFException {
        return this.doDeleteMultiple(jobID, legalLinkTypes, documentDescriptions, hopcountMethod);
    }

    @Override
    public DocumentDescription[] markDocumentExpired(Long jobID, String[] legalLinkTypes, DocumentDescription documentDescription, int hopcountMethod) throws ManifoldCFException {
        return this.markDocumentExpiredMultiple(jobID, legalLinkTypes, new DocumentDescription[]{documentDescription}, hopcountMethod);
    }

    @Override
    public DocumentDescription[] markDocumentCleanedUpMultiple(Long jobID, String[] legalLinkTypes, DocumentDescription[] documentDescriptions, int hopcountMethod) throws ManifoldCFException {
        return this.doDeleteMultiple(jobID, legalLinkTypes, documentDescriptions, hopcountMethod);
    }

    @Override
    public DocumentDescription[] markDocumentCleanedUp(Long jobID, String[] legalLinkTypes, DocumentDescription documentDescription, int hopcountMethod) throws ManifoldCFException {
        return this.markDocumentCleanedUpMultiple(jobID, legalLinkTypes, new DocumentDescription[]{documentDescription}, hopcountMethod);
    }

    protected DocumentDescription[] doDeleteMultiple(Long jobID, String[] legalLinkTypes, DocumentDescription[] documentDescriptions, int hopcountMethod) throws ManifoldCFException {
        DocumentDescription[] rval;
        int i;
        if (documentDescriptions.length == 0) {
            return new DocumentDescription[0];
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to delete " + Integer.toString(documentDescriptions.length) + " docs and clean up hopcount for job " + jobID.toString()));
        }
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        Object[] docIDHashes = new String[documentDescriptions.length];
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start deleting " + Integer.toString(docIDHashes.length) + " docs and clean up hopcount for job " + jobID.toString()));
                }
                String[] docIDSimpleHashes = new String[docIDHashes.length];
                for (i = 0; i < docIDHashes.length; ++i) {
                    Object docIDHash = docIDHashes[i];
                    DocumentDescription dd = documentDescriptions[(Integer)indexMap.get(docIDHash)];
                    this.jobQueue.deleteRecord(dd.getID());
                    docIDSimpleHashes[i] = dd.getDocumentIdentifierHash();
                }
                rval = this.calculateAffectedDeleteCarrydownChildren(jobID, docIDSimpleHashes);
                this.carryDown.deleteRecords(jobID, docIDSimpleHashes);
                if (legalLinkTypes.length > 0) {
                    this.hopCount.deleteDocumentIdentifiers(jobID, legalLinkTypes, docIDSimpleHashes, hopcountMethod);
                }
                this.database.performCommit();
                if (!Logging.perf.isDebugEnabled()) break;
                Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to delete " + Integer.toString(docIDHashes.length) + " docs and clean up hopcount for job " + jobID.toString()));
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction deleting " + Integer.toString(docIDHashes.length) + " docs and clean up hopcount for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        return rval;
    }

    protected DocumentDescription[] calculateAffectedDeleteCarrydownChildren(Long jobID, String[] docIDHashes) throws ManifoldCFException {
        HashMap resultHash = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.maxClauseProcessDeleteHashSet();
        int i = 0;
        int z = 0;
        while (i < docIDHashes.length) {
            if (z == maxCount) {
                this.processDeleteHashSet(jobID, resultHash, list);
                list.clear();
                z = 0;
            }
            list.add(docIDHashes[i]);
            ++i;
            ++z;
        }
        if (z > 0) {
            this.processDeleteHashSet(jobID, resultHash, list);
        }
        DocumentDescription[] rval = new DocumentDescription[resultHash.size()];
        i = 0;
        for (Long id : resultHash.keySet()) {
            DocumentDescription dd = (DocumentDescription)resultHash.get(id);
            rval[i++] = dd;
        }
        return rval;
    }

    protected int maxClauseProcessDeleteHashSet() {
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
        clauseDescriptionArray[0] = new JoinClause("t1." + "jobid", "t0." + "jobid");
        clauseDescriptionArray[1] = new JoinClause("t1." + "childidhash", "t0." + "dochash");
        return this.database.findConjunctionClauseMax(clauseDescriptionArray);
    }

    protected void processDeleteHashSet(Long jobID, HashMap resultHash, ArrayList list) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList newList = new ArrayList();
        sb.append("t0.").append("id").append(",").append("t0.").append("dochash").append(",").append("t0.").append("docid").append(" FROM ").append(this.carryDown.getTableName()).append(" t1, ").append(this.jobQueue.getTableName()).append(" t0 WHERE ");
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
        clauseDescriptionArray[0] = new UnitaryClause("t1." + "jobid", (Object)jobID);
        clauseDescriptionArray[1] = new MultiClause("t1." + "parentidhash", (List)list);
        sb.append(this.database.buildConjunctionClause(newList, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
        clauseDescriptionArray2[0] = new JoinClause("t0." + "dochash", "t1." + "childidhash");
        clauseDescriptionArray2[1] = new JoinClause("t0." + "jobid", "t1." + "jobid");
        sb.append(this.database.buildConjunctionClause(newList, clauseDescriptionArray2));
        IResultSet set = this.database.performQuery(sb.toString(), newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long id = (Long)row.getValue("id");
            String documentIdentifierHash = (String)row.getValue("dochash");
            String documentIdentifier = (String)row.getValue("docid");
            resultHash.put(id, new DocumentDescription(id, jobID, documentIdentifierHash, documentIdentifier));
        }
    }

    @Override
    public void requeueDocumentMultiple(DocumentDescription[] documentDescriptions, Long[] executeTimes, int[] actions) throws ManifoldCFException {
        int i;
        Object[] docIDHashes = new String[documentDescriptions.length];
        Long[] ids = new Long[documentDescriptions.length];
        Long[] executeTimesNew = new Long[documentDescriptions.length];
        int[] actionsNew = new int[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
            executeTimesNew[i] = executeTimes[index];
            actionsNew[i] = actions[index];
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setRequeuedStatus(ids[i], executeTimesNew[i], actionsNew[i], -1L, -1);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction requeuing documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void requeueDocument(DocumentDescription documentDescription, Long executeTime, int action) throws ManifoldCFException {
        this.requeueDocumentMultiple(new DocumentDescription[]{documentDescription}, new Long[]{executeTime}, new int[]{action});
    }

    @Override
    public void resetDocumentMultiple(DocumentDescription[] documentDescriptions, long executeTime, int action, long failTime, int failCount) throws ManifoldCFException {
        int i;
        Long executeTimeLong = new Long(executeTime);
        Long[] ids = new Long[documentDescriptions.length];
        Object[] docIDHashes = new String[documentDescriptions.length];
        Long[] executeTimes = new Long[documentDescriptions.length];
        int[] actions = new int[documentDescriptions.length];
        long[] failTimes = new long[documentDescriptions.length];
        int[] failCounts = new int[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
            executeTimes[i] = executeTimeLong;
            actions[i] = action;
            long oldFailTime = documentDescriptions[index].getFailTime();
            if (oldFailTime == -1L) {
                oldFailTime = failTime;
            }
            failTimes[i] = oldFailTime;
            int oldFailCount = documentDescriptions[index].getFailRetryCount();
            if (oldFailCount == -1) {
                oldFailCount = failCount;
            } else if (failCount != -1 && --oldFailCount > failCount) {
                oldFailCount = failCount;
            }
            failCounts[i] = oldFailCount;
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setRequeuedStatus(ids[i], executeTimes[i], actions[i], failTimes == null ? -1L : failTimes[i], failCounts == null ? -1 : failCounts[i]);
                }
                this.database.performCommit();
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetCleaningDocumentMultiple(DocumentDescription[] documentDescriptions, long checkTime) throws ManifoldCFException {
        int i;
        Long[] ids = new Long[documentDescriptions.length];
        Object[] docIDHashes = new String[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setUncleaningStatus(ids[i], checkTime);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting cleaning documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetCleaningDocument(DocumentDescription documentDescription, long checkTime) throws ManifoldCFException {
        this.resetCleaningDocumentMultiple(new DocumentDescription[]{documentDescription}, checkTime);
    }

    @Override
    public void resetDeletingDocumentMultiple(DocumentDescription[] documentDescriptions, long checkTime) throws ManifoldCFException {
        int i;
        Long[] ids = new Long[documentDescriptions.length];
        Object[] docIDHashes = new String[documentDescriptions.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifierHash() + ":" + documentDescriptions[i].getJobID();
            indexMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        for (i = 0; i < docIDHashes.length; ++i) {
            Object docIDHash = docIDHashes[i];
            Integer x = (Integer)indexMap.remove(docIDHash);
            if (x == null) {
                throw new ManifoldCFException("Assertion failure: duplicate document identifier jobid/hash detected!");
            }
            int index = x;
            ids[i] = documentDescriptions[index].getID();
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                for (i = 0; i < ids.length; ++i) {
                    this.jobQueue.setUndeletingStatus(ids[i], checkTime);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting documents: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetDeletingDocument(DocumentDescription documentDescription, long checkTime) throws ManifoldCFException {
        this.resetDeletingDocumentMultiple(new DocumentDescription[]{documentDescription}, checkTime);
    }

    @Override
    public void resetDocument(DocumentDescription documentDescription, long executeTime, int action, long failTime, int failCount) throws ManifoldCFException {
        this.resetDocumentMultiple(new DocumentDescription[]{documentDescription}, executeTime, action, failTime, failCount);
    }

    protected static String[] eliminateDuplicates(String[] docIDHashes) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < docIDHashes.length) {
            String docIDHash = docIDHashes[i++];
            map.put(docIDHash, docIDHash);
        }
        Object[] rval = new String[map.size()];
        i = 0;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        Arrays.sort(rval);
        return rval;
    }

    protected static HashMap buildReorderMap(String[] originalIDHashes, String[] reorderedIDHashes) {
        HashMap<String, Integer> reorderSet = new HashMap<String, Integer>();
        for (int i = 0; i < reorderedIDHashes.length; ++i) {
            String reorderedIDHash = reorderedIDHashes[i];
            Integer position = new Integer(i);
            reorderSet.put(reorderedIDHash, position);
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int j = 0; j < originalIDHashes.length; ++j) {
            String originalIDHash = originalIDHashes[j];
            Integer position = (Integer)reorderSet.get(originalIDHash);
            if (position == null) continue;
            map.put(new Integer(j), position);
            reorderSet.remove(originalIDHash);
        }
        return map;
    }

    @Override
    public void retryStartup(JobStartRecord jsr, long failTime, int failCount) throws ManifoldCFException {
        Long jobID = jsr.getJobID();
        long oldFailTime = jsr.getFailTime();
        if (oldFailTime == -1L) {
            oldFailTime = failTime;
        }
        failTime = oldFailTime;
        int oldFailCount = jsr.getFailRetryCount();
        if (oldFailCount == -1) {
            oldFailCount = failCount;
        } else if (failCount != -1 && --oldFailCount > failCount) {
            oldFailCount = failCount;
        }
        failCount = oldFailCount;
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.retryStartup(jobID, jsr.getRequestMinimum(), failTime, failCount);
                this.database.performCommit();
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting job startup: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void retrySeeding(JobSeedingRecord jsr, long failTime, int failCount) throws ManifoldCFException {
        Long jobID = jsr.getJobID();
        long oldFailTime = jsr.getFailTime();
        if (oldFailTime == -1L) {
            oldFailTime = failTime;
        }
        failTime = oldFailTime;
        int oldFailCount = jsr.getFailRetryCount();
        if (oldFailCount == -1) {
            oldFailCount = failCount;
        } else if (failCount != -1 && --oldFailCount > failCount) {
            oldFailCount = failCount;
        }
        failCount = oldFailCount;
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.retrySeeding(jobID, failTime, failCount);
                this.database.performCommit();
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting job seeding: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void retryNotification(JobNotifyRecord jnr, long failTime, int failCount) throws ManifoldCFException {
        Long jobID = jnr.getJobID();
        long oldFailTime = jnr.getFailTime();
        if (oldFailTime == -1L) {
            oldFailTime = failTime;
        }
        failTime = oldFailTime;
        int oldFailCount = jnr.getFailRetryCount();
        if (oldFailCount == -1) {
            oldFailCount = failCount;
        } else if (failCount != -1 && --oldFailCount > failCount) {
            oldFailCount = failCount;
        }
        failCount = oldFailCount;
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.retryNotification(jobID, failTime, failCount);
                this.database.performCommit();
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting job notification: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void retryDeleteNotification(JobNotifyRecord jnr, long failTime, int failCount) throws ManifoldCFException {
        Long jobID = jnr.getJobID();
        long oldFailTime = jnr.getFailTime();
        if (oldFailTime == -1L) {
            oldFailTime = failTime;
        }
        failTime = oldFailTime;
        int oldFailCount = jnr.getFailRetryCount();
        if (oldFailCount == -1) {
            oldFailCount = failCount;
        } else if (failCount != -1 && --oldFailCount > failCount) {
            oldFailCount = failCount;
        }
        failCount = oldFailCount;
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.retryDeleteNotification(jobID, failTime, failCount);
                this.database.performCommit();
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting job notification: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void addDocumentsInitial(String processID, Long jobID, String[] legalLinkTypes, String[] docIDHashes, String[] docIDs, boolean overrideSchedule, int hopcountMethod, IPriorityCalculator[] documentPriorities, String[][] prereqEventNames) throws ManifoldCFException {
        if (docIDHashes.length == 0) {
            return;
        }
        String[] reorderedDocIDHashes = JobManager.eliminateDuplicates(docIDHashes);
        HashMap reorderMap = JobManager.buildReorderMap(docIDHashes, reorderedDocIDHashes);
        IPriorityCalculator[] reorderedDocumentPriorities = new IPriorityCalculator[reorderedDocIDHashes.length];
        String[][] reorderedDocumentPrerequisites = new String[reorderedDocIDHashes.length][];
        String[] reorderedDocumentIdentifiers = new String[reorderedDocIDHashes.length];
        for (int i = 0; i < docIDHashes.length; ++i) {
            Integer newPosition = (Integer)reorderMap.get(new Integer(i));
            if (newPosition == null) continue;
            reorderedDocumentPriorities[newPosition.intValue()] = documentPriorities[i];
            reorderedDocumentPrerequisites[newPosition.intValue()] = prereqEventNames != null ? prereqEventNames[i] : null;
            reorderedDocumentIdentifiers[newPosition.intValue()] = docIDs[i];
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to add " + Integer.toString(reorderedDocIDHashes.length) + " initial docs and hopcounts for job " + jobID.toString()));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start adding " + Integer.toString(reorderedDocIDHashes.length) + " initial docs and hopcounts for job " + jobID.toString()));
                }
                for (int z = 0; z < reorderedDocIDHashes.length; ++z) {
                    long executeTime;
                    String docIDHash = reorderedDocIDHashes[z];
                    IPriorityCalculator docPriority = reorderedDocumentPriorities[z];
                    String docID = reorderedDocumentIdentifiers[z];
                    String[] docPrereqs = reorderedDocumentPrerequisites[z];
                    StringBuilder sb = new StringBuilder("SELECT ");
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
                    clauseDescriptionArray[0] = new UnitaryClause("dochash", (Object)docIDHash);
                    clauseDescriptionArray[1] = new UnitaryClause("jobid", (Object)jobID);
                    sb.append("id").append(",").append("status").append(",").append("checktime").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray));
                    sb.append(" FOR UPDATE");
                    IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                    long l = executeTime = overrideSchedule ? 0L : -1L;
                    if (set.getRowCount() > 0) {
                        IResultRow row = set.getRow(0);
                        Long rowID = (Long)row.getValue("id");
                        int status = JobQueue.stringToStatus((String)row.getValue("status"));
                        Long checkTimeValue = (Long)row.getValue("checktime");
                        this.jobQueue.updateExistingRecordInitial(rowID, status, checkTimeValue, executeTime, docPriority, docPrereqs, processID);
                        continue;
                    }
                    this.jobQueue.insertNewRecordInitial(jobID, docIDHash, docID, docPriority, executeTime, docPrereqs, processID);
                }
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " initial docs for job " + jobID.toString()));
                }
                if (legalLinkTypes.length > 0) {
                    this.hopCount.recordSeedReferences(jobID, legalLinkTypes, reorderedDocIDHashes, hopcountMethod, processID);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " initial docs and hopcounts for job " + jobID.toString()));
                }
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction adding " + Integer.toString(reorderedDocIDHashes.length) + " initial docs for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void addRemainingDocumentsInitial(String processID, Long jobID, String[] legalLinkTypes, String[] docIDHashes, int hopcountMethod) throws ManifoldCFException {
        if (docIDHashes.length == 0) {
            return;
        }
        String[] reorderedDocIDHashes = JobManager.eliminateDuplicates(docIDHashes);
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to add " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString()));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start adding " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString()));
                }
                this.jobQueue.addRemainingDocumentsInitial(jobID, reorderedDocIDHashes, processID);
                if (legalLinkTypes.length > 0) {
                    this.hopCount.recordSeedReferences(jobID, legalLinkTypes, reorderedDocIDHashes, hopcountMethod, processID);
                }
                this.database.performCommit();
                if (!Logging.perf.isDebugEnabled()) continue;
                Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString()));
                continue;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction adding " + Integer.toString(reorderedDocIDHashes.length) + " remaining docs and hopcounts for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void doneDocumentsInitial(Long jobID, String[] legalLinkTypes, boolean isPartial, int hopcountMethod) throws ManifoldCFException {
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to finish initial docs and hopcounts for job " + jobID.toString()));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start finishing initial docs and hopcounts for job " + jobID.toString()));
                }
                this.jobQueue.doneDocumentsInitial(jobID, isPartial);
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to finish initial docs for job " + jobID.toString()));
                }
                if (legalLinkTypes.length > 0) {
                    this.hopCount.finishSeedReferences(jobID, legalLinkTypes, hopcountMethod);
                }
                this.database.performCommit();
                if (!Logging.perf.isDebugEnabled()) break;
                Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to finish initial docs and hopcounts for job " + jobID.toString()));
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction finishing initial docs and hopcounts for job " + jobID.toString() + ": " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean[] findHopCounts(Long jobID, String[] legalLinkTypes, String[] docIDHashes, String linkType, int limit, int hopcountMethod) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String[] getAllSeeds(Long jobID) throws ManifoldCFException {
        return this.jobQueue.getAllSeeds(jobID);
    }

    @Override
    public void addDocuments(String processID, Long jobID, String[] legalLinkTypes, String[] docIDHashes, String[] docIDs, String parentIdentifierHash, String relationshipType, int hopcountMethod, String[][] dataNames, Object[][][] dataValues, IPriorityCalculator[] documentPriorities, String[][] prereqEventNames) throws ManifoldCFException {
        int k;
        if (docIDs.length == 0) {
            return;
        }
        HashMap nameMap = new HashMap();
        for (k = 0; k < docIDHashes.length; ++k) {
            String docIDHash = docIDHashes[k];
            HashMap names = (HashMap)nameMap.get(docIDHash);
            if (names == null) {
                names = new HashMap();
                nameMap.put(docIDHash, names);
            }
            String[] nameList = dataNames[k];
            Object[][] dataList = dataValues[k];
            for (int z = 0; z < nameList.length; ++z) {
                String name = nameList[z];
                Object[] values = dataList[z];
                HashMap<String, Object> valueMap = (HashMap<String, Object>)names.get(name);
                if (valueMap == null) {
                    valueMap = new HashMap<String, Object>();
                    names.put(name, valueMap);
                }
                for (int y = 0; y < values.length; ++y) {
                    String valueHash = values[y] instanceof CharacterInput ? ((CharacterInput)values[y]).getHashValue() : ManifoldCF.hash((String)((String)values[y]));
                    valueMap.put(valueHash, values[y]);
                }
            }
        }
        String[] reorderedDocIDHashes = JobManager.eliminateDuplicates(docIDHashes);
        HashMap reorderMap = JobManager.buildReorderMap(docIDHashes, reorderedDocIDHashes);
        IPriorityCalculator[] reorderedDocumentPriorities = new IPriorityCalculator[reorderedDocIDHashes.length];
        String[][] reorderedDocumentPrerequisites = new String[reorderedDocIDHashes.length][];
        String[] reorderedDocumentIdentifiers = new String[reorderedDocIDHashes.length];
        boolean[] rval = new boolean[docIDHashes.length];
        for (int i = 0; i < docIDHashes.length; ++i) {
            Integer newPosition = (Integer)reorderMap.get(new Integer(i));
            if (newPosition != null) {
                reorderedDocumentPriorities[newPosition.intValue()] = documentPriorities[i];
                reorderedDocumentPrerequisites[newPosition.intValue()] = prereqEventNames != null ? prereqEventNames[i] : null;
                reorderedDocumentIdentifiers[newPosition.intValue()] = docIDs[i];
            }
            rval[i] = false;
        }
        dataNames = new String[reorderedDocIDHashes.length][];
        String[][][] dataHashValues = new String[reorderedDocIDHashes.length][][];
        dataValues = new Object[reorderedDocIDHashes.length][][];
        for (k = 0; k < reorderedDocIDHashes.length; ++k) {
            String docIDHash = reorderedDocIDHashes[k];
            HashMap names = (HashMap)nameMap.get(docIDHash);
            dataNames[k] = new String[names.size()];
            dataHashValues[k] = new String[names.size()][];
            dataValues[k] = new Object[names.size()][];
            Iterator iter = names.keySet().iterator();
            int z = 0;
            while (iter.hasNext()) {
                String dataName;
                dataNames[k][z] = dataName = (String)iter.next();
                HashMap values = (HashMap)names.get(dataName);
                dataHashValues[k][z] = new String[values.size()];
                dataValues[k][z] = new Object[values.size()];
                Iterator iter2 = values.keySet().iterator();
                int y = 0;
                while (iter2.hasNext()) {
                    String dataValueHash = (String)iter2.next();
                    Object dataValue = values.get(dataValueHash);
                    dataHashValues[k][z][y] = dataValueHash;
                    dataValues[k][z][y] = dataValue;
                    ++y;
                }
                ++z;
            }
        }
        long startTime = 0L;
        if (Logging.perf.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            Logging.perf.debug((Object)("Waiting to add " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier " + parentIdentifierHash));
        }
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start adding " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier hash " + parentIdentifierHash));
                }
                HashMap<String, JobqueueRecord> existingRows = new HashMap<String, JobqueueRecord>();
                for (int z = 0; z < reorderedDocIDHashes.length; ++z) {
                    String docIDHash = reorderedDocIDHashes[z];
                    StringBuilder sb = new StringBuilder("SELECT ");
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
                    clauseDescriptionArray[0] = new UnitaryClause("dochash", (Object)docIDHash);
                    clauseDescriptionArray[1] = new UnitaryClause("jobid", (Object)jobID);
                    sb.append("id").append(",").append("status").append(",").append("checktime").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray));
                    sb.append(" FOR UPDATE");
                    IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                    if (set.getRowCount() > 0) {
                        IResultRow row = set.getRow(0);
                        Long rowID = (Long)row.getValue("id");
                        int status = JobQueue.stringToStatus((String)row.getValue("status"));
                        Long checkTimeValue = (Long)row.getValue("checktime");
                        existingRows.put(docIDHash, new JobqueueRecord(rowID, status, checkTimeValue));
                        continue;
                    }
                    this.jobQueue.insertNewRecord(jobID, docIDHash, reorderedDocumentIdentifiers[z], reorderedDocumentPriorities[z], 0L, reorderedDocumentPrerequisites[z]);
                }
                boolean[] carrydownChangesSeen = this.carryDown.recordCarrydownDataMultiple(jobID, parentIdentifierHash, reorderedDocIDHashes, dataNames, dataHashValues, dataValues, processID);
                boolean[] hopcountChangesSeen = null;
                if (parentIdentifierHash != null && relationshipType != null) {
                    hopcountChangesSeen = this.hopCount.recordReferences(jobID, legalLinkTypes, parentIdentifierHash, reorderedDocIDHashes, relationshipType, hopcountMethod, processID);
                }
                boolean reactivateRemovedHopcountRecords = false;
                for (int z = 0; z < reorderedDocIDHashes.length; ++z) {
                    String docIDHash = reorderedDocIDHashes[z];
                    JobqueueRecord jr = (JobqueueRecord)existingRows.get(docIDHash);
                    if (jr == null) continue;
                    this.jobQueue.updateExistingRecord(jr.getRecordID(), jr.getStatus(), jr.getCheckTimeValue(), 0L, carrydownChangesSeen[z] || hopcountChangesSeen != null && hopcountChangesSeen[z], reorderedDocumentPriorities[z], reorderedDocumentPrerequisites[z]);
                    if (hopcountChangesSeen == null || !hopcountChangesSeen[z]) continue;
                    reactivateRemovedHopcountRecords = true;
                }
                if (reactivateRemovedHopcountRecords) {
                    this.jobQueue.reactivateHopcountRemovedRecords(jobID);
                }
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to add " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier hash " + parentIdentifierHash));
                }
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    sleepAmt = this.getRandomAmount();
                    if (!Logging.perf.isDebugEnabled()) continue;
                    Logging.perf.debug((Object)("Aborted transaction adding " + Integer.toString(reorderedDocIDHashes.length) + " docs and hopcounts for job " + jobID.toString() + " parent identifier hash " + parentIdentifierHash + ": " + e.getMessage() + "; sleeping for " + new Long(sleepAmt).toString() + " ms"), (Throwable)e);
                    continue;
                }
                throw e;
            }
            catch (RuntimeException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void addDocument(String processID, Long jobID, String[] legalLinkTypes, String docIDHash, String docID, String parentIdentifierHash, String relationshipType, int hopcountMethod, String[] dataNames, Object[][] dataValues, IPriorityCalculator priority, String[] prereqEventNames) throws ManifoldCFException {
        this.addDocuments(processID, jobID, legalLinkTypes, new String[]{docIDHash}, new String[]{docID}, parentIdentifierHash, relationshipType, hopcountMethod, new String[][]{dataNames}, new Object[][][]{dataValues}, new IPriorityCalculator[]{priority}, new String[][]{prereqEventNames});
    }

    @Override
    public void revertDocuments(Long jobID, String[] legalLinkTypes, String[] parentIdentifierHashes) throws ManifoldCFException {
        if (parentIdentifierHashes.length == 0) {
            return;
        }
        if (legalLinkTypes.length == 0) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                this.carryDown.revertRecords(jobID, parentIdentifierHashes);
                this.database.performCommit();
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            catch (RuntimeException e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
            }
        }
        long sleepAmt = 0L;
        this.database.beginTransaction(2);
        try {
            this.carryDown.revertRecords(jobID, parentIdentifierHashes);
            this.hopCount.revertParents(jobID, parentIdentifierHashes);
            this.database.performCommit();
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        catch (RuntimeException e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
            this.sleepFor(sleepAmt);
        }
    }

    @Override
    public DocumentDescription[] finishDocuments(Long jobID, String[] legalLinkTypes, String[] parentIdentifierHashes, int hopcountMethod) throws ManifoldCFException {
        DocumentDescription[] rval;
        block26: {
            if (parentIdentifierHashes.length == 0) {
                return new DocumentDescription[0];
            }
            if (legalLinkTypes.length == 0) {
                while (true) {
                    long sleepAmt = 0L;
                    this.database.beginTransaction(2);
                    try {
                        rval = this.calculateAffectedRestoreCarrydownChildren(jobID, parentIdentifierHashes);
                        this.carryDown.restoreRecords(jobID, parentIdentifierHashes);
                        this.database.performCommit();
                        break block26;
                    }
                    catch (ManifoldCFException e) {
                        this.database.signalRollback();
                        if (e.getErrorCode() == 6) {
                            if (Logging.perf.isDebugEnabled()) {
                                Logging.perf.debug((Object)("Aborted transaction finishing " + Integer.toString(parentIdentifierHashes.length) + " doc carrydown records for job " + jobID.toString() + ": " + e.getMessage()));
                            }
                            sleepAmt = this.getRandomAmount();
                            continue;
                        }
                        throw e;
                    }
                    catch (Error e) {
                        this.database.signalRollback();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.database.signalRollback();
                        throw e;
                    }
                    finally {
                        this.database.endTransaction();
                        this.sleepFor(sleepAmt);
                        continue;
                    }
                    break;
                }
            }
            long startTime = 0L;
            if (Logging.perf.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                Logging.perf.debug((Object)("Waiting to finish " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString()));
            }
            while (true) {
                long sleepAmt = 0L;
                this.database.beginTransaction(2);
                try {
                    rval = this.calculateAffectedRestoreCarrydownChildren(jobID, parentIdentifierHashes);
                    this.carryDown.restoreRecords(jobID, parentIdentifierHashes);
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Waited " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to start finishing " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString()));
                    }
                    this.hopCount.finishParents(jobID, legalLinkTypes, parentIdentifierHashes, hopcountMethod);
                    this.database.performCommit();
                    if (!Logging.perf.isDebugEnabled()) break;
                    Logging.perf.debug((Object)("Took " + new Long(System.currentTimeMillis() - startTime).toString() + " ms to finish " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString()));
                }
                catch (ManifoldCFException e) {
                    this.database.signalRollback();
                    if (e.getErrorCode() == 6) {
                        if (Logging.perf.isDebugEnabled()) {
                            Logging.perf.debug((Object)("Aborted transaction finishing " + Integer.toString(parentIdentifierHashes.length) + " doc hopcounts for job " + jobID.toString() + ": " + e.getMessage()));
                        }
                        sleepAmt = this.getRandomAmount();
                        continue;
                    }
                    throw e;
                }
                catch (Error e) {
                    this.database.signalRollback();
                    throw e;
                }
                catch (RuntimeException e) {
                    this.database.signalRollback();
                    throw e;
                }
                finally {
                    this.database.endTransaction();
                    this.sleepFor(sleepAmt);
                    continue;
                }
                break;
            }
        }
        return rval;
    }

    protected DocumentDescription[] calculateAffectedRestoreCarrydownChildren(Long jobID, String[] parentIDHashes) throws ManifoldCFException {
        HashMap resultHash = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        int maxCount = this.database.getMaxOrClause();
        int i = 0;
        int z = 0;
        while (i < parentIDHashes.length) {
            if (z == maxCount) {
                this.processParentHashSet(jobID, resultHash, list);
                list.clear();
                z = 0;
            }
            list.add(parentIDHashes[i]);
            ++i;
            ++z;
        }
        if (z > 0) {
            this.processParentHashSet(jobID, resultHash, list);
        }
        DocumentDescription[] rval = new DocumentDescription[resultHash.size()];
        i = 0;
        for (Long id : resultHash.keySet()) {
            DocumentDescription dd = (DocumentDescription)resultHash.get(id);
            rval[i++] = dd;
        }
        return rval;
    }

    protected void processParentHashSet(Long jobID, HashMap resultHash, ArrayList list) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList<String> newlist = new ArrayList<String>();
        sb.append("t0.").append("id").append(",").append("t0.").append("dochash").append(",").append("t0.").append("docid").append(" FROM ").append(this.carryDown.getTableName()).append(" t1, ").append(this.jobQueue.getTableName()).append(" t0 WHERE ");
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
        clauseDescriptionArray[0] = new UnitaryClause("t1." + "jobid", (Object)jobID);
        clauseDescriptionArray[1] = new MultiClause("t1." + "parentidhash", (List)list);
        sb.append(this.database.buildConjunctionClause(newlist, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
        clauseDescriptionArray2[0] = new JoinClause("t0." + "dochash", "t1." + "childidhash");
        clauseDescriptionArray2[1] = new JoinClause("t0." + "jobid", "t1." + "jobid");
        sb.append(this.database.buildConjunctionClause(newlist, clauseDescriptionArray2)).append(" AND ");
        sb.append("t1.").append("isnew").append("=?");
        newlist.add(Carrydown.statusToString(0));
        IResultSet set = this.database.performQuery(sb.toString(), newlist, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long id = (Long)row.getValue("id");
            String documentIdentifierHash = (String)row.getValue("dochash");
            String documentIdentifier = (String)row.getValue("docid");
            resultHash.put(id, new DocumentDescription(id, jobID, documentIdentifierHash, documentIdentifier));
        }
    }

    @Override
    public boolean beginEventSequence(String processID, String eventName) throws ManifoldCFException {
        try {
            this.eventManager.createEvent(eventName, processID);
            return true;
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 6) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void completeEventSequence(String eventName) throws ManifoldCFException {
        this.eventManager.destroyEvent(eventName);
    }

    @Override
    public void carrydownChangeDocumentMultiple(DocumentDescription[] documentDescriptions, IPriorityCalculator[] docPriorities) throws ManifoldCFException {
        if (documentDescriptions.length == 0) {
            return;
        }
        HashMap<Object, Integer> docHashMap = new HashMap<Object, Integer>();
        Object[] docIDHashes = new String[documentDescriptions.length];
        for (int i = 0; i < documentDescriptions.length; ++i) {
            docIDHashes[i] = documentDescriptions[i].getDocumentIdentifier() + ":" + documentDescriptions[i].getJobID();
            docHashMap.put(docIDHashes[i], new Integer(i));
        }
        Arrays.sort(docIDHashes);
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                int originalIndex;
                Object docIDHash;
                int j;
                HashMap<Object, JobqueueRecord> existingRows = new HashMap<Object, JobqueueRecord>();
                for (j = 0; j < docIDHashes.length; ++j) {
                    docIDHash = docIDHashes[j];
                    originalIndex = (Integer)docHashMap.get(docIDHash);
                    DocumentDescription dd = documentDescriptions[originalIndex];
                    StringBuilder sb = new StringBuilder("SELECT ");
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    clauseDescriptionArray[0] = new UnitaryClause("id", (Object)dd.getID());
                    sb.append("id").append(",").append("status").append(",").append("checktime").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                    IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                    if (set.getRowCount() <= 0) continue;
                    IResultRow row = set.getRow(0);
                    Long rowID = (Long)row.getValue("id");
                    int status = JobQueue.stringToStatus((String)row.getValue("status"));
                    Long checkTimeValue = (Long)row.getValue("checktime");
                    existingRows.put(docIDHash, new JobqueueRecord(rowID, status, checkTimeValue));
                }
                while (j < docIDHashes.length) {
                    docIDHash = docIDHashes[j];
                    originalIndex = (Integer)docHashMap.get(docIDHash);
                    JobqueueRecord jr = (JobqueueRecord)existingRows.get(docIDHash);
                    if (jr != null) {
                        this.jobQueue.updateExistingRecord(jr.getRecordID(), jr.getStatus(), jr.getCheckTimeValue(), 0L, true, docPriorities[originalIndex], null);
                    }
                    ++j;
                }
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction handling " + Integer.toString(docIDHashes.length) + " carrydown changes: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void carrydownChangeDocument(DocumentDescription documentDescription, IPriorityCalculator docPriority) throws ManifoldCFException {
        this.carrydownChangeDocumentMultiple(new DocumentDescription[]{documentDescription}, new IPriorityCalculator[]{docPriority});
    }

    protected long getRandomAmount() {
        return this.database.getSleepAmt();
    }

    protected void sleepFor(long amt) throws ManifoldCFException {
        this.database.sleepFor(amt);
    }

    @Override
    public String[] retrieveParentData(Long jobID, String docIDHash, String dataName) throws ManifoldCFException {
        return this.carryDown.getDataValues(jobID, docIDHash, dataName);
    }

    @Override
    public CharacterInput[] retrieveParentDataAsFiles(Long jobID, String docIDHash, String dataName) throws ManifoldCFException {
        return this.carryDown.getDataValuesAsFiles(jobID, docIDHash, dataName);
    }

    @Override
    public void startJobs(long currentTime, List<Long> unwaitList) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList<String> list = new ArrayList<String>();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                Object[] objectArray = new Object[5];
                objectArray[0] = Jobs.statusToString(0);
                objectArray[1] = Jobs.statusToString(5);
                objectArray[2] = Jobs.statusToString(6);
                objectArray[3] = Jobs.statusToString(13);
                objectArray[4] = Jobs.statusToString(14);
                clauseDescriptionArray[0] = new MultiClause("status", objectArray);
                sb.append("id").append(",").append("lasttime").append(",").append("status").append(",").append("startmethod").append(",").append("connectionname").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ").append("startmethod").append("!=? FOR UPDATE");
                list.add(Jobs.startMethodToString(2));
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                Long[] jobIDSet = new Long[set.getRowCount()];
                int i = 0;
                while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i);
                    int n = i++;
                    jobIDSet[n] = (Long)row.getValue("id");
                }
                ScheduleRecord[][] srSet = this.jobs.readScheduleRecords(jobIDSet);
                i = 0;
                while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    int startMethod = Jobs.stringToStartMethod((String)row.getValue("startmethod"));
                    String connectionName = (String)row.getValue("connectionname");
                    ScheduleRecord[] thisSchedule = srSet[i++];
                    long startInterval = (Long)row.getValue("lasttime") + 1L;
                    if (Logging.jobs.isDebugEnabled()) {
                        Logging.jobs.debug((Object)("Checking if job " + jobID.toString() + " needs to be started; it was last checked at " + new Long(startInterval).toString() + ", and now it is " + new Long(currentTime).toString()));
                    }
                    Long matchTime = null;
                    Long duration = null;
                    boolean requestMinimum = false;
                    for (int l = 0; l < thisSchedule.length; ++l) {
                        Long thisMatchTime;
                        long trialStart;
                        long trialStartInterval = startInterval;
                        ScheduleRecord sr = thisSchedule[l];
                        Long thisDuration = sr.getDuration();
                        if (startMethod == 1 && thisDuration != null && (trialStart = currentTime - thisDuration) < trialStartInterval) {
                            trialStartInterval = trialStart;
                        }
                        if ((thisMatchTime = JobManager.checkTimeMatch(trialStartInterval, currentTime, sr.getDayOfWeek(), sr.getDayOfMonth(), sr.getMonthOfYear(), sr.getYear(), sr.getHourOfDay(), sr.getMinutesOfHour(), sr.getTimezone(), thisDuration)) == null) {
                            if (!Logging.jobs.isDebugEnabled()) continue;
                            Logging.jobs.debug((Object)(" No time match found within interval " + new Long(trialStartInterval).toString() + " to " + new Long(currentTime).toString()));
                            continue;
                        }
                        if (Logging.jobs.isDebugEnabled()) {
                            Logging.jobs.debug((Object)(" Time match FOUND within interval " + new Long(trialStartInterval).toString() + " to " + new Long(currentTime).toString()));
                        }
                        if (matchTime != null && thisDuration != null && (duration == null || thisMatchTime + thisDuration <= matchTime + duration)) continue;
                        matchTime = thisMatchTime;
                        duration = thisDuration;
                        requestMinimum = sr.getRequestMinimum();
                    }
                    if (matchTime == null) {
                        this.jobs.updateLastTime(jobID, currentTime);
                        continue;
                    }
                    int status = Jobs.stringToStatus(row.getValue("status").toString());
                    Long windowEnd = null;
                    if (duration != null) {
                        windowEnd = new Long(matchTime + duration);
                    }
                    Logging.jobs.info((Object)("Job '" + jobID + "' is within run window at " + new Long(currentTime).toString() + " ms. (which starts at " + matchTime.toString() + " ms." + (duration == null ? "" : " and goes for " + duration.toString() + " ms.") + ")"));
                    switch (status) {
                        case 0: {
                            this.jobs.startJob(jobID, windowEnd, requestMinimum);
                            this.jobQueue.clearFailTimes(jobID);
                            Logging.jobs.info((Object)("Signalled for job start for job " + jobID));
                            break;
                        }
                        case 5: {
                            unwaitList.add(jobID);
                            this.jobs.unwaitJob(jobID, 16, windowEnd);
                            this.jobQueue.clearFailTimes(jobID);
                            Logging.jobs.info((Object)("Un-waited job " + jobID));
                            break;
                        }
                        case 6: {
                            unwaitList.add(jobID);
                            this.jobs.unwaitJob(jobID, 17, windowEnd);
                            this.jobQueue.clearFailTimes(jobID);
                            Logging.jobs.info((Object)("Un-waited job " + jobID));
                            break;
                        }
                        case 13: {
                            unwaitList.add(jobID);
                            this.jobs.unwaitJob(jobID, 11, windowEnd);
                            Logging.jobs.info((Object)("Un-waited (but still paused) job " + jobID));
                            break;
                        }
                        case 14: {
                            unwaitList.add(jobID);
                            this.jobs.unwaitJob(jobID, 12, windowEnd);
                            Logging.jobs.info((Object)("Un-waited (but still paused) job " + jobID));
                            break;
                        }
                        case 9: {
                            unwaitList.add(jobID);
                            this.jobs.unwaitJob(jobID, 7, windowEnd);
                            Logging.jobs.info((Object)("Un-waited (but still paused) job " + jobID));
                            break;
                        }
                        case 10: {
                            unwaitList.add(jobID);
                            this.jobs.unwaitJob(jobID, 8, windowEnd);
                            Logging.jobs.info((Object)("Un-waited (but still paused) job " + jobID));
                            break;
                        }
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction resetting for restart: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void waitJobs(long currentTime, List<Long> waitList) throws ManifoldCFException {
        this.database.beginTransaction();
        try {
            StringBuilder sb = new StringBuilder("SELECT ");
            ArrayList<Long> list = new ArrayList<Long>();
            ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
            Object[] objectArray = new Object[6];
            objectArray[0] = Jobs.statusToString(1);
            objectArray[1] = Jobs.statusToString(2);
            objectArray[2] = Jobs.statusToString(40);
            objectArray[3] = Jobs.statusToString(41);
            objectArray[4] = Jobs.statusToString(11);
            objectArray[5] = Jobs.statusToString(12);
            clauseDescriptionArray[0] = new MultiClause("status", objectArray);
            sb.append("id").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ").append("windowend").append("<? FOR UPDATE");
            list.add(new Long(currentTime));
            IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                Long jobID = (Long)row.getValue("id");
                waitList.add(jobID);
                int status = Jobs.stringToStatus(row.getValue("status").toString());
                switch (status) {
                    case 1: 
                    case 40: {
                        this.jobs.waitJob(jobID, 3);
                        Logging.jobs.info((Object)("Job " + jobID + " now in 'wait' state due to window end"));
                        break;
                    }
                    case 2: 
                    case 41: {
                        this.jobs.waitJob(jobID, 4);
                        Logging.jobs.info((Object)("Job " + jobID + " now in 'wait' state due to window end"));
                        break;
                    }
                    case 11: {
                        this.jobs.waitJob(jobID, 13);
                        Logging.jobs.info((Object)("Job " + jobID + " now in 'wait paused' state due to window end"));
                        break;
                    }
                    case 12: {
                        this.jobs.waitJob(jobID, 14);
                        Logging.jobs.info((Object)("Job " + jobID + " now in 'wait paused' state due to window end"));
                        break;
                    }
                    case 7: {
                        this.jobs.waitJob(jobID, 9);
                        Logging.jobs.info((Object)("Job " + jobID + " now in 'wait paused' state due to window end"));
                        break;
                    }
                    case 8: {
                        this.jobs.waitJob(jobID, 10);
                        Logging.jobs.info((Object)("Job " + jobID + " now in 'wait paused' state due to window end"));
                        break;
                    }
                }
            }
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
    }

    @Override
    public void resetJobSchedule(Long jobID) throws ManifoldCFException {
    }

    protected static Long checkTimeMatch(long startTime, long currentTimestamp, EnumeratedValues daysOfWeek, EnumeratedValues daysOfMonth, EnumeratedValues months, EnumeratedValues years, EnumeratedValues hours, EnumeratedValues minutes, String timezone, Long duration) {
        Calendar c = timezone == null ? Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT) : Calendar.getInstance(TimeZone.getTimeZone(timezone), Locale.ROOT);
        c.setTimeInMillis(startTime);
        while (c.getTimeInMillis() < currentTimestamp) {
            int amtToAdd;
            int amtToAdd2;
            int x = c.get(14);
            if (x != c.getMinimum(14)) {
                amtToAdd2 = c.getLeastMaximum(14) + 1 - x;
                if (amtToAdd2 < 1) {
                    amtToAdd2 = 1;
                }
                c.add(14, amtToAdd2);
                continue;
            }
            x = c.get(13);
            if (x != c.getMinimum(13)) {
                amtToAdd2 = c.getLeastMaximum(13) + 1 - x;
                if (amtToAdd2 < 1) {
                    amtToAdd2 = 1;
                }
                c.add(13, amtToAdd2);
                continue;
            }
            boolean startedToCareYet = false;
            x = c.get(12);
            if (minutes == null) {
                if (x != c.getMinimum(12)) {
                    amtToAdd = c.getLeastMaximum(12) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(12, amtToAdd);
                    continue;
                }
            } else {
                if (!minutes.checkValue(x - c.getMinimum(12))) {
                    c.add(12, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(11);
            if (hours == null) {
                if (!startedToCareYet && x != c.getMinimum(11)) {
                    amtToAdd = c.getLeastMaximum(11) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(11, amtToAdd);
                    continue;
                }
            } else {
                if (!hours.checkValue(x - c.getMinimum(11))) {
                    c.add(11, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(7);
            if (daysOfWeek != null) {
                if (!daysOfWeek.checkValue(x - c.getMinimum(7))) {
                    c.add(7, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(5);
            if (daysOfMonth == null) {
                if (!startedToCareYet && x != c.getMinimum(5)) {
                    amtToAdd = c.getLeastMaximum(5) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(5, amtToAdd);
                    continue;
                }
            } else {
                if (!daysOfMonth.checkValue(x - c.getMinimum(5))) {
                    c.add(5, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(2);
            if (months == null) {
                if (!startedToCareYet && x != c.getMinimum(2)) {
                    amtToAdd = c.getLeastMaximum(2) + 1 - x;
                    if (amtToAdd < 1) {
                        amtToAdd = 1;
                    }
                    c.add(2, amtToAdd);
                    continue;
                }
            } else {
                if (!months.checkValue(x - c.getMinimum(2))) {
                    c.add(2, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            x = c.get(1);
            if (years != null) {
                if (!years.checkValue(x)) {
                    c.add(1, 1);
                    continue;
                }
                startedToCareYet = true;
            }
            if (duration != null && c.getTimeInMillis() + duration <= currentTimestamp) {
                c.add(14, c.getLeastMaximum(14));
                continue;
            }
            return new Long(c.getTimeInMillis());
        }
        return null;
    }

    @Override
    public void manualStart(Long jobID) throws ManifoldCFException {
        this.manualStart(jobID, false);
    }

    @Override
    public void manualStart(Long jobID, boolean requestMinimum) throws ManifoldCFException {
        this.database.beginTransaction();
        try {
            StringBuilder sb = new StringBuilder("SELECT ");
            ArrayList list = new ArrayList();
            ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
            clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
            sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
            IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
            if (set.getRowCount() < 1) {
                throw new ManifoldCFException("No such job: " + jobID);
            }
            IResultRow row = set.getRow(0);
            int status = Jobs.stringToStatus(row.getValue("status").toString());
            if (status != 0) {
                throw new ManifoldCFException("Job " + jobID + " is already running");
            }
            IJobDescription jobDescription = this.jobs.load(jobID, true);
            Logging.jobs.info((Object)("Manually starting job " + jobID));
            this.jobs.startJob(jobID, null, requestMinimum);
            this.jobQueue.clearFailTimes(jobID);
            Logging.jobs.info((Object)("Manual job start signal for job " + jobID + " successfully sent"));
        }
        catch (ManifoldCFException e) {
            this.database.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.database.signalRollback();
            throw e;
        }
        finally {
            this.database.endTransaction();
        }
    }

    @Override
    public void noteJobDeleteStarted(Long jobID, long startTime) throws ManifoldCFException {
        this.jobs.noteJobDeleteStarted(jobID, startTime);
        Logging.jobs.info((Object)("Job " + jobID + " delete is now started"));
    }

    @Override
    public void noteJobStarted(Long jobID, long startTime, String seedingVersion) throws ManifoldCFException {
        this.jobs.noteJobStarted(jobID, startTime, seedingVersion);
        Logging.jobs.info((Object)("Job " + jobID + " is now started"));
    }

    @Override
    public void noteJobSeeded(Long jobID, String seedingVersion) throws ManifoldCFException {
        this.jobs.noteJobSeeded(jobID, seedingVersion);
        Logging.jobs.info((Object)("Job " + jobID + " has been successfully reseeded"));
    }

    @Override
    public void prepareDeleteScan(Long jobID) throws ManifoldCFException {
        TrackerClass.notePrecommit();
        this.jobQueue.prepareDeleteScan(jobID);
        TrackerClass.noteCommit();
    }

    @Override
    public void prepareJobScan(Long jobID, String[] legalLinkTypes, int hopcountMethod, int connectorModel, boolean continuousJob, boolean fromBeginningOfTime, boolean requestMinimum) throws ManifoldCFException {
        this.jobQueue.resetPendingDocumentSchedules(jobID);
        this.jobQueue.prioritizeQueuedDocuments(jobID);
        if (connectorModel == 3) {
            if (fromBeginningOfTime) {
                Logging.jobs.info((Object)("Preparing MODEL_ADD_CHANGE_DELETE job " + jobID + " for run: fromBeginningOfTime=true, so queueAllExisting invoked"));
                this.queueAllExisting(jobID, legalLinkTypes);
            }
            Logging.jobs.info((Object)("Preparing MODEL_ADD_CHANGE_DELETE job " + jobID + " for run: fromBeginningOfTime=false, so nothing needed"));
            return;
        }
        if (connectorModel == 11) {
            if (fromBeginningOfTime) {
                Logging.jobs.info((Object)("Preparing MODEL_CHAINED_ADD_CHANGE_DELETE job " + jobID + " for run: fromBeginningOfTime=true, so queueAllExisting invoked"));
                this.queueAllExisting(jobID, legalLinkTypes);
            } else {
                Logging.jobs.info((Object)("Preparing MODEL_CHAINED_ADD_CHANGE_DELETE job " + jobID + " for run: fromBeginningOfTime=false, so preparePartialScan invoked"));
                this.jobQueue.preparePartialScan(jobID);
            }
            return;
        }
        if (requestMinimum && connectorModel != 0 && !fromBeginningOfTime) {
            if (connectorModel == 9 || connectorModel == 10) {
                Logging.jobs.info((Object)("Preparing minimal MODEL_CHAINED_* job " + jobID + " for run: preparePartialScan invoked"));
                this.jobQueue.preparePartialScan(jobID);
            }
            Logging.jobs.info((Object)("Preparing minimal non-MODEL_CHAINED_* job " + jobID + " for run: nothing needed"));
            return;
        }
        if (!continuousJob && connectorModel != 4 && (connectorModel == 0 || fromBeginningOfTime)) {
            Logging.jobs.info((Object)("Preparing non-continuous non-partial, either MODEL_ALL or fromBeginningOfTime, " + jobID + " for run: prepareFullScan"));
            this.prepareFullScan(jobID, legalLinkTypes, hopcountMethod);
        } else {
            Logging.jobs.info((Object)("Preparing incremental scan for " + jobID + ": prepareIncrementalScan"));
            this.jobQueue.prepareIncrementalScan(jobID);
        }
    }

    protected void queueAllExisting(Long jobID, String[] legalLinkTypes) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                if (legalLinkTypes.length > 0) {
                    this.jobQueue.reactivateHopcountRemovedRecords(jobID);
                }
                this.jobQueue.queueAllExisting(jobID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction during queueAllExisting: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    protected void prepareFullScan(Long jobID, String[] legalLinkTypes, int hopcountMethod) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction(2);
            try {
                if (legalLinkTypes.length > 0) {
                    ArrayList list = new ArrayList();
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[2];
                    objectArray[0] = JobQueue.statusToString(0);
                    objectArray[1] = JobQueue.statusToString(12);
                    clauseDescriptionArray[0] = new MultiClause("t99." + "status", objectArray);
                    String query = this.database.buildConjunctionClause(list, clauseDescriptionArray);
                    this.hopCount.deleteMatchingDocuments(jobID, legalLinkTypes, this.jobQueue.getTableName() + " t99", "t99." + "dochash", "t99." + "jobid", query, list, hopcountMethod);
                }
                this.jobQueue.prepareFullScan(jobID);
                TrackerClass.notePrecommit();
                this.database.performCommit();
                TrackerClass.noteCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction preparing full scan: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void manualAbort(Long jobID) throws ManifoldCFException {
        Logging.jobs.info((Object)("Manually aborting job " + jobID));
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.abortJob(jobID, null);
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction aborting job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)("Job " + jobID + " abort signal successfully sent"));
    }

    @Override
    public void manualAbortRestart(Long jobID, boolean requestMinimum) throws ManifoldCFException {
        Logging.jobs.info((Object)("Manually restarting job " + jobID));
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.abortRestartJob(jobID, requestMinimum);
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction restarting job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)("Job " + jobID + " restart signal successfully sent"));
    }

    @Override
    public void manualAbortRestart(Long jobID) throws ManifoldCFException {
        this.manualAbortRestart(jobID, false);
    }

    @Override
    public boolean errorAbort(Long jobID, String errorText) throws ManifoldCFException {
        boolean rval;
        Logging.jobs.info((Object)("Aborting job " + jobID + " due to error '" + errorText + "'"));
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                rval = this.jobs.abortJob(jobID, errorText);
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction aborting job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)("Job " + jobID + " abort signal successfully sent"));
        return rval;
    }

    @Override
    public void pauseJob(Long jobID) throws ManifoldCFException {
        Logging.jobs.info((Object)("Manually pausing job " + jobID));
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.pauseJob(jobID);
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction pausing job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)("Job " + jobID + " successfully paused"));
    }

    @Override
    public void restartJob(Long jobID) throws ManifoldCFException {
        Logging.jobs.info((Object)("Manually restarting paused job " + jobID));
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobs.restartJob(jobID);
                this.jobQueue.clearFailTimes(jobID);
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction restarting pausing job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
        Logging.jobs.info((Object)("Job " + jobID + " successfully restarted"));
    }

    @Override
    public JobSeedingRecord[] getJobsReadyForSeeding(String processID, long currentTime) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList<Object> list = new ArrayList<Object>();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("status", (Object)Jobs.statusToString(1));
                sb.append("id").append(",").append("seedingversion").append(",").append("failtime").append(",").append("failcount").append(",").append("reseedinterval").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ").append("type").append("=? AND ").append("(").append("reseedtime").append(" IS NULL OR ").append("reseedtime").append("<=?)").append(" FOR UPDATE");
                list.add(Jobs.typeToString(0));
                list.add(new Long(currentTime));
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                JobSeedingRecord[] rval = new JobSeedingRecord[set.getRowCount()];
                for (int i = 0; i < rval.length; ++i) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    String seedingVersionString = (String)row.getValue("seedingversion");
                    Long r = (Long)row.getValue("reseedinterval");
                    Long reseedTime = r != null ? new Long(currentTime + r) : null;
                    Long failTimeLong = (Long)row.getValue("failtime");
                    Long failRetryCountLong = (Long)row.getValue("failcount");
                    long failTime = failTimeLong == null ? -1L : failTimeLong;
                    int failRetryCount = failRetryCountLong == null ? -1 : (int)failRetryCountLong.longValue();
                    this.jobs.writeTransientStatus(jobID, 2, reseedTime, processID);
                    Logging.jobs.info((Object)("Marked job " + jobID + " for seeding"));
                    rval[i] = new JobSeedingRecord(jobID, seedingVersionString, failTime, failRetryCount);
                }
                this.database.performCommit();
                JobSeedingRecord[] jobSeedingRecordArray = rval;
                return jobSeedingRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for seeding: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public JobDeleteRecord[] getJobsReadyForDeleteCleanup(String processID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("status", (Object)Jobs.statusToString(25));
                sb.append("id").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                JobDeleteRecord[] rval = new JobDeleteRecord[set.getRowCount()];
                for (int i = 0; i < rval.length; ++i) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    this.jobs.writeTransientStatus(jobID, 36, processID);
                    Logging.jobs.info((Object)("Marked job " + jobID + " for delete startup"));
                    rval[i] = new JobDeleteRecord(jobID);
                }
                this.database.performCommit();
                JobDeleteRecord[] jobDeleteRecordArray = rval;
                return jobDeleteRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for startup: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public JobStartRecord[] getJobsReadyForStartup(String processID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                Object[] objectArray = new Object[2];
                objectArray[0] = Jobs.statusToString(23);
                objectArray[1] = Jobs.statusToString(24);
                clauseDescriptionArray[0] = new MultiClause("status", objectArray);
                sb.append("id").append(",").append("failtime").append(",").append("failcount").append(",").append("seedingversion").append(",").append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                JobStartRecord[] rval = new JobStartRecord[set.getRowCount()];
                for (int i = 0; i < rval.length; ++i) {
                    boolean requestMinimum;
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    String seedingVersionString = (String)row.getValue("seedingversion");
                    int status = Jobs.stringToStatus((String)row.getValue("status"));
                    Long failTimeLong = (Long)row.getValue("failtime");
                    Long failRetryCountLong = (Long)row.getValue("failcount");
                    long failTime = failTimeLong == null ? -1L : failTimeLong;
                    int failRetryCount = failRetryCountLong == null ? -1 : (int)failRetryCountLong.longValue();
                    boolean bl = requestMinimum = status == 24;
                    this.jobs.writeTransientStatus(jobID, requestMinimum ? 20 : 19, processID);
                    Logging.jobs.info((Object)("Marked job " + jobID + " for startup"));
                    rval[i] = new JobStartRecord(jobID, seedingVersionString, requestMinimum, failTime, failRetryCount);
                }
                this.database.performCommit();
                JobStartRecord[] jobStartRecordArray = rval;
                return jobStartRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for startup: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void inactivateJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
                sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 34: {
                        this.jobs.notificationComplete(jobID);
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted clearing notification state for job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void removeJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
                sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                if (set.getRowCount() == 0) {
                    return;
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 39: {
                        ManifoldCF.noteConfigurationChange();
                        this.jobQueue.deleteAllJobRecords(jobID);
                        this.carryDown.deleteOwner(jobID);
                        this.hopCount.deleteOwner(jobID);
                        this.jobs.delete(jobID);
                        Logging.jobs.info((Object)("Removed job " + jobID));
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted clearing delete notification state for job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetStartDeleteJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
                sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 36: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'ReadyForDelete' state"));
                        this.jobs.writePermanentStatus(jobID, 25, true);
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted resetting start delete job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetNotifyJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
                sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 34: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'ReadyForNotify' state"));
                        this.jobs.writePermanentStatus(jobID, 33, true);
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted resetting notify job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetDeleteNotifyJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
                sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 39: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'ReadyForDeleteNotify' state"));
                        this.jobs.writePermanentStatus(jobID, 38, true);
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted resetting delete notify job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetStartupJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
                sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 19: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'ReadyForStartup' state"));
                        this.jobs.writePermanentStatus(jobID, 23, true);
                        break;
                    }
                    case 20: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'ReadyForStartupMinimal' state"));
                        this.jobs.writePermanentStatus(jobID, 24, true);
                        break;
                    }
                    case 31: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " to 'AbortingForRestart' state"));
                        this.jobs.writePermanentStatus(jobID, 27, true);
                        break;
                    }
                    case 32: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " to 'AbortingForRestartMinimal' state"));
                        this.jobs.writePermanentStatus(jobID, 28, true);
                        break;
                    }
                    case 18: 
                    case 23: 
                    case 24: 
                    case 27: 
                    case 28: {
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted resetting startup job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void resetSeedJob(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("id", (Object)jobID);
                sb.append("status").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                if (set.getRowCount() == 0) {
                    throw new ManifoldCFException("No such job: " + jobID);
                }
                IResultRow row = set.getRow(0);
                int status = Jobs.stringToStatus((String)row.getValue("status"));
                switch (status) {
                    case 41: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'Active_Uninstalled' state"));
                        this.jobs.writePermanentStatus(jobID, 40);
                        break;
                    }
                    case 2: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'Active' state"));
                        this.jobs.writePermanentStatus(jobID, 1);
                        break;
                    }
                    case 6: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'ActiveWait' state"));
                        this.jobs.writePermanentStatus(jobID, 5);
                        break;
                    }
                    case 12: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'Paused' state"));
                        this.jobs.writePermanentStatus(jobID, 11);
                        break;
                    }
                    case 14: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'PausedWait' state"));
                        this.jobs.writePermanentStatus(jobID, 13);
                        break;
                    }
                    case 29: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'AbortingForRestart' state"));
                        this.jobs.writePermanentStatus(jobID, 27);
                        break;
                    }
                    case 30: {
                        Logging.jobs.info((Object)("Setting job " + jobID + " back to 'AbortingForRestartMinimal' state"));
                        this.jobs.writePermanentStatus(jobID, 28);
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 11: 
                    case 13: 
                    case 18: 
                    case 27: 
                    case 28: 
                    case 40: {
                        break;
                    }
                    default: {
                        throw new ManifoldCFException("Unexpected job status: " + Integer.toString(status));
                    }
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted resetting seeding job: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void deleteJobsReadyForDelete() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("status", (Object)Jobs.statusToString(35));
                sb.append("id").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                int i = 0;
                while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i++);
                    Long jobID = (Long)row.getValue("id");
                    list.clear();
                    sb = new StringBuilder("SELECT ");
                    ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
                    clauseDescriptionArray2[0] = new UnitaryClause("jobid", (Object)jobID);
                    Object[] objectArray = new Object[2];
                    objectArray[0] = JobQueue.statusToString(11);
                    objectArray[1] = JobQueue.statusToString(7);
                    clauseDescriptionArray2[1] = new MultiClause("status", objectArray);
                    sb.append("id").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(" ").append(this.database.constructOffsetLimitClause(0, 1));
                    IResultSet confirmSet = this.database.performQuery(sb.toString(), list, null, null, 1, null);
                    if (confirmSet.getRowCount() > 0) continue;
                    this.jobs.finishJobCleanup(jobID);
                    Logging.jobs.info((Object)("Job " + jobID + " cleanup is now completed"));
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted deleting jobs ready for delete: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public void finishJobs() throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                Object[] objectArray = new Object[3];
                objectArray[0] = Jobs.statusToString(1);
                objectArray[1] = Jobs.statusToString(5);
                objectArray[2] = Jobs.statusToString(40);
                clauseDescriptionArray[0] = new MultiClause("status", objectArray);
                sb.append("id").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                int i = 0;
                while (i < set.getRowCount()) {
                    IResultRow row = set.getRow(i++);
                    Long jobID = (Long)row.getValue("id");
                    sb = new StringBuilder("SELECT ");
                    list.clear();
                    ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
                    clauseDescriptionArray2[0] = new UnitaryClause("jobid", (Object)jobID);
                    Object[] objectArray2 = new Object[6];
                    objectArray2[0] = JobQueue.statusToString(1);
                    objectArray2[1] = JobQueue.statusToString(8);
                    objectArray2[2] = JobQueue.statusToString(0);
                    objectArray2[3] = JobQueue.statusToString(5);
                    objectArray2[4] = JobQueue.statusToString(9);
                    objectArray2[5] = JobQueue.statusToString(4);
                    clauseDescriptionArray2[1] = new MultiClause("status", objectArray2);
                    sb.append("id").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(" ").append(this.database.constructOffsetLimitClause(0, 1));
                    IResultSet confirmSet = this.database.performQuery(sb.toString(), list, null, null, 1, null);
                    if (confirmSet.getRowCount() > 0) continue;
                    this.jobs.writePermanentStatus(jobID, 15, true);
                    Logging.jobs.info((Object)("Marked job " + jobID + " for shutdown"));
                }
                this.database.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted finishing jobs: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public JobNotifyRecord[] getJobsReadyForInactivity(String processID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("status", (Object)Jobs.statusToString(33));
                sb.append("id").append(",").append("failtime").append(",").append("failcount").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                JobNotifyRecord[] rval = new JobNotifyRecord[set.getRowCount()];
                int i = 0;
                while (i < rval.length) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    Long failTimeLong = (Long)row.getValue("failtime");
                    Long failRetryCountLong = (Long)row.getValue("failcount");
                    long failTime = failTimeLong == null ? -1L : failTimeLong;
                    int failRetryCount = failRetryCountLong == null ? -1 : (int)failRetryCountLong.longValue();
                    this.jobs.writeTransientStatus(jobID, 34, processID);
                    Logging.jobs.info((Object)("Found job " + jobID + " in need of notification"));
                    rval[i++] = new JobNotifyRecord(jobID, failTime, failRetryCount);
                }
                this.database.performCommit();
                JobNotifyRecord[] jobNotifyRecordArray = rval;
                return jobNotifyRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for notify: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    @Override
    public JobNotifyRecord[] getJobsReadyForDelete(String processID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new UnitaryClause("status", (Object)Jobs.statusToString(38));
                sb.append("id").append(",").append("failtime").append(",").append("failcount").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray)).append(" FOR UPDATE");
                IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
                JobNotifyRecord[] rval = new JobNotifyRecord[set.getRowCount()];
                int i = 0;
                while (i < rval.length) {
                    IResultRow row = set.getRow(i);
                    Long jobID = (Long)row.getValue("id");
                    Long failTimeLong = (Long)row.getValue("failtime");
                    Long failRetryCountLong = (Long)row.getValue("failcount");
                    long failTime = failTimeLong == null ? -1L : failTimeLong;
                    int failRetryCount = failRetryCountLong == null ? -1 : (int)failRetryCountLong.longValue();
                    this.jobs.writeTransientStatus(jobID, 39, processID);
                    Logging.jobs.info((Object)("Found job " + jobID + " in need of delete notification"));
                    rval[i++] = new JobNotifyRecord(jobID, failTime, failRetryCount);
                }
                this.database.performCommit();
                JobNotifyRecord[] jobNotifyRecordArray = rval;
                return jobNotifyRecordArray;
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted getting jobs ready for notify: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJobResumes(long timestamp, List<IJobDescription> modifiedJobs) throws ManifoldCFException {
        this.lockManager.enterWriteLock(jobResumeLock);
        try {
            StringBuilder sb = new StringBuilder("SELECT ");
            ArrayList list = new ArrayList();
            ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
            Object[] objectArray = new Object[2];
            objectArray[0] = Jobs.statusToString(16);
            objectArray[1] = Jobs.statusToString(17);
            clauseDescriptionArray[0] = new MultiClause("status", objectArray);
            sb.append("id").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray));
            IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                Long jobID = (Long)row.getValue("id");
                IJobDescription jobDesc = this.jobs.load(jobID, true);
                modifiedJobs.add(jobDesc);
                this.jobQueue.prioritizeQueuedDocuments(jobID);
                this.jobs.finishResumeJob(jobID, timestamp);
                Logging.jobs.info((Object)("Resumed job " + jobID));
            }
        }
        finally {
            this.lockManager.leaveWriteLock(jobResumeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJobStops(long timestamp, List<IJobDescription> modifiedJobs, List<Integer> stopNotificationTypes) throws ManifoldCFException {
        this.lockManager.enterWriteLock(jobStopLock);
        try {
            StringBuilder sb = new StringBuilder("SELECT ");
            ArrayList list = new ArrayList();
            ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
            Object[] objectArray = new Object[10];
            objectArray[0] = Jobs.statusToString(18);
            objectArray[1] = Jobs.statusToString(27);
            objectArray[2] = Jobs.statusToString(28);
            objectArray[3] = Jobs.statusToString(37);
            objectArray[4] = Jobs.statusToString(7);
            objectArray[5] = Jobs.statusToString(8);
            objectArray[6] = Jobs.statusToString(3);
            objectArray[7] = Jobs.statusToString(4);
            objectArray[8] = Jobs.statusToString(9);
            objectArray[9] = Jobs.statusToString(10);
            clauseDescriptionArray[0] = new MultiClause("status", objectArray);
            sb.append("id").append(",").append("status").append(",").append("errortext").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray));
            IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                Long jobID = (Long)row.getValue("id");
                int jobStatus = Jobs.stringToStatus((String)row.getValue("status"));
                String errorText = (String)row.getValue("errortext");
                sb = new StringBuilder("SELECT ");
                list.clear();
                ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
                clauseDescriptionArray2[0] = new UnitaryClause("jobid", (Object)jobID);
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = JobQueue.statusToString(1);
                objectArray2[1] = JobQueue.statusToString(5);
                objectArray2[2] = JobQueue.statusToString(8);
                objectArray2[3] = JobQueue.statusToString(9);
                objectArray2[4] = JobQueue.statusToString(10);
                clauseDescriptionArray2[1] = new MultiClause("status", objectArray2);
                sb.append("id").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(" ").append(this.database.constructOffsetLimitClause(0, 1));
                IResultSet confirmSet = this.database.performQuery(sb.toString(), list, null, null, 1, null);
                if (confirmSet.getRowCount() > 0) continue;
                this.noDocPriorities(jobID);
                IJobDescription jobDesc = this.jobs.load(jobID, true);
                modifiedJobs.add(jobDesc);
                stopNotificationTypes.add(JobManager.mapToNotificationType(jobStatus, errorText == null || errorText.length() == 0));
                this.jobs.finishStopJob(jobID, timestamp);
                Logging.jobs.info((Object)("Stopped job " + jobID));
            }
        }
        finally {
            this.lockManager.leaveWriteLock(jobStopLock);
        }
    }

    protected static Integer mapToNotificationType(int jobStatus, boolean noErrorText) {
        switch (jobStatus) {
            case 18: 
            case 37: {
                return noErrorText ? 1 : 0;
            }
            case 27: 
            case 28: {
                return 4;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 2;
            }
            case 3: 
            case 4: {
                return 3;
            }
        }
        throw new RuntimeException("Unexpected job status: " + jobStatus);
    }

    protected void noDocPriorities(Long jobID) throws ManifoldCFException {
        while (true) {
            long sleepAmt = 0L;
            this.database.beginTransaction();
            try {
                this.jobQueue.noDocPriorities(jobID);
                this.database.performCommit();
            }
            catch (ManifoldCFException e) {
                this.database.signalRollback();
                if (e.getErrorCode() == 6) {
                    if (Logging.perf.isDebugEnabled()) {
                        Logging.perf.debug((Object)("Aborted transaction clearing document priorities: " + e.getMessage()));
                    }
                    sleepAmt = this.getRandomAmount();
                    continue;
                }
                throw e;
            }
            catch (RuntimeException e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            catch (Error e) {
                this.database.signalRollback();
                TrackerClass.noteRollback();
                throw e;
            }
            finally {
                this.database.endTransaction();
                this.sleepFor(sleepAmt);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetJobs(long currentTime, List<IJobDescription> resetJobs) throws ManifoldCFException {
        this.lockManager.enterWriteLock(jobStopLock);
        try {
            StringBuilder sb = new StringBuilder("SELECT ");
            ArrayList list = new ArrayList();
            ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
            clauseDescriptionArray[0] = new UnitaryClause("status", (Object)Jobs.statusToString(15));
            sb.append("id").append(" FROM ").append(this.jobs.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray));
            IResultSet set = this.database.performQuery(sb.toString(), list, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                Long jobID = (Long)row.getValue("id");
                sb = new StringBuilder("SELECT ");
                list.clear();
                ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[2];
                clauseDescriptionArray2[0] = new UnitaryClause("jobid", (Object)jobID);
                Object[] objectArray = new Object[2];
                objectArray[0] = JobQueue.statusToString(6);
                objectArray[1] = JobQueue.statusToString(10);
                clauseDescriptionArray2[1] = new MultiClause("status", objectArray);
                sb.append("id").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray2)).append(" ").append(this.database.constructOffsetLimitClause(0, 1));
                IResultSet confirmSet = this.database.performQuery(sb.toString(), list, null, null, 1, null);
                if (confirmSet.getRowCount() > 0) continue;
                sb = new StringBuilder("SELECT ");
                list.clear();
                ClauseDescription[] clauseDescriptionArray3 = new ClauseDescription[2];
                clauseDescriptionArray3[0] = new UnitaryClause("jobid", (Object)jobID);
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = JobQueue.statusToString(0);
                objectArray2[1] = JobQueue.statusToString(4);
                clauseDescriptionArray3[1] = new MultiClause("status", objectArray2);
                sb.append("id").append(" FROM ").append(this.jobQueue.getTableName()).append(" WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray3)).append(" ").append(this.database.constructOffsetLimitClause(0, 1));
                confirmSet = this.database.performQuery(sb.toString(), list, null, null, 1, null);
                if (confirmSet.getRowCount() > 0) {
                    this.jobs.returnJobToActive(jobID);
                    Logging.jobs.info((Object)("Job " + jobID + " is re-entering active state"));
                    continue;
                }
                IJobDescription jobDesc = this.jobs.load(jobID, true);
                resetJobs.add(jobDesc);
                this.jobs.finishJob(jobID, currentTime);
                Logging.jobs.info((Object)("Job " + jobID + " now completed"));
            }
        }
        finally {
            this.lockManager.leaveWriteLock(jobStopLock);
        }
    }

    @Override
    public JobStatus getStatus(Long jobID) throws ManifoldCFException {
        return this.getStatus(jobID, true);
    }

    @Override
    public JobStatus[] getAllStatus() throws ManifoldCFException {
        return this.getAllStatus(true);
    }

    @Override
    public JobStatus[] getRunningJobs() throws ManifoldCFException {
        return this.getRunningJobs(true);
    }

    @Override
    public JobStatus[] getFinishedJobs() throws ManifoldCFException {
        return this.getFinishedJobs(true);
    }

    @Override
    public JobStatus getStatus(Long jobID, boolean includeCounts) throws ManifoldCFException {
        return this.getStatus(jobID, includeCounts, Integer.MAX_VALUE);
    }

    @Override
    public JobStatus[] getAllStatus(boolean includeCounts) throws ManifoldCFException {
        return this.getAllStatus(includeCounts, Integer.MAX_VALUE);
    }

    @Override
    public JobStatus[] getRunningJobs(boolean includeCounts) throws ManifoldCFException {
        return this.getRunningJobs(includeCounts, Integer.MAX_VALUE);
    }

    @Override
    public JobStatus[] getFinishedJobs(boolean includeCounts) throws ManifoldCFException {
        return this.getFinishedJobs(includeCounts, Integer.MAX_VALUE);
    }

    @Override
    public JobStatus getStatus(Long jobID, boolean includeCounts, int maxCount) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        String whereClause = "id=?";
        list.add(jobID);
        JobStatus[] records = this.makeJobStatus(whereClause, list, includeCounts, maxCount);
        if (records.length == 0) {
            return null;
        }
        return records[0];
    }

    @Override
    public JobStatus[] getAllStatus(boolean includeCounts, int maxCount) throws ManifoldCFException {
        return this.makeJobStatus(null, null, includeCounts, maxCount);
    }

    @Override
    public JobStatus[] getRunningJobs(boolean includeCounts, int maxCount) throws ManifoldCFException {
        ArrayList whereParams = new ArrayList();
        String whereClause = this.database.buildConjunctionClause(whereParams, new ClauseDescription[]{new MultiClause("status", new Object[]{Jobs.statusToString(1), Jobs.statusToString(2), Jobs.statusToString(40), Jobs.statusToString(41), Jobs.statusToString(11), Jobs.statusToString(12), Jobs.statusToString(5), Jobs.statusToString(6), Jobs.statusToString(13), Jobs.statusToString(14), Jobs.statusToString(7), Jobs.statusToString(8), Jobs.statusToString(3), Jobs.statusToString(4), Jobs.statusToString(9), Jobs.statusToString(10), Jobs.statusToString(16), Jobs.statusToString(17)})});
        return this.makeJobStatus(whereClause, whereParams, includeCounts, maxCount);
    }

    @Override
    public JobStatus[] getFinishedJobs(boolean includeCounts, int maxCount) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder();
        ArrayList whereParams = new ArrayList();
        sb.append(this.database.buildConjunctionClause(whereParams, new ClauseDescription[]{new UnitaryClause("status", (Object)Jobs.statusToString(0))})).append(" AND ").append("endtime").append(" IS NOT NULL");
        return this.makeJobStatus(sb.toString(), whereParams, includeCounts, maxCount);
    }

    protected JobStatus[] makeJobStatus(String whereClause, ArrayList whereParams, boolean includeCounts, int maxCount) throws ManifoldCFException {
        IResultSet set = this.database.performQuery("SELECT t0.id,t0.description,t0.status,t0.starttime,t0.endtime,t0.errortext FROM " + this.jobs.getTableName() + " t0 " + (whereClause == null ? "" : " WHERE " + whereClause) + " ORDER BY " + "description" + " ASC", (List)whereParams, null, null);
        HashMap<Long, Long> set2Hash = new HashMap<Long, Long>();
        HashMap<Long, Long> set3Hash = new HashMap<Long, Long>();
        HashMap<Long, Long> set4Hash = new HashMap<Long, Long>();
        HashMap<Long, Boolean> set2Exact = new HashMap<Long, Boolean>();
        HashMap<Long, Boolean> set3Exact = new HashMap<Long, Boolean>();
        HashMap<Long, Boolean> set4Exact = new HashMap<Long, Boolean>();
        if (includeCounts) {
            if (maxCount == Integer.MAX_VALUE) {
                this.buildCountsUsingGroupBy(whereClause, whereParams, set2Hash, set3Hash, set4Hash, set2Exact, set3Exact, set4Exact);
            } else {
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                sb.append(this.database.constructCountClause("t2.x")).append(" AS doccount").append(" FROM (SELECT 'x' AS x FROM ").append(this.jobQueue.getTableName()).append(" t1");
                this.addWhereClause(sb, list, whereClause, whereParams, false);
                sb.append(" ").append(this.database.constructOffsetLimitClause(0, maxCount + 1, false)).append(") t2");
                IResultSet countResult = this.database.performQuery(sb.toString(), list, null, null);
                if (countResult.getRowCount() > 0 && (Long)countResult.getRow(0).getValue("doccount") > (long)maxCount) {
                    this.buildCountsUsingIndividualQueries(whereClause, whereParams, maxCount, set2Hash, set3Hash, set4Hash, set2Exact, set3Exact, set4Exact);
                } else {
                    this.buildCountsUsingGroupBy(whereClause, whereParams, set2Hash, set3Hash, set4Hash, set2Exact, set3Exact, set4Exact);
                }
            }
        }
        JobStatus[] rval = new JobStatus[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            String errorText;
            IResultRow row = set.getRow(i);
            Long jobID = (Long)row.getValue("id");
            String description = row.getValue("description").toString();
            int status = Jobs.stringToStatus(row.getValue("status").toString());
            Long startTimeValue = (Long)row.getValue("starttime");
            long startTime = -1L;
            if (startTimeValue != null) {
                startTime = startTimeValue;
            }
            Long endTimeValue = (Long)row.getValue("endtime");
            long endTime = -1L;
            if (endTimeValue != null) {
                endTime = endTimeValue;
            }
            if ((errorText = (String)row.getValue("errortext")) != null && errorText.length() == 0) {
                errorText = null;
            }
            int rstatus = 0;
            switch (status) {
                case 0: {
                    if (errorText != null) {
                        rstatus = 9;
                        break;
                    }
                    if (startTime >= 0L) {
                        rstatus = 5;
                        break;
                    }
                    rstatus = 0;
                    break;
                }
                case 40: 
                case 41: {
                    rstatus = 12;
                    break;
                }
                case 1: 
                case 2: {
                    rstatus = 1;
                    break;
                }
                case 15: {
                    rstatus = 13;
                    break;
                }
                case 33: 
                case 34: 
                case 38: 
                case 39: {
                    rstatus = 14;
                    break;
                }
                case 18: 
                case 37: {
                    rstatus = 10;
                    break;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    rstatus = 11;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    rstatus = 2;
                    break;
                }
                case 16: 
                case 17: {
                    rstatus = 4;
                    break;
                }
                case 11: 
                case 12: {
                    rstatus = 3;
                    break;
                }
                case 5: 
                case 6: {
                    rstatus = 6;
                    break;
                }
                case 13: 
                case 14: {
                    rstatus = 3;
                    break;
                }
                case 19: 
                case 20: 
                case 23: 
                case 24: {
                    rstatus = 7;
                    break;
                }
                case 25: 
                case 35: 
                case 36: 
                case 42: {
                    rstatus = 8;
                    break;
                }
            }
            Long set2Value = (Long)set2Hash.get(jobID);
            Long set3Value = (Long)set3Hash.get(jobID);
            Long set4Value = (Long)set4Hash.get(jobID);
            Boolean set2ExactValue = (Boolean)set2Exact.get(jobID);
            Boolean set3ExactValue = (Boolean)set3Exact.get(jobID);
            Boolean set4ExactValue = (Boolean)set4Exact.get(jobID);
            rval[i] = new JobStatus(jobID.toString(), description, rstatus, set2Value == null ? 0L : set2Value, set3Value == null ? 0L : set3Value, set4Value == null ? 0L : set4Value, set2ExactValue == null ? true : set2ExactValue, set3ExactValue == null ? true : set3ExactValue, set4ExactValue == null ? true : set4ExactValue, startTime, endTime, errorText);
        }
        return rval;
    }

    protected static ClauseDescription buildOutstandingClause() throws ManifoldCFException {
        return new MultiClause("status", new Object[]{JobQueue.statusToString(1), JobQueue.statusToString(8), JobQueue.statusToString(0), JobQueue.statusToString(5), JobQueue.statusToString(9), JobQueue.statusToString(4)});
    }

    protected static ClauseDescription buildProcessedClause() throws ManifoldCFException {
        return new MultiClause("status", new Object[]{JobQueue.statusToString(2), JobQueue.statusToString(3), JobQueue.statusToString(6), JobQueue.statusToString(5), JobQueue.statusToString(9), JobQueue.statusToString(4)});
    }

    protected void buildCountsUsingIndividualQueries(String whereClause, ArrayList whereParams, int maxCount, Map<Long, Long> set2Hash, Map<Long, Long> set3Hash, Map<Long, Long> set4Hash, Map<Long, Boolean> set2Exact, Map<Long, Boolean> set3Exact, Map<Long, Boolean> set4Exact) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList list = new ArrayList();
        sb.append("id").append(" FROM ").append(this.jobs.getTableName()).append(" t0");
        if (whereClause != null) {
            sb.append(" WHERE ").append(whereClause);
            if (whereParams != null) {
                list.addAll(whereParams);
            }
        }
        IResultSet jobSet = this.database.performQuery(sb.toString(), list, null, null);
        for (int i = 0; i < jobSet.getRowCount(); ++i) {
            IResultRow row = jobSet.getRow(i);
            Long jobID = (Long)row.getValue("id");
            sb = new StringBuilder("SELECT ");
            list.clear();
            sb.append(this.database.constructCountClause("t2.x")).append(" AS doccount").append(" FROM (SELECT 'x' AS x FROM ").append(this.jobQueue.getTableName()).append(" WHERE ");
            sb.append(this.database.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause("jobid", (Object)jobID)}));
            sb.append(" ").append(this.database.constructOffsetLimitClause(0, maxCount + 1, false)).append(") t2");
            IResultSet totalSet = this.database.performQuery(sb.toString(), list, null, null);
            if (totalSet.getRowCount() > 0) {
                long rowCount = (Long)totalSet.getRow(0).getValue("doccount");
                if (rowCount > (long)maxCount) {
                    set2Hash.put(jobID, new Long(maxCount));
                    set2Exact.put(jobID, new Boolean(false));
                } else {
                    set2Hash.put(jobID, new Long(rowCount));
                    set2Exact.put(jobID, new Boolean(true));
                }
            }
            sb = new StringBuilder("SELECT ");
            list.clear();
            sb.append(this.database.constructCountClause("t2.x")).append(" AS doccount").append(" FROM (SELECT 'x' AS x FROM ").append(this.jobQueue.getTableName()).append(" WHERE ");
            sb.append(this.database.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause("jobid", (Object)jobID)}));
            sb.append(" AND ");
            sb.append(this.database.buildConjunctionClause(list, new ClauseDescription[]{JobManager.buildOutstandingClause()}));
            sb.append(" ").append(this.database.constructOffsetLimitClause(0, maxCount + 1, false)).append(") t2");
            IResultSet outstandingSet = this.database.performQuery(sb.toString(), list, null, null);
            if (outstandingSet.getRowCount() > 0) {
                long rowCount = (Long)outstandingSet.getRow(0).getValue("doccount");
                if (rowCount > (long)maxCount) {
                    set3Hash.put(jobID, new Long(maxCount));
                    set3Exact.put(jobID, new Boolean(false));
                } else {
                    set3Hash.put(jobID, new Long(rowCount));
                    set3Exact.put(jobID, new Boolean(true));
                }
            }
            sb = new StringBuilder("SELECT ");
            list.clear();
            sb.append(this.database.constructCountClause("t2.x")).append(" AS doccount").append(" FROM (SELECT 'x' AS x FROM ").append(this.jobQueue.getTableName()).append(" WHERE ");
            sb.append(this.database.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause("jobid", (Object)jobID)}));
            sb.append(" AND ");
            sb.append(this.database.buildConjunctionClause(list, new ClauseDescription[]{JobManager.buildProcessedClause()}));
            sb.append(" ").append(this.database.constructOffsetLimitClause(0, maxCount + 1, false)).append(") t2");
            IResultSet processedSet = this.database.performQuery(sb.toString(), list, null, null);
            if (processedSet.getRowCount() <= 0) continue;
            long rowCount = (Long)processedSet.getRow(0).getValue("doccount");
            if (rowCount > (long)maxCount) {
                set4Hash.put(jobID, new Long(maxCount));
                set4Exact.put(jobID, new Boolean(false));
                continue;
            }
            set4Hash.put(jobID, new Long(rowCount));
            set4Exact.put(jobID, new Boolean(true));
        }
    }

    protected void buildCountsUsingGroupBy(String whereClause, ArrayList whereParams, Map<Long, Long> set2Hash, Map<Long, Long> set3Hash, Map<Long, Long> set4Hash, Map<Long, Boolean> set2Exact, Map<Long, Boolean> set3Exact, Map<Long, Boolean> set4Exact) throws ManifoldCFException {
        Long jobID;
        IResultRow row;
        int j;
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList list = new ArrayList();
        sb.append("jobid").append(",").append(this.database.constructCountClause("dochash")).append(" AS doccount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t1");
        this.addWhereClause(sb, list, whereClause, whereParams, false);
        sb.append(" GROUP BY ").append("jobid");
        IResultSet set2 = this.database.performQuery(sb.toString(), list, null, null);
        sb = new StringBuilder("SELECT ");
        list.clear();
        sb.append("jobid").append(",").append(this.database.constructCountClause("dochash")).append(" AS doccount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, new ClauseDescription[]{JobManager.buildOutstandingClause()}));
        this.addWhereClause(sb, list, whereClause, whereParams, true);
        sb.append(" GROUP BY ").append("jobid");
        IResultSet set3 = this.database.performQuery(sb.toString(), list, null, null);
        sb = new StringBuilder("SELECT ");
        list.clear();
        sb.append("jobid").append(",").append(this.database.constructCountClause("dochash")).append(" AS doccount").append(" FROM ").append(this.jobQueue.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, new ClauseDescription[]{JobManager.buildProcessedClause()}));
        this.addWhereClause(sb, list, whereClause, whereParams, true);
        sb.append(" GROUP BY ").append("jobid");
        IResultSet set4 = this.database.performQuery(sb.toString(), list, null, null);
        for (j = 0; j < set2.getRowCount(); ++j) {
            row = set2.getRow(j);
            jobID = (Long)row.getValue("jobid");
            set2Hash.put(jobID, (Long)row.getValue("doccount"));
            set2Exact.put(jobID, new Boolean(true));
        }
        for (j = 0; j < set3.getRowCount(); ++j) {
            row = set3.getRow(j);
            jobID = (Long)row.getValue("jobid");
            set3Hash.put(jobID, (Long)row.getValue("doccount"));
            set3Exact.put(jobID, new Boolean(true));
        }
        for (j = 0; j < set4.getRowCount(); ++j) {
            row = set4.getRow(j);
            jobID = (Long)row.getValue("jobid");
            set4Hash.put(jobID, (Long)row.getValue("doccount"));
            set4Exact.put(jobID, new Boolean(true));
        }
    }

    protected void addWhereClause(StringBuilder sb, ArrayList list, String whereClause, ArrayList whereParams, boolean wherePresent) {
        if (whereClause != null) {
            if (wherePresent) {
                sb.append(" AND");
            } else {
                sb.append(" WHERE");
            }
            sb.append(" EXISTS(SELECT 'x' FROM ").append(this.jobs.getTableName()).append(" t0 WHERE ").append(this.database.buildConjunctionClause((List)list, new ClauseDescription[]{new JoinClause("t0.id", "t1.jobid")})).append(" AND ").append(whereClause).append(")");
            if (whereParams != null) {
                list.addAll(whereParams);
            }
        }
    }

    @Override
    public IResultSet genDocumentStatus(String connectionName, StatusFilterCriteria filterCriteria, SortOrder sortOrder, int startRow, int rowCount) throws ManifoldCFException {
        Long currentTime = new Long(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList<String> list = new ArrayList<String>();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new JoinClause("t0." + "jobid", "t1." + "id");
        sb.append("t0.").append("id").append(" AS id,").append("t0.").append("docid").append(" AS identifier,").append("t1.").append("description").append(" AS job,").append("CASE").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Not yet processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Not yet processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Not yet processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Processed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Being removed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Being removed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Being removed'").append(" WHEN ").append("t0.").append("status").append("=? THEN 'Out of scope'").append(" ELSE 'Unknown'").append(" END AS state,").append("CASE").append(" WHEN ").append("t0.").append("status").append(" IN (?,?,?)").append(" THEN 'Inactive'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?)").append(" AND ").append("t0.").append("checkaction").append("=?").append(" AND t0.").append("checktime").append("<=").append(currentTime.toString()).append(" THEN 'Ready for processing'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?)").append(" AND ").append("t0.").append("checkaction").append("=?").append(" AND t0.").append("checktime").append("<=").append(currentTime.toString()).append(" THEN 'Ready for expiration'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?)").append(" AND ").append("t0.").append("checkaction").append("=?").append(" AND t0.").append("checktime").append(">").append(currentTime.toString()).append(" THEN 'Waiting for processing'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?)").append(" AND ").append("t0.").append("checkaction").append("=?").append(" AND t0.").append("checktime").append(">").append(currentTime.toString()).append(" THEN 'Waiting for expiration'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?)").append(" AND ").append("t0.").append("checktime").append(" IS NULL").append(" THEN 'Waiting forever'").append(" WHEN ").append("t0.").append("status").append("=?").append(" THEN 'Hopcount exceeded'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?,?)").append(" THEN 'Deleting'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?,?,?)").append(" AND ").append("t0.").append("checkaction").append("=?").append(" THEN 'Processing'").append(" WHEN ").append("t0.").append("status").append(" IN (?,?,?,?)").append(" AND ").append("t0.").append("checkaction").append("=?").append(" THEN 'Expiring'").append(" ELSE 'Unknown'").append(" END AS status,").append("t0.").append("checktime").append(" AS scheduled,").append("CASE").append(" WHEN ").append("t0.").append("checkaction").append("=? THEN 'Process'").append(" WHEN ").append("t0.").append("checkaction").append("=? THEN 'Expire'").append(" ELSE 'Unknown'").append(" END AS action,").append("t0.").append("failcount").append(" AS retrycount,").append("t0.").append("failtime").append(" AS retrylimit").append(" FROM ").append(this.jobQueue.getTableName()).append(" t0,").append(this.jobs.getTableName()).append(" t1 WHERE ").append(this.database.buildConjunctionClause(list, clauseDescriptionArray));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(10));
        list.add(JobQueue.statusToString(11));
        list.add(JobQueue.statusToString(12));
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(12));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(10));
        list.add(JobQueue.statusToString(11));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.actionToString(1));
        this.addCriteria(sb, list, "t0.", connectionName, filterCriteria, true);
        this.addOrdering(sb, new String[]{"id"}, sortOrder);
        this.addLimits(sb, startRow, rowCount);
        return this.database.performQuery(sb.toString(), list, null, null, rowCount, null);
    }

    @Override
    public IResultSet genQueueStatus(String connectionName, StatusFilterCriteria filterCriteria, SortOrder sortOrder, BucketDescription idBucketDescription, int startRow, int rowCount) throws ManifoldCFException {
        Long currentTime = new Long(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList<String> list = new ArrayList<String>();
        sb.append("t1.idbucket,SUM(t1.inactive) AS inactive,SUM(t1.processing) AS processing,SUM(t1.expiring) AS expiring,SUM(t1.deleting) AS deleting,").append("SUM(t1.processready) AS processready,SUM(t1.expireready) AS expireready,SUM(t1.processwaiting) AS processwaiting,SUM(t1.expirewaiting) AS expirewaiting,").append("SUM(t1.waitingforever) AS waitingforever,SUM(t1.hopcountexceeded) AS hopcountexceeded FROM (SELECT ");
        this.addBucketExtract(sb, list, "", "docid", idBucketDescription);
        sb.append(" AS idbucket,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?,?)").append(" THEN 1 ELSE 0").append(" END").append(" AS inactive,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?,?,?)").append(" AND ").append("checkaction").append("=?").append(" THEN 1 ELSE 0").append(" END").append(" as processing,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?,?,?)").append(" AND ").append("checkaction").append("=?").append(" THEN 1 ELSE 0").append(" END").append(" as expiring,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?,?)").append(" THEN 1 ELSE 0").append(" END").append(" as deleting,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?)").append(" AND ").append("checkaction").append("=?").append(" AND ").append("checktime").append("<=").append(currentTime.toString()).append(" THEN 1 ELSE 0").append(" END").append(" as processready,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?)").append(" AND ").append("checkaction").append("=?").append(" AND ").append("checktime").append("<=").append(currentTime.toString()).append(" THEN 1 ELSE 0").append(" END").append(" as expireready,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?)").append(" AND ").append("checkaction").append("=?").append(" AND ").append("checktime").append(">").append(currentTime.toString()).append(" THEN 1 ELSE 0").append(" END").append(" as processwaiting,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?)").append(" AND ").append("checkaction").append("=?").append(" AND ").append("checktime").append(">").append(currentTime.toString()).append(" THEN 1 ELSE 0").append(" END").append(" as expirewaiting,").append("CASE").append(" WHEN ").append("status").append(" IN (?,?)").append(" AND ").append("checktime").append(" IS NULL").append(" THEN 1 ELSE 0").append(" END").append(" as waitingforever,").append("CASE").append(" WHEN ").append("status").append("=?").append(" THEN 1 ELSE 0").append(" END").append(" as hopcountexceeded");
        sb.append(" FROM ").append(this.jobQueue.getTableName());
        list.add(JobQueue.statusToString(2));
        list.add(JobQueue.statusToString(3));
        list.add(JobQueue.statusToString(6));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(1));
        list.add(JobQueue.statusToString(8));
        list.add(JobQueue.statusToString(5));
        list.add(JobQueue.statusToString(9));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(7));
        list.add(JobQueue.statusToString(10));
        list.add(JobQueue.statusToString(11));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(0));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.actionToString(1));
        list.add(JobQueue.statusToString(0));
        list.add(JobQueue.statusToString(4));
        list.add(JobQueue.statusToString(12));
        this.addCriteria(sb, list, "", connectionName, filterCriteria, false);
        sb.append(") t1 GROUP BY idbucket");
        this.addOrdering(sb, new String[]{"idbucket", "inactive", "processing", "expiring", "deleting", "processready", "expireready", "processwaiting", "expirewaiting", "waitingforever", "hopcountexceeded"}, sortOrder);
        this.addLimits(sb, startRow, rowCount);
        return this.database.performQuery(sb.toString(), list, null, null, rowCount, null);
    }

    protected void addBucketExtract(StringBuilder sb, ArrayList list, String columnPrefix, String columnName, BucketDescription bucketDesc) {
        boolean isSensitive = bucketDesc.isSensitive();
        list.add(bucketDesc.getRegexp());
        sb.append(this.database.constructSubstringClause(columnPrefix + columnName, "?", !isSensitive));
    }

    protected boolean addCriteria(StringBuilder sb, ArrayList list, String fieldPrefix, String connectionName, StatusFilterCriteria criteria, boolean whereEmitted) throws ManifoldCFException {
        int stateValue;
        int k;
        RegExpCriteria identifierRegexp;
        Object[] matchingJobs = criteria.getJobs();
        if (matchingJobs != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            if (matchingJobs.length == 0) {
                sb.append("0>1");
            } else {
                ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "jobid", matchingJobs);
                sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
            }
        }
        if ((identifierRegexp = criteria.getIdentifierMatch()) != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            list.add(identifierRegexp.getRegexpString());
            sb.append(this.database.constructRegexpClause(fieldPrefix + "docid", "?", identifierRegexp.isInsensitive()));
        }
        Long nowTime = new Long(criteria.getNowTime());
        int[] states = criteria.getMatchingStates();
        int[] statuses = criteria.getMatchingStatuses();
        if (states.length == 0 || statuses.length == 0) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            sb.append("0>1");
            return whereEmitted;
        }
        whereEmitted = this.emitClauseStart(sb, whereEmitted);
        sb.append("(");
        block17: for (k = 0; k < states.length; ++k) {
            stateValue = states[k];
            if (k > 0) {
                sb.append(" OR ");
            }
            switch (stateValue) {
                case 0: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[3];
                    objectArray[0] = JobQueue.statusToString(0);
                    objectArray[1] = JobQueue.statusToString(1);
                    objectArray[2] = JobQueue.statusToString(8);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block17;
                }
                case 1: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[9];
                    objectArray[0] = JobQueue.statusToString(4);
                    objectArray[1] = JobQueue.statusToString(5);
                    objectArray[2] = JobQueue.statusToString(9);
                    objectArray[3] = JobQueue.statusToString(11);
                    objectArray[4] = JobQueue.statusToString(7);
                    objectArray[5] = JobQueue.statusToString(10);
                    objectArray[6] = JobQueue.statusToString(2);
                    objectArray[7] = JobQueue.statusToString(3);
                    objectArray[8] = JobQueue.statusToString(6);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block17;
                }
                case 2: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[1];
                    objectArray[0] = JobQueue.statusToString(12);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                }
            }
        }
        sb.append(")");
        whereEmitted = this.emitClauseStart(sb, whereEmitted);
        sb.append("(");
        block18: for (k = 0; k < statuses.length; ++k) {
            stateValue = statuses[k];
            if (k > 0) {
                sb.append(" OR ");
            }
            switch (stateValue) {
                case 0: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[3];
                    objectArray[0] = JobQueue.statusToString(2);
                    objectArray[1] = JobQueue.statusToString(3);
                    objectArray[2] = JobQueue.statusToString(6);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 1: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
                    Object[] objectArray = new Object[4];
                    objectArray[0] = JobQueue.statusToString(1);
                    objectArray[1] = JobQueue.statusToString(8);
                    objectArray[2] = JobQueue.statusToString(5);
                    objectArray[3] = JobQueue.statusToString(9);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    clauseDescriptionArray[1] = new UnitaryClause(fieldPrefix + "checkaction", (Object)JobQueue.actionToString(0));
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 2: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
                    Object[] objectArray = new Object[4];
                    objectArray[0] = JobQueue.statusToString(1);
                    objectArray[1] = JobQueue.statusToString(8);
                    objectArray[2] = JobQueue.statusToString(5);
                    objectArray[3] = JobQueue.statusToString(9);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    clauseDescriptionArray[1] = new UnitaryClause(fieldPrefix + "checkaction", (Object)JobQueue.actionToString(1));
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 3: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[3];
                    objectArray[0] = JobQueue.statusToString(7);
                    objectArray[1] = JobQueue.statusToString(10);
                    objectArray[2] = JobQueue.statusToString(11);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 4: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[3];
                    Object[] objectArray = new Object[2];
                    objectArray[0] = JobQueue.statusToString(0);
                    objectArray[1] = JobQueue.statusToString(4);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    clauseDescriptionArray[1] = new UnitaryClause(fieldPrefix + "checkaction", (Object)JobQueue.actionToString(0));
                    clauseDescriptionArray[2] = new UnitaryClause(fieldPrefix + "checktime", "<=", (Object)nowTime);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 5: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[3];
                    Object[] objectArray = new Object[2];
                    objectArray[0] = JobQueue.statusToString(0);
                    objectArray[1] = JobQueue.statusToString(4);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    clauseDescriptionArray[1] = new UnitaryClause(fieldPrefix + "checkaction", (Object)JobQueue.actionToString(1));
                    clauseDescriptionArray[2] = new UnitaryClause(fieldPrefix + "checktime", "<=", (Object)nowTime);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 6: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[3];
                    Object[] objectArray = new Object[2];
                    objectArray[0] = JobQueue.statusToString(0);
                    objectArray[1] = JobQueue.statusToString(4);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    clauseDescriptionArray[1] = new UnitaryClause(fieldPrefix + "checkaction", (Object)JobQueue.actionToString(0));
                    clauseDescriptionArray[2] = new UnitaryClause(fieldPrefix + "checktime", ">", (Object)nowTime);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 7: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[3];
                    Object[] objectArray = new Object[2];
                    objectArray[0] = JobQueue.statusToString(0);
                    objectArray[1] = JobQueue.statusToString(4);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    clauseDescriptionArray[1] = new UnitaryClause(fieldPrefix + "checkaction", (Object)JobQueue.actionToString(1));
                    clauseDescriptionArray[2] = new UnitaryClause(fieldPrefix + "checktime", ">", (Object)nowTime);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                    continue block18;
                }
                case 8: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[2];
                    objectArray[0] = JobQueue.statusToString(0);
                    objectArray[1] = JobQueue.statusToString(4);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray)).append(" AND ").append(fieldPrefix).append("checktime").append(" IS NULL");
                    continue block18;
                }
                case 9: {
                    ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
                    Object[] objectArray = new Object[1];
                    objectArray[0] = JobQueue.statusToString(12);
                    clauseDescriptionArray[0] = new MultiClause(fieldPrefix + "status", objectArray);
                    sb.append(this.database.buildConjunctionClause((List)list, clauseDescriptionArray));
                }
            }
        }
        sb.append(")");
        return whereEmitted;
    }

    protected boolean emitClauseStart(StringBuilder sb, boolean whereEmitted) {
        if (whereEmitted) {
            sb.append(" AND ");
        } else {
            sb.append(" WHERE ");
        }
        return true;
    }

    protected void addOrdering(StringBuilder sb, String[] completeFieldList, SortOrder sort) {
        int i;
        HashMap<String, String> hash = new HashMap<String, String>();
        sb.append(" ORDER BY ");
        int count = sort.getCount();
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            String column = sort.getColumn(i);
            sb.append(column);
            if (sort.getDirection(i) == 0) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            hash.put(column, column);
        }
        for (int j = 0; j < completeFieldList.length; ++j) {
            String field = completeFieldList[j];
            if (hash.get(field) != null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append(field);
            sb.append(" DESC");
            ++i;
        }
    }

    protected void addLimits(StringBuilder sb, int startRow, int maxRowCount) {
        sb.append(" ").append(this.database.constructOffsetLimitClause(startRow, maxRowCount));
    }

    protected static class MutableInteger {
        int value;

        public MutableInteger(int value) {
            this.value = value;
        }

        public MutableInteger duplicate() {
            return new MutableInteger(this.value);
        }

        public void decrement() {
            --this.value;
        }

        public void increment() {
            ++this.value;
        }

        public int intValue() {
            return this.value;
        }
    }

    protected static class ThrottleLimitSpec {
        protected final Pattern regexp;
        protected final int maxCount;

        public ThrottleLimitSpec(String regexp, int maxCount) throws PatternSyntaxException {
            this.regexp = Pattern.compile(regexp);
            this.maxCount = maxCount;
        }

        public Pattern getRegexp() {
            return this.regexp;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }

    protected static class ThrottleJobItem {
        protected List<ThrottleLimitSpec> throttleLimits = new ArrayList<ThrottleLimitSpec>();
        protected final Map<String, MutableInteger> binCounts = new HashMap<String, MutableInteger>();

        public void addLimit(String regexp, int maxCount) {
            try {
                this.throttleLimits.add(new ThrottleLimitSpec(regexp, maxCount));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }

        public ThrottleJobItem duplicate() {
            ThrottleJobItem rval = new ThrottleJobItem();
            rval.throttleLimits = this.throttleLimits;
            for (String key : this.binCounts.keySet()) {
                this.binCounts.put(key, this.binCounts.get(key).duplicate());
            }
            return rval;
        }

        public boolean isEmpty(String binName) {
            int remaining;
            MutableInteger value = this.binCounts.get(binName);
            if (value == null) {
                int x = this.findMaxCount(binName);
                if (x == -1) {
                    return false;
                }
                remaining = x;
            } else {
                remaining = value.intValue();
            }
            return remaining == 0;
        }

        public void decrement(String binName) {
            MutableInteger value = this.binCounts.get(binName);
            if (value == null) {
                int x = this.findMaxCount(binName);
                if (x == -1) {
                    return;
                }
                value = new MutableInteger(x);
                this.binCounts.put(binName, value);
            }
            value.decrement();
        }

        protected int findMaxCount(String binName) {
            int maxCount = -1;
            int i = 0;
            while (i < this.throttleLimits.size()) {
                ThrottleLimitSpec spec;
                Pattern p;
                Matcher m;
                if (!(m = (p = (spec = this.throttleLimits.get(i++)).getRegexp()).matcher(binName)).find()) continue;
                int limit = spec.getMaxCount();
                if (maxCount != -1 && limit >= maxCount) continue;
                maxCount = limit;
            }
            return maxCount;
        }
    }

    protected static class QueueHashItem {
        final int itemsPerChunk;
        int chunkCount = 0;
        int currentDocumentCount = 0;

        public QueueHashItem(int itemsPerChunk) {
            this.itemsPerChunk = itemsPerChunk;
        }

        public QueueHashItem duplicate() {
            QueueHashItem rval = new QueueHashItem(this.itemsPerChunk);
            rval.chunkCount = this.chunkCount;
            rval.currentDocumentCount = this.currentDocumentCount;
            return rval;
        }

        public void addDocument() {
            ++this.currentDocumentCount;
            if (this.currentDocumentCount == 1) {
                ++this.chunkCount;
            }
            if (this.currentDocumentCount == this.itemsPerChunk) {
                this.currentDocumentCount = 0;
            }
        }

        public int getChunkCount() {
            return this.chunkCount;
        }
    }

    protected static class ThrottleLimit
    implements ILimitChecker {
        protected Map<String, ThrottleJobItem> connectionMap = new HashMap<String, ThrottleJobItem>();
        protected final int n;
        protected final Map<Long, QueueHashItem> jobQueueHash = new HashMap<Long, QueueHashItem>();
        protected Map<Long, String> jobConnection = new HashMap<Long, String>();
        protected Map<String, IRepositoryConnector> activeConnections = new HashMap<String, IRepositoryConnector>();
        protected Map<String, Integer> setSizes = new HashMap<String, Integer>();
        protected Map<String, MutableInteger> maxConnectionCounts = new HashMap<String, MutableInteger>();
        protected int maxSetSize = 0;
        protected int documentsProcessed = 0;
        protected final List<DocumentDescription> blockingDocumentArray = new ArrayList<DocumentDescription>();

        public ThrottleLimit(int n) {
            this.n = n;
            Logging.perf.debug((Object)"Limit instance created");
        }

        public void tallyBlockingDocuments(BlockingDocuments blockingDocuments) {
            int i = 0;
            while (i < this.blockingDocumentArray.size()) {
                DocumentDescription dd = this.blockingDocumentArray.get(i++);
                blockingDocuments.addBlockingDocument(dd);
            }
            this.blockingDocumentArray.clear();
        }

        public void addJob(Long jobID, String connectionName) {
            this.jobConnection.put(jobID, connectionName);
        }

        public void addConnectionName(String connectionName, IRepositoryConnector connectorInstance) throws ManifoldCFException {
            this.activeConnections.put(connectionName, connectorInstance);
            int setSize = connectorInstance.getMaxDocumentRequest();
            this.setSizes.put(connectionName, new Integer(setSize));
            if (setSize > this.maxSetSize) {
                this.maxSetSize = setSize;
            }
        }

        public void addLimit(String connectionName, String regexp, int upperLimit) {
            ThrottleJobItem ji;
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)(" Adding fetch limit of " + Integer.toString(upperLimit) + " fetches for expression '" + regexp + "' for connection '" + connectionName + "'"));
            }
            if ((ji = this.connectionMap.get(connectionName)) == null) {
                ji = new ThrottleJobItem();
                this.connectionMap.put(connectionName, ji);
            }
            ji.addLimit(regexp, upperLimit);
        }

        public void setConnectionLimit(String connectionName, int maxDocuments) {
            if (Logging.perf.isDebugEnabled()) {
                Logging.perf.debug((Object)(" Setting connection limit of " + Integer.toString(maxDocuments) + " for connection " + connectionName));
            }
            this.maxConnectionCounts.put(connectionName, new MutableInteger(maxDocuments));
        }

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            return this.makeDeepCopy();
        }

        public ThrottleLimit makeDeepCopy() {
            ThrottleLimit rval = new ThrottleLimit(this.n);
            rval.activeConnections = this.activeConnections;
            rval.setSizes = this.setSizes;
            rval.maxConnectionCounts = this.maxConnectionCounts;
            rval.maxSetSize = this.maxSetSize;
            rval.jobConnection = this.jobConnection;
            rval.documentsProcessed = this.documentsProcessed;
            for (String string : this.connectionMap.keySet()) {
                rval.connectionMap.put(string, this.connectionMap.get(string).duplicate());
            }
            for (Long l : this.jobQueueHash.keySet()) {
                rval.jobQueueHash.put(l, this.jobQueueHash.get(l).duplicate());
            }
            return rval;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public int getRemainingDocuments() {
            return EXTRA_FACTOR * this.n * this.maxSetSize - this.documentsProcessed;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            int j;
            QueueHashItem queueItem;
            Logging.perf.debug((Object)"Checking if row should be included");
            Long jobIDValue = (Long)row.getValue("jobid");
            String connectionName = this.jobConnection.get(jobIDValue);
            if (connectionName == null) {
                Logging.perf.debug((Object)" Row does not have an eligible job - excluding");
                return false;
            }
            IRepositoryConnector connectorInstance = this.activeConnections.get(connectionName);
            if (connectorInstance == null) {
                Logging.perf.debug((Object)" Row does not have an eligible connector instance - excluding");
                return false;
            }
            MutableInteger connectionLimit = this.maxConnectionCounts.get(connectionName);
            if (connectionLimit != null) {
                if (connectionLimit.intValue() == 0) {
                    Logging.perf.debug((Object)" Row exceeds its connection limit - excluding");
                    return false;
                }
                connectionLimit.decrement();
            }
            if ((queueItem = this.jobQueueHash.get(jobIDValue)) == null) {
                int maxCount = this.setSizes.get(connectionName);
                queueItem = new QueueHashItem(maxCount);
                this.jobQueueHash.put(jobIDValue, queueItem);
            }
            String docIDHash = (String)row.getValue("dochash");
            String docID = (String)row.getValue("docid");
            String[] binNames = ManifoldCF.calculateBins(connectorInstance, docID);
            ++this.documentsProcessed;
            ThrottleJobItem item = this.connectionMap.get(connectionName);
            if (item == null) {
                queueItem.addDocument();
                Logging.perf.debug((Object)" Row has no throttling - including");
                return true;
            }
            for (j = 0; j < binNames.length; ++j) {
                if (!item.isEmpty(binNames[j])) continue;
                if (Logging.perf.isDebugEnabled()) {
                    Logging.perf.debug((Object)(" Bin " + binNames[j] + " has no more available fetches - excluding"));
                }
                Long id = (Long)row.getValue("id");
                Long jobID = (Long)row.getValue("jobid");
                DocumentDescription dd = new DocumentDescription(id, jobID, docIDHash, docID);
                this.blockingDocumentArray.add(dd);
                return false;
            }
            j = 0;
            while (j < binNames.length) {
                item.decrement(binNames[j++]);
            }
            queueItem.addDocument();
            Logging.perf.debug((Object)" Including!");
            return true;
        }

        public boolean checkContinue() throws ManifoldCFException {
            if (this.documentsProcessed >= EXTRA_FACTOR * this.n * this.maxSetSize) {
                return false;
            }
            int count = 0;
            for (Long jobID : this.jobQueueHash.keySet()) {
                QueueHashItem item = this.jobQueueHash.get(jobID);
                if ((count += item.getChunkCount()) <= this.n) continue;
                return false;
            }
            return true;
        }
    }

    protected static class JobqueueRecord {
        protected Long recordID;
        protected int status;
        protected Long checkTimeValue;

        public JobqueueRecord(Long recordID, int status, Long checkTimeValue) {
            this.recordID = recordID;
            this.status = status;
            this.checkTimeValue = checkTimeValue;
        }

        public Long getRecordID() {
            return this.recordID;
        }

        public int getStatus() {
            return this.status;
        }

        public Long getCheckTimeValue() {
            return this.checkTimeValue;
        }
    }
}

