/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;

class ResponseCoercer
extends TypeCoercer<Response> {
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final JsonTypeCoercer coercer;

    ResponseCoercer(JsonTypeCoercer coercer) {
        this.coercer = Objects.requireNonNull(coercer);
    }

    @Override
    public boolean test(Class<?> aClass) {
        return Response.class.isAssignableFrom(aClass);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Response> apply(Type type) {
        return (jsonInput, setting) -> {
            String state;
            Response response = new Response();
            Map json = (Map)this.coercer.coerce((JsonInput)jsonInput, Json.MAP_TYPE, (PropertySetting)((Object)setting));
            if (json.get("error") instanceof String) {
                state = (String)json.get("error");
                response.setState(state);
                response.setStatus(this.errorCodes.toStatus(state, Optional.empty()));
                response.setValue(json.get("message"));
            }
            if (json.get("state") instanceof String) {
                state = (String)json.get("state");
                response.setState(state);
                response.setStatus(this.errorCodes.toStatus(state, Optional.empty()));
            }
            if (json.get("status") != null) {
                Object status = json.get("status");
                if (status instanceof String) {
                    String state2 = (String)status;
                    response.setState(state2);
                    response.setStatus(this.errorCodes.toStatus(state2, Optional.empty()));
                } else {
                    int intStatus = ((Number)status).intValue();
                    response.setState(this.errorCodes.toState(intStatus));
                    response.setStatus(intStatus);
                }
            }
            if (json.get("sessionId") instanceof String) {
                response.setSessionId((String)json.get("sessionId"));
            }
            response.setValue(json.getOrDefault("value", json));
            return response;
        };
    }
}

