/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableDocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableFolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableRelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableSecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.definitions.TypeMutability;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ItemTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.SecondaryTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeMutabilityImpl;

public final class TypeDefinitionFactory {
    private static final Set<String> NEW_CMIS11_PROPERTIES = new HashSet<String>();
    private Class<? extends MutableDocumentTypeDefinition> documentTypeDefinitionClass = DocumentTypeDefinitionImpl.class;
    private Class<? extends MutableFolderTypeDefinition> folderTypeDefinitionClass = FolderTypeDefinitionImpl.class;
    private Class<? extends MutablePolicyTypeDefinition> policyTypeDefinitionClass = PolicyTypeDefinitionImpl.class;
    private Class<? extends MutableRelationshipTypeDefinition> relationshipTypeDefinitionClass = RelationshipTypeDefinitionImpl.class;
    private Class<? extends MutableItemTypeDefinition> itemTypeDefinitionClass = ItemTypeDefinitionImpl.class;
    private Class<? extends MutableSecondaryTypeDefinition> secondaryTypeDefinitionClass = SecondaryTypeDefinitionImpl.class;
    private String defaultNamespace = null;
    private boolean defaultControllableAcl = false;
    private boolean defaultIsFullTextIndexed;
    private boolean defaultControllablePolicy = false;
    private boolean defaultQueryable = true;
    private boolean defaultFulltextIndexed = false;
    private TypeMutability defaultTypeMutability;

    private TypeDefinitionFactory() {
        TypeMutabilityImpl typeMutability = new TypeMutabilityImpl();
        typeMutability.setCanCreate(Boolean.valueOf(false));
        typeMutability.setCanUpdate(Boolean.valueOf(false));
        typeMutability.setCanDelete(Boolean.valueOf(false));
        this.defaultTypeMutability = typeMutability;
    }

    public static TypeDefinitionFactory newInstance() {
        return new TypeDefinitionFactory();
    }

    public Class<? extends MutableDocumentTypeDefinition> getDocumentTypeDefinitionClass() {
        return this.documentTypeDefinitionClass;
    }

    public void setDocumentTypeDefinitionClass(Class<? extends MutableDocumentTypeDefinition> documentTypeDefinitionClass) {
        this.checkClass(documentTypeDefinitionClass);
        this.documentTypeDefinitionClass = documentTypeDefinitionClass;
    }

    protected MutableDocumentTypeDefinition createDocumentTypeDefinitionObject() {
        try {
            return this.documentTypeDefinitionClass.newInstance();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Cannot create type defintion object: " + e.getMessage(), (Throwable)e);
        }
    }

    public Class<? extends MutableFolderTypeDefinition> getFolderTypeDefinitionClass() {
        return this.folderTypeDefinitionClass;
    }

    public void setFolderTypeDefinitionClass(Class<? extends MutableFolderTypeDefinition> folderTypeDefinitionClass) {
        this.checkClass(folderTypeDefinitionClass);
        this.folderTypeDefinitionClass = folderTypeDefinitionClass;
    }

    protected MutableFolderTypeDefinition createFolderTypeDefinitionObject() {
        try {
            return this.folderTypeDefinitionClass.newInstance();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Cannot create type defintion object: " + e.getMessage(), (Throwable)e);
        }
    }

    public Class<? extends MutablePolicyTypeDefinition> getPolicyTypeDefinitionClass() {
        return this.policyTypeDefinitionClass;
    }

    public void setPolicyTypeDefinitionClass(Class<? extends MutablePolicyTypeDefinition> policyTypeDefinitionClass) {
        this.checkClass(policyTypeDefinitionClass);
        this.policyTypeDefinitionClass = policyTypeDefinitionClass;
    }

    protected MutablePolicyTypeDefinition createPolicyTypeDefinitionObject() {
        try {
            return this.policyTypeDefinitionClass.newInstance();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Cannot create type defintion object: " + e.getMessage(), (Throwable)e);
        }
    }

    public Class<? extends MutableRelationshipTypeDefinition> getRelationshipTypeDefinitionClass() {
        return this.relationshipTypeDefinitionClass;
    }

    public void setRelationshipTypeDefinitionClass(Class<? extends MutableRelationshipTypeDefinition> relationshipTypeDefinitionClass) {
        this.checkClass(relationshipTypeDefinitionClass);
        this.relationshipTypeDefinitionClass = relationshipTypeDefinitionClass;
    }

    protected MutableRelationshipTypeDefinition createRelationshipTypeDefinitionObject() {
        try {
            return this.relationshipTypeDefinitionClass.newInstance();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Cannot create type defintion object: " + e.getMessage(), (Throwable)e);
        }
    }

    public Class<? extends MutableItemTypeDefinition> getItemTypeDefinitionClass() {
        return this.itemTypeDefinitionClass;
    }

    public void setItemTypeDefinitionClass(Class<? extends MutableItemTypeDefinition> itemTypeDefinitionClass) {
        this.checkClass(itemTypeDefinitionClass);
        this.itemTypeDefinitionClass = itemTypeDefinitionClass;
    }

    protected MutableItemTypeDefinition createItemTypeDefinitionObject() {
        try {
            return this.itemTypeDefinitionClass.newInstance();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Cannot create type defintion object: " + e.getMessage(), (Throwable)e);
        }
    }

    public Class<? extends MutableSecondaryTypeDefinition> getSecondaryTypeDefinitionClass() {
        return this.secondaryTypeDefinitionClass;
    }

    public void setSecondaryTypeDefinitionClass(Class<? extends MutableSecondaryTypeDefinition> secondaryTypeDefinitionClass) {
        this.checkClass(secondaryTypeDefinitionClass);
        this.secondaryTypeDefinitionClass = secondaryTypeDefinitionClass;
    }

    protected MutableSecondaryTypeDefinition createSecondaryTypeDefinitionObject() {
        try {
            return this.secondaryTypeDefinitionClass.newInstance();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Cannot create type defintion object: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkClass(Class<? extends MutableTypeDefinition> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be set!");
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class has no accessible default constructor!", e);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public boolean getDefaultIsFulltextIndexed() {
        return this.defaultIsFullTextIndexed;
    }

    public void setDefaultIsFulltextIndexed(boolean defaultIsFullTextIndexed) {
        this.defaultIsFullTextIndexed = defaultIsFullTextIndexed;
    }

    public boolean getDefaultControllableAcl() {
        return this.defaultControllableAcl;
    }

    public void setDefaultControllableAcl(boolean defaultControllableAcl) {
        this.defaultControllableAcl = defaultControllableAcl;
    }

    public boolean getDefaultControllablePolicy() {
        return this.defaultControllablePolicy;
    }

    public void setDefaultControllablePolicy(boolean defaultControllablePolicy) {
        this.defaultControllablePolicy = defaultControllablePolicy;
    }

    public boolean getDefaultQueryable() {
        return this.defaultQueryable;
    }

    public void setDefaultQueryable(boolean defaultQueryable) {
        this.defaultQueryable = defaultQueryable;
    }

    public boolean getDefaultFulltextIndexed() {
        return this.defaultFulltextIndexed;
    }

    public void setDefaultFulltextIndexed(boolean defaultFulltextIndexed) {
        this.defaultFulltextIndexed = defaultFulltextIndexed;
    }

    public TypeMutability getDefaultTypeMutability() {
        return this.defaultTypeMutability;
    }

    public void setDefaultTypeMutability(TypeMutability defaultTypeMutability) {
        this.defaultTypeMutability = defaultTypeMutability;
    }

    public TypeMutability createTypeMutability(boolean canCreate, boolean canUpdate, boolean canDelete) {
        TypeMutabilityImpl result = new TypeMutabilityImpl();
        result.setCanCreate(Boolean.valueOf(canCreate));
        result.setCanUpdate(Boolean.valueOf(canUpdate));
        result.setCanDelete(Boolean.valueOf(canDelete));
        return result;
    }

    public MutableDocumentTypeDefinition createBaseDocumentTypeDefinition(CmisVersion cmisVersion) {
        return this.createDocumentTypeDefinition(cmisVersion, null);
    }

    public MutableDocumentTypeDefinition createDocumentTypeDefinition(CmisVersion cmisVersion, String parentId) {
        MutableDocumentTypeDefinition documentType = this.createDocumentTypeDefinitionObject();
        documentType.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        documentType.setParentTypeId(parentId);
        documentType.setIsControllableAcl(Boolean.valueOf(this.defaultControllableAcl));
        documentType.setIsControllablePolicy(Boolean.valueOf(this.defaultControllablePolicy));
        documentType.setIsCreatable(Boolean.valueOf(true));
        documentType.setDescription("Document");
        documentType.setDisplayName("Document");
        documentType.setIsFileable(Boolean.valueOf(true));
        documentType.setIsFulltextIndexed(Boolean.valueOf(this.defaultFulltextIndexed));
        documentType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        documentType.setLocalName("Document");
        documentType.setLocalNamespace(this.defaultNamespace);
        documentType.setIsQueryable(Boolean.valueOf(this.defaultQueryable));
        documentType.setQueryName("cmis:document");
        documentType.setId(BaseTypeId.CMIS_DOCUMENT.value());
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            documentType.setTypeMutability(this.defaultTypeMutability);
        }
        documentType.setIsVersionable(Boolean.valueOf(false));
        documentType.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        this.addBasePropertyDefinitions((MutableTypeDefinition)documentType, cmisVersion, parentId != null);
        this.addDocumentPropertyDefinitions(documentType, cmisVersion, parentId != null);
        return documentType;
    }

    public MutableFolderTypeDefinition createBaseFolderTypeDefinition(CmisVersion cmisVersion) {
        return this.createFolderTypeDefinition(cmisVersion, null);
    }

    public MutableFolderTypeDefinition createFolderTypeDefinition(CmisVersion cmisVersion, String parentId) {
        MutableFolderTypeDefinition folderType = this.createFolderTypeDefinitionObject();
        folderType.setBaseTypeId(BaseTypeId.CMIS_FOLDER);
        folderType.setParentTypeId(parentId);
        folderType.setIsControllableAcl(Boolean.valueOf(this.defaultControllableAcl));
        folderType.setIsControllablePolicy(Boolean.valueOf(this.defaultControllablePolicy));
        folderType.setIsCreatable(Boolean.valueOf(true));
        folderType.setDescription("Folder");
        folderType.setDisplayName("Folder");
        folderType.setIsFileable(Boolean.valueOf(true));
        folderType.setIsFulltextIndexed(Boolean.valueOf(this.defaultFulltextIndexed));
        folderType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        folderType.setLocalName("Folder");
        folderType.setLocalNamespace(this.defaultNamespace);
        folderType.setIsQueryable(Boolean.valueOf(this.defaultQueryable));
        folderType.setQueryName("cmis:folder");
        folderType.setId(BaseTypeId.CMIS_FOLDER.value());
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            folderType.setTypeMutability(this.defaultTypeMutability);
        }
        this.addBasePropertyDefinitions((MutableTypeDefinition)folderType, cmisVersion, parentId != null);
        this.addFolderPropertyDefinitions(folderType, cmisVersion, parentId != null);
        return folderType;
    }

    public MutablePolicyTypeDefinition createBasePolicyTypeDefinition(CmisVersion cmisVersion) {
        return this.createPolicyTypeDefinition(cmisVersion, null);
    }

    public MutablePolicyTypeDefinition createPolicyTypeDefinition(CmisVersion cmisVersion, String parentId) {
        MutablePolicyTypeDefinition policyType = this.createPolicyTypeDefinitionObject();
        policyType.setBaseTypeId(BaseTypeId.CMIS_POLICY);
        policyType.setParentTypeId(parentId);
        policyType.setIsControllableAcl(Boolean.valueOf(this.defaultControllableAcl));
        policyType.setIsControllablePolicy(Boolean.valueOf(this.defaultControllablePolicy));
        policyType.setIsCreatable(Boolean.valueOf(false));
        policyType.setDescription("Policy");
        policyType.setDisplayName("Policy");
        policyType.setIsFileable(Boolean.valueOf(false));
        policyType.setIsFulltextIndexed(Boolean.valueOf(this.defaultFulltextIndexed));
        policyType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        policyType.setLocalName("Policy");
        policyType.setLocalNamespace(this.defaultNamespace);
        policyType.setIsQueryable(Boolean.valueOf(this.defaultQueryable));
        policyType.setQueryName("cmis:policy");
        policyType.setId(BaseTypeId.CMIS_POLICY.value());
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            policyType.setTypeMutability(this.defaultTypeMutability);
        }
        this.addBasePropertyDefinitions((MutableTypeDefinition)policyType, cmisVersion, parentId != null);
        this.addPolicyPropertyDefinitions(policyType, cmisVersion, parentId != null);
        return policyType;
    }

    public MutableRelationshipTypeDefinition createBaseRelationshipTypeDefinition(CmisVersion cmisVersion) {
        return this.createRelationshipTypeDefinition(cmisVersion, null);
    }

    public MutableRelationshipTypeDefinition createRelationshipTypeDefinition(CmisVersion cmisVersion, String parentId) {
        MutableRelationshipTypeDefinition relationshipType = this.createRelationshipTypeDefinitionObject();
        relationshipType.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        relationshipType.setParentTypeId(parentId);
        relationshipType.setIsControllableAcl(Boolean.valueOf(this.defaultControllableAcl));
        relationshipType.setIsControllablePolicy(Boolean.valueOf(this.defaultControllablePolicy));
        relationshipType.setIsCreatable(Boolean.valueOf(false));
        relationshipType.setDescription("Relationship");
        relationshipType.setDisplayName("Relationship");
        relationshipType.setIsFileable(Boolean.valueOf(false));
        relationshipType.setIsFulltextIndexed(Boolean.valueOf(this.defaultFulltextIndexed));
        relationshipType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        relationshipType.setLocalName("Relationship");
        relationshipType.setLocalNamespace(this.defaultNamespace);
        relationshipType.setIsQueryable(Boolean.valueOf(this.defaultQueryable));
        relationshipType.setQueryName("cmis:relationship");
        relationshipType.setId(BaseTypeId.CMIS_RELATIONSHIP.value());
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            relationshipType.setTypeMutability(this.defaultTypeMutability);
        }
        this.addBasePropertyDefinitions((MutableTypeDefinition)relationshipType, cmisVersion, parentId != null);
        this.addRelationshipPropertyDefinitions(relationshipType, cmisVersion, parentId != null);
        return relationshipType;
    }

    public MutableItemTypeDefinition createBaseItemTypeDefinition(CmisVersion cmisVersion) {
        return this.createItemTypeDefinition(cmisVersion, null);
    }

    public MutableItemTypeDefinition createItemTypeDefinition(CmisVersion cmisVersion, String parentId) {
        if (cmisVersion == CmisVersion.CMIS_1_0) {
            throw new IllegalArgumentException("CMIS 1.0 doesn't support item types!");
        }
        MutableItemTypeDefinition itemType = this.createItemTypeDefinitionObject();
        itemType.setBaseTypeId(BaseTypeId.CMIS_ITEM);
        itemType.setParentTypeId(parentId);
        itemType.setIsControllableAcl(Boolean.valueOf(this.defaultControllableAcl));
        itemType.setIsControllablePolicy(Boolean.valueOf(this.defaultControllablePolicy));
        itemType.setIsCreatable(Boolean.valueOf(true));
        itemType.setDescription("Item");
        itemType.setDisplayName("Item");
        itemType.setIsFileable(Boolean.valueOf(true));
        itemType.setIsFulltextIndexed(Boolean.valueOf(this.defaultFulltextIndexed));
        itemType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        itemType.setLocalName("Item");
        itemType.setLocalNamespace(this.defaultNamespace);
        itemType.setIsQueryable(Boolean.valueOf(this.defaultQueryable));
        itemType.setQueryName("cmis:item");
        itemType.setId(BaseTypeId.CMIS_ITEM.value());
        itemType.setTypeMutability(this.defaultTypeMutability);
        this.addBasePropertyDefinitions((MutableTypeDefinition)itemType, cmisVersion, parentId != null);
        return itemType;
    }

    public MutableSecondaryTypeDefinition createBaseSecondaryTypeDefinition(CmisVersion cmisVersion) {
        return this.createSecondaryTypeDefinition(cmisVersion, null);
    }

    public MutableSecondaryTypeDefinition createSecondaryTypeDefinition(CmisVersion cmisVersion, String parentId) {
        if (cmisVersion == CmisVersion.CMIS_1_0) {
            throw new IllegalArgumentException("CMIS 1.0 doesn't support secondary types!");
        }
        MutableSecondaryTypeDefinition secondaryType = this.createSecondaryTypeDefinitionObject();
        secondaryType.setBaseTypeId(BaseTypeId.CMIS_SECONDARY);
        secondaryType.setParentTypeId(parentId);
        secondaryType.setIsControllableAcl(Boolean.valueOf(false));
        secondaryType.setIsControllablePolicy(Boolean.valueOf(false));
        secondaryType.setIsCreatable(Boolean.valueOf(false));
        secondaryType.setDescription("Secondary");
        secondaryType.setDisplayName("Secondary");
        secondaryType.setIsFileable(Boolean.valueOf(false));
        secondaryType.setIsFulltextIndexed(Boolean.valueOf(false));
        secondaryType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        secondaryType.setLocalName("Secondary");
        secondaryType.setLocalNamespace(this.defaultNamespace);
        secondaryType.setIsQueryable(Boolean.valueOf(this.defaultQueryable));
        secondaryType.setQueryName("cmis:secondary");
        secondaryType.setId(BaseTypeId.CMIS_SECONDARY.value());
        secondaryType.setTypeMutability(this.defaultTypeMutability);
        return secondaryType;
    }

    public MutableTypeDefinition createChildTypeDefinition(TypeDefinition parentTypeDefinition, String id) {
        return this.createChildTypeDefinition(parentTypeDefinition, id, id, id, id, null, true, null);
    }

    public MutableTypeDefinition createChildTypeDefinition(TypeDefinition parentTypeDefinition, String id, String localName, String queryName, String displayName, String description, boolean includePropertyDefinitions, CmisVersion cmisVersion) {
        if (parentTypeDefinition == null) {
            throw new IllegalArgumentException("Parent type must be set!");
        }
        if (id == null) {
            throw new IllegalArgumentException("Child id must be set!");
        }
        MutableTypeDefinition childType = this.copy(parentTypeDefinition, false);
        childType.setParentTypeId(parentTypeDefinition.getId());
        childType.setDescription(description);
        childType.setDisplayName(displayName);
        childType.setLocalName(localName);
        childType.setQueryName(queryName);
        childType.setId(id);
        if (includePropertyDefinitions) {
            this.copyPropertyDefinitions(parentTypeDefinition, childType, cmisVersion, true);
        }
        return childType;
    }

    public MutablePropertyDefinition<?> createPropertyDefinition(String id, String displayName, String description, PropertyType datatype, Cardinality cardinality, Updatability updateability, boolean inherited, boolean required, boolean queryable, boolean orderable) {
        if (id == null) {
            throw new IllegalArgumentException("ID must be set!");
        }
        if (datatype == null) {
            throw new IllegalArgumentException("Datatype must be set!");
        }
        if (cardinality == null) {
            throw new IllegalArgumentException("Cardinality must be set!");
        }
        if (updateability == null) {
            throw new IllegalArgumentException("Updateability must be set!");
        }
        PropertyBooleanDefinitionImpl result = null;
        switch (datatype) {
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                break;
            }
            case STRING: {
                result = new PropertyStringDefinitionImpl();
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown datatype! Spec change?");
            }
        }
        result.setId(id);
        result.setLocalName(id);
        result.setDisplayName(displayName);
        result.setDescription(description);
        result.setPropertyType(datatype);
        result.setCardinality(cardinality);
        result.setUpdatability(updateability);
        result.setIsInherited(Boolean.valueOf(inherited));
        result.setIsRequired(Boolean.valueOf(required));
        result.setIsQueryable(Boolean.valueOf(queryable));
        result.setIsOrderable(Boolean.valueOf(orderable));
        result.setQueryName(id);
        return result;
    }

    public <T> Choice<T> createChoice(String displayName, T value) {
        ChoiceImpl result = new ChoiceImpl();
        result.setDisplayName(displayName);
        result.setValue(value);
        return result;
    }

    public <T> Choice<T> createChoice(String displayName, List<T> value) {
        ChoiceImpl result = new ChoiceImpl();
        result.setDisplayName(displayName);
        result.setValue(value);
        return result;
    }

    public <T> Choice<T> createChoiceWithSubChoices(String displayName, List<Choice<T>> subChoice) {
        ChoiceImpl result = new ChoiceImpl();
        result.setDisplayName(displayName);
        result.setChoice(subChoice);
        return result;
    }

    public TypeDefinitionList createTypeDefinitionList(List<TypeDefinition> list, boolean hasMoreItems, BigInteger numItems) {
        if (list == null) {
            throw new IllegalArgumentException("List must be set!");
        }
        if (numItems != null && numItems.signum() < 0) {
            throw new IllegalArgumentException("Number of items is negative!");
        }
        TypeDefinitionListImpl result = new TypeDefinitionListImpl(list);
        result.setHasMoreItems(Boolean.valueOf(hasMoreItems));
        result.setNumItems(numItems);
        return result;
    }

    public TypeDefinitionList createTypeDefinitionList(Map<String, TypeDefinition> allTypes, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        return this.createTypeDefinitionList(allTypes, typeId, includePropertyDefinitions, maxItems, skipCount, null);
    }

    public TypeDefinitionList createTypeDefinitionList(Map<String, TypeDefinition> allTypes, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, CmisVersion cmisVersion) {
        int skipCountInt;
        int maxItemsInt;
        if (allTypes == null) {
            throw new IllegalArgumentException("Types map must be set!");
        }
        if (typeId != null && !allTypes.containsKey(typeId)) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' does not exist!");
        }
        TypeDefinitionListImpl result = new TypeDefinitionListImpl(Collections.emptyList());
        result.setHasMoreItems(Boolean.valueOf(false));
        result.setNumItems(BigInteger.ZERO);
        if (allTypes.isEmpty()) {
            return result;
        }
        int n = maxItemsInt = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (maxItemsInt < 0) {
            maxItemsInt = 0;
        }
        int n2 = skipCountInt = skipCount == null ? 0 : skipCount.intValue();
        if (skipCountInt < 0) {
            skipCountInt = 0;
        }
        boolean includePropertyDefinitionsBool = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        ArrayList<MutableTypeDefinition> targetList = new ArrayList<MutableTypeDefinition>();
        for (TypeDefinition typeDef : allTypes.values()) {
            if ((typeId != null || typeDef.getParentTypeId() != null) && (typeId == null || !typeId.equals(typeDef.getParentTypeId()))) continue;
            targetList.add(this.copy(typeDef, includePropertyDefinitionsBool, cmisVersion));
        }
        if (skipCountInt >= targetList.size()) {
            result.setHasMoreItems(Boolean.valueOf(false));
            result.setNumItems(BigInteger.valueOf(targetList.size()));
            return result;
        }
        Collections.sort(targetList, new Comparator<TypeDefinition>(){

            @Override
            public int compare(TypeDefinition td1, TypeDefinition td2) {
                String pid1 = td1.getParentTypeId();
                String pid2 = td2.getParentTypeId();
                if (pid1 == null) {
                    if (pid2 == null) {
                        return td1.getId().compareTo(td2.getId());
                    }
                    return -1;
                }
                if (pid2 == null) {
                    return 1;
                }
                int c = pid1.compareTo(pid2);
                if (c == 0) {
                    return td1.getId().compareTo(td2.getId());
                }
                return c;
            }
        });
        result.setList(targetList.subList(skipCountInt, Math.min(skipCountInt + maxItemsInt, targetList.size())));
        result.setNumItems(BigInteger.valueOf(targetList.size()));
        result.setHasMoreItems(Boolean.valueOf(targetList.size() > skipCountInt + maxItemsInt));
        return result;
    }

    public TypeDefinitionContainer createTypeDefinitionContainer(TypeDefinition typeDef, List<TypeDefinitionContainer> children) {
        if (typeDef == null) {
            throw new IllegalArgumentException("Type definition must be set!");
        }
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl(typeDef);
        result.setChildren(children);
        return result;
    }

    public List<TypeDefinitionContainer> createTypeDescendants(Map<String, TypeDefinition> allTypes, String typeId, BigInteger depth, Boolean includePropertyDefinitions) {
        return this.createTypeDescendants(allTypes, typeId, depth, includePropertyDefinitions, null);
    }

    public List<TypeDefinitionContainer> createTypeDescendants(Map<String, TypeDefinition> allTypes, String typeId, BigInteger depth, Boolean includePropertyDefinitions, CmisVersion cmisVersion) {
        int depthInt;
        if (allTypes == null) {
            throw new IllegalArgumentException("Types map must be set!");
        }
        int n = depthInt = depth == null ? -1 : depth.intValue();
        if (depthInt == 0) {
            throw new IllegalArgumentException("Depth must not be 0!");
        }
        if (typeId == null) {
            depthInt = -1;
        }
        if (typeId != null && !allTypes.containsKey(typeId)) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' does not exist!");
        }
        if (allTypes.isEmpty()) {
            return Collections.emptyList();
        }
        boolean includePropertyDefinitionsBool = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        HashMap<String, Set<String>> typeDefChildren = new HashMap<String, Set<String>>();
        for (TypeDefinition typeDef : allTypes.values()) {
            HashSet<String> children = (HashSet<String>)typeDefChildren.get(typeDef.getParentTypeId());
            if (children == null) {
                children = new HashSet<String>();
                typeDefChildren.put(typeDef.getParentTypeId(), children);
            }
            children.add(typeDef.getId());
        }
        Set children = (Set)typeDefChildren.get(typeId);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        for (String child : children) {
            result.add(this.createTypeDefinitionContainer(allTypes, typeDefChildren, child, depthInt - 1, includePropertyDefinitionsBool, cmisVersion));
        }
        return result;
    }

    private TypeDefinitionContainer createTypeDefinitionContainer(Map<String, TypeDefinition> allTypes, Map<String, Set<String>> typeDefChildren, String typeId, int depth, boolean includePropertyDefinitions, CmisVersion cmisVersion) {
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl();
        result.setTypeDefinition((TypeDefinition)(includePropertyDefinitions ? this.copy(allTypes.get(typeId), true, cmisVersion) : this.copy(allTypes.get(typeId), false, cmisVersion)));
        if (depth != 0 && typeDefChildren.containsKey(typeId)) {
            for (String child : typeDefChildren.get(typeId)) {
                result.getChildren().add(this.createTypeDefinitionContainer(allTypes, typeDefChildren, child, depth < 0 ? -1 : depth - 1, includePropertyDefinitions, cmisVersion));
            }
        }
        return result;
    }

    public MutableTypeDefinition copy(TypeDefinition sourceTypeDefintion, boolean includePropertyDefinitions) {
        return this.copy(sourceTypeDefintion, includePropertyDefinitions, null);
    }

    public MutableTypeDefinition copy(TypeDefinition sourceTypeDefintion, boolean includePropertyDefinitions, CmisVersion cmisVersion) {
        if (sourceTypeDefintion == null) {
            throw new IllegalArgumentException("Source type must be set!");
        }
        if (sourceTypeDefintion.getBaseTypeId() == null) {
            throw new IllegalArgumentException("Source type has no base type!");
        }
        MutableDocumentTypeDefinition result = null;
        switch (sourceTypeDefintion.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                result = this.createDocumentTypeDefinitionObject();
                result.setIsVersionable(((DocumentTypeDefinition)sourceTypeDefintion).isVersionable());
                result.setContentStreamAllowed(((DocumentTypeDefinition)sourceTypeDefintion).getContentStreamAllowed());
                break;
            }
            case CMIS_FOLDER: {
                result = this.createFolderTypeDefinitionObject();
                break;
            }
            case CMIS_POLICY: {
                result = this.createPolicyTypeDefinitionObject();
                break;
            }
            case CMIS_RELATIONSHIP: {
                List targetTypeIds;
                result = this.createRelationshipTypeDefinitionObject();
                List sourceTypeIds = ((RelationshipTypeDefinition)sourceTypeDefintion).getAllowedSourceTypeIds();
                if (sourceTypeIds != null) {
                    ((MutableRelationshipTypeDefinition)result).setAllowedSourceTypes(new ArrayList(sourceTypeIds));
                }
                if ((targetTypeIds = ((RelationshipTypeDefinition)sourceTypeDefintion).getAllowedTargetTypeIds()) == null) break;
                ((MutableRelationshipTypeDefinition)result).setAllowedTargetTypes(new ArrayList(targetTypeIds));
                break;
            }
            case CMIS_ITEM: {
                if (cmisVersion == CmisVersion.CMIS_1_0) {
                    throw new IllegalArgumentException("CMIS 1.0 doesn't support item types!");
                }
                result = this.createItemTypeDefinitionObject();
                break;
            }
            case CMIS_SECONDARY: {
                if (cmisVersion == CmisVersion.CMIS_1_0) {
                    throw new IllegalArgumentException("CMIS 1.0 doesn't support secondary types!");
                }
                result = this.createSecondaryTypeDefinitionObject();
                break;
            }
            default: {
                throw new RuntimeException("Unknown base type!");
            }
        }
        result.setId(sourceTypeDefintion.getId());
        result.setLocalName(sourceTypeDefintion.getLocalName());
        result.setLocalNamespace(sourceTypeDefintion.getLocalNamespace());
        result.setDisplayName(sourceTypeDefintion.getDisplayName());
        result.setQueryName(sourceTypeDefintion.getQueryName());
        result.setDescription(sourceTypeDefintion.getDescription());
        result.setBaseTypeId(sourceTypeDefintion.getBaseTypeId());
        result.setParentTypeId(sourceTypeDefintion.getParentTypeId());
        result.setIsCreatable(sourceTypeDefintion.isCreatable());
        result.setIsFileable(sourceTypeDefintion.isFileable());
        result.setIsQueryable(sourceTypeDefintion.isQueryable());
        result.setIsFulltextIndexed(sourceTypeDefintion.isFulltextIndexed());
        result.setIsIncludedInSupertypeQuery(sourceTypeDefintion.isIncludedInSupertypeQuery());
        result.setIsControllablePolicy(sourceTypeDefintion.isControllablePolicy());
        result.setIsControllableAcl(sourceTypeDefintion.isControllableAcl());
        if (cmisVersion != CmisVersion.CMIS_1_0 && sourceTypeDefintion.getTypeMutability() != null) {
            result.setTypeMutability(this.createTypeMutability(sourceTypeDefintion.getTypeMutability().canCreate(), sourceTypeDefintion.getTypeMutability().canUpdate(), sourceTypeDefintion.getTypeMutability().canDelete()));
        }
        this.copyExtensions((ExtensionsData)sourceTypeDefintion, (ExtensionsData)result);
        if (includePropertyDefinitions) {
            this.copyPropertyDefinitions(sourceTypeDefintion, (MutableTypeDefinition)result, cmisVersion, false);
        }
        return result;
    }

    public MutablePropertyDefinition<?> copy(PropertyDefinition<?> sourcePropertyDefinition) {
        if (sourcePropertyDefinition == null) {
            throw new IllegalArgumentException("Source definition must be set!");
        }
        if (sourcePropertyDefinition.getPropertyType() == null) {
            throw new IllegalArgumentException("Source definition property type must be set!");
        }
        PropertyBooleanDefinitionImpl result = null;
        switch (sourcePropertyDefinition.getPropertyType()) {
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                result.setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyBooleanDefinition)sourcePropertyDefinition)));
                result.setChoices(this.copyChoices((PropertyDefinition)((PropertyBooleanDefinition)sourcePropertyDefinition)));
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                ((PropertyDateTimeDefinitionImpl)result).setDateTimeResolution(((PropertyDateTimeDefinition)sourcePropertyDefinition).getDateTimeResolution());
                ((PropertyDateTimeDefinitionImpl)result).setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyDateTimeDefinition)sourcePropertyDefinition)));
                ((PropertyDateTimeDefinitionImpl)result).setChoices(this.copyChoices((PropertyDefinition)((PropertyDateTimeDefinition)sourcePropertyDefinition)));
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                ((PropertyDecimalDefinitionImpl)result).setMinValue(((PropertyDecimalDefinition)sourcePropertyDefinition).getMinValue());
                ((PropertyDecimalDefinitionImpl)result).setMaxValue(((PropertyDecimalDefinition)sourcePropertyDefinition).getMaxValue());
                ((PropertyDecimalDefinitionImpl)result).setPrecision(((PropertyDecimalDefinition)sourcePropertyDefinition).getPrecision());
                ((PropertyDecimalDefinitionImpl)result).setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyDecimalDefinition)sourcePropertyDefinition)));
                ((PropertyDecimalDefinitionImpl)result).setChoices(this.copyChoices((PropertyDefinition)((PropertyDecimalDefinition)sourcePropertyDefinition)));
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                ((PropertyHtmlDefinitionImpl)result).setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyHtmlDefinition)sourcePropertyDefinition)));
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                ((PropertyIdDefinitionImpl)result).setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyIdDefinition)sourcePropertyDefinition)));
                ((PropertyIdDefinitionImpl)result).setChoices(this.copyChoices((PropertyDefinition)((PropertyIdDefinition)sourcePropertyDefinition)));
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                ((PropertyIntegerDefinitionImpl)result).setMinValue(((PropertyIntegerDefinition)sourcePropertyDefinition).getMinValue());
                ((PropertyIntegerDefinitionImpl)result).setMaxValue(((PropertyIntegerDefinition)sourcePropertyDefinition).getMaxValue());
                ((PropertyIntegerDefinitionImpl)result).setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyIntegerDefinition)sourcePropertyDefinition)));
                ((PropertyIntegerDefinitionImpl)result).setChoices(this.copyChoices((PropertyDefinition)((PropertyIntegerDefinition)sourcePropertyDefinition)));
                break;
            }
            case STRING: {
                result = new PropertyStringDefinitionImpl();
                ((PropertyStringDefinitionImpl)result).setMaxLength(((PropertyStringDefinition)sourcePropertyDefinition).getMaxLength());
                ((PropertyStringDefinitionImpl)result).setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyStringDefinition)sourcePropertyDefinition)));
                ((PropertyStringDefinitionImpl)result).setChoices(this.copyChoices((PropertyDefinition)((PropertyStringDefinition)sourcePropertyDefinition)));
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                ((PropertyUriDefinitionImpl)result).setDefaultValue(this.copyDefaultValue((PropertyDefinition)((PropertyUriDefinition)sourcePropertyDefinition)));
                ((PropertyUriDefinitionImpl)result).setChoices(this.copyChoices((PropertyDefinition)((PropertyUriDefinition)sourcePropertyDefinition)));
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype!");
            }
        }
        result.setId(sourcePropertyDefinition.getId());
        result.setLocalName(sourcePropertyDefinition.getLocalName());
        result.setLocalNamespace(sourcePropertyDefinition.getLocalNamespace());
        result.setDisplayName(sourcePropertyDefinition.getDisplayName());
        result.setDescription(sourcePropertyDefinition.getDescription());
        result.setPropertyType(sourcePropertyDefinition.getPropertyType());
        result.setCardinality(sourcePropertyDefinition.getCardinality());
        result.setUpdatability(sourcePropertyDefinition.getUpdatability());
        result.setIsInherited(sourcePropertyDefinition.isInherited());
        result.setIsRequired(sourcePropertyDefinition.isRequired());
        result.setIsQueryable(sourcePropertyDefinition.isQueryable());
        result.setIsOrderable(sourcePropertyDefinition.isOrderable());
        result.setQueryName(sourcePropertyDefinition.getQueryName());
        result.setIsOpenChoice(sourcePropertyDefinition.isOpenChoice());
        this.copyExtensions((ExtensionsData)sourcePropertyDefinition, (ExtensionsData)result);
        return result;
    }

    protected void copyPropertyDefinitions(TypeDefinition source, MutableTypeDefinition target, CmisVersion cmisVersion, boolean markAsInherited) {
        assert (source != null);
        assert (target != null);
        if (source.getPropertyDefinitions() != null) {
            for (PropertyDefinition propDef : source.getPropertyDefinitions().values()) {
                if (cmisVersion == CmisVersion.CMIS_1_0 && NEW_CMIS11_PROPERTIES.contains(propDef.getId())) continue;
                MutablePropertyDefinition<?> newPropDef = this.copy(propDef);
                if (markAsInherited) {
                    newPropDef.setIsInherited(Boolean.valueOf(true));
                }
                target.addPropertyDefinition(newPropDef);
            }
        }
    }

    protected <T> List<T> copyDefaultValue(PropertyDefinition<T> source) {
        if (source == null || source.getDefaultValue() == null) {
            return null;
        }
        return new ArrayList(source.getDefaultValue());
    }

    protected <T> List<Choice<T>> copyChoices(PropertyDefinition<T> source) {
        if (source == null || source.getChoices() == null) {
            return null;
        }
        ArrayList<Choice<T>> result = new ArrayList<Choice<T>>(0);
        for (Choice c : source.getChoices()) {
            result.add(this.copyChoice(c));
        }
        return result;
    }

    private <T> Choice<T> copyChoice(Choice<T> source) {
        if (source == null) {
            return null;
        }
        ChoiceImpl result = new ChoiceImpl();
        result.setDisplayName(source.getDisplayName());
        if (source.getValue() != null) {
            result.setValue(new ArrayList(source.getValue()));
        }
        if (source.getChoice() != null) {
            ArrayList<Choice<T>> choices = new ArrayList<Choice<T>>();
            for (Choice c : source.getChoice()) {
                choices.add(this.copyChoice(c));
            }
            result.setChoice(choices);
        }
        return result;
    }

    protected void copyExtensions(ExtensionsData source, ExtensionsData target) {
        if (source == null || target == null) {
            return;
        }
        if (source.getExtensions() == null) {
            target.setExtensions(null);
            return;
        }
        ArrayList<CmisExtensionElement> elementList = new ArrayList<CmisExtensionElement>();
        for (CmisExtensionElement element : source.getExtensions()) {
            elementList.add(this.copy(element));
        }
        target.setExtensions(elementList);
    }

    private CmisExtensionElement copy(CmisExtensionElement element) {
        if (element == null) {
            return null;
        }
        HashMap attrs = element.getAttributes() != null ? new HashMap(element.getAttributes()) : null;
        List children = element.getChildren();
        if (CollectionsHelper.isNotEmpty((Collection)children)) {
            ArrayList<CmisExtensionElement> copyChildren = new ArrayList<CmisExtensionElement>(children.size());
            for (CmisExtensionElement child : children) {
                copyChildren.add(this.copy(child));
            }
            return new CmisExtensionElementImpl(element.getNamespace(), element.getName(), attrs, copyChildren);
        }
        return new CmisExtensionElementImpl(element.getNamespace(), element.getName(), attrs, element.getValue());
    }

    protected void addBasePropertyDefinitions(MutableTypeDefinition type, CmisVersion cmisVersion, boolean inherited) {
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:name", "Name", "Name", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, inherited, true, true, true));
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            type.addPropertyDefinition(this.createPropertyDefinition("cmis:description", "Description", "Description", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, inherited, false, false, false));
        }
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:objectId", "Object Id", "Object Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:baseTypeId", "Base Type Id", "Base Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:objectTypeId", "Object Type Id", "Object Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, inherited, true, true, false));
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            type.addPropertyDefinition(this.createPropertyDefinition("cmis:secondaryObjectTypeIds", "Secondary Type Ids", "Secondary Type Ids", PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, inherited, false, true, false));
        }
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:createdBy", "Created By", "Created By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, true));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:creationDate", "Creation Date", "Creation Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, true));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:lastModifiedBy", "Last Modified By", "Last Modified By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, true));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:lastModificationDate", "Last Modification Date", "Last Modification Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, true));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:changeToken", "Change Token", "Change Token", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
    }

    protected void addDocumentPropertyDefinitions(MutableDocumentTypeDefinition type, CmisVersion cmisVersion, boolean inherited) {
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:isImmutable", "Is Immutable", "Is Immutable", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:isLatestVersion", "Is Latest Version", "Is Latest Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:isMajorVersion", "Is Major Version", "Is Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:isLatestMajorVersion", "Is Latest Major Version", "Is Latest Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            type.addPropertyDefinition(this.createPropertyDefinition("cmis:isPrivateWorkingCopy", "Is Private Working Copy", "Is Private Working Copy", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, false));
        }
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:versionLabel", "Version Label", "Version Label", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:versionSeriesId", "Version Series Id", "Version Series Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:isVersionSeriesCheckedOut", "Is Verison Series Checked Out", "Is Verison Series Checked Out", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, inherited, false, true, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:versionSeriesCheckedOutBy", "Version Series Checked Out By", "Version Series Checked Out By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:versionSeriesCheckedOutId", "Version Series Checked Out Id", "Version Series Checked Out Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:checkinComment", "Checkin Comment", "Checkin Comment", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:contentStreamLength", "Content Stream Length", "Content Stream Length", PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:contentStreamMimeType", "MIME Type", "MIME Type", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:contentStreamFileName", "Filename", "Filename", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:contentStreamId", "Content Stream Id", "Content Stream Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
    }

    protected void addFolderPropertyDefinitions(MutableFolderTypeDefinition type, CmisVersion cmisVersion, boolean inherited) {
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:parentId", "Parent Id", "Parent Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:path", "Path", "Path", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, inherited, false, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:allowedChildObjectTypeIds", "Allowed Child Object Type Ids", "Allowed Child Object Type Ids", PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, inherited, false, false, false));
    }

    protected void addPolicyPropertyDefinitions(MutablePolicyTypeDefinition type, CmisVersion cmisVersion, boolean inherited) {
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:policyText", "Policy Text", "Policy Text", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, inherited, false, false, false));
    }

    protected void addRelationshipPropertyDefinitions(MutableRelationshipTypeDefinition type, CmisVersion cmisVersion, boolean inherited) {
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:sourceId", "Source Id", "Source Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READWRITE, inherited, true, false, false));
        type.addPropertyDefinition(this.createPropertyDefinition("cmis:targetId", "Target Id", "Target Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READWRITE, inherited, true, false, false));
    }

    static {
        NEW_CMIS11_PROPERTIES.add("cmis:description");
        NEW_CMIS11_PROPERTIES.add("cmis:secondaryObjectTypeIds");
        NEW_CMIS11_PROPERTIES.add("cmis:isPrivateWorkingCopy");
    }
}

