/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.Objects;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.Prior;

public class UniformPrior
implements Prior {
    private int numOutcomes;
    private double r;

    @Override
    public void logPrior(double[] dist, int[] context, float[] values) {
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            dist[oi] = this.r;
        }
    }

    @Override
    public void logPrior(double[] dist, Context[] context, float[] values) {
        this.logPrior(dist, (int[])null, values);
    }

    @Override
    public void logPrior(double[] dist, int[] context) {
        this.logPrior(dist, context, null);
    }

    @Override
    public void setLabels(String[] outcomeLabels, String[] contextLabels) {
        this.numOutcomes = outcomeLabels.length;
        this.r = StrictMath.log(1.0 / (double)this.numOutcomes);
    }

    public int hashCode() {
        return Objects.hash(this.numOutcomes, this.r);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UniformPrior) {
            UniformPrior prior = (UniformPrior)obj;
            return this.numOutcomes == prior.numOutcomes && this.r == prior.r;
        }
        return false;
    }
}

