/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.cookies;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisCookieStoreImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisHttpCookie;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisCookieManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)CmisCookieManager.class.getName());
    private static final String VERSION_ZERO_HEADER = "Set-cookie";
    private static final String VERSION_ONE_HEADER = "Set-cookie2";
    private final String sessionId;
    private final CmisCookieStoreImpl store;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public CmisCookieManager() {
        this("<unknown>");
    }

    public CmisCookieManager(String sessionId) {
        this.sessionId = sessionId;
        this.store = new CmisCookieStoreImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> get(String url, Map<String, List<String>> requestHeaders) {
        URI uri;
        if (url == null || requestHeaders == null) {
            throw new IllegalArgumentException("URL or headers are null!");
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new CmisConnectionException(e.getMessage(), (Throwable)e);
        }
        this.lock.writeLock().lock();
        try {
            List<CmisHttpCookie> cookies = this.store.get(uri);
            String uriPath = uri.getPath();
            for (int i = 0; i < cookies.size(); ++i) {
                CmisHttpCookie cookie = cookies.get(i);
                String cookiePath = cookie.getPath();
                if (cookiePath != null && uriPath.length() != 0 && uriPath.startsWith(cookiePath)) continue;
                cookies.remove(i);
            }
            Map<String, List<String>> map = CmisCookieManager.getCookieMap(cookies, requestHeaders);
            if (LOG.isDebugEnabled() && map != null && !map.isEmpty()) {
                LOG.debug("Session {}: Setting cookies for URL {}: {}", new Object[]{this.sessionId, url, map.get("Cookie") == null ? "" : map.get("Cookie").toString()});
            }
            Map<String, List<String>> map2 = map;
            return map2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static Map<String, List<String>> getCookieMap(List<CmisHttpCookie> cookies, Map<String, List<String>> requestHeaders) {
        if (cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        StringBuilder cookieHeaderStr = new StringBuilder(128);
        for (CmisHttpCookie cookie : cookies) {
            if (cookieHeaderStr.length() > 0) {
                cookieHeaderStr.append("; ");
            }
            cookieHeaderStr.append(cookie.getName());
            cookieHeaderStr.append('=');
            cookieHeaderStr.append(cookie.getValue());
        }
        return Collections.singletonMap("Cookie", Collections.singletonList(cookieHeaderStr.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String url, Map<String, List<String>> responseHeaders) {
        URI uri;
        if (url == null || responseHeaders == null) {
            throw new IllegalArgumentException("URL or headers are null!");
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new CmisConnectionException(e.getMessage(), (Throwable)e);
        }
        this.lock.writeLock().lock();
        try {
            List<CmisHttpCookie> cookies = CmisCookieManager.parseCookie(responseHeaders);
            for (CmisHttpCookie cookie : cookies) {
                if (cookie.getDomain() == null) {
                    cookie.setDomain(uri.getHost());
                }
                if (cookie.getPath() == null) {
                    cookie.setPath("/");
                }
                this.store.add(uri, cookie);
            }
            if (LOG.isDebugEnabled() && !cookies.isEmpty()) {
                LOG.debug("Session {}: Retrieved cookies for URL {}: {}", new Object[]{this.sessionId, url, cookies.toString()});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.store.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static List<CmisHttpCookie> parseCookie(Map<String, List<String>> responseHeaders) {
        ArrayList<CmisHttpCookie> cookies = new ArrayList<CmisHttpCookie>();
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.equalsIgnoreCase(VERSION_ZERO_HEADER) && !key.equalsIgnoreCase(VERSION_ONE_HEADER)) continue;
            for (String cookieStr : entry.getValue()) {
                try {
                    for (CmisHttpCookie cookie : CmisHttpCookie.parse(cookieStr)) {
                        cookies.add(cookie);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return cookies;
    }

    public CmisCookieStoreImpl getCookieStore() {
        return this.store;
    }
}

