/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonStream
extends TupleStream
implements Expressible {
    private TupleStream tupleStream;
    private StreamRunner streamRunner;
    private ArrayBlockingQueue<Tuple> queue;
    private int queueSize;
    private boolean eatTuples;
    private AtomicLong iterations = new AtomicLong();
    private long startTime;
    private long stopTime;
    private Exception exception;
    private long runInterval;
    private String id;
    private Map<String, DaemonStream> daemons;
    private boolean terminate;
    private boolean closed = false;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DaemonStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        TupleStream tupleStream = factory.constructStream(streamExpressions.get(0));
        StreamExpressionNamedParameter idExpression = factory.getNamedOperand(expression, "id");
        StreamExpressionNamedParameter runExpression = factory.getNamedOperand(expression, "runInterval");
        StreamExpressionNamedParameter queueExpression = factory.getNamedOperand(expression, "queueSize");
        StreamExpressionNamedParameter terminateExpression = factory.getNamedOperand(expression, "terminate");
        String id = null;
        long runInterval = 0L;
        int queueSize = 0;
        boolean terminate = false;
        if (idExpression == null) {
            throw new IOException("Invalid expression id parameter expected");
        }
        id = ((StreamExpressionValue)idExpression.getParameter()).getValue();
        runInterval = runExpression == null ? 2000L : Long.parseLong(((StreamExpressionValue)runExpression.getParameter()).getValue());
        if (queueExpression != null) {
            queueSize = Integer.parseInt(((StreamExpressionValue)queueExpression.getParameter()).getValue());
        }
        if (terminateExpression != null) {
            terminate = Boolean.parseBoolean(((StreamExpressionValue)terminateExpression.getParameter()).getValue());
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        this.init(tupleStream, id, runInterval, queueSize, terminate);
    }

    public DaemonStream(TupleStream tupleStream, String id, long runInterval, int queueSize, boolean terminate) {
        this.init(tupleStream, id, runInterval, queueSize, terminate);
    }

    public DaemonStream(TupleStream tupleStream, String id, long runInterval, int queueSize) {
        this(tupleStream, id, runInterval, queueSize, false);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.tupleStream instanceof Expressible)) throw new IOException("This UniqueStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.tupleStream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        expression.addParameter(new StreamExpressionNamedParameter("id", this.id));
        expression.addParameter(new StreamExpressionNamedParameter("runInterval", Long.toString(this.runInterval)));
        expression.addParameter(new StreamExpressionNamedParameter("queueSize", Integer.toString(this.queueSize)));
        expression.addParameter(new StreamExpressionNamedParameter("terminate", Boolean.toString(this.terminate)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.tupleStream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public void init(TupleStream tupleStream, String id, long runInterval, int queueSize) {
        this.init(tupleStream, id, runInterval, queueSize, false);
    }

    public void init(TupleStream tupleStream, String id, long runInterval, int queueSize, boolean terminate) {
        this.tupleStream = tupleStream;
        this.id = id;
        this.runInterval = runInterval;
        this.queueSize = queueSize;
        this.terminate = terminate;
        if (queueSize > 0) {
            this.queue = new ArrayBlockingQueue(queueSize);
            this.eatTuples = false;
        } else {
            this.eatTuples = true;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DaemonStream) {
            return this.id.equals(((DaemonStream)o).id);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void open() throws IOException {
        if (this.streamRunner != null && !this.closed) {
            log.error("There is already a running daemon named '{}', no action taken", (Object)this.id);
            throw new IOException("There is already an open daemon named '" + this.id + "', no action taken.");
        }
        this.closed = false;
        this.streamRunner = new StreamRunner(this.runInterval, this.id);
        ExecutorService service = ExecutorUtil.newMDCAwareSingleThreadExecutor(new SolrNamedThreadFactory("DaemonStream-" + this.id));
        try {
            service.submit(this.streamRunner);
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public Tuple read() throws IOException {
        try {
            return this.queue.take();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.tupleStream.getStreamSort();
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.tupleStream.setStreamContext(streamContext);
    }

    public void shutdown() {
        this.streamRunner.setShutdown(true);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.streamRunner != null) {
            this.streamRunner.setShutdown(true);
        }
        this.closed = true;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> children = new ArrayList<TupleStream>();
        children.add(this.tupleStream);
        return children;
    }

    public synchronized Tuple getInfo() {
        Tuple tuple = new Tuple();
        tuple.put("id", this.id);
        tuple.put("startTime", this.startTime);
        tuple.put("stopTime", this.stopTime);
        tuple.put("iterations", this.iterations.get());
        tuple.put("state", this.streamRunner.getState().toString());
        if (this.exception != null) {
            tuple.put("exception", this.exception.getMessage());
        }
        return tuple;
    }

    public void setDaemons(Map<String, DaemonStream> daemons) {
        this.daemons = daemons;
    }

    private synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private synchronized void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    private class StreamRunner
    implements Runnable {
        private long sleepMillis = 1000L;
        private long runInterval;
        private long lastRun;
        private String id;
        private volatile Thread executingThread;
        private boolean shutdown;

        public StreamRunner(long runInterval, String id) {
            this.runInterval = runInterval;
            this.id = id;
        }

        public synchronized void setShutdown(boolean shutdown) {
            this.shutdown = shutdown;
        }

        public synchronized boolean getShutdown() {
            return this.shutdown;
        }

        public Thread.State getState() {
            if (this.executingThread == null) {
                if (this.shutdown) {
                    return Thread.State.TERMINATED;
                }
                return Thread.State.NEW;
            }
            return this.executingThread.getState();
        }

        @Override
        public void run() {
            this.executingThread = Thread.currentThread();
            try {
                this.stream();
            }
            finally {
                this.setShutdown(true);
                this.executingThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void stream() {
            errors = 0;
            DaemonStream.this.setStartTime(new Date().getTime());
            block29: while (!this.getShutdown()) {
                now = new Date().getTime();
                if (now - this.lastRun > this.runInterval) {
                    this.lastRun = now;
                    try {
                        DaemonStream.this.tupleStream.open();
                        while (true) {
                            tuple = DaemonStream.this.tupleStream.read();
                            if (tuple.EOF) {
                                errors = 0;
                                if (tuple.getFields().containsKey("sleepMillis")) {
                                    this.sleepMillis = tuple.getLong("sleepMillis");
                                    if (DaemonStream.this.terminate && this.sleepMillis > 0L) {
                                        if (DaemonStream.this.daemons == null) break block29;
                                        DaemonStream.this.daemons.remove(this.id);
                                        break block29;
                                    }
                                    this.runInterval = -1L;
                                }
                                break;
                            }
                            if (DaemonStream.this.eatTuples) continue;
                            try {
                                DaemonStream.this.queue.put(tuple);
                            }
                            catch (InterruptedException e) {
                                try {
                                    DaemonStream.this.tupleStream.close();
                                }
                                catch (IOException e1) {
                                    if (DaemonStream.this.exception != null) break block29;
                                    DaemonStream.this.exception = e1;
                                    DaemonStream.log.error("Error in DaemonStream: {}", (Object)this.id, (Object)e1);
                                }
                                break block29;
                            }
                        }
                    }
                    catch (IOException e) {
                        DaemonStream.this.exception = e;
                        DaemonStream.log.error("Error in DaemonStream: {}", (Object)this.id, (Object)e);
                        if (++errors > 100) {
                            DaemonStream.log.error("Too many consecutive errors. Stopping DaemonStream: {}", (Object)this.id);
                            break;
                        }
                    }
                    catch (Throwable t) {
                        DaemonStream.log.error("Fatal Error in DaemonStream: {}", (Object)this.id, (Object)t);
                        break;
                    }
                    finally {
                        try {
                            DaemonStream.this.tupleStream.close();
                        }
                        catch (IOException e1) {
                            if (DaemonStream.this.exception != null) ** GOTO lbl54
                            DaemonStream.this.exception = e1;
                            DaemonStream.log.error("Error in DaemonStream: {}", (Object)this.id, (Object)e1);
                        }
lbl54:
                        // 3 sources

                    }
                }
                DaemonStream.this.iterations.incrementAndGet();
                if (this.sleepMillis <= 0L) continue;
                try {
                    Thread.sleep(this.sleepMillis);
                }
                catch (InterruptedException e) {
                    DaemonStream.log.error("Error in DaemonStream:{}", (Object)this.id, (Object)e);
                    break;
                }
            }
            if (!DaemonStream.this.eatTuples) {
                try {
                    DaemonStream.this.queue.put(Tuple.EOF());
                }
                catch (InterruptedException e) {
                    DaemonStream.log.error("Error in DaemonStream:{}", (Object)this.id, (Object)e);
                }
            }
            DaemonStream.this.setStopTime(new Date().getTime());
        }
    }
}

