/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.solr.common.util.Utf8CharSequence;

public class FastOutputStream
extends OutputStream
implements DataOutput {
    protected final OutputStream out;
    protected byte[] buf;
    protected long written;
    protected int pos;

    public FastOutputStream(OutputStream w) {
        this(w, new byte[8192], 0);
    }

    public FastOutputStream(OutputStream sink, byte[] tempBuffer, int start) {
        this.out = sink;
        this.buf = tempBuffer;
        this.pos = start;
    }

    public static FastOutputStream wrap(OutputStream sink) {
        return sink instanceof FastOutputStream ? (FastOutputStream)sink : new FastOutputStream(sink);
    }

    @Override
    public void write(int b) throws IOException {
        this.write((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte b) throws IOException {
        if (this.pos >= this.buf.length) {
            this.written += (long)this.pos;
            this.flush(this.buf, 0, this.buf.length);
            this.pos = 0;
        }
        this.buf[this.pos++] = b;
    }

    @Override
    public void write(byte[] arr, int off, int len) throws IOException {
        while (true) {
            int space;
            if (len <= (space = this.buf.length - this.pos)) {
                System.arraycopy(arr, off, this.buf, this.pos, len);
                this.pos += len;
                return;
            }
            if (len > this.buf.length) {
                if (this.pos > 0) {
                    this.flush(this.buf, 0, this.pos);
                    this.written += (long)this.pos;
                    this.pos = 0;
                }
                this.flush(arr, off, len);
                this.written += (long)len;
                return;
            }
            System.arraycopy(arr, off, this.buf, this.pos, space);
            this.written += (long)this.buf.length;
            this.flush(this.buf, 0, this.buf.length);
            this.pos = 0;
            off += space;
            len -= space;
        }
    }

    public void reserve(int len) throws IOException {
        if (len > this.buf.length - this.pos) {
            this.flushBuffer();
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write((byte)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write((byte)(v >>> 8));
        this.write((byte)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.reserve(4);
        this.buf[this.pos] = (byte)(v >>> 24);
        this.buf[this.pos + 1] = (byte)(v >>> 16);
        this.buf[this.pos + 2] = (byte)(v >>> 8);
        this.buf[this.pos + 3] = (byte)v;
        this.pos += 4;
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.reserve(8);
        this.buf[this.pos] = (byte)(v >>> 56);
        this.buf[this.pos + 1] = (byte)(v >>> 48);
        this.buf[this.pos + 2] = (byte)(v >>> 40);
        this.buf[this.pos + 3] = (byte)(v >>> 32);
        this.buf[this.pos + 4] = (byte)(v >>> 24);
        this.buf[this.pos + 5] = (byte)(v >>> 16);
        this.buf[this.pos + 6] = (byte)(v >>> 8);
        this.buf[this.pos + 7] = (byte)v;
        this.pos += 8;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        DataOutputStream daos = new DataOutputStream(this);
        daos.writeUTF(s);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        if (this.out != null) {
            this.out.close();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.pos > 0) {
            this.written += (long)this.pos;
            this.flush(this.buf, 0, this.pos);
            this.pos = 0;
        }
    }

    public void flush(byte[] buf, int offset, int len) throws IOException {
        this.out.write(buf, offset, len);
    }

    public long size() {
        return this.written + (long)this.pos;
    }

    public long written() {
        return this.written;
    }

    public void setWritten(long written) {
        this.written = written;
    }

    public void writeUtf8CharSeq(Utf8CharSequence utf8) throws IOException {
        int start = 0;
        int totalWritten = 0;
        while (totalWritten < utf8.size()) {
            if (this.pos >= this.buf.length) {
                this.flushBuffer();
            }
            int sz = utf8.write(start, this.buf, this.pos);
            this.pos += sz;
            totalWritten += sz;
            start += sz;
        }
    }
}

