/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Vector;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlkInt;

public class BlkImgDataSrcImageProducer
implements ImageProducer {
    private volatile Vector consumers;
    private BlkImgDataSrc src;
    private int type;
    private static final int GRAY = 0;
    private static final int RGB = 1;
    private static final int RGBA = 2;
    private static final ColorModel cm = ColorModel.getRGBdefault();

    public BlkImgDataSrcImageProducer(BlkImgDataSrc src) {
        switch (src.getNumComps()) {
            case 1: {
                this.type = 0;
                break;
            }
            case 3: {
                this.type = 1;
                break;
            }
            case 4: {
                this.type = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only 1, 3, and 4 components supported");
            }
        }
        int imh = src.getCompImgHeight(0);
        int imw = src.getCompImgWidth(0);
        for (int i = src.getNumComps() - 1; i >= 0; --i) {
            if (src.getCompImgHeight(i) != imh || src.getCompImgWidth(i) != imw) {
                throw new IllegalArgumentException("All components must have the same dimensions and no subsampling");
            }
            if (src.getNomRangeBits(i) <= 8) continue;
            throw new IllegalArgumentException("Depths greater than 8 bits per component is not supported");
        }
        this.src = src;
        this.consumers = new Vector();
    }

    public static Image createImage(BlkImgDataSrc src) {
        return Toolkit.getDefaultToolkit().createImage(new BlkImgDataSrcImageProducer(src));
    }

    public static Image createImage(BlkImgDataSrc src, Component c) {
        return c.getToolkit().createImage(new BlkImgDataSrcImageProducer(src));
    }

    @Override
    public final synchronized void addConsumer(ImageConsumer ic) {
        if (ic != null && !this.consumers.contains(ic)) {
            this.consumers.addElement(ic);
        }
    }

    @Override
    public boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.consumers.removeElement(ic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startProduction(ImageConsumer ic) {
        int i;
        int fb1;
        int mv1;
        int ls1;
        Object[] cons;
        Coord nT = this.src.getNumTiles(null);
        int tIdx = 0;
        if (ic != null) {
            this.addConsumer(ic);
        }
        BlkImgDataSrcImageProducer blkImgDataSrcImageProducer = this;
        synchronized (blkImgDataSrcImageProducer) {
            cons = new ImageConsumer[this.consumers.size()];
            this.consumers.copyInto(cons);
        }
        if (this.src == null) {
            for (int i2 = cons.length - 1; i2 >= 0; --i2) {
                cons[i2].imageComplete(1);
            }
            return;
        }
        int[] pixbuf = null;
        int mv2 = 0;
        int fb2 = 0;
        int ls2 = 0;
        int mv3 = 0;
        int fb3 = 0;
        int ls3 = 0;
        int mv4 = 0;
        int fb4 = 0;
        int ls4 = 0;
        DataBlkInt db4 = null;
        DataBlkInt db3 = null;
        DataBlkInt db2 = null;
        DataBlkInt db1 = null;
        switch (this.type) {
            case 2: {
                db4 = new DataBlkInt();
                ls4 = 1 << this.src.getNomRangeBits(3) - 1;
                mv4 = (1 << this.src.getNomRangeBits(3)) - 1;
                fb4 = this.src.getFixedPoint(3);
            }
            case 1: {
                db3 = new DataBlkInt();
                ls3 = 1 << this.src.getNomRangeBits(2) - 1;
                mv3 = (1 << this.src.getNomRangeBits(2)) - 1;
                fb3 = this.src.getFixedPoint(2);
                db2 = new DataBlkInt();
                ls2 = 1 << this.src.getNomRangeBits(1) - 1;
                mv2 = (1 << this.src.getNomRangeBits(1)) - 1;
                fb2 = this.src.getFixedPoint(1);
            }
            case 0: {
                db1 = new DataBlkInt();
                ls1 = 1 << this.src.getNomRangeBits(0) - 1;
                mv1 = (1 << this.src.getNomRangeBits(0)) - 1;
                fb1 = this.src.getFixedPoint(0);
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        nT = this.src.getNumTiles(null);
        int hints = 24;
        hints = nT.x == 1 ? (hints |= 6) : (hints |= 1);
        for (i = cons.length - 1; i >= 0; --i) {
            cons[i].setColorModel(cm);
            cons[i].setDimensions(this.src.getCompImgWidth(0), this.src.getCompImgHeight(0));
            cons[i].setHints(hints);
        }
        for (int y = 0; y < nT.y; ++y) {
            int x = 0;
            while (x < nT.x) {
                this.src.setTile(x, y);
                int height = this.src.getTileCompHeight(tIdx, 0);
                int width = this.src.getTileCompWidth(tIdx, 0);
                if (pixbuf == null || pixbuf.length < width) {
                    pixbuf = new int[width];
                }
                int tOffx = this.src.getCompULX(0) - (int)Math.ceil((double)this.src.getImgULX() / (double)this.src.getCompSubsX(0));
                int tOffy = this.src.getCompULY(0) - (int)Math.ceil((double)this.src.getImgULY() / (double)this.src.getCompSubsY(0));
                for (int l = 0; l < height; ++l) {
                    boolean prog = false;
                    switch (this.type) {
                        case 2: {
                            db4.ulx = 0;
                            db4.uly = l;
                            db4.w = width;
                            db4.h = 1;
                            this.src.getInternCompData(db4, 3);
                            prog = prog || db4.progressive;
                        }
                        case 1: {
                            db3.ulx = 0;
                            db2.ulx = 0;
                            db2.uly = db3.uly = l;
                            db2.w = db3.w = width;
                            db3.h = 1;
                            db2.h = 1;
                            this.src.getInternCompData(db3, 2);
                            prog = prog || db3.progressive;
                            this.src.getInternCompData(db2, 1);
                            prog = prog || db2.progressive;
                        }
                        case 0: {
                            db1.ulx = 0;
                            db1.uly = l;
                            db1.w = width;
                            db1.h = 1;
                            this.src.getInternCompData(db1, 0);
                            boolean bl = prog = prog || db1.progressive;
                        }
                    }
                    if (prog) {
                        for (i = cons.length - 1; i >= 0; --i) {
                            cons[i].imageComplete(4);
                        }
                        return;
                    }
                    switch (this.type) {
                        case 0: {
                            int tmp1;
                            int[] data1 = db1.data;
                            int k1 = db1.offset + width - 1;
                            for (i = width - 1; i >= 0; --i) {
                                tmp1 = (tmp1 = (data1[k1--] >> fb1) + ls1) < 0 ? 0 : (tmp1 > mv1 ? mv1 : tmp1);
                                pixbuf[i] = 0xFF000000 | tmp1 << 16 | tmp1 << 8 | tmp1;
                            }
                            break;
                        }
                        case 1: {
                            int tmp3;
                            int tmp2;
                            int tmp1;
                            int[] data1 = db1.data;
                            int[] data2 = db2.data;
                            int[] data3 = db3.data;
                            int k1 = db1.offset + width - 1;
                            int k2 = db2.offset + width - 1;
                            int k3 = db3.offset + width - 1;
                            for (i = width - 1; i >= 0; --i) {
                                tmp1 = (tmp1 = (data1[k1--] >> fb1) + ls1) < 0 ? 0 : (tmp1 > mv1 ? mv1 : tmp1);
                                tmp2 = (data2[k2--] >> fb2) + ls2;
                                tmp2 = tmp2 < 0 ? 0 : (tmp2 > mv2 ? mv2 : tmp2);
                                tmp3 = (data3[k3--] >> fb3) + ls3;
                                tmp3 = tmp3 < 0 ? 0 : (tmp3 > mv3 ? mv3 : tmp3);
                                pixbuf[i] = 0xFF000000 | tmp1 << 16 | tmp2 << 8 | tmp3;
                            }
                            break;
                        }
                        case 2: {
                            int tmp3;
                            int tmp2;
                            int tmp1;
                            int[] data1 = db1.data;
                            int[] data2 = db2.data;
                            int[] data3 = db3.data;
                            int[] data4 = db4.data;
                            int k1 = db1.offset + width - 1;
                            int k2 = db2.offset + width - 1;
                            int k3 = db3.offset + width - 1;
                            int k4 = db4.offset + width - 1;
                            for (i = width - 1; i >= 0; --i) {
                                tmp1 = (tmp1 = (data1[k1--] >> fb1) + ls1) < 0 ? 0 : (tmp1 > mv1 ? mv1 : tmp1);
                                tmp2 = (data2[k2--] >> fb2) + ls2;
                                tmp2 = tmp2 < 0 ? 0 : (tmp2 > mv2 ? mv2 : tmp2);
                                tmp3 = (data3[k3--] >> fb3) + ls3;
                                tmp3 = tmp3 < 0 ? 0 : (tmp3 > mv3 ? mv3 : tmp3);
                                int tmp4 = (data4[k4--] >> fb4) + ls4;
                                tmp4 = tmp4 < 0 ? 0 : (tmp4 > mv4 ? mv4 : tmp4);
                                pixbuf[i] = tmp4 << 24 | tmp1 << 16 | tmp2 << 8 | tmp3;
                            }
                            break;
                        }
                    }
                    for (i = cons.length - 1; i >= 0; --i) {
                        cons[i].setPixels(tOffx, tOffy + l, width, 1, cm, pixbuf, 0, width);
                    }
                }
                ++x;
                ++tIdx;
            }
        }
        for (i = cons.length - 1; i >= 0; --i) {
            cons[i].imageComplete(2);
        }
        for (i = cons.length - 1; i >= 0; --i) {
            cons[i].imageComplete(3);
        }
        BlkImgDataSrcImageProducer blkImgDataSrcImageProducer2 = this;
        synchronized (blkImgDataSrcImageProducer2) {
            for (i = cons.length - 1; i >= 0; --i) {
                this.consumers.removeElement(cons[i]);
            }
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }
}

