/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.ItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.SecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ItemTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.SecondaryTypeDefinitionImpl;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static TypeDefinition cloneType(TypeDefinition type) {
        if (type instanceof DocumentTypeDefinition) {
            return TypeUtil.cloneTypeDoc((DocumentTypeDefinition)type);
        }
        if (type instanceof FolderTypeDefinition) {
            return TypeUtil.cloneTypeFolder((FolderTypeDefinition)type);
        }
        if (type instanceof PolicyTypeDefinition) {
            return TypeUtil.cloneTypePolicy((PolicyTypeDefinition)type);
        }
        if (type instanceof ItemTypeDefinition) {
            return TypeUtil.cloneTypeItem((ItemTypeDefinition)type);
        }
        if (type instanceof RelationshipTypeDefinition) {
            return TypeUtil.cloneTypeRelationship((RelationshipTypeDefinition)type);
        }
        if (type instanceof SecondaryTypeDefinition) {
            return TypeUtil.cloneTypeSecondary((SecondaryTypeDefinition)type);
        }
        return null;
    }

    public static AbstractPropertyDefinition<?> clonePropertyDefinition(PropertyDefinition<?> pd) {
        if (pd instanceof PropertyBooleanDefinition) {
            PropertyBooleanDefinitionImpl pdBoolDef = new PropertyBooleanDefinitionImpl();
            PropertyBooleanDefinitionImpl pdSrc = (PropertyBooleanDefinitionImpl)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdBoolDef);
            pdBoolDef.setChoices(pdSrc.getChoices());
            pdBoolDef.setDefaultValue(pdSrc.getDefaultValue());
            return pdBoolDef;
        }
        if (pd instanceof PropertyDateTimeDefinition) {
            PropertyDateTimeDefinitionImpl pdDateDef = new PropertyDateTimeDefinitionImpl();
            PropertyDateTimeDefinitionImpl pdSrc = (PropertyDateTimeDefinitionImpl)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdDateDef);
            pdDateDef.setChoices(pdSrc.getChoices());
            pdDateDef.setDefaultValue(pdSrc.getDefaultValue());
            pdDateDef.setDateTimeResolution(pdSrc.getDateTimeResolution());
            return pdDateDef;
        }
        if (pd instanceof PropertyDecimalDefinition) {
            PropertyDecimalDefinitionImpl pdDecDef = new PropertyDecimalDefinitionImpl();
            PropertyDecimalDefinitionImpl pdSrc = (PropertyDecimalDefinitionImpl)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdDecDef);
            pdDecDef.setChoices(pdSrc.getChoices());
            pdDecDef.setDefaultValue(pdSrc.getDefaultValue());
            pdDecDef.setMinValue(pdSrc.getMinValue());
            pdDecDef.setMaxValue(pdSrc.getMaxValue());
            pdDecDef.setPrecision(pdSrc.getPrecision());
            return pdDecDef;
        }
        if (pd instanceof PropertyHtmlDefinition) {
            PropertyHtmlDefinitionImpl pdHtmlDef = new PropertyHtmlDefinitionImpl();
            PropertyHtmlDefinitionImpl pdSrc = (PropertyHtmlDefinitionImpl)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdHtmlDef);
            pdHtmlDef.setChoices(pdSrc.getChoices());
            pdHtmlDef.setDefaultValue(pdSrc.getDefaultValue());
            return pdHtmlDef;
        }
        if (pd instanceof PropertyIdDefinition) {
            PropertyIdDefinitionImpl pdIdDef = new PropertyIdDefinitionImpl();
            PropertyIdDefinitionImpl pdSrc = (PropertyIdDefinitionImpl)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdIdDef);
            pdIdDef.setChoices(pdSrc.getChoices());
            pdIdDef.setDefaultValue(pdSrc.getDefaultValue());
            return pdIdDef;
        }
        if (pd instanceof PropertyIntegerDefinition) {
            PropertyIntegerDefinitionImpl pdIntDef = new PropertyIntegerDefinitionImpl();
            PropertyIntegerDefinitionImpl pdSrc = (PropertyIntegerDefinitionImpl)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdIntDef);
            pdIntDef.setChoices(pdSrc.getChoices());
            pdIntDef.setDefaultValue(pdSrc.getDefaultValue());
            pdIntDef.setMinValue(pdSrc.getMinValue());
            pdIntDef.setMaxValue(pdSrc.getMaxValue());
            return pdIntDef;
        }
        if (pd instanceof PropertyStringDefinition) {
            PropertyStringDefinitionImpl pdStringDef = new PropertyStringDefinitionImpl();
            PropertyStringDefinitionImpl pdSrc = (PropertyStringDefinitionImpl)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdStringDef);
            pdStringDef.setChoices(pdSrc.getChoices());
            pdStringDef.setDefaultValue(pdSrc.getDefaultValue());
            pdStringDef.setMaxLength(pdSrc.getMaxLength());
            return pdStringDef;
        }
        if (pd instanceof PropertyUriDefinition) {
            PropertyUriDefinitionImpl pdUriDef = new PropertyUriDefinitionImpl();
            PropertyUriDefinition pdSrc = (PropertyUriDefinition)pd;
            TypeUtil.initializeAbstractPropertyDefinition(pd, pdUriDef);
            pdUriDef.setChoices(pdSrc.getChoices());
            pdUriDef.setDefaultValue(pdSrc.getDefaultValue());
            return pdUriDef;
        }
        return null;
    }

    public static DocumentTypeDefinitionImpl cloneTypeDoc(DocumentTypeDefinition type) {
        DocumentTypeDefinitionImpl td = new DocumentTypeDefinitionImpl();
        td.initialize((TypeDefinition)type);
        td.setIsVersionable(type.isVersionable());
        td.setContentStreamAllowed(type.getContentStreamAllowed());
        return td;
    }

    public static FolderTypeDefinitionImpl cloneTypeFolder(FolderTypeDefinition type) {
        FolderTypeDefinitionImpl td = new FolderTypeDefinitionImpl();
        td.initialize((TypeDefinition)type);
        return td;
    }

    public static RelationshipTypeDefinitionImpl cloneTypeRelationship(RelationshipTypeDefinition type) {
        RelationshipTypeDefinitionImpl td = new RelationshipTypeDefinitionImpl();
        td.initialize((TypeDefinition)type);
        td.setAllowedSourceTypes(type.getAllowedSourceTypeIds());
        td.setAllowedTargetTypes(type.getAllowedTargetTypeIds());
        return td;
    }

    public static ItemTypeDefinitionImpl cloneTypeItem(ItemTypeDefinition type) {
        ItemTypeDefinitionImpl td = new ItemTypeDefinitionImpl();
        td.initialize((TypeDefinition)type);
        return td;
    }

    public static SecondaryTypeDefinitionImpl cloneTypeSecondary(SecondaryTypeDefinition type) {
        SecondaryTypeDefinitionImpl td = new SecondaryTypeDefinitionImpl();
        td.initialize((TypeDefinition)type);
        return td;
    }

    public static PolicyTypeDefinitionImpl cloneTypePolicy(PolicyTypeDefinition type) {
        PolicyTypeDefinitionImpl td = new PolicyTypeDefinitionImpl();
        td.initialize((TypeDefinition)td);
        return null;
    }

    public static String getQueryNameFromId(String id) {
        StringBuilder sb = new StringBuilder(id.length());
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '.' || c == ' ' || c == ',' || c == '\'' || c == '\"' || c == '\\' || c == '(' || c == ')') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void initializeAbstractPropertyDefinition(PropertyDefinition<?> pdSrc, AbstractPropertyDefinition<?> pdTarget) {
        pdTarget.setCardinality(pdSrc.getCardinality());
        pdTarget.setDescription(pdSrc.getDescription());
        pdTarget.setDisplayName(pdSrc.getDisplayName());
        pdTarget.setExtensions(pdSrc.getExtensions());
        pdTarget.setId(pdSrc.getId());
        pdTarget.setIsInherited(Boolean.valueOf(false));
        pdTarget.setIsOpenChoice(pdSrc.isOpenChoice());
        pdTarget.setIsOrderable(pdSrc.isOrderable());
        pdTarget.setIsQueryable(pdSrc.isQueryable());
        pdTarget.setIsRequired(pdSrc.isRequired());
        pdTarget.setLocalName(pdSrc.getLocalName());
        pdTarget.setLocalNamespace(pdSrc.getLocalNamespace());
        pdTarget.setPropertyType(pdSrc.getPropertyType());
        pdTarget.setQueryName(pdSrc.getQueryName());
        pdTarget.setUpdatability(pdSrc.getUpdatability());
    }
}

