/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notifications.slack;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.notifications.BaseNotificationConnector;
import org.apache.manifoldcf.crawler.notifications.slack.Messages;
import org.apache.manifoldcf.crawler.notifications.slack.SlackSession;
import org.apache.manifoldcf.crawler.system.Logging;

public class SlackConnector
extends BaseNotificationConnector {
    protected static final long SESSION_EXPIRATION_MILLISECONDS = 300000L;
    protected long sessionExpiration = -1L;
    protected String webHookUrl = null;
    protected SlackSession.ProxySettings proxySettings = null;
    protected SlackSession session = null;

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.webHookUrl = configParameters.getObfuscatedParameter("webHookUrl");
        String proxyHost = configParameters.getParameter("proxyHost");
        String proxyPortString = configParameters.getParameter("proxyPort");
        if (StringUtils.isNotEmpty((String)proxyHost) && StringUtils.isNotEmpty((String)proxyPortString)) {
            String proxyUsername = configParameters.getParameter("proxyUsername");
            String proxyPassword = configParameters.getObfuscatedParameter("proxyPassword");
            String proxyDomain = configParameters.getParameter("proxyDomain");
            this.proxySettings = new SlackSession.ProxySettings(proxyHost, proxyPortString, proxyUsername, proxyPassword, proxyDomain);
        } else {
            Logging.connectors.info((Object)"Using no proxy settings - no proxyHost and no proxyPort found.");
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.webHookUrl = null;
        this.proxySettings = null;
        this.finalizeConnection();
        super.disconnect();
    }

    public void poll() throws ManifoldCFException {
        if (this.session != null && System.currentTimeMillis() >= this.sessionExpiration) {
            this.finalizeConnection();
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        this.finalizeConnection();
        this.getSession();
        try {
            CheckConnectionThread cct = new CheckConnectionThread(this.session);
            cct.start();
            cct.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (IOException e) {
            SlackConnector.handleIOException(e, "checking the connection");
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (this.webHookUrl == null) {
                throw new ManifoldCFException("Missing webHookUrl parameter");
            }
            try {
                ConnectThread connectThread = new ConnectThread(this.webHookUrl, this.proxySettings);
                connectThread.start();
                this.session = connectThread.finishUp();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
            catch (IOException e) {
                SlackConnector.handleIOException(e, "connecting");
            }
        }
        this.sessionExpiration = System.currentTimeMillis() + 300000L;
    }

    protected void finalizeConnection() {
        if (this.session != null) {
            try {
                CloseSessionThread closeSessionThread = new CloseSessionThread(this.session);
                closeSessionThread.start();
                closeSessionThread.finishUp();
            }
            catch (InterruptedException closeSessionThread) {
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("Error while closing connection to server: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
    }

    public void notifyOfJobStopErrorAbort(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendSlackMessage(spec, "erroraborted");
    }

    public void notifyOfJobStopManualAbort(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendSlackMessage(spec, "manualaborted");
    }

    public void notifyOfJobStopManualPause(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendSlackMessage(spec, "manualpaused");
    }

    public void notifyOfJobStopSchedulePause(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendSlackMessage(spec, "schedulepaused");
    }

    public void notifyOfJobStopRestart(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendSlackMessage(spec, "restarted");
    }

    public void notifyOfJobEnd(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.sendSlackMessage(spec, "finished");
    }

    protected void sendSlackMessage(Specification spec, String nodeType) throws ManifoldCFException, ServiceInterruption {
        int i;
        String channel = "";
        String message = "";
        for (i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (sn.getType().equals("channel")) {
                channel = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("message")) continue;
            message = sn.getAttributeValue("value");
        }
        if (nodeType != null) {
            for (i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode childNode = spec.getChild(i);
                if (!childNode.getType().equals(nodeType)) continue;
                for (int j = 0; j < childNode.getChildCount(); ++j) {
                    SpecificationNode sn = childNode.getChild(j);
                    if (sn.getType().equals("channel")) {
                        channel = sn.getAttributeValue("value");
                        continue;
                    }
                    if (!sn.getType().equals("message")) continue;
                    message = sn.getAttributeValue("value");
                }
            }
        }
        if (StringUtils.isBlank((String)message)) {
            return;
        }
        this.getSession();
        SendThread st = new SendThread(this.session, channel, message);
        st.start();
        try {
            st.finishUp();
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (IOException e) {
            SlackConnector.handleIOException(e, "sending slack message");
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SlackConnector.WebHook"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        SlackConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationHeader.js", paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        SlackConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "Configuration_Server.html", paramMap);
    }

    private static void fillInServerConfigurationMap(Map<String, Object> paramMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String webHookUrl = parameters.getObfuscatedParameter("webHookUrl");
        webHookUrl = webHookUrl == null ? "" : mapper.mapPasswordToKey(webHookUrl);
        String proxyHost = SlackConnector.getEmptyOnNull(parameters, "proxyHost");
        String proxyPort = SlackConnector.getEmptyOnNull(parameters, "proxyPort");
        String proxyUsername = SlackConnector.getEmptyOnNull(parameters, "proxyUsername");
        String proxyPassword = parameters.getObfuscatedParameter("proxyPassword");
        proxyPassword = proxyPassword == null ? "" : mapper.mapPasswordToKey(proxyPassword);
        String proxyDomain = SlackConnector.getEmptyOnNull(parameters, "proxyDomain");
        paramMap.put("WEBHOOK_URL", webHookUrl);
        paramMap.put("PROXY_HOST", proxyHost);
        paramMap.put("PROXY_PORT", proxyPort);
        paramMap.put("PROXY_USERNAME", proxyUsername);
        paramMap.put("PROXY_PASSWORD", proxyPassword);
        paramMap.put("PROXY_DOMAIN", proxyDomain);
    }

    private static String getEmptyOnNull(ConfigParams parameters, String key) {
        String value = parameters.getParameter(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String proxyDomain;
        String proxyPassword;
        String proxyPort;
        String proxyHost;
        String webHookUrl = variableContext.getParameter("webHookUrl");
        if (webHookUrl != null) {
            parameters.setObfuscatedParameter("webHookUrl", variableContext.mapKeyToPassword(webHookUrl));
        }
        if ((proxyHost = variableContext.getParameter("proxyHost")) != null) {
            parameters.setParameter("proxyHost", proxyHost);
        }
        if (StringUtils.isNotEmpty((String)(proxyPort = variableContext.getParameter("proxyPort")))) {
            try {
                Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                Logging.connectors.warn((Object)("Proxy port must be a number. Found " + proxyPort));
                throw new ManifoldCFException("Proxy Port must be a number: " + e.getMessage(), (Throwable)e);
            }
            parameters.setParameter("proxyPort", proxyPort);
        } else if (proxyPort != null) {
            parameters.setParameter("proxyPort", proxyPort);
        }
        String proxyUsername = variableContext.getParameter("proxyUsername");
        if (proxyUsername != null) {
            parameters.setParameter("proxyUsername", proxyUsername);
        }
        if ((proxyPassword = variableContext.getParameter("proxyPassword")) != null) {
            parameters.setObfuscatedParameter("proxyPassword", variableContext.mapKeyToPassword(proxyPassword));
        }
        if ((proxyDomain = variableContext.getParameter("proxyDomain")) != null) {
            parameters.setParameter("proxyDomain", proxyDomain);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        SlackConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "ConfigurationView.html", paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "SlackConnector.Message"));
        Messages.outputResourceWithVelocity(out, locale, "SpecificationHeader.js", paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        this.outputMessageTab(out, locale, ds, tabName, connectionSequenceNumber, actualSequenceNumber);
    }

    protected void outputMessageTab(IHTTPOutput out, Locale locale, Specification ds, String tabName, int connectionSequenceNumber, int actualSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        SlackConnector.fillInMessageTab(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "Specification_Message.html", paramMap);
    }

    protected static void fillInMessageTab(Map<String, Object> paramMap, Specification ds) {
        int i;
        String channel = "";
        String message = "";
        for (i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals("channel")) {
                channel = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("message")) continue;
            message = sn.getAttributeValue("value");
        }
        if (channel.length() > 0) {
            SlackConnector.addRecord(paramMap, "finished", channel, message);
            SlackConnector.addRecord(paramMap, "erroraborted", channel, message);
            SlackConnector.addRecord(paramMap, "manualaborted", channel, message);
            SlackConnector.addRecord(paramMap, "manualpaused", channel, message);
            SlackConnector.addRecord(paramMap, "schedulepaused", channel, message);
            SlackConnector.addRecord(paramMap, "restarted", channel, message);
        } else {
            SlackConnector.addRecord(paramMap, "finished", "", "");
            SlackConnector.addRecord(paramMap, "erroraborted", "", "");
            SlackConnector.addRecord(paramMap, "manualaborted", "", "");
            SlackConnector.addRecord(paramMap, "manualpaused", "", "");
            SlackConnector.addRecord(paramMap, "schedulepaused", "", "");
            SlackConnector.addRecord(paramMap, "restarted", "", "");
            for (i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode childNode = ds.getChild(i);
                if (!childNode.getType().equals("finished") && !childNode.getType().equals("erroraborted") && !childNode.getType().equals("manualaborted") && !childNode.getType().equals("manualpaused") && !childNode.getType().equals("schedulepaused") && !childNode.getType().equals("restarted")) continue;
                channel = "";
                message = "";
                for (int j = 0; j < childNode.getChildCount(); ++j) {
                    SpecificationNode sn = childNode.getChild(j);
                    if (sn.getType().equals("channel")) {
                        channel = sn.getAttributeValue("value");
                        continue;
                    }
                    if (!sn.getType().equals("message")) continue;
                    message = sn.getAttributeValue("value");
                }
                SlackConnector.addRecord(paramMap, childNode.getType(), channel, message);
            }
        }
    }

    protected static void addRecord(Map<String, Object> paramMap, String nodeType, String channel, String message) {
        paramMap.put(nodeType + "_CHANNEL", channel);
        paramMap.put(nodeType + "_MESSAGE", message);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        return this.processMessageTab(variableContext, ds, connectionSequenceNumber);
    }

    protected String processMessageTab(IPostParameters variableContext, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        SlackConnector.removeNodes(ds, "channel");
        SlackConnector.removeNodes(ds, "message");
        SlackConnector.gatherRecord(ds, seqPrefix, variableContext, "finished");
        SlackConnector.gatherRecord(ds, seqPrefix, variableContext, "erroraborted");
        SlackConnector.gatherRecord(ds, seqPrefix, variableContext, "manualaborted");
        SlackConnector.gatherRecord(ds, seqPrefix, variableContext, "manualpaused");
        SlackConnector.gatherRecord(ds, seqPrefix, variableContext, "schedulepaused");
        SlackConnector.gatherRecord(ds, seqPrefix, variableContext, "restarted");
        return null;
    }

    protected static void gatherRecord(Specification ds, String seqPrefix, IPostParameters variableContext, String nodeType) {
        String message;
        SlackConnector.removeNodes(ds, nodeType);
        SpecificationNode sn = new SpecificationNode(nodeType);
        String channel = variableContext.getParameter(seqPrefix + nodeType + "_channel");
        if (channel != null) {
            SlackConnector.addNodeValue(sn, "channel", channel);
        }
        if ((message = variableContext.getParameter(seqPrefix + nodeType + "_message")) != null) {
            SlackConnector.addNodeValue(sn, "message", message);
        }
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        SlackConnector.fillInMessageTab(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, "SpecificationView.html", paramMap);
    }

    protected static void removeNodes(Specification ds, String nodeTypeName) {
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals(nodeTypeName)) {
                ds.removeChild(i);
                continue;
            }
            ++i;
        }
    }

    protected static void addNodeValue(SpecificationNode ds, String nodeType, String value) {
        SpecificationNode sn = new SpecificationNode(nodeType);
        sn.setAttribute("value", value);
        ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.error((Object)("Slack: Error " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("Error " + context + ": " + e.getMessage(), (Throwable)e);
    }

    protected static class SendThread
    extends Thread {
        protected final SlackSession session;
        protected final String channel;
        protected final String message;
        protected Throwable exception = null;

        public SendThread(SlackSession session, String channel, String message) {
            this.session = session;
            this.channel = channel;
            this.message = message;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.send(this.channel, this.message);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final SlackSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(SlackSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.checkConnection();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class CloseSessionThread
    extends Thread {
        protected final SlackSession session;
        protected Throwable exception = null;

        public CloseSessionThread(SlackSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.close();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    protected static class ConnectThread
    extends Thread {
        protected final String webHookUrl;
        protected final SlackSession.ProxySettings proxySettings;
        protected SlackSession session = null;
        protected Throwable exception = null;

        public ConnectThread(String webHookUrl, SlackSession.ProxySettings proxySettings) {
            this.webHookUrl = webHookUrl;
            this.proxySettings = proxySettings;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session = new SlackSession(this.webHookUrl, this.proxySettings);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public SlackSession finishUp() throws IOException, InterruptedException {
            try {
                this.join();
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    if (this.exception instanceof Error) {
                        throw (Error)this.exception;
                    }
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    throw new RuntimeException("Unknown exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
                }
                return this.session;
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }
}

