/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authority;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.authorities.authority.AuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.AuthorityGroupManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityGroupManager;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;

public class AuthorityConnectionManager
extends BaseTable
implements IAuthorityConnectionManager {
    public static final String _rcsid = "@(#)$Id: AuthorityConnectionManager.java 996524 2010-09-13 13:38:01Z kwright $";
    private static final String passwordSuffix = "password";
    protected static final String nameField = "authorityname";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected static final String maxCountField = "maxcount";
    protected static final String configField = "configxml";
    protected static final String mappingField = "mappingname";
    protected static final String authDomainField = "authdomainname";
    protected static final String groupNameField = "groupname";
    protected final ICacheManager cacheManager;
    protected final IThreadContext threadContext;
    protected final ILockManager lockManager;
    protected static final String authoritiesLock = "AUTHORITIES_LOCK";
    protected static final int FETCH_MAX = 200;

    public AuthorityConnectionManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "authconnections");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block5: {
            IAuthorityGroupManager authMgr = AuthorityGroupManagerFactory.make(this.threadContext);
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(classNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(maxCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(configField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(mappingField, new ColumnDescription("VARCHAR(32)", false, true, null, null, false));
                map.put(authDomainField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(groupNameField, new ColumnDescription("VARCHAR(32)", false, false, authMgr.getTableName(), authMgr.getGroupNameColumn(), false));
                this.performCreate(map, null);
            }
            IndexDescription authDomainIndex = new IndexDescription(false, new String[]{authDomainField});
            IndexDescription authorityIndex = new IndexDescription(false, new String[]{groupNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (authDomainIndex != null && id.equals((Object)authDomainIndex)) {
                    authDomainIndex = null;
                }
                if (authorityIndex != null && id.equals((Object)authorityIndex)) {
                    authorityIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (authDomainIndex != null) {
                this.performAddIndex(null, authDomainIndex);
            }
            if (authorityIndex == null) break block5;
            this.performAddIndex(null, authorityIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    @Override
    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)3);
        IAuthorityConnection[] list = this.getAllConnections();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        int i = 0;
        while (i < list.length) {
            IAuthorityConnection conn = list[i++];
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getClassName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getConfigParams().toXML());
            ManifoldCF.writeDword((OutputStream)os, (int)conn.getMaxConnections());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getPrerequisiteMapping());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getAuthDomain());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getAuthGroup());
        }
    }

    @Override
    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        IAuthorityGroupManager authMgr = AuthorityGroupManagerFactory.make(this.threadContext);
        int version = ManifoldCF.readDword((InputStream)is);
        if (version < 3 || version > 3) {
            throw new IOException("Unknown authority configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IAuthorityConnection conn = this.create();
            String name = ManifoldCF.readString((InputStream)is);
            String description = ManifoldCF.readString((InputStream)is);
            conn.setName(name);
            conn.setDescription(description);
            conn.setClassName(ManifoldCF.readString((InputStream)is));
            conn.getConfigParams().fromXML(ManifoldCF.readString((InputStream)is));
            conn.setMaxConnections(ManifoldCF.readDword((InputStream)is));
            conn.setPrerequisiteMapping(ManifoldCF.readString((InputStream)is));
            conn.setAuthDomain(ManifoldCF.readString((InputStream)is));
            conn.setAuthGroup(ManifoldCF.readString((InputStream)is));
            this.save(conn);
        }
    }

    @Override
    public boolean isGroupReferenced(String groupName) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(AuthorityConnectionManager.getAuthorityConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(groupNameField, (Object)groupName)});
        IResultSet set = this.performQuery("SELECT authorityname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
        return set.getRowCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuthorityConnection[] getDomainConnections(String authDomain) throws ManifoldCFException {
        this.lockManager.enterReadLock(authoritiesLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(AuthorityConnectionManager.getAuthorityConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            StringBuilder sb = new StringBuilder("SELECT ");
            ArrayList list = new ArrayList();
            sb.append(nameField).append(" FROM ").append(this.getTableName()).append(" WHERE ");
            sb.append(this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(authDomainField, (Object)authDomain)}));
            IResultSet set = this.performQuery(sb.toString(), list, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IAuthorityConnection[] iAuthorityConnectionArray = this.loadMultiple(names);
            return iAuthorityConnectionArray;
        }
        finally {
            this.lockManager.leaveReadLock(authoritiesLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuthorityConnection[] getAllConnections() throws ManifoldCFException {
        this.lockManager.enterReadLock(authoritiesLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(AuthorityConnectionManager.getAuthorityConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT authorityname,lower(authorityname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IAuthorityConnection[] iAuthorityConnectionArray = this.loadMultiple(names);
            return iAuthorityConnectionArray;
        }
        finally {
            this.lockManager.leaveReadLock(authoritiesLock);
        }
    }

    @Override
    public IAuthorityConnection load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    @Override
    public IAuthorityConnection[] loadMultiple(String[] names) throws ManifoldCFException {
        IAuthorityConnection[] rval = new IAuthorityConnection[names.length];
        if (names.length == 0) {
            return rval;
        }
        int inputIndex = 0;
        int outputIndex = 0;
        while (names.length - inputIndex > 200) {
            outputIndex = this.loadMultipleInternal(rval, outputIndex, names, inputIndex, 200);
            inputIndex += 200;
        }
        this.loadMultipleInternal(rval, outputIndex, names, inputIndex, names.length - inputIndex);
        return rval;
    }

    protected int loadMultipleInternal(IAuthorityConnection[] rval, int outputIndex, String[] fetchNames, int inputIndex, int length) throws ManifoldCFException {
        AuthorityConnection[] results;
        AuthorityConnectionDescription[] objectDescriptions = new AuthorityConnectionDescription[length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < length; ++i) {
            ssb.clear();
            String name = fetchNames[inputIndex + i];
            ssb.add(AuthorityConnectionManager.getAuthorityConnectionKey(name));
            objectDescriptions[i] = new AuthorityConnectionDescription(name, new StringSet(ssb));
        }
        AuthorityConnectionExecutor exec = new AuthorityConnectionExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        for (AuthorityConnection result : results = exec.getResults()) {
            rval[outputIndex++] = result;
        }
        return outputIndex;
    }

    @Override
    public IAuthorityConnection create() throws ManifoldCFException {
        AuthorityConnection rval = new AuthorityConnection();
        return rval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(IAuthorityConnection object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(AuthorityConnectionManager.getAuthorityConnectionsKey());
        ssb.add(AuthorityConnectionManager.getAuthorityConnectionKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        this.lockManager.enterNonExWriteLock(authoritiesLock);
        try {
            ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
            try {
                this.beginTransaction();
                try {
                    ManifoldCF.noteConfigurationChange();
                    ArrayList params = new ArrayList();
                    String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
                    this.performDelete("WHERE " + query, params, null);
                    this.cacheManager.invalidateKeys(ch);
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            finally {
                this.cacheManager.leaveCache(ch);
            }
        }
        finally {
            this.lockManager.leaveNonExWriteLock(authoritiesLock);
        }
    }

    @Override
    public String getAuthorityNameColumn() {
        return nameField;
    }

    @Override
    public boolean isMappingReferenced(String mappingName) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(AuthorityConnectionManager.getAuthorityConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(mappingField, (Object)mappingName)});
        IResultSet set = this.performQuery("SELECT authorityname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
        return set.getRowCount() > 0;
    }

    protected static String getAuthorityConnectionsKey() {
        return CacheKeyFactory.makeAuthorityConnectionsKey();
    }

    protected static String getAuthorityConnectionKey(String connectionName) {
        return CacheKeyFactory.makeAuthorityConnectionKey(connectionName);
    }

    protected AuthorityConnection[] getAuthorityConnectionsMultiple(String[] connectionNames) throws ManifoldCFException {
        int i;
        AuthorityConnection[] rval = new AuthorityConnection[connectionNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < connectionNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(connectionNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.maxClauseGetAuthorityConnectionsChunk();
            while (i < connectionNames.length) {
                if (j == maxIn) {
                    this.getAuthorityConnectionsChunk(rval, returnIndex, params);
                    params.clear();
                    j = 0;
                }
                params.add(connectionNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getAuthorityConnectionsChunk(rval, returnIndex, params);
            }
            AuthorityConnection[] authorityConnectionArray = rval;
            return authorityConnectionArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected int maxClauseGetAuthorityConnectionsChunk() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void getAuthorityConnectionsChunk(AuthorityConnection[] rval, Map returnIndex, ArrayList params) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(nameField, (List)params)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = (Integer)returnIndex.get(name);
            AuthorityConnection rc = new AuthorityConnection();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rc.setClassName((String)row.getValue(classNameField));
            rc.setMaxConnections((int)((Long)row.getValue(maxCountField)).longValue());
            rc.setPrerequisiteMapping((String)row.getValue(mappingField));
            rc.setAuthDomain((String)row.getValue(authDomainField));
            rc.setAuthGroup((String)row.getValue(groupNameField));
            String xml = (String)row.getValue(configField);
            if (xml != null && xml.length() > 0) {
                rc.getConfigParams().fromXML(xml);
            }
            rval[index] = rc;
        }
    }

    protected static class AuthorityConnectionExecutor
    extends ExecutorBase {
        protected AuthorityConnectionManager thisManager;
        protected AuthorityConnection[] returnValues;
        protected HashMap returnMap = new HashMap();

        public AuthorityConnectionExecutor(AuthorityConnectionManager manager, AuthorityConnectionDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new AuthorityConnection[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getConnectionName(), new Integer(i));
            }
        }

        public AuthorityConnection[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] connectionNames = new String[objectDescriptions.length];
            for (int i = 0; i < connectionNames.length; ++i) {
                AuthorityConnectionDescription desc = (AuthorityConnectionDescription)objectDescriptions[i];
                connectionNames[i] = desc.getConnectionName();
            }
            return this.thisManager.getAuthorityConnectionsMultiple(connectionNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            AuthorityConnectionDescription objectDesc = (AuthorityConnectionDescription)objectDescription;
            AuthorityConnection ci = (AuthorityConnection)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getConnectionName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class AuthorityConnectionDescription
    extends BaseDescription {
        protected String connectionName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public AuthorityConnectionDescription(String connectionName, StringSet invKeys) {
            super("authorityconnectioncache");
            this.connectionName = connectionName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + connectionName;
            this.cacheKeys = invKeys;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorityConnectionDescription)) {
                return false;
            }
            AuthorityConnectionDescription d = (AuthorityConnectionDescription)((Object)o);
            return d.connectionName.equals(this.connectionName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

