/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.nuxeo.client.objects.AbstractBase$$Lambda$1;
import org.nuxeo.client.objects.AbstractBase$$Lambda$2;
import retrofit2.Retrofit;

public class AbstractBase<B extends AbstractBase<B>> {
    @JsonIgnore
    protected OkHttpClient.Builder okhttpBuilder;
    @JsonIgnore
    protected Retrofit.Builder retrofitBuilder;
    @JsonIgnore
    protected Map<String, Interceptor> headerInterceptors;
    @JsonIgnore
    protected Map<String, List<String>> headerValues;
    @JsonIgnore
    protected Retrofit retrofit;

    public AbstractBase() {
        this.okhttpBuilder = new OkHttpClient.Builder();
        this.retrofitBuilder = new Retrofit.Builder();
        this.headerInterceptors = new HashMap<String, Interceptor>();
        this.headerValues = new HashMap<String, List<String>>();
    }

    protected AbstractBase(AbstractBase<?> base) {
        this.replaceWith(base);
    }

    public B timeout(long timeout) {
        this.okhttpBuilder.connectTimeout(timeout, TimeUnit.SECONDS);
        this.okhttpBuilder.readTimeout(timeout, TimeUnit.SECONDS);
        this.buildRetrofit();
        return (B)this;
    }

    public B connectTimeout(long connectTimeout) {
        this.okhttpBuilder.connectTimeout(connectTimeout, TimeUnit.SECONDS);
        this.buildRetrofit();
        return (B)this;
    }

    public B readTimeout(long readTimeout) {
        this.okhttpBuilder.readTimeout(readTimeout, TimeUnit.SECONDS);
        this.buildRetrofit();
        return (B)this;
    }

    public B header(String header, String value, String ... values) {
        return this.header(false, header, value, values);
    }

    public B header(boolean append, String header, String value, String ... values) {
        List<String> lValues = this.headerValues.compute(header, AbstractBase$$Lambda$1.lambdaFactory$(values, value, append));
        Interceptor previousInterceptor = this.headerInterceptors.remove(header);
        if (previousInterceptor != null) {
            this.okhttpBuilder.interceptors().remove(previousInterceptor);
        }
        String headerValue = String.join((CharSequence)",", lValues);
        Interceptor interceptor = AbstractBase$$Lambda$2.lambdaFactory$(header, headerValue);
        this.headerInterceptors.put(header, interceptor);
        this.okhttpBuilder.interceptors().add(interceptor);
        this.buildRetrofit();
        return (B)this;
    }

    public B transactionTimeout(long timeout) {
        return this.header("Nuxeo-Transaction-Timeout", String.valueOf(timeout), new String[0]);
    }

    public B enrichers(boolean append, String type, String enricher, String ... enrichers) {
        return this.header(append, "enrichers." + type, enricher, enrichers);
    }

    public B enrichers(String type, String enricher, String ... enrichers) {
        return this.enrichers(false, type, enricher, enrichers);
    }

    public B enrichersForDocument(String enricher, String ... enrichers) {
        return this.enrichers("document", enricher, enrichers);
    }

    public B fetchProperties(boolean append, String fetch, String fetchProperty, String ... fetchProperties) {
        return this.header(append, "fetch." + fetch, fetchProperty, fetchProperties);
    }

    public B fetchProperties(String type, String fetchProperty, String ... fetchProperties) {
        return this.fetchProperties(false, type, fetchProperty, fetchProperties);
    }

    public B fetchPropertiesForDocument(String fetchProperty, String ... fetchProperties) {
        return this.fetchProperties("document", fetchProperty, fetchProperties);
    }

    public B fetchPropertiesForGroup(String fetchProperty, String ... fetchProperties) {
        return this.fetchProperties("group", fetchProperty, fetchProperties);
    }

    public B depth(String value) {
        return this.header("depth", value, new String[0]);
    }

    public B version(String value) {
        return this.header("X-Versioning-Option", value, new String[0]);
    }

    public B schemas(boolean append, String property, String ... properties) {
        return this.header(append, "X-NXproperties", property, properties);
    }

    public B schemas(String property, String ... properties) {
        return this.schemas(false, property, properties);
    }

    protected void buildRetrofit() {
        OkHttpClient okhttp = this.okhttpBuilder.build();
        this.retrofit = this.retrofitBuilder.callFactory((Call.Factory)okhttp).build();
    }

    protected final void replaceWith(AbstractBase<?> base) {
        OkHttpClient okhttp = base.okhttpBuilder.build();
        this.retrofit = base.retrofitBuilder.callFactory((Call.Factory)okhttp).build();
        this.okhttpBuilder = okhttp.newBuilder();
        this.retrofitBuilder = this.retrofit.newBuilder();
        this.headerInterceptors = new HashMap<String, Interceptor>();
        this.headerInterceptors.putAll(base.headerInterceptors);
        this.headerValues = new HashMap<String, List<String>>();
        this.headerValues.putAll(base.headerValues);
    }

    static /* synthetic */ Response lambda$header$1(String header, String headerValue, Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        request = request.newBuilder().addHeader(header, headerValue).build();
        return chain.proceed(request);
    }

    static /* synthetic */ List lambda$header$0(String[] values, String value, boolean append, String k, List vOld) {
        ArrayList<String> vNew = new ArrayList<String>(1 + values.length);
        vNew.add(value);
        vNew.addAll(Arrays.asList(values));
        if (append) {
            vNew.addAll(vOld);
        }
        return vNew;
    }
}

