/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLIdentifierFactory;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLStatement;
import org.w3c.dom.Element;

public class SAMLConfig {
    private static SAMLConfig instance;
    private Logger log = Logger.getLogger((String)SAMLConfig.class.getName());
    protected Properties properties;
    private SAMLIdentifier IDProvider = null;
    private Hashtable bindingMap = new Hashtable();

    protected SAMLConfig() {
        this.verifyUsableXmlParser();
        this.properties = new Properties();
        try {
            this.loadProperties(this.getClass().getResourceAsStream("/conf/opensaml.properties"));
        }
        catch (IOException iOException) {
            this.log.warn((Object)"Unable to load default library properties.");
        }
        Init.init();
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition"), "org.opensaml.SAMLAudienceRestrictionCondition");
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionConditionType"), "org.opensaml.SAMLAudienceRestrictionCondition");
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "DoNotCacheCondition"), "org.opensaml.SAMLDoNotCacheCondition");
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "DoNotCacheConditionType"), "org.opensaml.SAMLDoNotCacheCondition");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery"), "org.opensaml.SAMLAttributeQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQueryType"), "org.opensaml.SAMLAttributeQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery"), "org.opensaml.SAMLAuthenticationQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQueryType"), "org.opensaml.SAMLAuthenticationQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery"), "org.opensaml.SAMLAuthorizationDecisionQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQueryType"), "org.opensaml.SAMLAuthorizationDecisionQuery");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement"), "org.opensaml.SAMLAttributeStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatementType"), "org.opensaml.SAMLAttributeStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement"), "org.opensaml.SAMLAuthenticationStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatementType"), "org.opensaml.SAMLAuthenticationStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement"), "org.opensaml.SAMLAuthorizationDecisionStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatementType"), "org.opensaml.SAMLAuthorizationDecisionStatement");
        this.setDefaultBindingProvider("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", this.getProperty("org.opensaml.provider.soapbinding"));
    }

    public static synchronized SAMLConfig instance() {
        if (instance == null) {
            instance = new SAMLConfig();
            return instance;
        }
        return instance;
    }

    public synchronized SAMLIdentifier getDefaultIDProvider() {
        if (this.IDProvider == null) {
            this.IDProvider = SAMLIdentifierFactory.getInstance();
        }
        return this.IDProvider;
    }

    public synchronized String getDefaultBindingProvider(String string) {
        return (String)this.bindingMap.get(string);
    }

    public synchronized void setDefaultBindingProvider(String string, String string2) {
        this.bindingMap.put(string, string2);
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setProperties(properties);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public boolean getBooleanProperty(String string) {
        return new Boolean(this.properties.getProperty(string));
    }

    public void setBooleanProperty(String string, Boolean bl) {
        this.setProperty(string, bl.toString());
    }

    public int getIntProperty(String string) {
        return new Integer(this.properties.getProperty(string));
    }

    public void setIntProperty(String string, int n) {
        this.setProperty(string, new Integer(n).toString());
    }

    private void verifyUsableXmlParser() {
        try {
            Class.forName("javax.xml.validation.SchemaFactory");
            Element.class.getDeclaredMethod("setIdAttributeNS", String.class, String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FactoryConfigurationError("OpenSAML requires an xml parser that supports DOM3 calls. Sun JAXP 1.3 has been included with this release and is strongly recommended. If you are using Java 1.4, make sure that you have enabled the Endorsed Standards Override Mechanism for this parser (see http://java.sun.com/j2se/1.4.2/docs/guide/standards/ for details).");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError("OpenSAML requires an xml parser that supports JAXP 1.3. Sun JAXP 1.3 has been included with this release and is strongly recommended. If you are using Java 1.4, make sure that you have enabled the Endorsed Standards Override Mechanism for this parser (see http://java.sun.com/j2se/1.4.2/docs/guide/standards/ for details).");
        }
    }
}

