/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchAction;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConfig;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConnection;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchDelete;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchIndex;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchParam;
import org.apache.manifoldcf.agents.output.elasticsearch.Messages;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.core.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.Logging;

public class ElasticSearchConnector
extends BaseOutputConnector {
    private static final String ELASTICSEARCH_INDEXATION_ACTIVITY = "Indexation";
    private static final String ELASTICSEARCH_DELETION_ACTIVITY = "Deletion";
    private static final String[] ELASTICSEARCH_ACTIVITIES = new String[]{"Indexation", "Deletion"};
    private static final String ELASTICSEARCH_TAB_SERVER = "ElasticSearchConnector.Server";
    private static final String ELASTICSEARCH_TAB_PARAMETERS = "ElasticSearchConnector.Parameters";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_Server.html";
    private static final String EDIT_CONFIG_FORWARD_PARAMETERS = "editConfiguration_Parameters.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final long EXPIRATION_INTERVAL = 60000L;
    private static final int maxIdLength = 512;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClient client = null;
    private long expirationTime = -1L;

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
    }

    protected HttpClient getSession() throws ManifoldCFException {
        if (this.client == null) {
            int socketTimeout = 900000;
            int connectionTimeout = 60000;
            ElasticSearchConfig config = new ElasticSearchConfig(this.params);
            IKeystoreManager keystoreManager = config.getSSLKeystore();
            String userName = config.getUserName();
            String password = config.getPassword();
            try {
                socketTimeout = Integer.parseInt(config.getElasticSearchSocketTimeout());
            }
            catch (NumberFormatException e) {
                Logging.connectors.warn((Object)"An error occurred when parser the value of ElasticSearch socket timeout. Setting to default: 900000 (millisecond).");
            }
            try {
                connectionTimeout = Integer.parseInt(config.getElasticSearchConnectionTimeout());
            }
            catch (NumberFormatException e) {
                Logging.connectors.warn((Object)"An error occurred when parser the value of ElasticSearch connection timeout. Setting to default: 60000 (millisecond).");
            }
            UsernamePasswordCredentials credentials = userName != null && userName.length() > 0 ? new UsernamePasswordCredentials(userName, password) : null;
            SSLConnectionSocketFactory myFactory = null;
            myFactory = keystoreManager != null ? new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(keystoreManager.getSecureSocketFactory(), (long)connectionTimeout), (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : SSLConnectionSocketFactory.getSocketFactory();
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (credentials != null) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            }
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
            this.client = HttpClients.custom().setConnectionManager(this.connectionManager).setMaxConnTotal(1).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).build();
        }
        this.expirationTime = System.currentTimeMillis() + 60000L;
        return this.client;
    }

    protected void closeSession() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
        this.client = null;
        this.expirationTime = -1L;
    }

    protected static String compressDocumentURI(String documentURI) throws ManifoldCFException {
        if (documentURI.length() <= 512) {
            return documentURI;
        }
        return ManifoldCF.hash((String)documentURI);
    }

    public boolean isConnected() {
        return this.connectionManager != null;
    }

    public void disconnect() throws ManifoldCFException {
        super.disconnect();
        this.closeSession();
    }

    public void poll() throws ManifoldCFException {
        super.poll();
        if (this.connectionManager != null && System.currentTimeMillis() > this.expirationTime) {
            this.closeSession();
        }
    }

    public String[] getActivitiesList() {
        return ELASTICSEARCH_ACTIVITIES;
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, ElasticSearchParam params, String tabName, Integer sequenceNumber, Integer currentSequenceNumber) throws ManifoldCFException {
        Map<String, Object> paramMap = null;
        if (params != null) {
            paramMap = params.buildMap(out);
            if (tabName != null) {
                paramMap.put("TabName", tabName);
            }
            if (currentSequenceNumber != null) {
                paramMap.put("SelectedNum", currentSequenceNumber.toString());
            }
        } else {
            paramMap = new HashMap<String, Object>();
        }
        if (sequenceNumber != null) {
            paramMap.put("SeqNum", sequenceNumber.toString());
        }
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        super.outputConfigurationHeader(threadContext, out, locale, parameters, tabsArray);
        tabsArray.add(Messages.getString(locale, ELASTICSEARCH_TAB_SERVER));
        tabsArray.add(Messages.getString(locale, ELASTICSEARCH_TAB_PARAMETERS));
        ElasticSearchConnector.outputResource(EDIT_CONFIG_HEADER_FORWARD, out, locale, null, null, null, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        try {
            super.outputConfigurationBody(threadContext, out, locale, parameters, tabName);
            ElasticSearchConfig config = this.getConfigParameters(parameters);
            ElasticSearchConnector.outputResource(EDIT_CONFIG_FORWARD_SERVER, out, locale, config, tabName, null, null);
            ElasticSearchConnector.outputResource(EDIT_CONFIG_FORWARD_PARAMETERS, out, locale, config, tabName, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final ElasticSearchConfig getConfigParameters(ConfigParams configParams) {
        if (configParams == null) {
            configParams = this.getConfiguration();
        }
        return new ElasticSearchConfig(configParams);
    }

    public VersionContext getPipelineDescription(Specification os) throws ManifoldCFException {
        return new VersionContext("", this.params, os);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        ElasticSearchConnector.outputResource(VIEW_CONFIG_FORWARD, out, locale, this.getConfigParameters(parameters), null, null, null);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        return ElasticSearchConfig.contextToConfig(threadContext, variableContext, parameters);
    }

    protected static String[] convertACL(String[] acl, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException {
        if (acl != null) {
            String[] rval = new String[acl.length];
            for (int i = 0; i < rval.length; ++i) {
                rval[i] = activities.qualifyAccessToken(authorityNameString, acl[i]);
            }
            return rval;
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        String compressedDocumentURI = ElasticSearchConnector.compressDocumentURI(documentURI);
        HttpClient client = this.getSession();
        ElasticSearchConfig config = this.getConfigParameters(null);
        InputStream inputStream = document.getBinaryStream();
        String[] acls = null;
        String[] denyAcls = null;
        String[] shareAcls = null;
        String[] shareDenyAcls = null;
        String[] parentAcls = null;
        String[] parentDenyAcls = null;
        Iterator a = document.securityTypesIterator();
        while (a.hasNext()) {
            String securityType = (String)a.next();
            String[] convertedAcls = ElasticSearchConnector.convertACL(document.getSecurityACL(securityType), authorityNameString, activities);
            String[] convertedDenyAcls = ElasticSearchConnector.convertACL(document.getSecurityDenyACL(securityType), authorityNameString, activities);
            if (securityType.equals("document")) {
                acls = convertedAcls;
                denyAcls = convertedDenyAcls;
                continue;
            }
            if (securityType.equals("share")) {
                shareAcls = convertedAcls;
                shareDenyAcls = convertedDenyAcls;
                continue;
            }
            if (securityType.equals("parent")) {
                parentAcls = convertedAcls;
                parentDenyAcls = convertedDenyAcls;
                continue;
            }
            activities.recordActivity(null, ELASTICSEARCH_INDEXATION_ACTIVITY, Long.valueOf(document.getBinaryLength()), documentURI, "UNKNOWNSECURITY", "Rejected document that has security info which ElasticSearch does not recognize: '" + securityType + "'");
            return 1;
        }
        long startTime = System.currentTimeMillis();
        ElasticSearchIndex oi = new ElasticSearchIndex(client, config);
        try {
            oi.execute(compressedDocumentURI, document, inputStream, acls, denyAcls, shareAcls, shareDenyAcls, parentAcls, parentDenyAcls, documentURI);
            if (oi.getResult() != ElasticSearchConnection.Result.OK) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            activities.recordActivity(Long.valueOf(startTime), ELASTICSEARCH_INDEXATION_ACTIVITY, Long.valueOf(document.getBinaryLength()), documentURI, oi.getResultCode(), oi.getResultDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        String compressedDocumentURI = ElasticSearchConnector.compressDocumentURI(documentURI);
        HttpClient client = this.getSession();
        long startTime = System.currentTimeMillis();
        ElasticSearchDelete od = new ElasticSearchDelete(client, this.getConfigParameters(null));
        try {
            od.execute(compressedDocumentURI);
        }
        finally {
            activities.recordActivity(Long.valueOf(startTime), ELASTICSEARCH_DELETION_ACTIVITY, null, documentURI, od.getResultCode(), od.getResultDescription());
        }
    }

    public String check() throws ManifoldCFException {
        HttpClient client = this.getSession();
        ElasticSearchAction oss = new ElasticSearchAction(client, this.getConfigParameters(null));
        try {
            oss.executeGET(ElasticSearchAction.CommandEnum._stats, true);
            String resultName = oss.getResult().name();
            if (resultName.equals("OK")) {
                return super.check();
            }
            return resultName + " " + oss.getResultDescription();
        }
        catch (ServiceInterruption e) {
            return "Transient exception: " + e.getMessage();
        }
    }
}

