/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.system.ManifoldCF;
import org.junit.After;
import org.junit.Before;

public class Base {
    protected File currentPath = null;
    protected File configFile = null;
    protected File loggingFile = null;
    protected File logOutputFile = null;
    protected File connectorFile = null;

    protected void initialize() throws Exception {
        if (this.currentPath == null) {
            this.currentPath = new File(".").getCanonicalFile();
            this.configFile = new File("properties.xml").getCanonicalFile();
            this.loggingFile = new File("logging.xml").getCanonicalFile();
            this.logOutputFile = new File("manifoldcf.log").getCanonicalFile();
            this.connectorFile = new File("connectors.xml").getCanonicalFile();
            System.setProperty("org.apache.manifoldcf.configfile", this.configFile.getCanonicalFile().getAbsolutePath());
        }
    }

    protected boolean isInitialized() {
        return this.configFile.exists();
    }

    @Before
    public void setUp() throws Exception {
        this.initializeSystem();
        try {
            this.localReset();
        }
        catch (Exception e) {
            System.out.println("Warning: Preclean error: " + e.getMessage());
        }
        try {
            this.localSetUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void writeLoggingIni(StringBuilder output) throws Exception {
        output.append("<Configuration status=\"warn\" name=\"ManifoldCF\" packages=\"\">\n  <Appenders>\n    <File name=\"MyFile\" fileName=\"" + this.logOutputFile.getAbsolutePath().replaceAll("\\\\", "/") + "\">\n      <PatternLayout>\n        <Pattern>%5p %d{ISO8601} (%t) - %m%n</Pattern>\n      </PatternLayout>\n    </File>\n  </Appenders>\n  <Loggers>\n    <Root level=\"error\">\n      <AppenderRef ref=\"MyFile\"/>\n    </Root>\n  </Loggers>\n</Configuration>\n");
    }

    protected void writePropertiesXML(StringBuilder output) throws Exception {
        output.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<configuration>\n");
        this.writeProperties(output);
        output.append("</configuration>\n");
    }

    protected void writeProperties(StringBuilder output) throws Exception {
        output.append("  <property name=\"org.apache.manifoldcf.logconfigfile\" value=\"" + this.loggingFile.getAbsolutePath().replaceAll("\\\\", "/") + "\"/>\n  <property name=\"org.apache.manifoldcf.connectorsconfigurationfile\" value=\"" + this.connectorFile.getAbsolutePath().replaceAll("\\\\", "/") + "\"/>\n  <property name=\"org.apache.manifoldcf.diagnostics\" value=\"DEBUG\"/>\n");
    }

    protected void writeConnectorsXML(StringBuilder output) throws Exception {
        output.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<connectors>\n");
        this.writeConnectors(output);
        output.append("</connectors>\n");
    }

    protected void writeConnectors(StringBuilder output) throws Exception {
    }

    protected String getDatabaseSuperuserName() throws Exception {
        return "";
    }

    protected String getDatabaseSuperuserPassword() throws Exception {
        return "";
    }

    protected void initializeSystem() throws Exception {
        this.initialize();
        StringBuilder loggingIniContents = new StringBuilder();
        this.writeLoggingIni(loggingIniContents);
        Base.writeFile(this.loggingFile, loggingIniContents.toString());
        StringBuilder propertiesXMLContents = new StringBuilder();
        this.writePropertiesXML(propertiesXMLContents);
        Base.writeFile(this.configFile, propertiesXMLContents.toString());
        StringBuilder connectorsXMLContents = new StringBuilder();
        this.writeConnectorsXML(connectorsXMLContents);
        Base.writeFile(this.connectorFile, connectorsXMLContents.toString());
        ManifoldCF.initializeEnvironment((IThreadContext)ThreadContextFactory.make());
    }

    protected void localSetUp() throws Exception {
        IThreadContext tc = ThreadContextFactory.make();
        ManifoldCF.createSystemDatabase((IThreadContext)tc, (String)this.getDatabaseSuperuserName(), (String)this.getDatabaseSuperuserPassword());
    }

    @After
    public void cleanUp() throws Exception {
        try {
            this.localCleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.cleanupSystem();
    }

    protected void cleanupSystem() throws Exception {
        this.initialize();
        if (this.isInitialized()) {
            this.logOutputFile.delete();
            this.configFile.delete();
            this.loggingFile.delete();
            this.connectorFile.delete();
            IThreadContext threadContext = ThreadContextFactory.make();
            ManifoldCF.cleanUpEnvironment((IThreadContext)threadContext);
            ManifoldCF.resetEnvironment((IThreadContext)threadContext);
        }
    }

    protected void localReset() throws Exception {
        IThreadContext tc = ThreadContextFactory.make();
        ManifoldCF.dropSystemDatabase((IThreadContext)tc, (String)this.getDatabaseSuperuserName(), (String)this.getDatabaseSuperuserPassword());
    }

    protected void localCleanUp() throws Exception {
        this.localReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeFile(File f, String fileContents) throws IOException {
        try (FileOutputStream os = new FileOutputStream(f);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            w.write(fileContents);
        }
    }
}

