/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;

public enum DataType {
    BYTE,
    USHORT,
    SHORT,
    INT,
    FLOAT,
    DOUBLE;

    private static final DataType[] VALUES;

    public static DataType forBands(RenderedImage renderedImage) {
        return DataType.forDataBufferType(ImageUtilities.getBandType(renderedImage.getSampleModel()));
    }

    public static DataType forRange(NumberRange<?> numberRange, boolean bl) {
        ArgumentChecks.ensureNonNull("range", numberRange);
        byte by = Numbers.getEnumConstant(numberRange.getElementType());
        if (!bl) {
            if (by >= 9) {
                return DOUBLE;
            }
            if (by >= 7) {
                return FLOAT;
            }
        }
        double d = numberRange.getMinDouble();
        double d2 = numberRange.getMaxDouble();
        if (!(by >= 3 && by <= 8 && by != 6 || d >= -1.67772165E7 && d2 < 1.67772165E7)) {
            return DOUBLE;
        }
        DataType dataType = d >= -0.5 && d2 < 65535.5 ? (d2 < 255.5 ? BYTE : USHORT) : (d >= -32768.5 && d2 < 32767.5 ? SHORT : (d >= -2.1474836485E9 && d2 < 2.1474836475E9 ? INT : FLOAT));
        return dataType;
    }

    public static DataType forPrimitiveType(Class<?> clazz, boolean bl) {
        switch (Numbers.getEnumConstant(clazz)) {
            case 3: {
                return bl ? BYTE : SHORT;
            }
            case 4: {
                return bl ? USHORT : SHORT;
            }
            case 5: {
                if (bl) break;
                return INT;
            }
            case 8: {
                return FLOAT;
            }
            case 9: {
                return DOUBLE;
            }
        }
        throw new RasterFormatException(Resources.format((short)69, clazz));
    }

    public static DataType forDataBufferType(int n) {
        if (n >= 0 && n < VALUES.length) {
            return VALUES[n];
        }
        throw new RasterFormatException(Resources.format((short)69, n));
    }

    public final int size() {
        return DataBuffer.getDataTypeSize(this.ordinal());
    }

    public final boolean isUnsigned() {
        return this.ordinal() <= 1;
    }

    public final boolean isInteger() {
        return this.ordinal() <= 3;
    }

    public final DataType toFloat() {
        int n = this.ordinal();
        return n < 3 || n == 4 ? FLOAT : DOUBLE;
    }

    public final int toDataBufferType() {
        return this.ordinal();
    }

    static {
        VALUES = DataType.values();
    }
}

